/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.rotation;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationPolyline;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationViewAwt;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationViewSwing;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.globaloperators.JunROTATE;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunOpenGLRotationModel
extends JunApplicationModel {
    protected JunOpenGLRotationPolyline polyline;
    protected int scale;
    protected Vector selection;
    protected boolean swapXY;
    protected boolean showXAxis;
    protected boolean showYAxis;
    protected double grid;
    protected int lastDivisions;
    protected StBlockClosure openBlock;
    protected StMenuBar _menuBar;

    protected void initialize() {
        super.initialize();
        this.polyline = null;
        this.scale = 50;
        this.selection = null;
        this.swapXY = false;
        this.showXAxis = true;
        this.showYAxis = true;
        this.grid = Double.NaN;
        this.lastDivisions = 10;
        this.openBlock = null;
        this._menuBar = null;
    }

    public Jun2dPoint descaledPoint_(Point point) {
        double d = this.scale();
        if (this.swapXY) {
            return new Jun2dPoint((double)point.y / d * -1.0, (double)point.x / d);
        }
        return new Jun2dPoint((double)point.x / d, (double)point.y / d * -1.0);
    }

    public double grid() {
        return this.grid;
    }

    public int lastDivisions() {
        return this.lastDivisions;
    }

    public void lastDivisions_(int n) {
        this.lastDivisions = n;
    }

    public Jun2dPoint lastVertex() {
        return this.polyline().last();
    }

    public StBlockClosure openBlock() {
        return this.openBlock;
    }

    public void openBlock_(StBlockClosure stBlockClosure) {
        this.openBlock = stBlockClosure;
    }

    public JunOpenGLRotationPolyline polyline() {
        if (this.polyline == null) {
            this.polyline = new JunOpenGLRotationPolyline();
            this.polyline.addDependent_((DependentListener)this);
        }
        return this.polyline;
    }

    public void polyline_(JunOpenGLRotationPolyline junOpenGLRotationPolyline) {
        if (this.polyline != null) {
            this.polyline.removeDependent_((DependentListener)this);
        }
        this.polyline = junOpenGLRotationPolyline;
        if (this.polyline != null) {
            this.polyline.addDependent_((DependentListener)this);
        }
        this.updateLoopMenu();
        this.changed_(JunOpenGLRotationModel.$((String)"polyline"));
    }

    public int scale() {
        return this.scale;
    }

    public void scale_(int n) {
        this.scale = n;
        this.changed_(JunOpenGLRotationModel.$((String)"scale"));
    }

    public Point scaledPoint_(Jun2dPoint jun2dPoint) {
        double d = this.scale();
        if (this.swapXY) {
            return new Point((int)(jun2dPoint.y() * d), (int)(jun2dPoint.x() * d * -1.0));
        }
        return new Point((int)(jun2dPoint.x() * d), (int)(jun2dPoint.y() * d * -1.0));
    }

    public boolean showXAxis() {
        return this.showXAxis;
    }

    public void showXAxis_(boolean bl) {
        this.showXAxis = bl;
        this.update_(new DependentEvent((Object)this, JunOpenGLRotationModel.$((String)"showXAxis"), null));
    }

    public boolean showYAxis() {
        return this.showYAxis;
    }

    public void showYAxis_(boolean bl) {
        this.showYAxis = bl;
        this.update_(new DependentEvent((Object)this, JunOpenGLRotationModel.$((String)"showYAxis"), null));
    }

    public boolean swapXY() {
        return this.swapXY;
    }

    public void swapXY_(boolean bl) {
        this.swapXY = bl;
        this.update_(new DependentEvent((Object)this, JunOpenGLRotationModel.$((String)"swapXY"), null));
    }

    public StView defaultView() {
        if (JunOpenGLRotationModel.GetDefaultViewMode() == 0) {
            return new JunOpenGLRotationViewAwt(this);
        }
        return new JunOpenGLRotationViewSwing(this);
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Rotation Model");
    }

    protected JunLispList divisionsToLispList() {
        return new JunLispCons(JunOpenGLRotationModel.$((String)"divisions"), new Integer(this.lastDivisions()));
    }

    public void fromLispList_(JunLispCons junLispCons) {
        if (junLispCons.head() != this.kindName()) {
            throw SmalltalkException.Error((String)"unexpected error");
        }
        final JunOpenGLRotationModel junOpenGLRotationModel = this;
        ((JunLispList)((Object)junLispCons.tail())).do_(new StBlockClosure(){

            public Object value_(Object object) {
                JunLispCons junLispCons = (JunLispCons)((Object)object);
                if (junLispCons.head() == 1.$((String)"scale")) {
                    junOpenGLRotationModel.scale_(((Number)junLispCons.tail()).intValue());
                }
                if (junLispCons.head() == 1.$((String)"swapXY")) {
                    junOpenGLRotationModel.swapXY_((Boolean)junLispCons.tail());
                }
                if (junLispCons.head() == 1.$((String)"showXAxis")) {
                    junOpenGLRotationModel.showXAxis_((Boolean)junLispCons.tail());
                }
                if (junLispCons.head() == 1.$((String)"showYAxis")) {
                    junOpenGLRotationModel.showYAxis_((Boolean)junLispCons.tail());
                }
                if (junLispCons.head() == 1.$((String)"grid")) {
                    if (junLispCons.tail() == null) {
                        junOpenGLRotationModel.grid_(Double.NaN);
                    } else {
                        junOpenGLRotationModel.grid_(((Number)junLispCons.tail()).doubleValue());
                    }
                }
                if (junLispCons.head() == 1.$((String)"divisions")) {
                    junOpenGLRotationModel.lastDivisions_(((Number)junLispCons.tail()).intValue());
                }
                if (junLispCons.head() == 1.$((String)"JunOpenGLRotationPolyline")) {
                    junOpenGLRotationModel.polyline_(JunOpenGLRotationPolyline.FromLispList_(junLispCons));
                }
                return null;
            }
        });
    }

    protected JunLispList gridToLispList() {
        return new JunLispCons(JunOpenGLRotationModel.$((String)"grid"), Double.isNaN(this.grid()) ? null : new Double(this.grid()));
    }

    protected JunLispList scaleToLispList() {
        return new JunLispCons(JunOpenGLRotationModel.$((String)"scale"), new Integer(this.scale()));
    }

    protected JunLispList showXAxisToLispList() {
        return new JunLispCons(JunOpenGLRotationModel.$((String)"showXAxis"), new Boolean(this.showXAxis()));
    }

    protected JunLispList showYAxisToLispList() {
        return new JunLispCons(JunOpenGLRotationModel.$((String)"showYAxis"), new Boolean(this.showYAxis()));
    }

    protected JunLispList swapXYToLispList() {
        return new JunLispCons(JunOpenGLRotationModel.$((String)"swapXY"), new Boolean(this.swapXY()));
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = JunLispCons.Cell();
        junLispCons.head_(this.kindName());
        junLispCons.add_((Object)this.scaleToLispList());
        junLispCons.add_((Object)this.swapXYToLispList());
        junLispCons.add_((Object)this.showXAxisToLispList());
        junLispCons.add_((Object)this.showYAxisToLispList());
        junLispCons.add_((Object)this.gridToLispList());
        junLispCons.add_((Object)this.divisionsToLispList());
        junLispCons.add_((Object)this.polyline().toLispList());
        return junLispCons;
    }

    protected void updateLoopMenu() {
        StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)this._menuBar().atNameKey_(JunOpenGLRotationModel.$((String)"toggleLoop"));
        stCheckBoxMenuItem.beSelected(this.polyline().loop());
    }

    public void updateMenuIndication() {
        this.updateLoopMenu();
        this.updateShowXAxisMenu();
        this.updateShowYAxisMenu();
        this.updateSwapXYMenu();
    }

    protected void updateShowXAxisMenu() {
        StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)this._menuBar().atNameKey_(JunOpenGLRotationModel.$((String)"toggleShowXAxis"));
        stCheckBoxMenuItem.beSelected(this.showXAxis());
    }

    protected void updateShowYAxisMenu() {
        StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)this._menuBar().atNameKey_(JunOpenGLRotationModel.$((String)"toggleShowYAxis"));
        stCheckBoxMenuItem.beSelected(this.showYAxis());
    }

    protected void updateSwapXYMenu() {
        StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)this._menuBar().atNameKey_(JunOpenGLRotationModel.$((String)"toggleSwapXY"));
        stCheckBoxMenuItem.beSelected(this.swapXY());
    }

    public void deleteSelection() {
        Vector vector = this.selectedVertices();
        this.deselectAll();
        this.removeVertices_(vector);
    }

    public void doOpen() {
        File file = JunFileRequesterDialog.RequestFile(JunOpenGLRotationModel.$String((String)"Select a <1p> file.", null, (Object)"lrt"), new File("rotation.lrt"));
        if (file == null) {
            return;
        }
        try {
            if (this.numVertices() > 0) {
                if (this.openBlock() != null) {
                    this.openBlock().value_((Object)file);
                } else {
                    JunOpenGLRotationModel junOpenGLRotationModel = new JunOpenGLRotationModel();
                    junOpenGLRotationModel.readFromLRT10_(file);
                    if (junOpenGLRotationModel.numVertices() > 0) {
                        junOpenGLRotationModel.open();
                    }
                }
            } else {
                this.readFromLRT10_(file);
            }
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void doRotate() {
        String string = new Integer(this.lastDivisions).toString();
        string = JunDialog.Request_(JunSystem.$String((String)"How many divisions?"), string);
        if (string != null) {
            try {
                JunBody junBody = this.rotatedBody_(new Integer(string));
                if (junBody != null) {
                    junBody.show();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void doSave() {
        File file = JunFileRequesterDialog.RequestNewFile(JunOpenGLRotationModel.$String((String)"Input a <1p> file.", null, (Object)"lrt"), new File("rotation.lrt"));
        if (file == null) {
            return;
        }
        try {
            this.writeToLRT10_(file);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void invertSelection() {
        int n = this.numVertices();
        for (int i = 0; i < n; ++i) {
            if (this.indexSelected_(i)) {
                this.deselectIndex_(i);
                continue;
            }
            this.selectIndex_(i);
        }
    }

    public void reverseVertices() {
        Vector vector = (Vector)this.selectedIndices().clone();
        this.polyline().reverseVertices();
        this.deselectAll();
        int n = this.numVertices();
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = ((Number)vector.elementAt(i)).intValue();
            this.selectIndex_(n - n2);
        }
    }

    public void selectAll() {
        int n = this.numVertices();
        for (int i = 0; i < n; ++i) {
            this.selectIndex_(i);
        }
    }

    public void setGrid() {
        String string = !Double.isNaN(this.grid) ? new Double(this.grid).toString() : "none";
        string = JunDialog.Request_(JunSystem.$String((String)"New grid value ('none' for no grid)?"), string);
        if (string != null) {
            try {
                this.grid_(new Double(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.grid_(Double.NaN);
            }
        }
    }

    public void swapVertices() {
        if (this.numSelection() == 2) {
            Jun2dPoint jun2dPoint = this.selectedVertexAt_(0);
            this.vertexAt_put_(this.selectedIndexAt_(0), this.selectedVertexAt_(1));
            this.vertexAt_put_(this.selectedIndexAt_(1), jun2dPoint);
        }
    }

    public void toggleLoop() {
        this.polyline().loop_(!this.polyline().loop());
    }

    public void toggleShowXAxis() {
        this.showXAxis_(!this.showXAxis());
    }

    public void toggleShowYAxis() {
        this.showYAxis_(!this.showYAxis());
    }

    public void toggleSwapXY() {
        this.swapXY_(!this.swapXY());
    }

    public void zoomIn() {
        this.scale_(this.scale() * 2);
    }

    public void zoomOut() {
        this.scale_(this.scale() / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromLRT10_(BufferedReader bufferedReader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = bufferedReader.read()) > 0) {
                stringWriter.write(n);
            }
            stringWriter.flush();
            this.fromLispList_((JunLispCons)((Object)JunLispParser.Parse_(stringWriter.toString())));
        }
        finally {
            stringWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromLRT10_(File file) throws IOException {
        FileReader fileReader;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            this.loadFromLRT10_(bufferedReader);
        }
        finally {
            bufferedReader.close();
        }
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createEditMenu());
        }
        return this._menuBar;
    }

    public StPopupMenu _popupMenu() {
        StPopupMenu stPopupMenu = new StPopupMenu();
        stPopupMenu.addAll(this._editMenu().menuItems());
        return stPopupMenu;
    }

    protected StMenu _createEditMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Edit"), JunOpenGLRotationModel.$((String)"editMenu"));
        stMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Rotate") + "..."), (MenuListener)new MenuPerformer((StObject)this, "doRotate")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Open") + "..."), (MenuListener)new MenuPerformer((StObject)this, "doOpen")));
        stMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Save") + "..."), (MenuListener)new MenuPerformer((StObject)this, "doSave")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Select all"), (MenuListener)new MenuPerformer((StObject)this, "selectAll")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Deselect all"), (MenuListener)new MenuPerformer((StObject)this, "deselectAll")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Invert selection"), (MenuListener)new MenuPerformer((StObject)this, "invertSelection")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Reverse all vertices"), (MenuListener)new MenuPerformer((StObject)this, "reverseVertices")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Swap selected vertices"), (MenuListener)new MenuPerformer((StObject)this, "swapVertices")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Delete selected vertices"), (MenuListener)new MenuPerformer((StObject)this, "deleteSelection")));
        stMenu.addSeparator();
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Loop polyline"), JunOpenGLRotationModel.$((String)"toggleLoop"), (MenuListener)new MenuPerformer((StObject)this, "toggleLoop")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Swap XY axes"), JunOpenGLRotationModel.$((String)"toggleSwapXY"), (MenuListener)new MenuPerformer((StObject)this, "toggleSwapXY")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Show X-Axis", (String)"Show X axis"), JunOpenGLRotationModel.$((String)"toggleShowXAxis"), (MenuListener)new MenuPerformer((StObject)this, "toggleShowXAxis")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Show Y-Axis", (String)"Show Y axis"), JunOpenGLRotationModel.$((String)"toggleShowYAxis"), (MenuListener)new MenuPerformer((StObject)this, "toggleShowYAxis")));
        stMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Grid") + "..."), (MenuListener)new MenuPerformer((StObject)this, "setGrid")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Zoom in"), (MenuListener)new MenuPerformer((StObject)this, "zoomIn")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Zoom out"), (MenuListener)new MenuPerformer((StObject)this, "zoomOut")));
        return stMenu;
    }

    protected StMenu _editMenu() {
        return (StMenu)this._menuBar().atNameKey_(JunOpenGLRotationModel.$((String)"editMenu"));
    }

    public JunBody rotatedBody_(int n) {
        Object object;
        if (n < 3 || this.numVertices() < 2) {
            return null;
        }
        Object object2 = this.verticesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                if (jun2dPoint.y() < 0.0) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        if (object2 == Boolean.FALSE) {
            JunDialog.Warn_(JunSystem.$String((String)"There is a vertex whose y < 0."));
            return null;
        }
        final JunOpenGLRotationModel junOpenGLRotationModel = this;
        object2 = this.edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Object object2;
                final Jun2dLine jun2dLine = (Jun2dLine)((Object)object);
                if (!jun2dLine.from().equals((Object)jun2dLine.to()) && (object2 = junOpenGLRotationModel.edgesDo_(new StBlockClosure(){

                    public Object value_(Object object) {
                        Jun2dPoint jun2dPoint;
                        Jun2dLine jun2dLine2 = (Jun2dLine)((Object)object);
                        if (!(jun2dLine2.from().equals((Object)jun2dLine2.to()) || (jun2dPoint = jun2dLine.lineSegmentIntersectingPointWithLineSegment_(jun2dLine2)) == null || jun2dPoint.equals((Object)jun2dLine.from()) || jun2dPoint.equals((Object)jun2dLine.to()) || jun2dPoint.equals((Object)jun2dLine2.from()) || jun2dPoint.equals((Object)jun2dLine2.to()))) {
                            return Boolean.FALSE;
                        }
                        return null;
                    }
                })) != null) {
                    return object2;
                }
                return null;
            }
        });
        if (object2 == Boolean.FALSE) {
            JunDialog.Warn_(JunSystem.$String((String)"Some segments intersect."));
            return null;
        }
        final StValueHolder stValueHolder = new StValueHolder(0.0);
        final StValueHolder stValueHolder2 = new StValueHolder();
        this.edgesDo_flag_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dLine jun2dLine = (Jun2dLine)((Object)object);
                Jun2dLine jun2dLine2 = (Jun2dLine)((Object)stValueHolder2.value());
                if (jun2dLine2 != null) {
                    double d = stValueHolder._doubleValue();
                    stValueHolder.value_(d += jun2dLine2.to().minus_(jun2dLine2.from()).product_(jun2dLine.to().minus_(jun2dLine.from())));
                }
                stValueHolder2.value_((Object)jun2dLine);
                return null;
            }
        }, 2);
        Jun2dPoint[] jun2dPointArray = this.allVertices();
        if (stValueHolder._doubleValue() < 0.0) {
            object = new Jun2dPoint[jun2dPointArray.length];
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                object[i] = jun2dPointArray[jun2dPointArray.length - i - 1];
            }
            jun2dPointArray = object;
        }
        object = JunBody.RotationSweep2dPoints_divisions_(jun2dPointArray, n);
        if (this.swapXY()) {
            JunROTATE.Body_point_vector_angle_((JunBody)object, new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0), JunAngle.FromDeg_(-90.0)).doOperation();
        }
        this.lastDivisions = n;
        return object;
    }

    public Integer[] _selectedIndicesAsArray() {
        int n = this.selection.size();
        Object[] objectArray = new Integer[n];
        this.selection.copyInto(objectArray);
        return objectArray;
    }

    public void deselectAll() {
        int n = this.selectedVertices().size();
        while (--n >= 0) {
            Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)this.selectedVertices().elementAt(n));
            this.deselectVertex_(jun2dPoint);
        }
    }

    public void deselectIndex_(int n) {
        Integer n2 = new Integer(n);
        if (this.selectedIndices().contains(n2)) {
            this.selectedIndices().removeElement(n2);
            this.changed_(JunOpenGLRotationModel.$((String)"selection"));
        }
    }

    public void deselectVertex_(Jun2dPoint jun2dPoint) {
        int n = this.vertexIndex_(jun2dPoint);
        if (n >= 0) {
            this.deselectIndex_(n);
        }
    }

    public boolean indexSelected_(int n) {
        return this.selectedIndices().contains(new Integer(n));
    }

    public int numSelection() {
        return this.selectedIndices().size();
    }

    public int selectedIndexAt_(int n) {
        return ((Number)this.selectedIndices().elementAt(n)).intValue();
    }

    public Vector selectedIndices() {
        if (this.selection == null) {
            this.selection = new Vector();
        }
        return this.selection;
    }

    public Jun2dPoint selectedVertexAt_(int n) {
        return this.vertexAt_(this.selectedIndexAt_(n));
    }

    public Vector selectedVertices() {
        int n = this.numSelection();
        Vector<Jun2dPoint> vector = new Vector<Jun2dPoint>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.selectedVertexAt_(i));
        }
        return vector;
    }

    public void selectIndex_(int n) {
        if (0 <= n && n < this.numVertices()) {
            Integer n2 = new Integer(n);
            if (this.selectedIndices().contains(n2)) {
                this.selectedIndices().removeElement(n2);
            }
            this.selectedIndices().addElement(n2);
            this.changed_(JunOpenGLRotationModel.$((String)"selection"));
        }
    }

    public void selectVertex_(Jun2dPoint jun2dPoint) {
        int n = this.vertexIndex_(jun2dPoint);
        if (n >= 0) {
            this.selectIndex_(n);
        }
    }

    public boolean vertexSelected_(Jun2dPoint jun2dPoint) {
        return this.selectedVertices().contains((Object)jun2dPoint);
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunOpenGLRotationModel.$((String)"loop")) {
            this.updateLoopMenu();
        }
        if (stSymbol == JunOpenGLRotationModel.$((String)"swapXY")) {
            this.updateSwapXYMenu();
        }
        if (stSymbol == JunOpenGLRotationModel.$((String)"showXAxis")) {
            this.updateShowXAxisMenu();
        }
        if (stSymbol == JunOpenGLRotationModel.$((String)"showYAxis")) {
            this.updateShowYAxisMenu();
        }
        this.changed_(stSymbol);
    }

    public void addVertex_(Jun2dPoint jun2dPoint) {
        this.polyline().add_(jun2dPoint);
    }

    public void addVertex_beforeIndex_(Jun2dPoint jun2dPoint, int n) {
        this.polyline().add_beforeIndex_(jun2dPoint, n);
    }

    public Jun2dPoint[] allVertices() {
        if (this.polyline().loop()) {
            Vector vector = this.polyline().vertices();
            int n = vector.size();
            Jun2dPoint[] jun2dPointArray = new Jun2dPoint[n + 1];
            vector.copyInto((Object[])jun2dPointArray);
            jun2dPointArray[n] = this.firstVertex();
            return jun2dPointArray;
        }
        return this.polyline()._verticesAsArray();
    }

    public Object edgesDo_(StBlockClosure stBlockClosure) {
        return this.polyline().edgesDo_(stBlockClosure);
    }

    public Object edgesDo_flag_(StBlockClosure stBlockClosure, int n) {
        return this.polyline().edgesDo_flag_(stBlockClosure, n);
    }

    public Jun2dPoint firstVertex() {
        return this.polyline().first();
    }

    public void grid_(double d) {
        this.grid = d;
        this.changed_(JunOpenGLRotationModel.$((String)"grid"));
    }

    public int nearestVertexIndex_(final Jun2dPoint jun2dPoint) {
        int n;
        int n2;
        int n3 = this.numSelection();
        if (n3 == 2 && Math.abs((n2 = this.selectedIndexAt_(0)) - (n = this.selectedIndexAt_(1))) == 1) {
            return Math.max(n2, n);
        }
        if (n3 == 1) {
            n2 = this.selectedIndexAt_(0);
            if (n2 == this.numVertices() - 1) {
                return n2 + 1;
            }
            if (n2 == 0) {
                return n2;
            }
            Jun2dLine jun2dLine = new Jun2dLine(this.vertexAt_(n2), this.vertexAt_(n2 - 1));
            double d = jun2dLine.lineSegmentDistanceFromPoint_(jun2dPoint);
            jun2dLine = new Jun2dLine(this.vertexAt_(n2), this.vertexAt_(n2 + 1));
            double d2 = jun2dLine.lineSegmentDistanceFromPoint_(jun2dPoint);
            if (d2 < d) {
                return n2 + 1;
            }
            return n2;
        }
        final StValueHolder stValueHolder = new StValueHolder(0);
        final StValueHolder stValueHolder2 = new StValueHolder(0);
        final StValueHolder stValueHolder3 = new StValueHolder();
        this.edgesDo_flag_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dLine jun2dLine = (Jun2dLine)((Object)object);
                double d = jun2dLine.from().equals((Object)jun2dLine.to()) ? jun2dLine.from().minus_(jun2dPoint).length() : jun2dLine.lineSegmentDistanceFromPoint_(jun2dPoint);
                if (stValueHolder3.value() == null || d < stValueHolder3._doubleValue()) {
                    stValueHolder.value_(stValueHolder2.value());
                    stValueHolder3.value_(d);
                }
                stValueHolder2.value_(stValueHolder2._intValue() + 1);
                return null;
            }
        }, 1);
        return stValueHolder._intValue();
    }

    public int numVertices() {
        return this.polyline().size();
    }

    public void removeVertex_(Jun2dPoint jun2dPoint) {
        int n = this.vertexIndex_(jun2dPoint);
        if (n >= 0) {
            this.removeVertexAtIndex_(n);
        }
    }

    public void removeVertexAtIndex_(int n) {
        this.polyline().removeAtIndex_(n);
        this.deselectIndex_(n);
        for (int i = 0; i < this.numSelection(); ++i) {
            int n2 = this.selectedIndexAt_(i);
            if (n2 <= n) continue;
            this.selectedIndices().setElementAt(new Integer(n2 - 1), i);
        }
    }

    public void removeVertices_(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)vector.elementAt(i));
            this.removeVertex_(jun2dPoint);
        }
    }

    public Jun2dPoint vertexAt_(int n) {
        return this.polyline().at_(n);
    }

    public void vertexAt_put_(int n, Jun2dPoint jun2dPoint) {
        this.polyline().at_put_(n, jun2dPoint);
    }

    public int vertexIndex_(Jun2dPoint jun2dPoint) {
        for (int i = 0; i < this.numVertices(); ++i) {
            if (!jun2dPoint.equals((Object)this.vertexAt_(i))) continue;
            return i;
        }
        return -1;
    }

    public Object verticesDo_(StBlockClosure stBlockClosure) {
        return this.polyline().verticesDo_(stBlockClosure);
    }

    protected String defaultStampForLRT10() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("%LRT V1.0 List Rotation Transmission (Lisp S Expression)");
        printWriter.println("% This file was created by " + JunSystem.System() + JunSystem.Version());
        printWriter.println("% " + DateFormat.getInstance().format(new Date()));
        printWriter.println();
        printWriter.flush();
        return stringWriter.toString();
    }

    public void saveToLRT10_(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.defaultStampForLRT10());
        this.toLispList().saveOn_(bufferedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToLRT10_(File file) throws IOException {
        if (file == null) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            this.saveToLRT10_(bufferedWriter);
        }
        finally {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }
}

