/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.util.Collection;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGL3dPolyline
extends JunOpenGL3dVertexesObject {
    protected float lineWidth;
    protected int stippleFactor = 1;
    protected short stipplePattern;

    public JunOpenGL3dPolyline() {
    }

    public JunOpenGL3dPolyline(Collection collection) {
        super(collection);
    }

    public JunOpenGL3dPolyline(Collection collection, Color color) {
        super(collection, color);
    }

    public JunOpenGL3dPolyline(Collection collection, Color color, float f) {
        super(collection, color, f);
    }

    public JunOpenGL3dPolyline(Jun3dPoint[] jun3dPointArray) {
        super(jun3dPointArray);
    }

    public JunOpenGL3dPolyline(Jun3dPoint[] jun3dPointArray, Color color) {
        super(jun3dPointArray, color);
    }

    public JunOpenGL3dPolyline(Jun3dPoint[] jun3dPointArray, Color color, float f) {
        super(jun3dPointArray, color, f);
    }

    public JunOpenGL3dPolyline(Jun3dPoint[] jun3dPointArray, Color[] colorArray) {
        super(jun3dPointArray, colorArray);
    }

    public JunOpenGL3dPolyline(Jun3dPoint[] jun3dPointArray, Color[] colorArray, float f) {
        super(jun3dPointArray, colorArray, f);
    }

    public JunOpenGL3dPolyline(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2) {
        super(jun3dPointArray, jun3dPointArray2);
    }

    public JunOpenGL3dPolyline(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2, Color[] colorArray) {
        super(jun3dPointArray, jun3dPointArray2, colorArray);
    }

    public JunOpenGL3dPolyline(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2, Color[] colorArray, float f) {
        super(jun3dPointArray, jun3dPointArray2, colorArray, f);
    }

    public JunOpenGL3dPolyline(JunLispList junLispList) {
        super(junLispList);
    }

    public static JunOpenGL3dObject FromLispList_(JunLispCons junLispCons) {
        return new JunOpenGL3dPolyline(junLispCons);
    }

    public static JunOpenGL3dObject Vertexes_(Jun3dPoint[] jun3dPointArray) {
        return new JunOpenGL3dPolyline(jun3dPointArray);
    }

    public static JunOpenGL3dObject Vertexes_(Collection collection) {
        return new JunOpenGL3dPolyline(collection);
    }

    public static JunOpenGL3dObject Vertexes_paint_(Jun3dPoint[] jun3dPointArray, Color color) {
        return new JunOpenGL3dPolyline(jun3dPointArray, color);
    }

    protected void initialize() {
        super.initialize();
        this.lineWidth = this.defaultLineWidth();
        this.stippleFactor = 1;
        this.stipplePattern = Short.MIN_VALUE;
    }

    public float lineWidth() {
        return this.lineWidth;
    }

    public void lineWidth_(float f) {
        this.lineWidth = f;
    }

    public int stippleFactor() {
        return this.stippleFactor;
    }

    public void stippleFactor_(int n) {
        this.stippleFactor = n;
    }

    public short stipplePattern() {
        return this.stipplePattern;
    }

    public void stipplePattern_(short s) {
        this.stipplePattern = s;
    }

    public void halftone_(double d) {
        int n = JunImageProcessor.Stipple_(Math.max(0.0, Math.min(d, 1.0)));
        this.stipplePattern = (short)n;
    }

    public boolean hasStipple() {
        return this.stipplePattern != Short.MIN_VALUE;
    }

    public boolean isLoop() {
        return false;
    }

    public boolean isPolyline() {
        return true;
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        if (this.hasPaint()) {
            junOpenGLRenderingContext.paint_(this.paint());
        }
        if (this.hasAlpha()) {
            junOpenGLRenderingContext.alpha_(this.alpha());
        }
        junOpenGLRenderingContext.lineWidth_(this.lineWidth());
        if (this.hasStipple()) {
            junOpenGLRenderingContext.lineStippleFactor_pattern_(this.stippleFactor(), this.stipplePattern());
            junOpenGLRenderingContext.enableLineStipple();
        }
        junOpenGLRenderingContext.displayLines_(this.vertexes());
        if (this.hasStipple()) {
            junOpenGLRenderingContext.disableLineStipple();
        }
    }

    public Object geometriesDo_(StBlockClosure stBlockClosure) {
        for (int i = 0; i < this.vertexes.length - 1; ++i) {
            Object object = stBlockClosure.value_((Object)new Jun3dLine(this.vertexes[i], this.vertexes[i + 1]));
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public void polylinesDo_(StBlockClosure stBlockClosure) {
        stBlockClosure.value_((Object)this);
    }

    public int numberOfPolygons() {
        return 0;
    }

    public StSymbol kindName() {
        return JunOpenGL3dPolyline.$((String)"Polyline");
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        if (!this.hasName() && !this.hasColor() && !this.hasStipple() && this.lineWidth <= 1.0f) {
            for (int i = 0; i < this.vertexes.length; ++i) {
                junLispCons.add_((Object)this.vertexes[i]);
            }
            return junLispCons;
        }
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.lineWidth() > 1.0f) {
            junLispCons.add_((Object)this.lineWidthToLispList());
        }
        if (this.hasStipple()) {
            junLispCons.add_((Object)this.stippleToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        junLispCons.add_((Object)this.vertexesToLispList());
        return junLispCons;
    }

    protected JunLispList lineWidthToLispList() {
        if (this.lineWidth <= 1.0f) {
            return this.lispNil();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dPolyline.$((String)"width"));
        junLispCons.tail_(new Float(this.lineWidth()));
        return junLispCons;
    }

    protected JunLispList stippleToLispList() {
        if (!this.hasStipple()) {
            return this.lispNil();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dPolyline.$((String)"stipple"));
        junLispCons.add_(new Integer(this.stippleFactor()));
        junLispCons.add_(new Short(this.stipplePattern()));
        return junLispCons;
    }

    protected JunLispList textureToLispList() {
        throw SmalltalkException.ShouldNotImplement();
    }

    public void fromLispList(JunLispList junLispList) {
        super.fromLispList(junLispList);
        this.lineWidthFromLispList(junLispList);
    }

    protected void lineWidthFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"width"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.lineWidth_(((Number)junLispCons.tail()).intValue());
    }

    protected void stippleFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"stipple"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.stippleFactor_(((Number)((JunLispCons)((Object)junLispCons.tail())).nth_(1)).intValue());
        this.stipplePattern_(((Number)((JunLispCons)((Object)junLispCons.tail())).nth_(2)).shortValue());
    }

    protected void textureFromLispList(JunLispList junLispList) {
    }

    protected String vrml10IndexedSetName() {
        return "IndexedLineSet";
    }

    protected String vrml20IndexedSetName() {
        return "IndexedLineSet";
    }
}

