/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.io.Writer;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGL3dNurbsCurve
extends JunOpenGL3dPrimitiveObject {
    protected float lineWidth;
    protected int stippleFactor;
    protected short stipplePattern;
    protected Jun3dPoint[] controlPoints;
    protected double[] weights;
    protected double[] knotVector;

    public static JunOpenGL3dNurbsCurve BezierControlPoints_(Jun3dPoint[] jun3dPointArray) {
        int n = jun3dPointArray.length;
        double[] dArray = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
            dArray[i + n] = 1.0;
        }
        return JunOpenGL3dNurbsCurve.BSplineControlPoints_knotVector_(jun3dPointArray, dArray);
    }

    public static JunOpenGL3dNurbsCurve BSplineControlPoints_knotVector_(Jun3dPoint[] jun3dPointArray, double[] dArray) {
        int n = jun3dPointArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 1.0;
        }
        return new JunOpenGL3dNurbsCurve(jun3dPointArray, dArray2, dArray);
    }

    public static final JunOpenGL3dObject Circle() {
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(0.0, -1.0, 0.0), new Jun3dPoint(1.0, -1.0, 0.0), new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(1.0, 1.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(-1.0, 1.0, 0.0), new Jun3dPoint(-1.0, 0.0, 0.0), new Jun3dPoint(-1.0, -1.0, 0.0), new Jun3dPoint(0.0, -1.0, 0.0)};
        double[] dArray = new double[]{1.0, Math.sqrt(0.5), 1.0, Math.sqrt(0.5), 1.0, Math.sqrt(0.5), 1.0, Math.sqrt(0.5), 1.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 4.0};
        return new JunOpenGL3dNurbsCurve(jun3dPointArray, dArray, dArray2);
    }

    public static JunOpenGL3dNurbsCurve ControlPoints_weights_knotVector_(Jun3dPoint[] jun3dPointArray, double[] dArray, double[] dArray2) {
        return new JunOpenGL3dNurbsCurve(jun3dPointArray, dArray, dArray2);
    }

    public JunOpenGL3dNurbsCurve(Jun3dPoint[] jun3dPointArray, double[] dArray, double[] dArray2) {
        this.controlPoints_(jun3dPointArray);
        this.weights_(dArray);
        this.knotVector_(dArray2);
    }

    public JunOpenGL3dNurbsCurve(JunLispList junLispList) {
        this.fromLispList(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.lineWidth = this.defaultLineWidth();
        this.stippleFactor = 1;
        this.stipplePattern = Short.MIN_VALUE;
        this.controlPoints = null;
        this.weights = null;
        this.knotVector = null;
    }

    public void halftone_(double d) {
        int n = JunImageProcessor.Stipple_(Math.max(0.0, Math.min(d, 1.0)));
        this.stipplePattern = (short)n;
    }

    public float lineWidth() {
        return this.lineWidth;
    }

    public void lineWidth_(float f) {
        this.lineWidth = f;
    }

    public int stippleFactor() {
        return this.stippleFactor;
    }

    public void stippleFactor_(int n) {
        this.stippleFactor = n;
    }

    public short stipplePattern() {
        return this.stipplePattern;
    }

    public void stipplePattern_(short s) {
        this.stipplePattern = s;
    }

    public Jun3dPoint[] controlPoints() {
        return this.controlPoints;
    }

    public void controlPoints_(Jun3dPoint[] jun3dPointArray) {
        this.controlPoints = jun3dPointArray;
    }

    public double[] weights() {
        return this.weights;
    }

    public void weights_(double[] dArray) {
        this.weights = dArray;
    }

    public double[] knotVector() {
        return this.knotVector;
    }

    public void knotVector_(double[] dArray) {
        this.knotVector = dArray;
    }

    public boolean hasStipple() {
        return this.stipplePattern != Short.MIN_VALUE;
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        if (this.hasPaint()) {
            junOpenGLRenderingContext.paint_(this.paint());
        }
        if (this.hasAlpha()) {
            junOpenGLRenderingContext.alpha_(this.alpha());
        }
        junOpenGLRenderingContext.lineWidth_(this.lineWidth);
        if (this.hasStipple()) {
            junOpenGLRenderingContext.lineStippleFactor_pattern_(this.stippleFactor(), this.stipplePattern());
            junOpenGLRenderingContext.enableLineStipple();
        }
        junOpenGLRenderingContext.displayNurbsCurve_(this._asJunNurbsCurve());
        if (this.hasStipple()) {
            junOpenGLRenderingContext.disableLineStipple();
        }
    }

    public Object geometriesDo_(StBlockClosure stBlockClosure) {
        return stBlockClosure.value_((Object)this._asJunNurbsCurve());
    }

    public void pointsDo_(StBlockClosure stBlockClosure) {
        for (int i = 0; i < this.controlPoints.length; ++i) {
            stBlockClosure.value_((Object)this.controlPoints[i]);
        }
    }

    public JunOpenGL3dObject transform_(Jun3dTransformation jun3dTransformation) {
        JunOpenGL3dNurbsCurve junOpenGL3dNurbsCurve = (JunOpenGL3dNurbsCurve)this.copy();
        for (int i = 0; i < junOpenGL3dNurbsCurve.controlPoints.length; ++i) {
            Jun3dPoint jun3dPoint;
            junOpenGL3dNurbsCurve.controlPoints[i] = jun3dPoint = junOpenGL3dNurbsCurve.controlPoints[i].transform_(jun3dTransformation);
        }
        return junOpenGL3dNurbsCurve;
    }

    public JunNurbsCurve _asJunNurbsCurve() {
        return new JunNurbsCurve(this.controlPoints, this.weights, this.knotVector);
    }

    public JunOpenGL3dObject reversed() {
        throw new SmalltalkException("not implemented yet");
    }

    public JunOpenGL3dObject controlPointsObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        if (this.controlPoints != null) {
            for (int i = 0; i < this.controlPoints.length; ++i) {
                JunOpenGL3dVertex junOpenGL3dVertex = new JunOpenGL3dVertex(this.controlPoints[i], Color.blue);
                junOpenGL3dVertex.size_(5.0f);
                junOpenGL3dCompoundObject.add_(junOpenGL3dVertex);
            }
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(this.controlPoints, Color.blue));
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dObject yourselfAndControlPointsObject() {
        return new JunOpenGL3dCompoundObject(this, this.controlPointsObject());
    }

    public StObject postCopy() {
        super.postCopy();
        this.controlPoints = (Jun3dPoint[])this.controlPoints.clone();
        this.weights = (double[])this.weights.clone();
        this.knotVector = (double[])this.knotVector.clone();
        return this;
    }

    public int numberOfPolygons() {
        return 0;
    }

    public StSymbol kindName() {
        return JunOpenGL3dNurbsCurve.$((String)"NurbsCurve");
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.lineWidth() > 1.0f) {
            junLispCons.add_((Object)this.lineWidthToLispList());
        }
        if (this.hasStipple()) {
            junLispCons.add_((Object)this.stippleToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        junLispCons.add_((Object)this.controlsToLispList());
        junLispCons.add_((Object)this.weightsToLispList());
        junLispCons.add_((Object)this.knotsToLispList());
        return junLispCons;
    }

    protected JunLispList stippleToLispList() {
        if (!this.hasStipple()) {
            return this.lispNil();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dNurbsCurve.$((String)"stipple"));
        junLispCons.add_(new Integer(this.stippleFactor()));
        junLispCons.add_(new Short(this.stipplePattern()));
        return junLispCons;
    }

    protected JunLispList textureToLispList() {
        throw SmalltalkException.ShouldNotImplement();
    }

    protected JunLispList lineWidthToLispList() {
        if (this.lineWidth <= 1.0f) {
            return this.lispNil();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dNurbsCurve.$((String)"width"));
        junLispCons.tail_(new Float(this.lineWidth()));
        return junLispCons;
    }

    protected JunLispList controlsToLispList() {
        Object[] objectArray = new Object[this.controlPoints.length + 1];
        objectArray[0] = JunOpenGL3dNurbsCurve.$((String)"controls");
        for (int i = 0; i < this.controlPoints.length; ++i) {
            objectArray[i + 1] = this.controlPoints[i];
        }
        return JunLispCons.List_(objectArray);
    }

    protected JunLispList weightsToLispList() {
        Object[] objectArray = new Object[this.weights.length + 1];
        objectArray[0] = JunOpenGL3dNurbsCurve.$((String)"weights");
        for (int i = 0; i < this.weights.length; ++i) {
            objectArray[i + 1] = new Double(this.weights[i]);
        }
        return JunLispCons.List_(objectArray);
    }

    protected JunLispList knotsToLispList() {
        Object[] objectArray = new Object[this.knotVector.length + 1];
        objectArray[0] = JunOpenGL3dNurbsCurve.$((String)"knots");
        for (int i = 0; i < this.knotVector.length; ++i) {
            objectArray[i + 1] = new Double(this.knotVector[i]);
        }
        return JunLispCons.List_(objectArray);
    }

    public void fromLispList(JunLispList junLispList) {
        super.fromLispList(junLispList);
        this.lineWidthFromLispList(junLispList);
        this.stippleFromLispList(junLispList);
        this.controlsFromLispList(junLispList);
        this.weightsFromLispList(junLispList);
        this.knotsFromLispList(junLispList);
        this.transformationFromLispList(junLispList);
    }

    protected void controlsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"controls"));
            }
        }, new StBlockClosure()));
        Object[] objectArray = junLispCons == null ? ((JunLispCons)((Object)junLispList.tail())).asArray() : ((JunLispCons)((Object)junLispCons.tail())).asArray();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[objectArray.length];
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            jun3dPointArray[i] = (Jun3dPoint)((Object)objectArray[i]);
        }
        this.controlPoints_(jun3dPointArray);
    }

    protected void knotsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"knots"));
            }
        }, new StBlockClosure()));
        Object[] objectArray = junLispCons == null ? ((JunLispList)((Object)junLispList.tail())).asArray() : ((JunLispList)((Object)junLispCons.tail())).asArray();
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((Number)objectArray[i]).doubleValue();
        }
        this.knotVector_(dArray);
    }

    protected void lineWidthFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"width"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.lineWidth_(((Number)junLispCons.tail()).floatValue());
    }

    protected void stippleFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"stipple"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.stippleFactor_(((Number)((JunLispCons)((Object)junLispCons.tail())).nth_(1)).intValue());
        this.stipplePattern_(((Number)((JunLispCons)((Object)junLispCons.tail())).nth_(2)).shortValue());
    }

    protected void weightsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 5.$((String)"weights"));
            }
        }, new StBlockClosure()));
        Object[] objectArray = junLispCons == null ? ((JunLispList)((Object)junLispList.tail())).asArray() : ((JunLispList)((Object)junLispCons.tail())).asArray();
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((Number)objectArray[i]).doubleValue();
        }
        this.weights_(dArray);
    }

    public void vrml10On_(Writer writer) {
        throw new SmalltalkException("not implemented yet");
    }

    public void vrml20On_(Writer writer) {
        throw new SmalltalkException("not implemented yet");
    }
}

