/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.awt.Cursor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dArc;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dGraph;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dNode;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCone;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCylinder;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsCurve;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsSurface;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPatchedObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dSphere;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.opengl.picking.JunOpenGLPickingObjects;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGL3dCompoundObject
extends JunOpenGL3dObject
implements JunOpenGLPickingObjects {
    protected ArrayList components;
    protected JunOpenGLTexture texture;
    protected JunAngle smoothingAngle;

    public JunOpenGL3dCompoundObject() {
        this(0);
    }

    public JunOpenGL3dCompoundObject(int n) {
        this.initialize_(n);
    }

    public JunOpenGL3dCompoundObject(Collection collection) {
        this.components_(collection);
    }

    public JunOpenGL3dCompoundObject(JunOpenGL3dObject junOpenGL3dObject) {
        this(1);
        this.add_(junOpenGL3dObject);
    }

    public JunOpenGL3dCompoundObject(JunOpenGL3dObject junOpenGL3dObject, JunOpenGL3dObject junOpenGL3dObject2) {
        this(2);
        this.add_(junOpenGL3dObject);
        this.add_(junOpenGL3dObject2);
    }

    public JunOpenGL3dCompoundObject(JunOpenGL3dObject junOpenGL3dObject, JunOpenGL3dObject junOpenGL3dObject2, JunOpenGL3dObject junOpenGL3dObject3) {
        this(3);
        this.add_(junOpenGL3dObject);
        this.add_(junOpenGL3dObject2);
        this.add_(junOpenGL3dObject3);
    }

    public JunOpenGL3dCompoundObject(JunOpenGL3dObject junOpenGL3dObject, JunOpenGL3dObject junOpenGL3dObject2, JunOpenGL3dObject junOpenGL3dObject3, JunOpenGL3dObject junOpenGL3dObject4) {
        this(4);
        this.add_(junOpenGL3dObject);
        this.add_(junOpenGL3dObject2);
        this.add_(junOpenGL3dObject3);
        this.add_(junOpenGL3dObject4);
    }

    public JunOpenGL3dCompoundObject(JunOpenGL3dObject[] junOpenGL3dObjectArray) {
        this.addAll_(junOpenGL3dObjectArray);
    }

    public JunOpenGL3dCompoundObject(JunLispList junLispList) {
        this();
        StSymbol stSymbol = (StSymbol)junLispList.head();
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"SkinningBody")) {
            this.skinningBodyFromLispList(junLispList);
        } else {
            this.fromLispList(junLispList);
        }
    }

    public static JunOpenGL3dCompoundObject Components_(Vector vector) {
        return new JunOpenGL3dCompoundObject(vector);
    }

    public static JunOpenGL3dCompoundObject With_(JunOpenGL3dObject junOpenGL3dObject) {
        return new JunOpenGL3dCompoundObject(junOpenGL3dObject);
    }

    public static JunOpenGL3dCompoundObject With_with_(JunOpenGL3dObject junOpenGL3dObject, JunOpenGL3dObject junOpenGL3dObject2) {
        return new JunOpenGL3dCompoundObject(junOpenGL3dObject, junOpenGL3dObject2);
    }

    public static JunOpenGL3dCompoundObject With_with_with_(JunOpenGL3dObject junOpenGL3dObject, JunOpenGL3dObject junOpenGL3dObject2, JunOpenGL3dObject junOpenGL3dObject3) {
        return new JunOpenGL3dCompoundObject(junOpenGL3dObject, junOpenGL3dObject2, junOpenGL3dObject3);
    }

    public static JunOpenGL3dCompoundObject With_with_with_with_(JunOpenGL3dObject junOpenGL3dObject, JunOpenGL3dObject junOpenGL3dObject2, JunOpenGL3dObject junOpenGL3dObject3, JunOpenGL3dObject junOpenGL3dObject4) {
        return new JunOpenGL3dCompoundObject(junOpenGL3dObject, junOpenGL3dObject2, junOpenGL3dObject3, junOpenGL3dObject4);
    }

    public static JunOpenGL3dCompoundObject WithAll_(JunOpenGL3dObject[] junOpenGL3dObjectArray) {
        return new JunOpenGL3dCompoundObject(junOpenGL3dObjectArray);
    }

    public static JunOpenGL3dObject FromLispList_(JunLispCons junLispCons) {
        StSymbol stSymbol = (StSymbol)junLispCons.head();
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"PatchedBody")) {
            return new JunOpenGL3dPatchedObject(junLispCons);
        }
        return new JunOpenGL3dCompoundObject(junLispCons);
    }

    public static JunOpenGL3dObject ObjectFromLispList_(JunLispCons junLispCons) {
        StSymbol stSymbol = (StSymbol)junLispCons.head();
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"CompoundBody")) {
            return new JunOpenGL3dCompoundObject(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"PatchedBody")) {
            return new JunOpenGL3dPatchedObject(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"SkinningBody")) {
            return new JunOpenGL3dCompoundObject(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Polygon")) {
            return new JunOpenGL3dPolygon(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Polyline")) {
            return new JunOpenGL3dPolyline(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"PolylineLoop")) {
            return new JunOpenGL3dPolylineLoop(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Spot")) {
            return new JunOpenGL3dVertex(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"NurbsCurve")) {
            return new JunOpenGL3dNurbsCurve(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"NurbsSurface")) {
            return new JunOpenGL3dNurbsSurface(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Cone")) {
            return new JunOpenGL3dCone(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Cylinder")) {
            return new JunOpenGL3dCylinder(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Sphere")) {
            return new JunOpenGL3dSphere(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Arc")) {
            return new JunOpenGL3dArc(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Graph")) {
            return new JunOpenGL3dGraph(junLispCons);
        }
        if (stSymbol == JunOpenGL3dCompoundObject.$((String)"Node")) {
            return new JunOpenGL3dNode(junLispCons);
        }
        throw SmalltalkException.Error((String)"unexpected error");
    }

    protected void initialize() {
        this.initialize_(-1);
    }

    protected void initialize_(int n) {
        super.initialize();
        this.components = n < 0 ? null : new ArrayList(n);
        this.texture = null;
        this.smoothingAngle = null;
    }

    protected ArrayList _components() {
        if (this.components == null) {
            this.components = new ArrayList();
        }
        return this.components;
    }

    public JunOpenGL3dObject[] components() {
        return this._components().toArray(new JunOpenGL3dObject[this.size()]);
    }

    public void components_(JunOpenGL3dObject[] junOpenGL3dObjectArray) {
        if (junOpenGL3dObjectArray == null) {
            this.components = new ArrayList(0);
        } else {
            this.components = new ArrayList(junOpenGL3dObjectArray.length);
            this.addAll_(junOpenGL3dObjectArray);
        }
    }

    public void components_(Collection collection) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = null;
        if (collection != null) {
            junOpenGL3dObjectArray = new JunOpenGL3dObject[collection.size()];
            collection.toArray(junOpenGL3dObjectArray);
        }
        this.components_(junOpenGL3dObjectArray);
    }

    public JunOpenGLTexture texture() {
        return this.texture;
    }

    public void texture_(JunOpenGLTexture junOpenGLTexture) {
        this.texture = junOpenGLTexture;
        super.texture_(junOpenGLTexture);
    }

    public JunAngle smoothingAngle() {
        return this.smoothingAngle;
    }

    protected void smoothingAngle_(JunAngle junAngle) {
        this.smoothingAngle = junAngle;
    }

    public int size() {
        return this._components().size();
    }

    public void establishAllNormalVectorsWithSmoothingAngle_(JunAngle junAngle) {
        final JunGeometry.HashEqualityDictionary hashEqualityDictionary = new JunGeometry.HashEqualityDictionary();
        this.polygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dPolygon junOpenGL3dPolygon = (JunOpenGL3dPolygon)((Object)object);
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[junOpenGL3dPolygon.numberOfVertexes()];
                for (int i = 0; i < jun3dPointArray.length; ++i) {
                    jun3dPointArray[i] = junOpenGL3dPolygon.normalVector();
                }
                junOpenGL3dPolygon.normalVectors_(jun3dPointArray);
                Jun3dPoint[] jun3dPointArray2 = junOpenGL3dPolygon.vertexes();
                for (int i = 0; i < jun3dPointArray2.length; ++i) {
                    ArrayList<JunOpenGL3dPolygon> arrayList = (ArrayList<JunOpenGL3dPolygon>)hashEqualityDictionary.get(jun3dPointArray2[i]);
                    if (arrayList == null) {
                        arrayList = new ArrayList<JunOpenGL3dPolygon>();
                        hashEqualityDictionary.put(jun3dPointArray2[i], arrayList);
                    }
                    arrayList.add(junOpenGL3dPolygon);
                }
                return null;
            }
        });
        Iterator iterator = hashEqualityDictionary.keySet().iterator();
        while (iterator.hasNext()) {
            Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)iterator.next());
            ArrayList arrayList = (ArrayList)hashEqualityDictionary.get(jun3dPoint);
            this._establishNormalVectors(jun3dPoint, arrayList, junAngle);
        }
        this.smoothingAngle_(junAngle);
    }

    protected void _establishNormalVectors(Jun3dPoint jun3dPoint, ArrayList arrayList, JunAngle junAngle) {
        double d;
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        JunOpenGL3dPolygon junOpenGL3dPolygon = (JunOpenGL3dPolygon)((Object)arrayList.remove(0));
        Jun3dPoint jun3dPoint2 = junOpenGL3dPolygon.normalVector();
        ArrayList<JunOpenGL3dPolygon> arrayList2 = new ArrayList<JunOpenGL3dPolygon>();
        arrayList2.add(junOpenGL3dPolygon);
        JunOpenGL3dPolygon junOpenGL3dPolygon2 = junOpenGL3dPolygon;
        JunOpenGL3dPolygon junOpenGL3dPolygon3 = null;
        while ((junOpenGL3dPolygon3 = junOpenGL3dPolygon2._findAdjacentOnRight(jun3dPoint, arrayList)) != null && !arrayList2.contains((Object)junOpenGL3dPolygon3) && !((d = junOpenGL3dPolygon2.normalVector().dotProduct_(junOpenGL3dPolygon3.normalVector())) < junAngle.cos())) {
            arrayList2.add(junOpenGL3dPolygon3);
            jun3dPoint2 = jun3dPoint2.plus_(junOpenGL3dPolygon3.normalVector());
            arrayList.remove((Object)junOpenGL3dPolygon3);
            junOpenGL3dPolygon2 = junOpenGL3dPolygon3;
        }
        junOpenGL3dPolygon2 = junOpenGL3dPolygon;
        junOpenGL3dPolygon3 = null;
        while ((junOpenGL3dPolygon3 = junOpenGL3dPolygon2._findAdjacentOnLeft(jun3dPoint, arrayList)) != null && !arrayList2.contains((Object)junOpenGL3dPolygon3) && !((d = junOpenGL3dPolygon2.normalVector().dotProduct_(junOpenGL3dPolygon3.normalVector())) < junAngle.cos())) {
            arrayList2.add(junOpenGL3dPolygon3);
            jun3dPoint2 = jun3dPoint2.plus_(junOpenGL3dPolygon3.normalVector());
            arrayList.remove((Object)junOpenGL3dPolygon3);
            junOpenGL3dPolygon2 = junOpenGL3dPolygon3;
        }
        if (arrayList2.size() > 1) {
            jun3dPoint2 = jun3dPoint2.unitVector();
            for (int i = 0; i < arrayList2.size(); ++i) {
                junOpenGL3dPolygon = (JunOpenGL3dPolygon)((Object)arrayList2.get(i));
                int n = junOpenGL3dPolygon.indexOfVertex(jun3dPoint);
                junOpenGL3dPolygon.normalVectors()[n] = jun3dPoint2;
            }
        }
        if (!arrayList.isEmpty()) {
            this._establishNormalVectors(jun3dPoint, arrayList, junAngle);
        }
    }

    public void flushAllAlphas() {
        this.flushAlpha();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].flushAllAlphas();
        }
    }

    public void flushAllBounds() {
        this.flushBounds();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].flushAllBounds();
        }
    }

    public void flushAllColors() {
        this.flushColors();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].flushAllColors();
        }
    }

    public void flushAllNames() {
        this.flushName();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].flushAllNames();
        }
    }

    public void flushAllNormalVectors() {
        this.flushNormalVectors();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].flushAllNormalVectors();
        }
    }

    public void flushAllPaints() {
        this.flushPaint();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].flushAllPaints();
        }
    }

    public void flushComponents() {
        this.components = null;
    }

    public void flushSmoothingAngle() {
        this.smoothingAngle = null;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public boolean isCompound() {
        return true;
    }

    public boolean isCompoundBody() {
        if (this.components == null) {
            return true;
        }
        if (this.components.isEmpty()) {
            return true;
        }
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            JunOpenGL3dObject junOpenGL3dObject = junOpenGL3dObjectArray[i];
            if (junOpenGL3dObject.hasColor()) {
                return true;
            }
            if (junOpenGL3dObject.hasStipple()) {
                return true;
            }
            if (junOpenGL3dObject instanceof JunOpenGL3dPolygon) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this._components().isEmpty();
    }

    public boolean isPatchedBody() {
        if (this.isCompoundBody()) {
            return false;
        }
        int n = 0;
        Vector<Jun3dPoint> vector = new Vector<Jun3dPoint>(1024);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            JunOpenGL3dPolygon junOpenGL3dPolygon = (JunOpenGL3dPolygon)junOpenGL3dObjectArray[i];
            if (junOpenGL3dPolygon.hasColors() || junOpenGL3dPolygon.hasNormalVectors()) {
                return false;
            }
            Jun3dPoint[] jun3dPointArray = junOpenGL3dPolygon.vertexes();
            int n4 = jun3dPointArray.length;
            n += n4;
            for (int j = 0; j < n4; ++j) {
                Jun3dPoint jun3dPoint = jun3dPointArray[j];
                int n5 = -1;
                for (int k = 0; k < vector.size(); ++k) {
                    if (!jun3dPoint.equals((Object)((Jun3dPoint)((Object)vector.elementAt(k))))) continue;
                    n5 = k;
                    break;
                }
                if (n5 >= 0) continue;
                vector.add(jun3dPoint);
            }
            n2 = Math.min(n2, n4);
            n3 = Math.max(n3, n4);
        }
        return n2 != n3 || vector.size() * 2 <= n;
    }

    public boolean isSkinningBody() {
        if (this.isCompoundBody()) {
            return false;
        }
        return !this.isPatchedBody();
    }

    public StObject postCopy() {
        super.postCopy();
        if (this.components != null) {
            this.components = (ArrayList)this.components.clone();
        }
        return this;
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        int n = Integer.MIN_VALUE;
        if (this.hasTexture()) {
            n = junOpenGLRenderingContext.textureCoordinateIndex();
            junOpenGLRenderingContext.textureCoordinateIndex_(0);
            this.texture().enableTextureOn_(junOpenGLRenderingContext);
        }
        if (this.hasTransparency()) {
            junOpenGLRenderingContext.enableCullFace();
            junOpenGLRenderingContext.disableDepthMask();
            junOpenGLRenderingContext.enableBlending();
        }
        this.renderOpaqueComponentsOn_(junOpenGLRenderingContext);
        this.renderTransparentComponentsOn_(junOpenGLRenderingContext);
        if (this.hasTransparency()) {
            junOpenGLRenderingContext.disableCullFace();
            junOpenGLRenderingContext.enableDepthMask();
            junOpenGLRenderingContext.disableBlending();
        }
        if (this.hasTexture()) {
            this.texture().disableTextureOn_(junOpenGLRenderingContext);
            junOpenGLRenderingContext.textureCoordinateIndex_(n);
        }
    }

    protected void renderOpaqueComponentsOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            if (junOpenGL3dObjectArray[i].hasTransparency()) continue;
            if (this.hasPaint()) {
                junOpenGLRenderingContext.paint_(this.paint());
            }
            if (this.hasAlpha()) {
                junOpenGLRenderingContext.alpha_(this.alpha());
            }
            if (this.hasTexture()) {
                this.texture().enableTextureOn_(junOpenGLRenderingContext);
            }
            junOpenGL3dObjectArray[i].renderOn_(junOpenGLRenderingContext);
        }
    }

    protected void renderTransparentComponentsOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            if (!junOpenGL3dObjectArray[i].hasTransparency()) continue;
            if (this.hasPaint()) {
                junOpenGLRenderingContext.paint_(this.paint());
            }
            if (this.hasAlpha()) {
                junOpenGLRenderingContext.alpha_(this.alpha());
            }
            if (this.hasTexture()) {
                this.texture().enableTextureOn_(junOpenGLRenderingContext);
            }
            junOpenGL3dObjectArray[i].renderOn_(junOpenGLRenderingContext);
        }
    }

    public void add_(JunOpenGL3dObject junOpenGL3dObject) {
        if (junOpenGL3dObject == null) {
            return;
        }
        this._components().add(junOpenGL3dObject);
        this.flushBounds();
    }

    public void addAll_(JunOpenGL3dObject[] junOpenGL3dObjectArray) {
        if (junOpenGL3dObjectArray == null) {
            return;
        }
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            this.add_(junOpenGL3dObjectArray[i]);
        }
    }

    public void addAll_(Collection collection) {
        if (collection == null) {
            return;
        }
        JunOpenGL3dObject[] junOpenGL3dObjectArray = new JunOpenGL3dObject[collection.size()];
        collection.toArray(junOpenGL3dObjectArray);
        this.addAll_(junOpenGL3dObjectArray);
    }

    public void remove_(JunOpenGL3dObject junOpenGL3dObject) {
        if (junOpenGL3dObject == null) {
            return;
        }
        this._components().remove((Object)junOpenGL3dObject);
        this.flushBounds();
    }

    public void removeAll_(JunOpenGL3dObject[] junOpenGL3dObjectArray) {
        if (junOpenGL3dObjectArray == null) {
            return;
        }
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            this.remove_(junOpenGL3dObjectArray[i]);
        }
    }

    public void removeAll_(Collection collection) {
        if (collection == null) {
            return;
        }
        JunOpenGL3dObject[] junOpenGL3dObjectArray = new JunOpenGL3dObject[collection.size()];
        collection.toArray(junOpenGL3dObjectArray);
        this.removeAll_(junOpenGL3dObjectArray);
    }

    public Object do_(StBlockClosure stBlockClosure) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            Object object = stBlockClosure.value_((Object)junOpenGL3dObjectArray[i]);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object objectsDo_(StBlockClosure stBlockClosure) {
        stBlockClosure.value_((Object)this);
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            Object object = junOpenGL3dObjectArray[i].objectsDo_(stBlockClosure);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Object geometriesDo_(StBlockClosure stBlockClosure) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            Object object = junOpenGL3dObjectArray[i].geometriesDo_(stBlockClosure);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public void pointsDo_(StBlockClosure stBlockClosure) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].pointsDo_(stBlockClosure);
        }
    }

    public Object primitivesDo_(StBlockClosure stBlockClosure) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].primitivesDo_(stBlockClosure);
        }
        return null;
    }

    public void polygonsDo_(StBlockClosure stBlockClosure) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].polygonsDo_(stBlockClosure);
        }
    }

    public void polylinesDo_(StBlockClosure stBlockClosure) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].polylinesDo_(stBlockClosure);
        }
    }

    public JunOpenGL3dObject transform_(Jun3dTransformation jun3dTransformation) {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = (JunOpenGL3dCompoundObject)this.copy();
        if (this.components != null) {
            JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
            JunOpenGL3dObject[] junOpenGL3dObjectArray2 = new JunOpenGL3dObject[junOpenGL3dObjectArray.length];
            for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
                junOpenGL3dObjectArray2[i] = junOpenGL3dObjectArray[i].transform_(jun3dTransformation);
            }
            junOpenGL3dCompoundObject.components_(junOpenGL3dObjectArray2);
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject asCompoundObject() {
        return this;
    }

    public JunOpenGL3dPatchedObject asPatchedObject() {
        JunOpenGL3dPatchedObject junOpenGL3dPatchedObject = new JunOpenGL3dPatchedObject();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        if (junOpenGL3dObjectArray.length > 0) {
            for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
                if (!(junOpenGL3dObjectArray[i] instanceof JunOpenGL3dPolygon)) {
                    return null;
                }
                junOpenGL3dPatchedObject.add_((JunOpenGL3dPolygon)junOpenGL3dObjectArray[i]);
            }
        }
        if (this.name != null) {
            junOpenGL3dPatchedObject.name = this.name;
        }
        if (this.paint != null) {
            junOpenGL3dPatchedObject.paint = this.paint;
        }
        junOpenGL3dPatchedObject.alpha = this.alpha;
        if (this.texture != null) {
            junOpenGL3dPatchedObject.texture = this.texture;
        }
        return junOpenGL3dPatchedObject;
    }

    public JunOpenGL3dObject reversed() {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = (JunOpenGL3dCompoundObject)JunOpenGL3dCompoundObject._New(this.getClass(), (Object)new Integer(junOpenGL3dObjectArray.length));
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dCompoundObject.add_(junOpenGL3dObjectArray[i].reversed());
        }
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dObject yourselfAndNormalVectorsObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dCompoundObject.add_(junOpenGL3dObjectArray[i].yourselfAndNormalVectorsObject());
        }
        this._copyInto(junOpenGL3dCompoundObject);
        return junOpenGL3dCompoundObject;
    }

    public int numberOfPolygons() {
        int n = 0;
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            n += junOpenGL3dObjectArray[i].numberOfPolygons();
        }
        return n;
    }

    public int numberOfPrimitives() {
        int n = 0;
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            n += junOpenGL3dObjectArray[i].numberOfPrimitives();
        }
        return n;
    }

    protected void patcheCollection_from_for_(Vector vector, Vector vector2, JunOpenGL3dObject junOpenGL3dObject) {
        if (junOpenGL3dObject instanceof JunOpenGL3dPolygon) {
            Jun3dPoint[] jun3dPointArray = ((JunOpenGL3dPolygon)junOpenGL3dObject).vertexes();
            Vector<Integer> vector3 = new Vector<Integer>(jun3dPointArray.length);
            for (int i = 0; i < jun3dPointArray.length; ++i) {
                int n = vector2.indexOf((Object)jun3dPointArray[i]);
                if (n < 0) continue;
                vector3.addElement(new Integer(n + 1));
            }
            vector.addElement(vector3);
        }
    }

    protected void pointCollection_for_(Vector vector, JunOpenGL3dObject junOpenGL3dObject) {
        if (junOpenGL3dObject instanceof JunOpenGL3dPolygon) {
            Jun3dPoint[] jun3dPointArray = ((JunOpenGL3dPolygon)junOpenGL3dObject).vertexes();
            for (int i = 0; i < jun3dPointArray.length; ++i) {
                if (vector.indexOf((Object)jun3dPointArray[i]) >= 0) continue;
                vector.addElement(jun3dPointArray[i]);
            }
        }
    }

    public StSymbol kindName() {
        return JunOpenGL3dCompoundObject.$((String)"CompoundBody");
    }

    public JunLispCons toLispList() {
        if (!this.isCompoundBody()) {
            return this.patchedOrSkinningBodyToLispList();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        junLispCons.add_((Object)this.componentsToLispList());
        return junLispCons;
    }

    protected JunLispList textureToLispList() {
        if (!this.hasTexture()) {
            return this.lispNil();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dCompoundObject.$((String)"texture"));
        junLispCons.tail_((Object)this.texture().toLispList());
        return junLispCons;
    }

    protected JunLispList componentsToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dCompoundObject.$((String)"bodies"));
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junLispCons.add_((Object)junOpenGL3dObjectArray[i].toLispList());
        }
        return junLispCons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JunLispCons patchedBodyToLispList() {
        Object[] objectArray;
        Object object;
        Vector vector;
        Object object2;
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dCompoundObject.$((String)"PatchedBody"));
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        JunCursors junCursors = new JunCursors(Cursor.getPredefinedCursor(3));
        try {
            int n;
            junCursors._show();
            object2 = this.components();
            vector = new Vector(1024);
            for (int i = 0; i < ((JunOpenGL3dObject[])object2).length; ++i) {
                this.pointCollection_for_(vector, object2[i]);
            }
            object = new Vector(1024);
            for (n = 0; n < ((JunOpenGL3dObject[])object2).length; ++n) {
                this.patcheCollection_from_for_((Vector)object, vector, object2[n]);
            }
            objectArray = object.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = JunLispCons.List_((Vector)objectArray[n]);
            }
        }
        finally {
            junCursors._restore();
        }
        object2 = JunLispCons.List_(vector);
        object = JunLispCons.List_(objectArray);
        object2 = JunLispCons.Head_tail_(JunOpenGL3dCompoundObject.$((String)"points"), object2);
        object = JunLispCons.Head_tail_(JunOpenGL3dCompoundObject.$((String)"patches"), object);
        junLispCons.add_(object2);
        junLispCons.add_(object);
        return junLispCons;
    }

    protected JunLispCons skinningBodyToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dCompoundObject.$((String)"SkinningBody"));
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        JunLispList[] junLispListArray = new JunLispList[junOpenGL3dObjectArray.length];
        for (int i = 0; i < junLispListArray.length; ++i) {
            junLispListArray[i] = junOpenGL3dObjectArray[i].toLispList();
        }
        JunLispList junLispList = JunLispCons.List_((Object[])junLispListArray);
        junLispList = JunLispCons.Head_tail_(JunOpenGL3dCompoundObject.$((String)"polygons"), (Object)junLispList);
        junLispCons.add_((Object)junLispList);
        return junLispCons;
    }

    protected JunLispCons patchedOrSkinningBodyToLispList() {
        if (this.isSkinningBody()) {
            return this.skinningBodyToLispList();
        }
        return this.asPatchedObject().toLispList();
    }

    public void fromLispList(JunLispList junLispList) {
        super.fromLispList(junLispList);
        this.componentsFromLispList(junLispList);
        this.textureFromLispList(junLispList);
        this.transformationFromLispList(junLispList);
    }

    protected void componentsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"bodies"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispList)((Object)junLispCons.tail())).asArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.add_(JunOpenGL3dCompoundObject.ObjectFromLispList_((JunLispCons)((Object)objectArray[i])));
        }
    }

    protected void textureFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"texture"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        if (junLispCons.tail() instanceof JunLispCons) {
            this.texture_(new JunOpenGLTexture((JunLispCons)((Object)junLispCons.tail())));
        }
    }

    protected void patchedBodyFromLispList(JunLispList junLispList) {
        this.nameFromLispList(junLispList);
        this.colorFromLispList(junLispList);
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"points"));
            }
        }, new StBlockClosure()));
        Object[] objectArray = junLispCons == null ? null : ((JunLispCons)((Object)junLispCons.tail())).asArray();
        junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 5.$((String)"patches"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        if (objectArray == null) {
            Object[] objectArray2 = ((JunLispCons)((Object)junLispCons.tail())).asArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                this.add_(new JunOpenGL3dPolygon((JunLispCons)((Object)objectArray2[i])));
            }
        } else {
            int n;
            Object[] objectArray3 = ((JunLispCons)((Object)junLispCons.tail())).asArray();
            Object[] objectArray4 = new Object[objectArray3.length];
            for (n = 0; n < objectArray3.length; ++n) {
                objectArray4[n] = ((JunLispList)((Object)objectArray3[n])).asArray();
            }
            for (n = 0; n < objectArray4.length; ++n) {
                Object[] objectArray5 = (Object[])objectArray4[n];
                int n2 = objectArray5.length;
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n2];
                for (int i = 0; i < n2; ++i) {
                    jun3dPointArray[i] = (Jun3dPoint)((Object)objectArray[((Number)objectArray5[i]).intValue() - 1]);
                }
                this.add_(new JunOpenGL3dPolygon(jun3dPointArray));
            }
        }
        this.textureFromLispList(junLispList);
        this.transformationFromLispList(junLispList);
    }

    protected void skinningBodyFromLispList(JunLispList junLispList) {
        this.nameFromLispList(junLispList);
        this.colorFromLispList(junLispList);
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 6.$((String)"polygons"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Object[] objectArray = ((JunLispList)((Object)junLispCons.tail())).asArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.add_(new JunOpenGL3dPolygon((JunLispCons)((Object)objectArray[i])));
        }
        this.textureFromLispList(junLispList);
        this.transformationFromLispList(junLispList);
    }

    public void vrml10On_(Writer writer) {
        try {
            BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            bufferedWriter.write("DEF ");
            bufferedWriter.write(this.legalName());
            bufferedWriter.newLine();
            bufferedWriter.write("Separator {");
            bufferedWriter.newLine();
            this.vrml10ColorOn_(bufferedWriter);
            this.vrml10ComponentsOn_(bufferedWriter);
            bufferedWriter.write("} #Separator");
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    protected String vrml10IndexedSetName() {
        return "IndexedFaceSet";
    }

    protected void vrml10ComponentsOn_(Writer writer) {
        if (!this.isCompoundBody()) {
            this.vrml10IndexedFaceSetOn_(writer);
            return;
        }
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].vrml10On_(writer);
        }
    }

    protected void vrml10IndexedFaceSetOn_(Writer writer) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        Vector vector = new Vector();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            this.pointCollection_for_(vector, junOpenGL3dObjectArray[i]);
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            this.patcheCollection_from_for_(vector2, vector, junOpenGL3dObjectArray[i]);
        }
        if (vector.isEmpty()) {
            return;
        }
        try {
            int n;
            int n2;
            BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            bufferedWriter.write("\t");
            bufferedWriter.write("Coordinate3 {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t");
            bufferedWriter.write("point [");
            bufferedWriter.newLine();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)vector.elementAt(n2));
                bufferedWriter.write("\t\t\t");
                bufferedWriter.write(String.valueOf((float)jun3dPoint.x()));
                bufferedWriter.write(" ");
                bufferedWriter.write(String.valueOf((float)jun3dPoint.y()));
                bufferedWriter.write(" ");
                bufferedWriter.write(String.valueOf((float)jun3dPoint.z()));
                if (n2 != vector.size() - 1) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write(" #");
                bufferedWriter.write(String.valueOf(n2));
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t\t");
            bufferedWriter.write("] #point");
            bufferedWriter.newLine();
            bufferedWriter.write("\t");
            bufferedWriter.write("} #Coordinate3");
            bufferedWriter.newLine();
            if (this.hasTexture()) {
                bufferedWriter.write("\t");
                bufferedWriter.write("Texture2 {");
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t");
                bufferedWriter.write("image ");
                this.texture.vrmlSFImageOn_(bufferedWriter);
                bufferedWriter.newLine();
                bufferedWriter.write("\t");
                bufferedWriter.write("} #Texture2");
                bufferedWriter.newLine();
            }
            if (this.hasTexture() && this.texture().hasCoordinates()) {
                bufferedWriter.write("\t");
                bufferedWriter.write("TextureCoordinate2 {");
                bufferedWriter.newLine();
                bufferedWriter.write("\t\t");
                bufferedWriter.write("point [");
                bufferedWriter.newLine();
                Jun2dPoint[] jun2dPointArray = this.texture().coordinates();
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    Jun2dPoint jun2dPoint = jun2dPointArray[i];
                    bufferedWriter.write("\t\t\t");
                    bufferedWriter.write(String.valueOf((float)jun2dPoint.x()));
                    bufferedWriter.write(" ");
                    bufferedWriter.write(String.valueOf((float)jun2dPoint.y()));
                    if (i != jun2dPointArray.length - 1) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.write(" #");
                    bufferedWriter.write(String.valueOf(i));
                    bufferedWriter.newLine();
                }
                bufferedWriter.write("\t\t");
                bufferedWriter.write("]");
                bufferedWriter.newLine();
                bufferedWriter.write("\t");
                bufferedWriter.write("} #TextureCoordinate2");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t");
            bufferedWriter.write(this.vrml10IndexedSetName());
            bufferedWriter.write(" {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t");
            bufferedWriter.write("coordIndex [");
            bufferedWriter.newLine();
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                Vector vector3 = (Vector)vector2.elementAt(n2);
                bufferedWriter.write("\t\t\t");
                for (int i = 0; i < vector3.size(); ++i) {
                    n = (Integer)vector3.elementAt(i);
                    bufferedWriter.write(String.valueOf(n - 1));
                    bufferedWriter.write(", ");
                }
                bufferedWriter.write("-1");
                if (n2 != vector2.size() - 1) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t\t");
            bufferedWriter.write("] #coordIndex");
            bufferedWriter.newLine();
            if (this.hasTexture() && this.texture().hasCoordinates()) {
                bufferedWriter.write("\t\t");
                bufferedWriter.write("textureCoordIndex [");
                bufferedWriter.newLine();
                n2 = 0;
                for (int i = 1; i < vector2.size() + 1; ++i) {
                    Vector vector4 = (Vector)vector2.elementAt(i - 1);
                    bufferedWriter.write("\t\t\t");
                    for (n = n2; n < n2 + vector4.size() - 1; ++n) {
                        bufferedWriter.write(String.valueOf(n));
                        bufferedWriter.write(", ");
                    }
                    bufferedWriter.write("-1");
                    n2 += vector4.size();
                    if (i != vector2.size()) {
                        bufferedWriter.write(",");
                    }
                    bufferedWriter.newLine();
                }
                bufferedWriter.write("\t\t");
                bufferedWriter.write("] #textureCoordIndex");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t");
            bufferedWriter.write("} #");
            bufferedWriter.write(this.vrml10IndexedSetName());
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void vrml20On_(PrintWriter printWriter, String string) {
        printWriter.println(string + "Transform {");
        printWriter.println(string + "\t" + "children [");
        if (this.isCompoundBody()) {
            this.vrml20ComponentsOn_(printWriter, string + "\t" + "\t");
        } else {
            this.vrml20ShapeOn_(printWriter, string + "\t" + "\t");
        }
        printWriter.println(string + "\t" + "] # children");
        Jun3dBoundingBox jun3dBoundingBox = this.boundingBox();
        Jun3dPoint jun3dPoint = jun3dBoundingBox.center();
        printWriter.print(string + "\t" + "bboxCenter ");
        printWriter.print((float)jun3dPoint.x());
        printWriter.print(' ');
        printWriter.print((float)jun3dPoint.y());
        printWriter.print(' ');
        printWriter.print((float)jun3dPoint.z());
        printWriter.println();
        printWriter.print(string + "\t" + "bboxSize ");
        printWriter.print((float)jun3dBoundingBox.width());
        printWriter.print(' ');
        printWriter.print((float)jun3dBoundingBox.height());
        printWriter.print(' ');
        printWriter.print((float)jun3dBoundingBox.depth());
        printWriter.println();
        printWriter.println(string + "} #Transform");
        printWriter.flush();
    }

    protected String vrml20IndexedSetName() {
        return "IndexedFaceSet";
    }

    protected void vrml20ComponentsOn_(PrintWriter printWriter, String string) {
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            junOpenGL3dObjectArray[i].vrml20On_(printWriter, string);
            if (i >= junOpenGL3dObjectArray.length - 1) continue;
            printWriter.println(string + ',');
        }
    }

    protected void vrml20GeometryOn_(PrintWriter printWriter, String string) {
        Object object;
        int n;
        JunOpenGL3dObject[] junOpenGL3dObjectArray = this.components();
        Vector vector = new Vector();
        for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
            this.pointCollection_for_(vector, junOpenGL3dObjectArray[i]);
        }
        Vector vector2 = new Vector();
        for (n = 0; n < junOpenGL3dObjectArray.length; ++n) {
            this.patcheCollection_from_for_(vector2, vector, junOpenGL3dObjectArray[n]);
        }
        if (vector.isEmpty()) {
            return;
        }
        printWriter.println(string + "geometry " + this.vrml20IndexedSetName() + " {");
        printWriter.println(string + "\t" + "coord Coordinate {");
        printWriter.println(string + "\t" + "\t" + "point [");
        for (n = 0; n < vector.size(); ++n) {
            object = (Jun3dPoint)((Object)vector.elementAt(n));
            printWriter.print(string + "\t" + "\t" + "\t");
            printWriter.print((float)((Jun3dPoint)((Object)object)).x());
            printWriter.print(' ');
            printWriter.print((float)((Jun3dPoint)((Object)object)).y());
            printWriter.print(' ');
            printWriter.print((float)((Jun3dPoint)((Object)object)).z());
            if (n < vector.size() - 1) {
                printWriter.print(',');
            }
            printWriter.println(" #" + n);
        }
        printWriter.println(string + "\t" + "\t" + "] #point");
        printWriter.println(string + "\t" + "} #Coordinate");
        printWriter.println(string + "\t" + "coordIndex [ #patches: " + vector2.size());
        for (n = 0; n < vector2.size(); ++n) {
            object = (Vector)vector2.elementAt(n);
            printWriter.print(string + "\t" + "\t");
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                int n2 = (Integer)((Vector)object).elementAt(i);
                printWriter.print(n2 - 1);
                printWriter.print(", ");
            }
            printWriter.write("-1");
            if (n < vector2.size() - 1) {
                printWriter.print(',');
            }
            printWriter.println();
        }
        printWriter.println(string + "\t" + "] #coordIndex");
        if (this.hasTexture() && this.texture().hasCoordinates()) {
            int n3;
            printWriter.println(string + "\t" + "texCoord TextureCoordinate {");
            printWriter.println(string + "\t" + "\t" + "point [");
            Jun2dPoint[] jun2dPointArray = this.texture().coordinates();
            for (n3 = 0; n3 < jun2dPointArray.length; ++n3) {
                Jun2dPoint jun2dPoint = jun2dPointArray[n3];
                printWriter.print(string + "\t" + "\t" + "\t");
                printWriter.print((float)jun2dPoint.x());
                printWriter.print(' ');
                printWriter.print((float)jun2dPoint.y());
                if (n3 < jun2dPointArray.length - 1) {
                    printWriter.print(',');
                }
                printWriter.println(" #" + n3);
            }
            printWriter.println(string + "\t" + "\t" + "] #point");
            printWriter.println(string + "\t" + "} #TextureCoordinate");
            printWriter.println(string + "\t" + "texCoordIndex [");
            n3 = 0;
            for (int i = 0; i < vector2.size(); ++i) {
                Vector vector3 = (Vector)vector2.elementAt(i);
                printWriter.print(string + "\t" + "\t");
                for (int j = n3; j <= n3 + vector3.size() - 1; ++j) {
                    printWriter.print(j);
                    printWriter.print(", ");
                }
                printWriter.print("-1");
                n3 += vector3.size();
                if (i != vector2.size()) {
                    printWriter.print(',');
                }
                printWriter.println();
            }
            printWriter.println(string + "\t" + "] #texCoordIndex");
        }
        printWriter.println(string + "\t" + "solid FALSE");
        printWriter.println(string + "} #" + this.vrml20IndexedSetName());
    }
}

