/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.lights;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

public class JunOpenGLSpotLight
extends JunOpenGLLight {
    protected Jun3dPoint position;
    protected Jun3dPoint direction;
    protected JunAngle cutoffAngle;

    public JunOpenGLSpotLight(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, JunAngle junAngle, Color color, float f) {
        this.setPosition_direction_cutoffAngle_color_alpha_(jun3dPoint, jun3dPoint2, junAngle, color, f);
    }

    public static JunOpenGLSpotLight At3dPoint_(Jun3dPoint jun3dPoint) {
        return JunOpenGLSpotLight.At3dPoint_color_(jun3dPoint, JunOpenGLSpotLight.DefaultColor());
    }

    public static JunOpenGLSpotLight At3dPoint_color_(Jun3dPoint jun3dPoint, Color color) {
        return JunOpenGLSpotLight.At3dPoint_color_alpha_(jun3dPoint, color, JunOpenGLSpotLight.DefaultAlpha());
    }

    public static JunOpenGLSpotLight At3dPoint_color_alpha_(Jun3dPoint jun3dPoint, Color color, float f) {
        return JunOpenGLSpotLight.At3dPoint_direction_cutoffAngle_color_alpha_(jun3dPoint, null, null, color, f);
    }

    public static JunOpenGLSpotLight At3dPoint_direction_cutoffAngle_color_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, JunAngle junAngle, Color color) {
        return JunOpenGLSpotLight.At3dPoint_direction_cutoffAngle_color_alpha_(jun3dPoint, jun3dPoint2, junAngle, color, JunOpenGLSpotLight.DefaultAlpha());
    }

    public static JunOpenGLSpotLight At3dPoint_direction_cutoffAngle_color_alpha_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, JunAngle junAngle, Color color, float f) {
        return new JunOpenGLSpotLight(jun3dPoint, jun3dPoint2, junAngle, color, f);
    }

    public Jun3dPoint position() {
        return this.position;
    }

    public void position_(Jun3dPoint jun3dPoint) {
        this.position = jun3dPoint;
    }

    public Jun3dPoint direction() {
        return this.direction;
    }

    public void direction_(Jun3dPoint jun3dPoint) {
        this.direction = jun3dPoint;
    }

    public JunAngle cutoffAngle() {
        return this.cutoffAngle;
    }

    public void cutoffAngle_(JunAngle junAngle) {
        this.cutoffAngle = junAngle;
    }

    public void lightingOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        JunAngle junAngle;
        Jun3dPoint jun3dPoint = this.direction();
        if (jun3dPoint == null) {
            jun3dPoint = junOpenGLRenderingContext.projection().sightPoint().minus_(this.position());
        }
        if ((junAngle = this.cutoffAngle()) == null) {
            junAngle = JunAngle.FromDeg_(45.0);
        }
        int n = junOpenGLRenderingContext.getLightIndex();
        junOpenGLRenderingContext.lightIndex_position_direction_cutoffAngle_color_alpha_(n, this.position(), jun3dPoint, junAngle, this.color(), this.alpha());
        junOpenGLRenderingContext.enableLightIndex_(n);
        junOpenGLRenderingContext.enableLighting();
    }

    public JunOpenGLLight transform_(Jun3dTransformation jun3dTransformation) {
        JunOpenGLSpotLight junOpenGLSpotLight = (JunOpenGLSpotLight)this.copy();
        junOpenGLSpotLight.position_(this.position().transform_(jun3dTransformation));
        if (this.direction != null) {
            junOpenGLSpotLight.direction_(this.direction().transform_(jun3dTransformation).minus_(Jun3dPoint.Zero().transform_(jun3dTransformation)));
        }
        return junOpenGLSpotLight;
    }

    protected void setPosition_color_alpha_(Jun3dPoint jun3dPoint, Color color, float f) {
        this.position = jun3dPoint;
        this.color = color;
        this.alpha = f;
    }

    protected void setPosition_direction_cutoffAngle_color_alpha_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, JunAngle junAngle, Color color, float f) {
        this.position = jun3dPoint;
        this.direction = jun3dPoint2;
        this.cutoffAngle = junAngle;
        this.color = color;
        this.alpha = f;
    }
}

