/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.flux;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;

public class JunCoordinateAngles
extends JunGeometry {
    protected JunAngle omegaAngle;
    protected JunAngle phiAngle;
    protected JunAngle thetaAngle;

    public static JunCoordinateAngles Omega_phi_theta_(JunAngle junAngle, JunAngle junAngle2, JunAngle junAngle3) {
        JunCoordinateAngles junCoordinateAngles = new JunCoordinateAngles();
        junCoordinateAngles.omega_(junAngle);
        junCoordinateAngles.phi_(junAngle2);
        junCoordinateAngles.theta_(junAngle3);
        return junCoordinateAngles;
    }

    public static JunCoordinateAngles P1_p2_p3_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        JunCoordinateAngles junCoordinateAngles = new JunCoordinateAngles();
        junCoordinateAngles.p1_p2_p3_(jun3dPoint, jun3dPoint2, jun3dPoint3);
        return junCoordinateAngles;
    }

    public static JunCoordinateAngles P1_p2_p3_p4_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, Jun3dPoint jun3dPoint4) {
        JunCoordinateAngles junCoordinateAngles = new JunCoordinateAngles();
        junCoordinateAngles.p1_p2_p3_p4_(jun3dPoint, jun3dPoint2, jun3dPoint3, jun3dPoint4);
        return junCoordinateAngles;
    }

    public static JunCoordinateAngles V1_v2_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        JunCoordinateAngles junCoordinateAngles = new JunCoordinateAngles();
        junCoordinateAngles.v1_v2_(jun3dPoint, jun3dPoint2);
        return junCoordinateAngles;
    }

    protected void initialize() {
        super.initialize();
        this.omega_(0.0);
        this.phi_(0.0);
        this.theta_(0.0);
    }

    public final JunAngle omega() {
        return this.omegaAngle;
    }

    public void omega_(double d) {
        this.omegaAngle = JunAngle.FromRad_(d);
    }

    public final void omega_(JunAngle junAngle) {
        this.omegaAngle = junAngle;
    }

    public void p1_p2_p3_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        Jun3dPoint jun3dPoint4 = jun3dPoint2.minus_(jun3dPoint);
        Jun3dPoint jun3dPoint5 = this.outerProduct_with_(jun3dPoint4, jun3dPoint3.minus_(jun3dPoint));
        jun3dPoint5 = this.outerProduct_with_(jun3dPoint5, jun3dPoint4);
        this.computeAnglesFrom_and_(jun3dPoint4, jun3dPoint5);
    }

    public void p1_p2_p3_p4_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, Jun3dPoint jun3dPoint4) {
        Jun3dPoint jun3dPoint5 = jun3dPoint2.minus_(jun3dPoint);
        Jun3dPoint jun3dPoint6 = this.outerProduct_with_(jun3dPoint5, jun3dPoint4.minus_(jun3dPoint3));
        this.computeAnglesFrom_and_(jun3dPoint5, jun3dPoint6);
    }

    public final JunAngle phi() {
        return this.phiAngle;
    }

    public void phi_(double d) {
        this.phiAngle = JunAngle.FromRad_(d);
    }

    public final void phi_(JunAngle junAngle) {
        this.phiAngle = junAngle;
    }

    public final JunAngle theta() {
        return this.thetaAngle;
    }

    public void theta_(double d) {
        this.thetaAngle = JunAngle.FromRad_(d);
    }

    public final void theta_(JunAngle junAngle) {
        this.thetaAngle = junAngle;
    }

    public void v1_v2_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        this.p1_p2_p3_(new Jun3dPoint(0.0, 0.0, 0.0), jun3dPoint, jun3dPoint2);
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunCoordinateAngles junCoordinateAngles = (JunCoordinateAngles)((Object)object);
        return this.omega().equal_(junCoordinateAngles.omega()) && this.phi().equal_(junCoordinateAngles.phi()) && this.theta().equal_(junCoordinateAngles.theta());
    }

    public boolean equals(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunCoordinateAngles junCoordinateAngles = (JunCoordinateAngles)((Object)object);
        return this.omega().equals(junCoordinateAngles.omega()) && this.phi().equals(junCoordinateAngles.phi()) && this.theta().equals(junCoordinateAngles.theta());
    }

    public Jun3dTransformation asInverseTransformation() {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.RotateX_(this.omega().negated());
        Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.RotateY_(this.phi().negated());
        Jun3dTransformation jun3dTransformation3 = Jun3dTransformation.RotateZ_(this.theta().negated());
        Jun3dTransformation jun3dTransformation4 = Jun3dTransformation.Unity();
        jun3dTransformation4 = jun3dTransformation4.product_(jun3dTransformation3);
        jun3dTransformation4 = jun3dTransformation4.product_(jun3dTransformation2);
        jun3dTransformation4 = jun3dTransformation4.product_(jun3dTransformation);
        return jun3dTransformation4;
    }

    public Jun3dTransformation asTransformation() {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.RotateX_(this.omega());
        Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.RotateY_(this.phi());
        Jun3dTransformation jun3dTransformation3 = Jun3dTransformation.RotateZ_(this.theta());
        Jun3dTransformation jun3dTransformation4 = Jun3dTransformation.Unity();
        jun3dTransformation4 = jun3dTransformation4.product_(jun3dTransformation);
        jun3dTransformation4 = jun3dTransformation4.product_(jun3dTransformation2);
        jun3dTransformation4 = jun3dTransformation4.product_(jun3dTransformation3);
        return jun3dTransformation4;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("Coordinate Angles (");
        this.omega().printOn_(writer);
        writer.write(32);
        this.phi().printOn_(writer);
        writer.write(32);
        this.theta().printOn_(writer);
        writer.write(41);
    }

    protected void computeAnglesFrom_and_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        double d;
        Jun3dPoint jun3dPoint3 = jun3dPoint;
        Jun3dPoint jun3dPoint4 = jun3dPoint2;
        double d2 = this.vectorLength_(new Jun3dPoint(jun3dPoint3.x(), jun3dPoint3.y(), 0.0));
        if (d2 < JunCoordinateAngles.Accuracy()) {
            d = 0.0;
        } else {
            double d3 = jun3dPoint3.y() / d2;
            d = Math.acos(jun3dPoint3.x() / d2);
            if (d3 > 0.0) {
                d *= -1.0;
            }
        }
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromRad_(d));
        jun3dPoint3 = jun3dPoint3.transform_(jun3dTransformation);
        jun3dPoint4 = jun3dPoint4.transform_(jun3dTransformation);
        d2 = this.vectorLength_(jun3dPoint3);
        double d4 = jun3dPoint3.z() / d2;
        double d5 = Math.acos(this.vectorLength_(new Jun3dPoint(jun3dPoint3.x(), jun3dPoint3.y(), 0.0)) / d2);
        if (d4 < 0.0) {
            d5 *= -1.0;
        }
        jun3dTransformation = Jun3dTransformation.RotateY_(JunAngle.FromRad_(d5));
        jun3dPoint3 = jun3dPoint3.transform_(jun3dTransformation);
        jun3dPoint4 = jun3dPoint4.transform_(jun3dTransformation);
        d2 = this.vectorLength_(new Jun3dPoint(0.0, jun3dPoint4.y(), jun3dPoint4.z()));
        double d6 = jun3dPoint4.y() / d2;
        double d7 = Math.acos(jun3dPoint4.z() / d2);
        if (d6 > 0.0) {
            d7 *= -1.0;
        }
        this.thetaAngle = JunAngle.FromRad_(d * -1.0);
        this.phiAngle = JunAngle.FromRad_(d5 * -1.0);
        this.omegaAngle = JunAngle.FromRad_(d7 * -1.0);
    }

    protected Jun3dPoint outerProduct_with_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return new Jun3dPoint(jun3dPoint.y() * jun3dPoint2.z() - jun3dPoint.z() * jun3dPoint2.y(), jun3dPoint.z() * jun3dPoint2.x() - jun3dPoint.x() * jun3dPoint2.z(), jun3dPoint.x() * jun3dPoint2.y() - jun3dPoint.y() * jun3dPoint2.x());
    }

    protected double vectorLength_(Jun3dPoint jun3dPoint) {
        return Math.sqrt(jun3dPoint.x() * jun3dPoint.x() + jun3dPoint.y() * jun3dPoint.y() + jun3dPoint.z() * jun3dPoint.z());
    }
}

