/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.display;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.goodies.progress.JunCursorAnimator;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.goodies.wheels.JunThumbWheel;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.opengl.display.JunOpenGL3dModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayController;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayView;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewAwt;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing;
import jp.co.sra.jun.opengl.display.JunOpenGLShowModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObject;
import jp.co.sra.jun.opengl.picking.JunOpenGLObjectPicker;
import jp.co.sra.jun.opengl.picking.JunOpenGLPickingObjects;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.vrml.support.JunVrmlCompiler;
import jp.co.sra.jun.vrml.support.JunVrmlGenerator10;
import jp.co.sra.jun.vrml.support.JunVrmlGenerator97;
import jp.co.sra.jun.vrml.support.JunVrmlParser10;
import jp.co.sra.jun.vrml.support.JunVrmlParser97;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunOpenGLDisplayModel
extends JunOpenGL3dModel {
    protected HashMap pushButtons;
    protected JunButtonModel dollyButton;

    public JunOpenGLDisplayModel() {
    }

    public JunOpenGLDisplayModel(JunOpenGL3dObject junOpenGL3dObject) {
        this();
        this.displayObject_(junOpenGL3dObject);
    }

    public static JunOpenGLDisplayModel DisplayObject_(Class clazz, JunOpenGL3dObject junOpenGL3dObject) {
        JunOpenGLDisplayModel junOpenGLDisplayModel = (JunOpenGLDisplayModel)JunOpenGLDisplayModel._New((Class)clazz);
        junOpenGLDisplayModel.displayObject_(junOpenGL3dObject);
        return junOpenGLDisplayModel;
    }

    public static BufferedImage PickNormalImage() {
        return JunCursors.NormalCursorImage();
    }

    public static BufferedImage PickBoundsImage() {
        return JunCursors.BoundsCursorImage();
    }

    public static BufferedImage PickPencilImage() {
        return JunCursors.PencilCursorImage();
    }

    public static JunOpenGLDisplayModel Show_(JunOpenGL3dObject junOpenGL3dObject) {
        return JunOpenGLDisplayModel.Show_eyePoint_(junOpenGL3dObject, null);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint) {
        return JunOpenGLDisplayModel.Show_eyePoint_sightPoint_(junOpenGL3dObject, jun3dPoint, null);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_sightPoint_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return JunOpenGLDisplayModel.Show_eyePoint_sightPoint_upVector_(junOpenGL3dObject, jun3dPoint, jun3dPoint2, null);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_sightPoint_upVector_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        return JunOpenGLDisplayModel.Show_eyePoint_sightPoint_upVector_viewFactor_(junOpenGL3dObject, jun3dPoint, jun3dPoint2, jun3dPoint3, Double.NaN);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_sightPoint_upVector_viewFactor_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d) {
        return JunOpenGLDisplayModel.Show_eyePoint_sightPoint_upVector_viewFactor_zoomHeight_(junOpenGL3dObject, jun3dPoint, jun3dPoint2, jun3dPoint3, d, Double.NaN);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_sightPoint_upVector_viewFactor_zoomHeight_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2) {
        return JunOpenGLDisplayModel.Show_eyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(junOpenGL3dObject, jun3dPoint, jun3dPoint2, jun3dPoint3, d, d2, null);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, Rectangle rectangle) {
        Hashtable<StSymbol, Object> hashtable = new Hashtable<StSymbol, Object>();
        if (jun3dPoint != null) {
            hashtable.put(JunOpenGLDisplayModel.$((String)"eyePoint"), (Object)jun3dPoint);
        }
        if (jun3dPoint2 != null) {
            hashtable.put(JunOpenGLDisplayModel.$((String)"sightPoint"), (Object)jun3dPoint2);
        }
        if (jun3dPoint3 != null) {
            hashtable.put(JunOpenGLDisplayModel.$((String)"upVector"), (Object)jun3dPoint3);
        }
        if (!Double.isNaN(d)) {
            hashtable.put(JunOpenGLDisplayModel.$((String)"viewFactor"), new Double(d));
        }
        if (!Double.isNaN(d2)) {
            hashtable.put(JunOpenGLDisplayModel.$((String)"zoomHeight"), new Double(d2));
        }
        return JunOpenGLDisplayModel.Show_projectionTable_in_(junOpenGL3dObject, hashtable, rectangle);
    }

    public static JunOpenGLDisplayModel Show_in_(JunOpenGL3dObject junOpenGL3dObject, Rectangle rectangle) {
        return JunOpenGLDisplayModel.Show_projectionTable_in_(junOpenGL3dObject, null, rectangle);
    }

    public static JunOpenGLDisplayModel Show_projectionTable_(JunOpenGL3dObject junOpenGL3dObject, Map map) {
        return JunOpenGLDisplayModel.Show_projectionTable_in_(junOpenGL3dObject, map, null);
    }

    public static JunOpenGLDisplayModel Show_projectionTable_in_(JunOpenGL3dObject junOpenGL3dObject, Map map, Rectangle rectangle) {
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel(junOpenGL3dObject);
        if (map != null) {
            junOpenGLDisplayModel.defaultProjectionTable_(map);
        }
        if (rectangle == null) {
            junOpenGLDisplayModel.open();
        } else {
            junOpenGLDisplayModel.openIn_(rectangle);
        }
        return junOpenGLDisplayModel;
    }

    protected void initialize() {
        super.initialize();
        this.pushButtons = null;
        this.dollyButton = null;
    }

    public JunOpenGL3dObject displayObject() {
        return super.openGL3dObject();
    }

    public void displayObject_(JunOpenGL3dObject junOpenGL3dObject) {
        super.openGL3dObject_(junOpenGL3dObject);
        if (this.showModel() != null) {
            this.showModel().flushObject();
        }
    }

    public JunOpenGLProjection displayProjection() {
        return super.openGLProjection();
    }

    public void displayProjection_(JunOpenGLProjection junOpenGLProjection) {
        super.openGLProjection_(junOpenGLProjection);
    }

    public JunOpenGLProjector displayProjector() {
        return super.openGLProjector();
    }

    public JunOpenGLShowModel showModel() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunOpenGLShowModel)) continue;
            return (JunOpenGLShowModel)dependentListenerArray[i];
        }
        return null;
    }

    public final JunOpenGL3dObject openGL3dObject() {
        return this.displayObject();
    }

    public final void openGL3dObject_(JunOpenGL3dObject junOpenGL3dObject) {
        this.displayObject_(junOpenGL3dObject);
    }

    public final JunOpenGLProjection openGLProjection() {
        return this.displayProjection();
    }

    public final void openGLProjection_(JunOpenGLProjection junOpenGLProjection) {
        this.displayProjection_(junOpenGLProjection);
    }

    public final JunOpenGLProjector openGLProjector() {
        return this.displayProjector();
    }

    protected void altClick_(JunOpenGL3dObject junOpenGL3dObject) {
    }

    protected void ctrlClick_(JunOpenGL3dObject junOpenGL3dObject) {
    }

    public void focus_to_(Jun2dBoundingBox jun2dBoundingBox, Jun2dBoundingBox jun2dBoundingBox2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.displayProjection();
        Jun3dPoint jun3dPoint = junOpenGLProjection.translateTo3dPointFromPoint_(jun2dBoundingBox.origin().plus_(jun2dBoundingBox.corner()).dividedBy_(2.0));
        Jun3dPoint jun3dPoint2 = junOpenGLProjection.translateTo3dPointFromPoint_(jun2dBoundingBox2.origin().plus_(jun2dBoundingBox2.corner()).dividedBy_(2.0));
        junOpenGLProjection.sightPoint_(junOpenGLProjection.sightPoint().plus_(jun3dPoint2.minus_(jun3dPoint)));
        Jun3dPoint jun3dPoint3 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(0.0, jun2dBoundingBox.origin().y()));
        Jun3dPoint jun3dPoint4 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(0.0, jun2dBoundingBox.corner().y()));
        Jun3dPoint jun3dPoint5 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(jun2dBoundingBox.origin().x(), 0.0));
        Jun3dPoint jun3dPoint6 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(jun2dBoundingBox.corner().x(), 0.0));
        double d = jun3dPoint3.minus_(jun3dPoint4).length();
        double d2 = jun3dPoint5.minus_(jun3dPoint6).length();
        Jun3dPoint jun3dPoint7 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(0.0, jun2dBoundingBox2.origin().y()));
        Jun3dPoint jun3dPoint8 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(0.0, jun2dBoundingBox2.corner().y()));
        Jun3dPoint jun3dPoint9 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(jun2dBoundingBox2.origin().x(), 0.0));
        Jun3dPoint jun3dPoint10 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(jun2dBoundingBox2.corner().x(), 0.0));
        double d3 = jun3dPoint7.minus_(jun3dPoint8).length();
        double d4 = jun3dPoint9.minus_(jun3dPoint10).length();
        double d5 = junOpenGLProjection.regularHeight() * d3 / d;
        double d6 = d5 * d4 / d3;
        double d7 = d5;
        if (d2 / d * d5 < d6) {
            double d8 = d2 * d5 / (d * d6);
            d7 = d5 * d8;
        }
        if (d * 0.01 < d3 && d3 * 0.01 < d) {
            junOpenGLProjection.zoomHeight_(d7);
        }
        this.displayProjection_(junOpenGLProjection);
        this.changed_(JunOpenGLDisplayModel.$((String)"projection"));
    }

    public JunOpenGL3dObject pick_with_(Jun2dPoint jun2dPoint, MouseEvent mouseEvent) {
        if (this.displayObject() == null) {
            return null;
        }
        if (this.displayObject().isPrimitive()) {
            return null;
        }
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGLObjectPicker.PickObjectAt_fromCompound_projection_(jun2dPoint, (JunOpenGLPickingObjects)((Object)this.displayObject()), this.displayProjection());
        if (junOpenGL3dObject == null) {
            if (!this.selectedObjects().isEmpty()) {
                this.clearSelectedObjects();
                this.changed_(JunOpenGLDisplayModel.$((String)"selection"));
            }
            this.updateMenuIndication();
            return null;
        }
        if (mouseEvent.isShiftDown()) {
            if (this.selectedObjects().contains((Object)junOpenGL3dObject)) {
                this.removeSelectedObject_(junOpenGL3dObject);
                this.changed_(JunOpenGLDisplayModel.$((String)"selection"));
            } else {
                this.addSelectedObject_(junOpenGL3dObject);
                this.changed_(JunOpenGLDisplayModel.$((String)"selection"));
            }
        } else if (mouseEvent.isControlDown()) {
            this.ctrlClick_(junOpenGL3dObject);
        } else if (mouseEvent.isAltDown()) {
            this.altClick_(junOpenGL3dObject);
        } else {
            this.clearSelectedObjects();
            this.addSelectedObject_(junOpenGL3dObject);
            this.changed_(JunOpenGLDisplayModel.$((String)"selection"));
        }
        this.updateMenuIndication();
        return junOpenGL3dObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movementVector_(Jun2dPoint jun2dPoint) {
        StController stController = this.getController();
        if (stController != null && stController instanceof JunOpenGLDisplayController) {
            JunOpenGLDisplayController junOpenGLDisplayController = (JunOpenGLDisplayController)stController;
            try {
                junOpenGLDisplayController.flushMovementVector();
                junOpenGLDisplayController.movementVector_(jun2dPoint);
            }
            finally {
                junOpenGLDisplayController.createMovementProcess();
            }
        }
    }

    public void selectAll() {
        if (this.openGL3dObject() == null) {
            return;
        }
        if (this.openGL3dObject().isPrimitive()) {
            return;
        }
        this.clearSelectedObjects();
        if (this.openGL3dObject().isCompound()) {
            JunOpenGL3dObject[] junOpenGL3dObjectArray = ((JunOpenGL3dCompoundObject)this.openGL3dObject()).components();
            for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
                this.selectedObjects().add(junOpenGL3dObjectArray[i]);
            }
        } else {
            this.selectedObjects().add(this.openGL3dObject());
        }
        this.changed_(JunOpenGLDisplayModel.$((String)"selection"));
        this.updateMenuIndication();
    }

    public boolean useMovementProcess() {
        Boolean bl = (Boolean)this.preferenceTable().at_(JunOpenGLDisplayModel.$((String)"useMovementProcess"));
        if (bl == null) {
            bl = Boolean.TRUE;
            this.preferenceTable().at_put_(JunOpenGLDisplayModel.$((String)"useMovementProcess"), bl);
        }
        return bl;
    }

    public void useMovementProcess_(boolean bl) {
        this.preferenceTable().at_put_(JunOpenGLDisplayModel.$((String)"useMovementProcess"), bl);
    }

    public boolean usePressActivity() {
        Boolean bl = (Boolean)this.preferenceTable().at_(JunOpenGLDisplayModel.$((String)"usePressActivity"));
        if (bl == null) {
            bl = Boolean.FALSE;
            this.preferenceTable().at_put_(JunOpenGLDisplayModel.$((String)"usePressActivity"), bl);
        }
        return bl;
    }

    public void usePressActivity_(boolean bl) {
        this.preferenceTable().at_put_(JunOpenGLDisplayModel.$((String)"usePressActivity"), bl);
    }

    public boolean useYellowButtonMenu() {
        Boolean bl = (Boolean)this.preferenceTable().at_(JunOpenGLDisplayModel.$((String)"useYellowButtonMenu"));
        if (bl == null) {
            bl = Boolean.FALSE;
            this.preferenceTable().at_put_(JunOpenGLDisplayModel.$((String)"useYellowButtonMenu"), bl);
        }
        return bl;
    }

    public void useYellowButtonMenu_(boolean bl) {
        this.preferenceTable().at_put_(JunOpenGLDisplayModel.$((String)"useYellowButtonMenu"), bl);
    }

    public boolean noControl() {
        Boolean bl = (Boolean)this.preferenceTable().at_(JunOpenGLDisplayModel.$((String)"noControl"));
        if (bl == null) {
            bl = Boolean.FALSE;
            this.preferenceTable().at_put_(JunOpenGLDisplayModel.$((String)"noControl"), bl);
        }
        return bl;
    }

    public void noControl_(boolean bl) {
        this.preferenceTable().at_put_(JunOpenGLDisplayModel.$((String)"noControl"), bl);
    }

    public void wheel_at_in_(int n, Point point, Rectangle rectangle) {
        StSymbol stSymbol = null;
        Map map = JunOpenGLDisplayModel.NineBoxesOf_(rectangle);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            StRectangle stRectangle = (StRectangle)entry.getValue();
            if (!stRectangle.containsPoint_(point)) continue;
            stSymbol = (StSymbol)entry.getKey();
            break;
        }
        if (stSymbol == null) {
            return;
        }
        if (stSymbol == JunOpenGLDisplayModel.$((String)"topLeft")) {
            this.wheelActionInTopLeftBox_(n);
        } else if (stSymbol == JunOpenGLDisplayModel.$((String)"topCenter")) {
            this.wheelActionInTopCenterBox_(n);
        } else if (stSymbol == JunOpenGLDisplayModel.$((String)"topRight")) {
            this.wheelActionInTopRightBox_(n);
        } else if (stSymbol == JunOpenGLDisplayModel.$((String)"leftCenter")) {
            this.wheelActionInLeftCenterBox_(n);
        } else if (stSymbol == JunOpenGLDisplayModel.$((String)"center")) {
            this.wheelActionInCenterBox_(n);
        } else if (stSymbol == JunOpenGLDisplayModel.$((String)"rightCenter")) {
            this.wheelActionInRightCenterBox_(n);
        } else if (stSymbol == JunOpenGLDisplayModel.$((String)"bottomLeft")) {
            this.wheelActionInBottomLeftBox_(n);
        } else if (stSymbol == JunOpenGLDisplayModel.$((String)"bottomCenter")) {
            this.wheelActionInBottomCenterBox_(n);
        } else if (stSymbol == JunOpenGLDisplayModel.$((String)"bottomRight")) {
            this.wheelActionInBottomRightBox_(n);
        }
    }

    protected void wheelActionInTopLeftBox_(int n) {
        double d = JunSensorUtility.AltDown() ? 0.01 : 0.1;
        Jun2dPoint jun2dPoint = n < 0 ? new Jun2dPoint(-d, d) : new Jun2dPoint(d, -d);
        this.grab_(jun2dPoint);
    }

    protected void wheelActionInTopCenterBox_(int n) {
        int n2;
        int n3 = n2 = JunSensorUtility.AltDown() ? 1 : 5;
        if (n > 0) {
            n2 *= -1;
        }
        Jun3dTransformation jun3dTransformation = JunAngle.FromDeg_(n2).transformationToRotate_(this.sightPoint().to_(this.eyePoint()));
        Jun3dLine jun3dLine = this.sightPoint().to_(this.sightPoint().plus_(this.upVector().normalVector())).transform_(jun3dTransformation);
        Jun3dPoint jun3dPoint = jun3dLine.to().minus_(jun3dLine.from());
        this.upVector_(jun3dPoint);
    }

    protected void wheelActionInTopRightBox_(int n) {
        double d = JunSensorUtility.AltDown() ? 0.01 : 0.1;
        Jun2dPoint jun2dPoint = n < 0 ? new Jun2dPoint(d, d) : new Jun2dPoint(-d, -d);
        this.grab_(jun2dPoint);
    }

    protected void wheelActionInLeftCenterBox_(int n) {
        double d = JunSensorUtility.AltDown() ? 0.01 : 0.1;
        Jun2dPoint jun2dPoint = n < 0 ? new Jun2dPoint(0.0, d) : new Jun2dPoint(0.0, -d);
        this.grab_(jun2dPoint);
    }

    protected void wheelActionInCenterBox_(int n) {
        this.wheelActionInRightCenterBox_(n);
    }

    protected void wheelActionInRightCenterBox_(int n) {
        double d = JunSensorUtility.AltDown() ? 0.01 : 0.1;
        double d2 = n < 0 ? 1.0 - d : 1.0 + d;
        this.zoom_(d2);
    }

    protected void wheelActionInBottomLeftBox_(int n) {
        this.wheelActionInTopRightBox_(n);
    }

    protected void wheelActionInBottomCenterBox_(int n) {
        double d = JunSensorUtility.AltDown() ? 0.01 : 0.1;
        Jun2dPoint jun2dPoint = n < 0 ? new Jun2dPoint(-d, 0.0) : new Jun2dPoint(d, 0.0);
        this.grab_(jun2dPoint);
    }

    protected void wheelActionInBottomRightBox_(int n) {
        this.wheelActionInTopLeftBox_(n);
    }

    public JunButtonModel dollyButton() {
        if (this.dollyButton == null) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.DollyCursorImage());
            junButtonModel.action_(this.dollyButtonAction());
            this.dollyButton = junButtonModel;
        }
        return this.dollyButton;
    }

    protected StBlockClosure dollyButtonAction() {
        return new StBlockClosure(){

            public Object value_(Object object) {
                JunButtonModel junButtonModel;
                junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                return null;
            }
        };
    }

    public JunButtonModel dragButton() {
        if (!this.pushButtons().containsKey(JunOpenGLDisplayModel.$((String)"drag"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.QuartersCursorImage());
            junButtonModel.action_(this.dragButtonAction());
            this.pushButtons().put(JunOpenGLDisplayModel.$((String)"drag"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLDisplayModel.$((String)"drag")));
    }

    protected StBlockClosure dragButtonAction() {
        return new StBlockClosure(){

            public Object value_(Object object) {
                JunButtonModel junButtonModel = (JunButtonModel)((Object)object);
                JunOpenGLDisplayModel.this.setButtonState(2.$((String)"drag"), !junButtonModel.value());
                return null;
            }
        };
    }

    public JunButtonModel focusButton() {
        if (!this.pushButtons().containsKey(JunOpenGLDisplayModel.$((String)"focus"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.GlassCursorImage());
            junButtonModel.action_(this.focusButtonAction());
            this.pushButtons().put(JunOpenGLDisplayModel.$((String)"focus"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLDisplayModel.$((String)"focus")));
    }

    protected StBlockClosure focusButtonAction() {
        return new StBlockClosure(){

            public Object value_(Object object) {
                JunButtonModel junButtonModel = (JunButtonModel)((Object)object);
                JunOpenGLDisplayModel.this.setButtonState(3.$((String)"focus"), !junButtonModel.value());
                return null;
            }
        };
    }

    public JunButtonModel grabButton() {
        if (!this.pushButtons().containsKey(JunOpenGLDisplayModel.$((String)"grab"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.HandCursorImage());
            junButtonModel.action_(this.grabButtonAction());
            this.pushButtons().put(JunOpenGLDisplayModel.$((String)"grab"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLDisplayModel.$((String)"grab")));
    }

    protected StBlockClosure grabButtonAction() {
        return new StBlockClosure(){

            public Object value_(Object object) {
                JunButtonModel junButtonModel = (JunButtonModel)((Object)object);
                JunOpenGLDisplayModel.this.setButtonState(4.$((String)"grab"), !junButtonModel.value());
                return null;
            }
        };
    }

    public JunButtonModel pickButton() {
        if (!this.pushButtons().containsKey(JunOpenGLDisplayModel.$((String)"pick"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunOpenGLDisplayModel.PickNormalImage());
            junButtonModel.action_(this.pickButtonAction());
            this.pushButtons().put(JunOpenGLDisplayModel.$((String)"pick"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLDisplayModel.$((String)"pick")));
    }

    protected StBlockClosure pickButtonAction() {
        return new StBlockClosure(){

            public Object value_(Object object) {
                JunButtonModel junButtonModel = (JunButtonModel)((Object)object);
                JunOpenGLDisplayModel.this.setButtonState(5.$((String)"pick"), !junButtonModel.value());
                return null;
            }
        };
    }

    public synchronized StSymbol buttonState() {
        Iterator iterator = this.pushButtons().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            JunButtonModel junButtonModel = (JunButtonModel)((Object)entry.getValue());
            if (!junButtonModel.value()) continue;
            return (StSymbol)entry.getKey();
        }
        return JunOpenGLDisplayModel.$((String)"none");
    }

    protected synchronized void setButtonState(StSymbol stSymbol, boolean bl) {
        if (!bl) {
            ((JunButtonModel)((Object)this.pushButtons().get(stSymbol))).value_(bl);
        } else {
            Iterator iterator = this.pushButtons().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ((JunButtonModel)((Object)entry.getValue())).value_(entry.getKey() == stSymbol);
            }
        }
        this.changed_(JunOpenGLDisplayModel.$((String)"state"));
    }

    protected Map pushButtons() {
        if (this.pushButtons == null) {
            this.pushButtons = new HashMap();
        }
        return this.pushButtons;
    }

    public JunThumbWheel xThumbWheel() {
        JunThumbWheel junThumbWheel = new JunThumbWheel(true);
        junThumbWheel.compute_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dPoint jun2dPoint = new Jun2dPoint(0.0, -((Number)object).doubleValue() / 50.0);
                JunOpenGLDisplayModel.this.grab_(jun2dPoint);
                return null;
            }
        });
        return junThumbWheel;
    }

    public JunThumbWheel yThumbWheel() {
        JunThumbWheel junThumbWheel = new JunThumbWheel(false);
        junThumbWheel.compute_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dPoint jun2dPoint = new Jun2dPoint(((Number)object).doubleValue() / 50.0, 0.0);
                JunOpenGLDisplayModel.this.grab_(jun2dPoint);
                return null;
            }
        });
        return junThumbWheel;
    }

    public JunThumbWheel zThumbWheel() {
        JunThumbWheel junThumbWheel = new JunThumbWheel(true);
        junThumbWheel.compute_(new StBlockClosure(){

            public Object value_(Object object) {
                if (JunOpenGLDisplayModel.this.dollyButton().value()) {
                    double d = ((Number)object).doubleValue() / 400.0;
                    JunOpenGLDisplayModel.this.dolly_(d);
                } else {
                    double d = 1.0 + ((Number)object).doubleValue() / 100.0;
                    JunOpenGLDisplayModel.this.zoom_(d);
                }
                return null;
            }
        });
        return junThumbWheel;
    }

    public StView defaultView() {
        if (JunOpenGLDisplayModel.GetDefaultViewMode() == 0) {
            return new JunOpenGLDisplayViewAwt(this);
        }
        return new JunOpenGLDisplayViewSwing(this);
    }

    public StView defaultViewWithoutWidgets() {
        if (JunOpenGLDisplayModel.GetDefaultViewMode() == 0) {
            return JunOpenGLDisplayViewAwt.WithoutWidgets(this);
        }
        return JunOpenGLDisplayViewSwing.WithoutWidgets(this);
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        JunOpenGLDisplayLight[] junOpenGLDisplayLightArray = this.displayLights();
        for (int i = 0; i < junOpenGLDisplayLightArray.length; ++i) {
            junOpenGLDisplayLightArray[i].closeRequest();
        }
        if (this.showModel() != null) {
            this.showModel().closeRequest();
        }
        super.noticeOfWindowClose(windowEvent);
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add(this._createEditMenu());
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createLightMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createFileMenu() {
        StMenu stMenu = new StMenu((Object)JunOpenGLDisplayModel.$String((String)"File"), JunOpenGLDisplayModel.$((String)"fileMenu"));
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"New"), (MenuListener)new MenuPerformer((StObject)this, "newModel")));
        stMenu.add(new StMenuItem((Object)(JunOpenGLDisplayModel.$String((String)"Open") + "..."), (MenuListener)new MenuPerformer((StObject)this, "openLST")));
        StMenu stMenu2 = new StMenu((Object)JunOpenGLDisplayModel.$String((String)"Open as..."));
        stMenu2.add(new StMenuItem((Object)"VRML1.0...", (MenuListener)new MenuPerformer((StObject)this, "openWRL10")));
        stMenu2.add(new StMenuItem((Object)"VRML97...", (MenuListener)new MenuPerformer((StObject)this, "openWRL97")));
        stMenu.add((StMenuItem)stMenu2);
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)(JunOpenGLDisplayModel.$String((String)"Save") + "..."), JunOpenGLDisplayModel.$((String)"saveMenu"), (MenuListener)new MenuPerformer((StObject)this, "saveLST")));
        StMenu stMenu3 = new StMenu((Object)JunOpenGLDisplayModel.$String((String)"Save as..."), JunOpenGLDisplayModel.$((String)"saveAsMenu"));
        stMenu3.add(new StMenuItem((Object)"VRML1.0...", (MenuListener)new MenuPerformer((StObject)this, "saveWRL10")));
        stMenu3.add(new StMenuItem((Object)"VRML97...", (MenuListener)new MenuPerformer((StObject)this, "saveWRL97")));
        stMenu.add((StMenuItem)stMenu3);
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Save as image..."), JunOpenGLDisplayModel.$((String)"saveAsImageMenu"), (MenuListener)new MenuPerformer((StObject)this, "saveAsImage")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Quit"), (MenuListener)new MenuPerformer((StObject)this, "quitDoing")));
        return stMenu;
    }

    protected StMenu _createEditMenu() {
        StMenu stMenu = new StMenu((Object)JunOpenGLDisplayModel.$String((String)"Edit"), JunOpenGLDisplayModel.$((String)"editMenu"));
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Copy"), JunOpenGLDisplayModel.$((String)"copyMenu"), (MenuListener)new MenuPerformer((StObject)this, "copyObject")));
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Cut"), JunOpenGLDisplayModel.$((String)"cutMenu"), (MenuListener)new MenuPerformer((StObject)this, "cutObject")));
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Paste"), JunOpenGLDisplayModel.$((String)"pasteMenu"), (MenuListener)new MenuPerformer((StObject)this, "pasteObject")));
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Clear"), JunOpenGLDisplayModel.$((String)"clearMenu"), (MenuListener)new MenuPerformer((StObject)this, "clearObject")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Select all"), JunOpenGLDisplayModel.$((String)"selectAllMenu"), (MenuListener)new MenuPerformer((StObject)this, "selectAll")));
        return stMenu;
    }

    protected StMenu _createMiscMenu() {
        StMenu stMenu = new StMenu((Object)JunOpenGLDisplayModel.$String((String)"Misc"), JunOpenGLDisplayModel.$((String)"miscMenu"));
        StMenu stMenu2 = new StMenu((Object)JunOpenGLDisplayModel.$String((String)"Texture"), JunOpenGLDisplayModel.$((String)"textureMenu"));
        stMenu2.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"From user..."), JunOpenGLDisplayModel.$((String)"textureFromUserMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureFromUser")));
        stMenu2.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"From file..."), JunOpenGLDisplayModel.$((String)"textureFromFileMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureFromFile")));
        stMenu2.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Take away"), (MenuListener)new MenuPerformer((StObject)this, "textureTakeAway")));
        stMenu2.addSeparator();
        stMenu2.add((StMenuItem)new StCheckBoxMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Linear approx."), JunOpenGLDisplayModel.$((String)"textureLinearMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureLinear")));
        stMenu2.add((StMenuItem)new StCheckBoxMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Clamp"), JunOpenGLDisplayModel.$((String)"textureClampMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureClamp")));
        stMenu2.add((StMenuItem)new StCheckBoxMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Modulate"), JunOpenGLDisplayModel.$((String)"textureModulateMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureModulate")));
        stMenu2.add((StMenuItem)new StCheckBoxMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Mipmap"), JunOpenGLDisplayModel.$((String)"textureMipmapMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureMipmap")));
        stMenu.add((StMenuItem)stMenu2);
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Spawn"), JunOpenGLDisplayModel.$((String)"spawnMenu"), (MenuListener)new MenuPerformer((StObject)this, "spawnObject")));
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Viewport"), JunOpenGLDisplayModel.$((String)"viewportMenu"), (MenuListener)new MenuPerformer((StObject)this, "spawnViewport")));
        stMenu.add(new StMenuItem((Object)JunOpenGLDisplayModel.$String((String)"Bounds"), JunOpenGLDisplayModel.$((String)"boundsMenu"), (MenuListener)new MenuPerformer((StObject)this, "showBounds")));
        return stMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearObject() {
        if (this.selectedObjects().isEmpty()) {
            return;
        }
        if (!this.displayObject().isCompound()) {
            return;
        }
        JunCursorAnimator junCursorAnimator = JunCursorAnimator.ClockCursors();
        try {
            junCursorAnimator._show();
            Object[] objectArray = this.selectedObjects().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((JunOpenGL3dCompoundObject)this.displayObject()).remove_((JunOpenGL3dObject)((Object)objectArray[i]));
            }
            this.clearSelectedObjects();
            this.changed_(JunOpenGLDisplayModel.$((String)"object"));
        }
        finally {
            junCursorAnimator._restore();
        }
        this.updateMenuIndication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyObject() {
        if (JunSensorUtility.ShiftDown()) {
            this.projectionTableToCopyBuffer();
            return;
        }
        if (this.openGL3dObject() == null) {
            return;
        }
        JunCursorAnimator junCursorAnimator = JunCursorAnimator.ClockCursors();
        try {
            junCursorAnimator._show();
            JunOpenGL3dObject junOpenGL3dObject = this.spawningObject();
            String string = this.defaultStampForLST10() + junOpenGL3dObject.toLispList().saveString();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), this);
        }
        finally {
            junCursorAnimator._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cutObject() {
        if (this.selectedObjects().isEmpty()) {
            return;
        }
        if (!this.displayObject().isCompound()) {
            return;
        }
        JunCursorAnimator junCursorAnimator = JunCursorAnimator.ClockCursors();
        try {
            junCursorAnimator._show();
            this.copyObject();
            Object[] objectArray = this.selectedObjects().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((JunOpenGL3dCompoundObject)this.displayObject()).remove_((JunOpenGL3dObject)((Object)objectArray[i]));
            }
            this.clearSelectedObjects();
            this.changed_(JunOpenGLDisplayModel.$((String)"object"));
        }
        finally {
            junCursorAnimator._restore();
        }
        this.updateMenuIndication();
    }

    public void openLST() {
        this.openLST10();
    }

    public void openLST10() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)"LST"), new String[]{"*.lst", "*.LST"})};
        File file = JunFileRequesterDialog.Request(JunOpenGLDisplayModel.$String((String)"Select an <1p> file.", null, (Object)"LST"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        JunOpenGL3dObject junOpenGL3dObject = null;
        try {
            junOpenGL3dObject = this.readFromLST10_(file);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        if (junOpenGL3dObject == null) {
            return;
        }
        this.displayObject_(junOpenGL3dObject);
        this.resetView();
        if (this.showModel() != null) {
            this.showModel().resetView();
        }
    }

    public void openWRL10() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)"VRML"), new String[]{"*.wrl", "*.WRL"})};
        File file = JunFileRequesterDialog.Request(JunOpenGLDisplayModel.$String((String)"Select a <1p> file.", null, (Object)"VRML"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.readFromWRL10_(file);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        this.resetView();
        if (this.showModel() != null) {
            this.showModel().resetView();
        }
    }

    public void openWRL20() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)"VRML"), new String[]{"*.wrl", "*.WRL"})};
        File file = JunFileRequesterDialog.Request(JunOpenGLDisplayModel.$String((String)"Select a <1p> file.", null, (Object)"VRML"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.readFromWRL20_(file);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        this.resetView();
        if (this.showModel() != null) {
            this.showModel().resetView();
        }
    }

    public void openWRL97() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)"VRML"), new String[]{"*.wrl", "*.WRL"})};
        File file = JunFileRequesterDialog.Request(JunOpenGLDisplayModel.$String((String)"Select a <1p> file.", null, (Object)"VRML"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.readFromWRL97_(file);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteObject() {
        if (JunSensorUtility.ShiftDown()) {
            this.projectionTableFromCopyBuffer();
            return;
        }
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        String string = null;
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
        if (string == null) {
            return;
        }
        if (!string.startsWith(this.defaultStampForLST10().substring(0, 9))) {
            JunDialog.Warn_(JunOpenGLDisplayModel.$String((String)"The contents of copy buffer is not <1p>.", null, (Object)"LST"));
            return;
        }
        JunCursorAnimator junCursorAnimator = JunCursorAnimator.ClockCursors();
        try {
            junCursorAnimator._show();
            JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.LoadFrom_(string);
            if (this.displayObject() == null) {
                this.displayObject_(junOpenGL3dObject);
                this.clearSelectedObjects();
                this.addSelectedObject_(junOpenGL3dObject);
                this.resetView();
            } else if (this.displayObject().isCompound()) {
                ((JunOpenGL3dCompoundObject)this.displayObject()).add_(junOpenGL3dObject);
                this.clearSelectedObjects();
                this.addSelectedObject_(junOpenGL3dObject);
                this.changed_(JunOpenGLDisplayModel.$((String)"object"));
            } else {
                junOpenGL3dObject = new JunOpenGL3dCompoundObject(this.displayObject(), junOpenGL3dObject);
                this.displayObject_(junOpenGL3dObject);
                this.clearSelectedObjects();
                this.addSelectedObject_(junOpenGL3dObject);
                this.changed_(JunOpenGLDisplayModel.$((String)"object"));
            }
        }
        finally {
            junCursorAnimator._restore();
        }
        this.updateMenuIndication();
    }

    public void quitDoing() {
        this.closeRequest();
    }

    public void saveLST() {
        this.saveLST10();
    }

    public void saveLST10() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)"LST"), new String[]{"*.lst", "*.LST"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunOpenGLDisplayModel.$String((String)"Input an <1p> file.", null, (Object)"LST"), new File(this.displayObject().name() + ".lst"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.writeToLST10_object_(file, this.displayObject());
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void saveWRL10() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)"VRML"), new String[]{"*.wrl", "*.WRL"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunOpenGLDisplayModel.$String((String)"Input a <1p> file.", null, (Object)"VRML"), new File(this.displayObject().name() + ".wrl"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.writeToWRL10_object_(file, this.displayObject());
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void saveWRL20() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)"VRML"), new String[]{"*.wrl", "*.WRL"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunOpenGLDisplayModel.$String((String)"Input a <1p> file.", null, (Object)"VRML"), new File(this.displayObject().name() + ".wrl"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.writeToWRL20_object_(file, this.displayObject());
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void saveWRL97() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)"VRML"), new String[]{"*.wrl", "*.WRL"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunOpenGLDisplayModel.$String((String)"Input a <1p> file.", null, (Object)"VRML"), new File(this.displayObject().name() + ".wrl"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.writeToWRL97_(file);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void showBounds() {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGL3dObject junOpenGL3dObject = this.spawningObject();
        JunOpenGL3dObject junOpenGL3dObject2 = this.boundingObjectFor_(junOpenGL3dObject);
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject2);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
        junOpenGLDisplayModel.displayProjection_((JunOpenGLProjection)this.displayProjection().copy());
        junOpenGLDisplayModel.open();
        junOpenGLDisplayModel.changed_(JunOpenGLDisplayModel.$((String)"object"));
    }

    public void spawnObject() {
        JunOpenGLDisplayModel junOpenGLDisplayModel = null;
        try {
            junOpenGLDisplayModel = (JunOpenGLDisplayModel)this.classToSpawn().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        junOpenGLDisplayModel.displayObject_(this.spawningObject());
        junOpenGLDisplayModel.defaultProjectionTable_(this.projectionTable());
        StView stView = this.getView();
        if (stView == null) {
            junOpenGLDisplayModel.open();
        } else {
            StRectangle stRectangle = new StRectangle(stView.topComponent().getBounds());
            StRectangle stRectangle2 = new StRectangle(0, 0, stRectangle.width(), stRectangle.height());
            stRectangle2 = stRectangle2.align_with_(stRectangle2.topLeft(), new Point(stRectangle.right() + 5, stRectangle.top()));
            junOpenGLDisplayModel.openIn_(stRectangle2.toRectangle());
        }
        junOpenGLDisplayModel.changed_(JunOpenGLDisplayModel.$((String)"object"));
    }

    public void spawnViewport() {
        JunOpenGLShowModel junOpenGLShowModel = this.showModel();
        if (junOpenGLShowModel == null) {
            junOpenGLShowModel = new JunOpenGLShowModel(this);
        }
        if (junOpenGLShowModel.builder().windows().length > 0) {
            junOpenGLShowModel._windowExpandAndRaise();
        } else {
            StView stView = this.getView();
            if (stView == null) {
                junOpenGLShowModel.open();
            } else {
                StRectangle stRectangle = new StRectangle(stView.topComponent().getBounds());
                StRectangle stRectangle2 = new StRectangle(0, 0, stRectangle.width(), stRectangle.height());
                stRectangle2 = stRectangle2.align_with_(stRectangle2.topLeft(), new Point(stRectangle.right() + 5, stRectangle.top()));
                junOpenGLShowModel.openIn_(stRectangle2.toRectangle());
            }
        }
    }

    public void textureClamp() {
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        final Boolean bl = !this.clamp();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    junOpenGLTexture.clamp_(bl);
                    junOpenGL3dObject.texture_(junOpenGLTexture);
                }
                return null;
            }
        });
        this.updateMiscMenuIndication();
        this.changed_(JunOpenGLDisplayModel.$((String)"texture"));
    }

    public void textureFromFile() {
        if (this.displayObject() == null) {
            return;
        }
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunOpenGLDisplayModel.$String((String)"<1p> files", null, (Object)JunOpenGLDisplayModel.$String((String)"Image")), JunSystem.DefaultImageExtensionPatterns()), JunFileModel.FileType.All(JunOpenGLDisplayModel.$String((String)"All files"))};
        File file = JunFileRequesterDialog.Request(JunOpenGLDisplayModel.$String((String)"Select an <1p> file.", null, (Object)JunOpenGLDisplayModel.$String((String)"Image")), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        StImage stImage = JunImageProcessor.ImageFromFile_(file.getPath());
        if (stImage == null) {
            return;
        }
        JunOpenGLTexture junOpenGLTexture = new JunOpenGLTexture(stImage);
        if (this.hasTextureMapping()) {
            junOpenGLTexture.linear_(this.linear());
            junOpenGLTexture.clamp_(this.clamp());
            junOpenGLTexture.modulate_(this.modulate());
            junOpenGLTexture.mipmap_(this.mipmap());
        }
        if (this.selectedObjects().isEmpty()) {
            this.displayObject().texture_(junOpenGLTexture);
        } else {
            Object[] objectArray = this.selectedObjects().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((JunOpenGL3dObject)((Object)objectArray[i])).texture_(junOpenGLTexture);
            }
        }
        this.updateMiscMenuIndication();
        this.changed_(JunOpenGLDisplayModel.$((String)"texture"));
    }

    public void textureFromUser() {
        if (this.displayObject() == null) {
            return;
        }
        StImage stImage = StImage._FromUser();
        if (stImage == null) {
            return;
        }
        JunOpenGLTexture junOpenGLTexture = new JunOpenGLTexture(stImage);
        if (this.hasTextureMapping()) {
            junOpenGLTexture.linear_(this.linear());
            junOpenGLTexture.clamp_(this.clamp());
            junOpenGLTexture.modulate_(this.modulate());
            junOpenGLTexture.mipmap_(this.mipmap());
        }
        if (this.selectedObjects().isEmpty()) {
            this.displayObject().texture_(junOpenGLTexture);
        } else {
            Object[] objectArray = this.selectedObjects().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((JunOpenGL3dObject)((Object)objectArray[i])).texture_(junOpenGLTexture);
            }
        }
        this.updateMiscMenuIndication();
        this.changed_(JunOpenGLDisplayModel.$((String)"texture"));
    }

    public void textureLinear() {
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        final Boolean bl = !this.linear();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    junOpenGLTexture.linear_(bl);
                    junOpenGL3dObject.texture_(junOpenGLTexture);
                }
                return null;
            }
        });
        this.updateMiscMenuIndication();
        this.changed_(JunOpenGLDisplayModel.$((String)"texture"));
    }

    public void textureMipmap() {
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        final Boolean bl = !this.mipmap();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    junOpenGLTexture.mipmap_(bl);
                    junOpenGL3dObject.texture_(junOpenGLTexture);
                }
                return null;
            }
        });
        this.updateMiscMenuIndication();
        this.changed_(JunOpenGLDisplayModel.$((String)"texture"));
    }

    public void textureModulate() {
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        final Boolean bl = !this.modulate();
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                JunOpenGLTexture junOpenGLTexture = junOpenGL3dObject.texture();
                if (junOpenGLTexture != null) {
                    junOpenGLTexture.modulate_(bl);
                    junOpenGL3dObject.texture_(junOpenGLTexture);
                }
                return null;
            }
        });
        this.updateMiscMenuIndication();
        this.changed_(JunOpenGLDisplayModel.$((String)"texture"));
    }

    public void textureTakeAway() {
        if (this.displayObject() == null) {
            return;
        }
        if (this.selectedObjects().isEmpty()) {
            this.displayObject().texture_(null);
        } else {
            Object[] objectArray = this.selectedObjects().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((JunOpenGL3dObject)((Object)objectArray[i])).texture_(null);
            }
        }
        this.updateMiscMenuIndication();
        this.changed_(JunOpenGLDisplayModel.$((String)"texture"));
    }

    public void updateMenuIndication() {
        super.updateMenuIndication();
        this.updateFileMenuIndication();
        this.updateEditMenuIndication();
        this.updateMiscMenuIndication();
        if (this.showModel() != null) {
            this.showModel().updateMenuIndication();
        }
    }

    public void updateFileMenuIndication() {
        if (this._menuBar() == null) {
            return;
        }
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunOpenGLDisplayModel.$((String)"fileMenu"));
        if (stMenu == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        StMenuItem stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"saveMenu"));
        if (stMenuItem != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"saveAsMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"saveAsImageMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
    }

    public void updateEditMenuIndication() {
        if (this._menuBar() == null) {
            return;
        }
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunOpenGLDisplayModel.$((String)"editMenu"));
        if (stMenu == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        boolean bl2 = !this.selectedObjects().isEmpty();
        StMenuItem stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"copyMenu"));
        if (stMenuItem != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"cutMenu"))) != null) {
            stMenuItem.beEnabled(bl && bl2);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"clearMenu"))) != null) {
            stMenuItem.beEnabled(bl && bl2);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"selectAllMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
    }

    public void updateMiscMenuIndication() {
        StMenuItem stMenuItem;
        if (this._menuBar() == null) {
            return;
        }
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunOpenGLDisplayModel.$((String)"miscMenu"));
        if (stMenu == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        StMenu stMenu2 = (StMenu)stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"textureMenu"));
        if (stMenu2 != null) {
            stMenu2.beEnabled(bl);
            if (bl) {
                StCheckBoxMenuItem stCheckBoxMenuItem = (StCheckBoxMenuItem)stMenu2.atNameKey_(JunOpenGLDisplayModel.$((String)"textureMipmapMenu"));
                if (stCheckBoxMenuItem != null) {
                    stCheckBoxMenuItem.beSelected(this.mipmap());
                }
                if ((stCheckBoxMenuItem = (StCheckBoxMenuItem)stMenu2.atNameKey_(JunOpenGLDisplayModel.$((String)"textureModulateMenu"))) != null) {
                    stCheckBoxMenuItem.beSelected(this.modulate());
                }
                if ((stCheckBoxMenuItem = (StCheckBoxMenuItem)stMenu2.atNameKey_(JunOpenGLDisplayModel.$((String)"textureClampMenu"))) != null) {
                    stCheckBoxMenuItem.beSelected(this.clamp());
                }
                if ((stCheckBoxMenuItem = (StCheckBoxMenuItem)stMenu2.atNameKey_(JunOpenGLDisplayModel.$((String)"textureLinearMenu"))) != null) {
                    stCheckBoxMenuItem.beSelected(this.linear());
                }
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"spawnMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"viewportMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGLDisplayModel.$((String)"boundsMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
    }

    public void flushMovementVector() {
        StView stView = this.getView();
        if (stView != null) {
            ((JunOpenGLDisplayController)((JunOpenGLDisplayView)stView).controller()).flushMovementVector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunOpenGL3dObject loadFromLST10_(StReadStream stReadStream) {
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.LoadFrom_(stReadStream);
            return junOpenGL3dObject;
        }
        catch (SmalltalkException smalltalkException) {
            JunDialog.Warn_(smalltalkException.getMessage());
            JunOpenGL3dObject junOpenGL3dObject = null;
            return junOpenGL3dObject;
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromWRL10_(StReadStream stReadStream) {
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            JunVrmlCompiler.Source_parser_generator_displayModel_(stReadStream, new JunVrmlParser10(), new JunVrmlGenerator10(), this);
        }
        catch (SmalltalkException smalltalkException) {
            JunDialog.Warn_(smalltalkException.getMessage());
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromWRL20_(StReadStream stReadStream) {
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            JunVrmlCompiler.Source_parser_generator_displayModel_(stReadStream, new JunVrmlParser97(), new JunVrmlGenerator97(), this);
        }
        catch (SmalltalkException smalltalkException) {
            JunDialog.Warn_(smalltalkException.getMessage());
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromWRL97_(StReadStream stReadStream) {
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            JunVrmlCompiler.Source_parser_generator_displayModel_(stReadStream, new JunVrmlParser97(), new JunVrmlGenerator97(), this);
        }
        catch (SmalltalkException smalltalkException) {
            JunDialog.Warn_(smalltalkException.getMessage());
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunOpenGL3dObject readFromLST10_(File file) throws IOException {
        if (file == null) {
            return null;
        }
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            StReadStream stReadStream;
            long l;
            block9: {
                JunOpenGL3dObject junOpenGL3dObject;
                junCursors._show();
                l = file.length();
                stReadStream = new StReadStream(file);
                try {
                    if (l > 100000L) break block9;
                    junOpenGL3dObject = this.loadFromLST10_(stReadStream);
                }
                catch (Throwable throwable) {
                    stReadStream.close();
                    throw throwable;
                }
                stReadStream.close();
                return junOpenGL3dObject;
            }
            final StValueHolder stValueHolder = new StValueHolder();
            final JunProgress junProgress = new JunProgress();
            junProgress.message_(JunOpenGLDisplayModel.$String((String)"reading <1p>...", null, (Object)"LST"));
            junProgress.do_(new StBlockClosure(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object value() {
                    junProgress.value_(0.0f);
                    Thread thread = new Thread(){

                        public void run() {
                            while (junProgress.value() < 1.0f) {
                                float f = (float)Math.round((double)((float)stReadStream.position() / (float)l) / 0.005) * 0.005f;
                                if (junProgress.value() != f) {
                                    junProgress.value_(f);
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    };
                    thread.setPriority(6);
                    thread.start();
                    try {
                        stValueHolder.value_((Object)JunOpenGLDisplayModel.this.loadFromLST10_(stReadStream));
                    }
                    finally {
                        junProgress.value_(1.0f);
                    }
                    return null;
                }
            });
            JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)stValueHolder.value());
            stReadStream.close();
            return junOpenGL3dObject;
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromWRL10_(File file) throws IOException {
        if (file == null) {
            return;
        }
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            final long l = file.length();
            final StReadStream stReadStream = new StReadStream(file);
            try {
                if (l <= 100000L) {
                    this.loadFromWRL10_(stReadStream);
                } else {
                    final JunProgress junProgress = new JunProgress();
                    junProgress.message_(JunOpenGLDisplayModel.$String((String)"reading <1p>...", null, (Object)"WRL"));
                    junProgress.do_(new StBlockClosure(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object value() {
                            junProgress.value_(0.0f);
                            Thread thread = new Thread(){

                                public void run() {
                                    while (junProgress.value() < 1.0f) {
                                        float f = (float)Math.round((double)((float)stReadStream.position() / (float)l) / 0.005) * 0.005f;
                                        if (junProgress.value() != f) {
                                            junProgress.value_(f);
                                        }
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                }
                            };
                            thread.setPriority(6);
                            thread.start();
                            try {
                                JunOpenGLDisplayModel.this.loadFromWRL10_(stReadStream);
                            }
                            finally {
                                junProgress.value_(1.0f);
                            }
                            return null;
                        }
                    });
                }
            }
            finally {
                stReadStream.close();
            }
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromWRL20_(File file) throws IOException {
        if (file == null) {
            return;
        }
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            final long l = file.length();
            final StReadStream stReadStream = new StReadStream(file);
            try {
                if (l <= 100000L) {
                    this.loadFromWRL20_(stReadStream);
                } else {
                    final JunProgress junProgress = new JunProgress();
                    junProgress.message_(JunOpenGLDisplayModel.$String((String)"reading <1p>...", null, (Object)"WRL"));
                    junProgress.do_(new StBlockClosure(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object value() {
                            junProgress.value_(0.0f);
                            Thread thread = new Thread(){

                                public void run() {
                                    while (junProgress.value() < 1.0f) {
                                        float f = (float)Math.round((double)((float)stReadStream.position() / (float)l) / 0.005) * 0.005f;
                                        if (junProgress.value() != f) {
                                            junProgress.value_(f);
                                        }
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                }
                            };
                            thread.setPriority(6);
                            thread.start();
                            try {
                                JunOpenGLDisplayModel.this.loadFromWRL20_(stReadStream);
                            }
                            finally {
                                junProgress.value_(1.0f);
                            }
                            return null;
                        }
                    });
                }
            }
            finally {
                stReadStream.close();
            }
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromWRL97_(File file) throws IOException {
        if (file == null) {
            return;
        }
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            final long l = file.length();
            final StReadStream stReadStream = new StReadStream(file);
            try {
                if (l <= 100000L) {
                    this.loadFromWRL97_(stReadStream);
                } else {
                    final JunProgress junProgress = new JunProgress();
                    junProgress.message_(JunOpenGLDisplayModel.$String((String)"reading <1p>...", null, (Object)"WRL"));
                    junProgress.do_(new StBlockClosure(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object value() {
                            junProgress.value_(0.0f);
                            Thread thread = new Thread(){

                                public void run() {
                                    while (junProgress.value() < 1.0f) {
                                        float f = (float)Math.round((double)((float)stReadStream.position() / (float)l) / 0.005) * 0.005f;
                                        if (junProgress.value() != f) {
                                            junProgress.value_(f);
                                        }
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                }
                            };
                            thread.setPriority(6);
                            thread.start();
                            try {
                                JunOpenGLDisplayModel.this.loadFromWRL97_(stReadStream);
                            }
                            finally {
                                junProgress.value_(1.0f);
                            }
                            return null;
                        }
                    });
                }
            }
            finally {
                stReadStream.close();
            }
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToLST10_object_(BufferedWriter bufferedWriter, JunOpenGL3dObject junOpenGL3dObject) throws IOException {
        JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
        try {
            junCursors._show();
            bufferedWriter.write(this.defaultStampForLST10());
            junOpenGL3dObject.saveOn_(bufferedWriter);
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToWRL10_object_(BufferedWriter bufferedWriter, JunOpenGL3dObject junOpenGL3dObject) throws IOException {
        JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
        try {
            junCursors._show();
            bufferedWriter.write(this.defaultStampForWRL10());
            junOpenGL3dObject.vrml10On_(bufferedWriter);
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToWRL20_object_(BufferedWriter bufferedWriter, JunOpenGL3dObject junOpenGL3dObject) throws IOException {
        JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
        try {
            junCursors._show();
            double d = junOpenGL3dObject.boundingBox().width();
            d = Math.max(d, junOpenGL3dObject.boundingBox().height());
            d = Math.max(d, junOpenGL3dObject.boundingBox().depth());
            bufferedWriter.write(this.defaultStampForWRL20());
            bufferedWriter.write("Viewpoint {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t");
            bufferedWriter.write("position 0.0 0.0 ");
            bufferedWriter.write(String.valueOf((float)d * 2.0f));
            bufferedWriter.newLine();
            bufferedWriter.write("}");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("NavigationInfo {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t");
            bufferedWriter.write("speed ");
            bufferedWriter.write(String.valueOf((float)d / 10.0f));
            bufferedWriter.newLine();
            bufferedWriter.write("}");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            junOpenGL3dObject.vrml20On_(bufferedWriter);
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToWRL97_(BufferedWriter bufferedWriter) throws IOException {
        JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
        try {
            junCursors._show();
            this.vrml97On_(bufferedWriter);
        }
        finally {
            junCursors._restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToLST10_object_(File file, JunOpenGL3dObject junOpenGL3dObject) throws IOException {
        if (file == null) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            this.saveToLST10_object_(bufferedWriter, junOpenGL3dObject);
        }
        finally {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToWRL10_object_(File file, JunOpenGL3dObject junOpenGL3dObject) throws IOException {
        if (file == null) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            this.saveToWRL10_object_(bufferedWriter, junOpenGL3dObject);
        }
        finally {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToWRL20_object_(File file, JunOpenGL3dObject junOpenGL3dObject) throws IOException {
        if (file == null) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            this.saveToWRL20_object_(bufferedWriter, junOpenGL3dObject);
        }
        finally {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToWRL97_(File file) throws IOException {
        if (file == null) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            this.saveToWRL97_(bufferedWriter);
        }
        finally {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }

    protected void vrml97On_(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.defaultStampForWRL97());
        bufferedWriter.newLine();
        this.vrml97WorldInfoOn_(bufferedWriter);
        bufferedWriter.newLine();
        this.vrml97NavigationInfoOn_(bufferedWriter);
        bufferedWriter.newLine();
        this.vrml97BackgroundOn_(bufferedWriter);
        bufferedWriter.newLine();
        this.vrml97ViewpointOn_(bufferedWriter);
        bufferedWriter.newLine();
        this.displayObject().vrml20On_(bufferedWriter);
    }

    protected void vrml97WorldInfoOn_(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("WorldInfo {");
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("info [");
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write(9);
        bufferedWriter.write("\"This file was created by " + JunSystem.System() + JunSystem.Version() + " for Java\"");
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write(9);
        bufferedWriter.write("\"" + DateFormat.getInstance().format(new Date()) + "\"");
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write(93);
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("title \"");
        if (this.displayObject() != null) {
            bufferedWriter.write(this.displayObject().name() + ": ");
        }
        bufferedWriter.write("Sample of " + this._className() + "\"");
        bufferedWriter.newLine();
        bufferedWriter.write(125);
        bufferedWriter.newLine();
    }

    protected void vrml97NavigationInfoOn_(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("NavigationInfo {");
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("type [\"EXAMINE\", \"ANY\"]");
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("avatarSize [0.25, 1.6, 0.75");
        bufferedWriter.write(", " + (float)this.sightPoint().x());
        bufferedWriter.write(", " + (float)this.sightPoint().y());
        bufferedWriter.write(", " + (float)this.sightPoint().z());
        bufferedWriter.write(93);
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("visibilityLimit " + (float)this.displayProjector().far());
        bufferedWriter.newLine();
        bufferedWriter.write(125);
        bufferedWriter.newLine();
    }

    protected void vrml97BackgroundOn_(BufferedWriter bufferedWriter) throws IOException {
        Color color = this.backgroundColor();
        if (color == null) {
            return;
        }
        bufferedWriter.write("Background {");
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("skyColor [");
        bufferedWriter.write(" " + (float)color.getRed() / 255.0f);
        bufferedWriter.write(" " + (float)color.getGreen() / 255.0f);
        bufferedWriter.write(" " + (float)color.getBlue() / 255.0f);
        bufferedWriter.write(" ]");
        bufferedWriter.newLine();
        bufferedWriter.write(125);
        bufferedWriter.newLine();
    }

    protected void vrml97ViewpointOn_(BufferedWriter bufferedWriter) throws IOException {
        if (this._presetProjections == null) {
            this.vrml97ViewpointOn_(bufferedWriter, this.openGLProjection());
        } else {
            for (int i = 0; i < this._presetProjections.length; ++i) {
                this.vrml97ViewpointOn_(bufferedWriter, this._presetProjections[i]);
            }
        }
    }

    protected void vrml97ViewpointOn_(BufferedWriter bufferedWriter, JunOpenGLProjection junOpenGLProjection) throws IOException {
        if (junOpenGLProjection == null) {
            return;
        }
        Jun3dTransformation jun3dTransformation = this.transformationForVrml97(junOpenGLProjection);
        Jun3dPoint jun3dPoint = jun3dTransformation.rotationVector();
        JunAngle junAngle = jun3dTransformation.rotationAngle();
        bufferedWriter.write("Viewpoint {");
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("fieldOfView " + (float)Math.atan(junOpenGLProjection.zoomHeight() / junOpenGLProjection.eyePoint().distance_(junOpenGLProjection.sightPoint()) / 2.0) * 2.0f);
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("orientation");
        bufferedWriter.write(" " + (float)jun3dPoint.x());
        bufferedWriter.write(" " + (float)jun3dPoint.y());
        bufferedWriter.write(" " + (float)jun3dPoint.z());
        bufferedWriter.write(" " + (float)junAngle.rad());
        bufferedWriter.newLine();
        bufferedWriter.write(9);
        bufferedWriter.write("position");
        bufferedWriter.write(" " + (float)junOpenGLProjection.eyePoint().x());
        bufferedWriter.write(" " + (float)junOpenGLProjection.eyePoint().y());
        bufferedWriter.write(" " + (float)junOpenGLProjection.eyePoint().z());
        if (junOpenGLProjection.description() != null) {
            bufferedWriter.newLine();
            bufferedWriter.write(9);
            bufferedWriter.write("description \"" + junOpenGLProjection.description() + '\"');
        }
        bufferedWriter.newLine();
        bufferedWriter.write(125);
        bufferedWriter.newLine();
    }

    private Jun3dTransformation transformationForVrml97(JunOpenGLProjection junOpenGLProjection) {
        Jun3dPoint jun3dPoint = junOpenGLProjection.eyePoint().minus_(junOpenGLProjection.sightPoint()).unitVector();
        Jun3dPoint jun3dPoint2 = junOpenGLProjection.upVector();
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(jun3dPoint2.y() * jun3dPoint.z() - jun3dPoint2.z() * jun3dPoint.y(), jun3dPoint2.z() * jun3dPoint.x() - jun3dPoint2.x() * jun3dPoint.z(), jun3dPoint2.x() * jun3dPoint.y() - jun3dPoint2.y() * jun3dPoint.x()).unitVector();
        double[] dArray = new double[]{jun3dPoint3.x(), jun3dPoint2.x(), jun3dPoint.x(), 0.0, jun3dPoint3.y(), jun3dPoint2.y(), jun3dPoint.y(), 0.0, jun3dPoint3.z(), jun3dPoint2.z(), jun3dPoint.z(), 0.0, 0.0, 0.0, 0.0, 1.0};
        return Jun3dTransformation.Translate_(new Jun3dPoint(0.0, 0.0, 0.0).minus_(junOpenGLProjection.sightPoint())).product_(Jun3dTransformation.FromArray_(dArray));
    }

    public String defaultStampForLST10() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("%LST V1.0 List Shape Transmission (Lisp S Expression)");
        printWriter.println("% This file was created by " + JunSystem.System() + JunSystem.Version());
        printWriter.println("% " + DateFormat.getInstance().format(new Date()));
        printWriter.println();
        printWriter.flush();
        return stringWriter.toString();
    }

    public String defaultStampForWRL10() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("#VRML V1.0 ascii");
        printWriter.println("# This file was created by " + JunSystem.System() + JunSystem.Version());
        printWriter.println("# " + DateFormat.getInstance().format(new Date()));
        printWriter.println();
        printWriter.flush();
        return stringWriter.toString();
    }

    public String defaultStampForWRL20() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("#VRML V2.0 utf8");
        printWriter.println();
        printWriter.println("WorldInfo {");
        printWriter.print("\t");
        printWriter.println("info [");
        printWriter.print("\t\t");
        printWriter.println("\"This file was created by " + JunSystem.System() + JunSystem.Version() + "\"");
        printWriter.print("\t\t");
        printWriter.println("\"" + DateFormat.getInstance().format(new Date()) + "\"");
        printWriter.print("\t");
        printWriter.println("]");
        printWriter.print("\t");
        printWriter.print("title \"");
        if (this.displayObject() != null) {
            printWriter.print(this.displayObject().name());
        }
        printWriter.print(": Sample of ");
        printWriter.print(this.getClass().getName());
        printWriter.println("\"");
        printWriter.println("}");
        printWriter.println();
        printWriter.flush();
        return stringWriter.toString();
    }

    public String defaultStampForWRL97() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("#VRML V2.0 utf8");
        printWriter.println("# This file was created by " + JunSystem.System() + JunSystem.Version() + " for Java");
        printWriter.println("# " + DateFormat.getInstance().format(new Date()));
        printWriter.println();
        printWriter.flush();
        return stringWriter.toString();
    }

    public JunOpenGL3dObject boundingObjectFor_(JunOpenGL3dObject junOpenGL3dObject) {
        Jun3dBoundingBox jun3dBoundingBox = junOpenGL3dObject.boundingBox();
        Jun3dPoint jun3dPoint = jun3dBoundingBox.origin();
        Jun3dPoint jun3dPoint2 = jun3dBoundingBox.corner();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(jun3dPoint.x(), jun3dPoint.y(), jun3dPoint2.z()), new Jun3dPoint(jun3dPoint.x(), jun3dPoint2.y(), jun3dPoint2.z()), new Jun3dPoint(jun3dPoint.x(), jun3dPoint2.y(), jun3dPoint.z()), new Jun3dPoint(jun3dPoint.x(), jun3dPoint.y(), jun3dPoint.z())};
        JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(jun3dPointArray, Color.gray);
        junOpenGL3dPolylineLoop.alpha_(0.5f);
        jun3dPointArray[3] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint.y(), jun3dPoint2.z());
        jun3dPointArray[2] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint2.z());
        jun3dPointArray[1] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint.z());
        jun3dPointArray[0] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint.y(), jun3dPoint.z());
        JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop2 = new JunOpenGL3dPolylineLoop(jun3dPointArray, Color.gray);
        junOpenGL3dPolylineLoop2.alpha_(0.5f);
        jun3dPointArray[0] = new Jun3dPoint(jun3dPoint.x(), jun3dPoint2.y(), jun3dPoint2.z());
        jun3dPointArray[1] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint2.z());
        jun3dPointArray[2] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint.z());
        jun3dPointArray[3] = new Jun3dPoint(jun3dPoint.x(), jun3dPoint2.y(), jun3dPoint.z());
        JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop3 = new JunOpenGL3dPolylineLoop(jun3dPointArray, Color.gray);
        junOpenGL3dPolylineLoop3.alpha_(0.5f);
        jun3dPointArray[3] = new Jun3dPoint(jun3dPoint.x(), jun3dPoint2.y(), jun3dPoint2.z());
        jun3dPointArray[2] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint2.z());
        jun3dPointArray[1] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint.z());
        jun3dPointArray[0] = new Jun3dPoint(jun3dPoint.x(), jun3dPoint2.y(), jun3dPoint.z());
        JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop4 = new JunOpenGL3dPolylineLoop(jun3dPointArray, Color.gray);
        junOpenGL3dPolylineLoop4.alpha_(0.5f);
        jun3dPointArray[0] = new Jun3dPoint(jun3dPoint.x(), jun3dPoint.y(), jun3dPoint2.z());
        jun3dPointArray[1] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint.y(), jun3dPoint2.z());
        jun3dPointArray[2] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint2.z());
        jun3dPointArray[3] = new Jun3dPoint(jun3dPoint.x(), jun3dPoint2.y(), jun3dPoint2.z());
        JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop5 = new JunOpenGL3dPolylineLoop(jun3dPointArray, Color.gray);
        junOpenGL3dPolylineLoop5.alpha_(0.5f);
        jun3dPointArray[0] = new Jun3dPoint(jun3dPoint.x(), jun3dPoint.y(), jun3dPoint2.z());
        jun3dPointArray[1] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint.y(), jun3dPoint2.z());
        jun3dPointArray[2] = new Jun3dPoint(jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint2.z());
        jun3dPointArray[3] = new Jun3dPoint(jun3dPoint.x(), jun3dPoint2.y(), jun3dPoint2.z());
        JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop6 = new JunOpenGL3dPolylineLoop(jun3dPointArray, Color.gray);
        junOpenGL3dPolylineLoop6.alpha_(0.5f);
        JunOpenGL3dObject junOpenGL3dObject2 = JunOpenGL3dObject.Axes2();
        junOpenGL3dObject2 = junOpenGL3dObject2.transform_(Jun3dTransformation.Scale_(jun3dPoint2.minus_(jun3dPoint)));
        junOpenGL3dObject2 = junOpenGL3dObject2.transform_(Jun3dTransformation.Translate_(jun3dPoint));
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop2);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop3);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop4);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop5);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolylineLoop6);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject2);
        return junOpenGL3dCompoundObject;
    }

    protected Jun3dPoint computeSightPoint() {
        if (this.selectedObjects().isEmpty()) {
            return super.computeSightPoint();
        }
        int n = this.selectedObjects().size();
        JunOpenGL3dObject[] junOpenGL3dObjectArray = new JunOpenGL3dObject[n];
        this.selectedObjects().copyInto((Object[])junOpenGL3dObjectArray);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            Jun3dPoint jun3dPoint = junOpenGL3dObjectArray[i].boundingBox().center();
            d += jun3dPoint.x();
            d2 += jun3dPoint.y();
            d3 += jun3dPoint.z();
        }
        return new Jun3dPoint(d / (double)n, d2 / (double)n, d3 / (double)n);
    }

    protected Jun3dPoint[] getCollection_centerValue_fromValue_toValue_(int n, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        Jun3dPoint jun3dPoint4;
        int n2 = n - 1;
        double d = jun3dPoint.distance_(jun3dPoint2);
        Jun3dLine jun3dLine = new Jun3dLine(jun3dPoint, jun3dPoint3);
        jun3dLine = jun3dLine.normalizedLine();
        Jun3dPoint jun3dPoint5 = jun3dLine.atT_(d).minus_(jun3dPoint2).dividedBy_(n2);
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n];
        jun3dPointArray[0] = jun3dPoint4 = jun3dPoint2;
        for (int i = 1; i <= n2; ++i) {
            jun3dPoint4 = jun3dPoint4.plus_(jun3dPoint5);
            jun3dLine = new Jun3dLine(jun3dPoint, jun3dPoint4);
            jun3dLine = jun3dLine.normalizedLine();
            jun3dPointArray[i] = jun3dLine.atT_(d);
        }
        return jun3dPointArray;
    }

    protected double[] getCollection_fromValue_toValue_(int n, double d, double d2) {
        double d3;
        int n2 = n - 1;
        double d4 = (d2 - d) / (double)n2;
        double[] dArray = new double[n];
        dArray[0] = d3 = d;
        for (int i = 1; i < n2; ++i) {
            dArray[i] = d3 += d4;
        }
        dArray[n2] = d2;
        return dArray;
    }

    protected Jun3dPoint[] getCollection_fromValue_toValue_(int n, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        Jun3dPoint jun3dPoint3;
        int n2 = n - 1;
        Jun3dPoint jun3dPoint4 = jun3dPoint2.minus_(jun3dPoint).dividedBy_(n2);
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n];
        jun3dPointArray[0] = jun3dPoint3 = jun3dPoint;
        for (int i = 1; i < n2; ++i) {
            jun3dPointArray[i] = jun3dPoint3 = jun3dPoint3.plus_(jun3dPoint4);
        }
        jun3dPointArray[n2] = jun3dPoint2;
        return jun3dPointArray;
    }

    public JunOpenGL3dObject spawningObject() {
        JunOpenGL3dObject junOpenGL3dObject;
        if (this.selectedObjects() == null || this.selectedObjects().isEmpty()) {
            junOpenGL3dObject = this.displayObject() == null ? null : (this.displayObject().isTransformedObject() ? ((JunOpenGL3dTransformedObject)this.displayObject()).transformedObject() : (JunOpenGL3dObject)this.displayObject().copy());
        } else {
            Object[] objectArray = this.selectedObjects().toArray();
            if (objectArray.length > 1) {
                junOpenGL3dObject = new JunOpenGL3dCompoundObject();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_((JunOpenGL3dObject)((Object)objectArray[i]));
                }
            } else {
                junOpenGL3dObject = (JunOpenGL3dObject)((JunOpenGL3dObject)((Object)objectArray[0])).copy();
            }
        }
        return junOpenGL3dObject;
    }

    public StView getView() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            DependentListener dependentListener = dependentListenerArray[i];
            if (!(dependentListener instanceof JunOpenGLDisplayView) || ((JunOpenGLDisplayView)dependentListener).getOpenGLDisplayModel() != this) continue;
            return (StView)dependentListener;
        }
        return null;
    }

    protected Class classToSpawn() {
        return this.getClass();
    }
}

