/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.cosmos;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunSphereSurface;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmViewAwt;
import jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmViewSwing;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.display.JunOpenGLShowModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

public class JunOpenGLMicrocosmModel
extends JunOpenGLDisplayModel {
    public JunOpenGLShowModel showModel() {
        JunOpenGLShowModel junOpenGLShowModel = super.showModel();
        if (junOpenGLShowModel == null) {
            junOpenGLShowModel = new JunOpenGLShowModel(this){

                public Jun3dPoint defaultEyePoint() {
                    if (this.defaultProjectionTable().get(1.$((String)"eyePoint")) == null) {
                        this.defaultEyePoint_(JunOpenGLProjection.DefaultEyePoint);
                    }
                    return (Jun3dPoint)((Object)this.defaultProjectionTable().get(1.$((String)"eyePoint")));
                }

                public void defaultEyePoint_(Jun3dPoint jun3dPoint) {
                    this.defaultProjectionTable().put(1.$((String)"eyePoint"), jun3dPoint);
                }
            };
        }
        return junOpenGLShowModel;
    }

    public Color defaultLightColor() {
        return Color.getHSBColor(0.0f, 0.0f, 0.75f);
    }

    public StView defaultView() {
        if (JunOpenGLMicrocosmModel.GetDefaultViewMode() == 0) {
            return new JunOpenGLMicrocosmViewAwt(this);
        }
        return new JunOpenGLMicrocosmViewSwing(this);
    }

    public JunOpenGLDisplayLight[] displayLights() {
        if (this.displayLights == null) {
            this.displayLights = new JunOpenGLDisplayLight[5];
            this.displayLights[0] = JunOpenGLDisplayLight.ParallelLight_color_position_(true, this.defaultLightColor(), this.defaultLightPoint());
            this.displayLights[1] = JunOpenGLDisplayLight.PointLight_color_position_(true, Color.white, new Jun3dPoint(0.0, 0.0, 0.0));
            this.displayLights[2] = new JunOpenGLDisplayLight();
            this.displayLights[3] = new JunOpenGLDisplayLight();
            this.displayLights[4] = JunOpenGLDisplayLight.AmbientLight_color_(true, this.defaultLightColor());
            for (int i = 0; i < this.displayLights.length; ++i) {
                this.displayLights[i].compute_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGLMicrocosmModel.this.updateLightMenuIndication();
                        this.changed_(2.$((String)"light"));
                        return null;
                    }
                });
            }
        }
        return this.displayLights;
    }

    public void displayObject_(JunOpenGL3dObject junOpenGL3dObject) {
        super.displayObject_(junOpenGL3dObject);
        if (!this.defaultProjectionTable().containsKey(JunOpenGLMicrocosmModel.$((String)"eyePoint"))) {
            this.eyePoint_(this.computeEyePoint());
        }
        if (!this.defaultProjectionTable().containsKey(JunOpenGLMicrocosmModel.$((String)"sightPoint"))) {
            this.sightPoint_(this.computeSightPoint());
        }
        if (!this.defaultProjectionTable().containsKey(JunOpenGLMicrocosmModel.$((String)"upVector"))) {
            this.upVector_(this.computeUpVector());
        }
        if (!this.defaultProjectionTable().containsKey(JunOpenGLMicrocosmModel.$((String)"viewFactor"))) {
            this.viewFactor_(this.computeViewFactor());
        }
        if (!this.defaultProjectionTable().containsKey(JunOpenGLMicrocosmModel.$((String)"zoomHeight"))) {
            this.zoomHeight_(this.computeZoomHeight());
        }
    }

    public void grab_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.displayProjection();
        JunSphereSurface junSphereSurface = this.grabSphere();
        junSphereSurface.center_(junOpenGLProjection.eyePoint());
        Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
        Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
        JunAngle junAngle = new Jun3dLine(junSphereSurface.center(), jun3dPoint2).angleWithLine_(new Jun3dLine(junSphereSurface.center(), jun3dPoint));
        if (Math.abs(junAngle.rad()) > 0.001) {
            Jun3dLine jun3dLine = new Jun3dLine(junSphereSurface.center(), junSphereSurface.center().minus_(jun3dPoint.minus_(junSphereSurface.center()).product_(jun3dPoint2.minus_(junSphereSurface.center()))));
            Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
            Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.Rotate_around_(junAngle.mul_(-1.0), jun3dLine);
            Jun3dPoint jun3dPoint3 = junOpenGLProjection.eyePoint().plus_(junOpenGLProjection.unitUpVector());
            junOpenGLProjection.sightPoint_(jun3dTransformation2.applyTo_(junOpenGLProjection.sightPoint()));
            junOpenGLProjection.upVector_(jun3dTransformation.applyTo_(jun3dPoint3).minus_(junOpenGLProjection.sightPoint()));
            this.displayProjection_(junOpenGLProjection);
            this.changed_(JunOpenGLMicrocosmModel.$((String)"projection"));
        }
    }

    public JunButtonModel grabButton() {
        if (!this.pushButtons().containsKey(JunOpenGLMicrocosmModel.$((String)"grab"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.ReadCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel = (JunButtonModel)((Object)object);
                    JunOpenGLMicrocosmModel.this.setButtonState(3.$((String)"grab"), !junButtonModel.value());
                    return junButtonModel;
                }
            });
            this.pushButtons().put(JunOpenGLMicrocosmModel.$((String)"grab"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLMicrocosmModel.$((String)"grab")));
    }

    protected Jun3dPoint computeEyePoint() {
        return this.boundingBox().center();
    }

    protected Jun3dPoint computeSightPoint() {
        Jun3dBoundingBox jun3dBoundingBox = this.boundingBox();
        double d = Math.min(jun3dBoundingBox.width(), Math.min(jun3dBoundingBox.height(), jun3dBoundingBox.depth())) * 2.0;
        return jun3dBoundingBox.center().minus_(new Jun3dPoint(0.0, 0.0, d));
    }

    protected Jun3dPoint computeUpVector() {
        return new Jun3dPoint(0.0, 1.0, 0.0);
    }

    protected double computeViewFactor() {
        return 25.0;
    }

    protected double computeZoomHeight() {
        Jun3dBoundingBox jun3dBoundingBox = this.boundingBox();
        return Math.min(jun3dBoundingBox.width(), Math.min(jun3dBoundingBox.height(), jun3dBoundingBox.depth())) * 2.5;
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Microcosm");
    }
}

