/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.awt.Color;
import java.awt.Point;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.opengl.chart.JunChartData;
import jp.co.sra.jun.opengl.chart.JunChartDataSheet;
import jp.co.sra.jun.opengl.chart.JunChartWithRoundShape;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

public class JunChartRadar
extends JunChartWithRoundShape {
    public static final double DefaultPointSize = 0.01;
    public static final double DefaultLineWidth = 1.0;
    protected double pointSize;
    protected double lineWidth;

    public JunChartRadar() {
    }

    public JunChartRadar(Vector vector) {
        super(vector);
    }

    public JunChartRadar(Vector vector, int n) {
        super(vector, n);
    }

    public JunChartRadar(JunChartData junChartData) {
        super(junChartData);
    }

    protected void initialize() {
        super.initialize();
        this.pointSize = 0.01;
        this.lineWidth = 1.0;
    }

    public double lineWidth() {
        return this.lineWidth;
    }

    public void lineWidth_(double d) {
        this.lineWidth = d;
    }

    public double pointSize() {
        return this.pointSize;
    }

    public void pointSize_(double d) {
        this.pointSize = d;
    }

    protected void _copyAttributes(JunChartRadar junChartRadar) {
        super._copyAttributes(junChartRadar);
        junChartRadar.pointSize_(this.pointSize);
        junChartRadar.lineWidth_(this.lineWidth);
    }

    protected JunOpenGL3dCompoundObject createChart3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunChartData junChartData = this.data();
        JunChartDataSheet[] junChartDataSheetArray = junChartData.sheets();
        if (junChartDataSheetArray == null) {
            return junOpenGL3dCompoundObject;
        }
        for (int i = 0; i < junChartDataSheetArray.length; ++i) {
            JunChartDataSheet junChartDataSheet = junChartDataSheetArray[i];
            int n = junChartDataSheet.rowSize();
            double d = this.intervalBetweenCharts() * (double)i;
            for (int j = 0; j < junChartDataSheet.valueSize(); ++j) {
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n];
                Color color = this.nextColor();
                for (int k = 0; k < n; ++k) {
                    Number number = (Number)junChartDataSheet.valueAtPoint_(new Point(k, j));
                    Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, junChartData.normalizeValue_(number.doubleValue()), d);
                    jun3dPointArray[k] = jun3dPoint = jun3dPoint.rotatedBy_(JunAngle.FromRad_(Math.PI * 2 * (double)k / (double)n));
                    JunOpenGL3dObject junOpenGL3dObject = this.createSmallCubeAt_(jun3dPoint);
                    junOpenGL3dObject.paint_(color);
                    junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
                    this.registerVisualObject_withValue_(junOpenGL3dObject, new Object[]{junChartDataSheet.keysAtRow_(k), number});
                }
                JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
                junOpenGL3dPolyline.paint_(color);
                junOpenGL3dPolyline.lineWidth_((float)this.lineWidth());
                junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
            }
        }
        return junOpenGL3dCompoundObject;
    }

    protected JunOpenGL3dObject createSmallCubeAt_(Jun3dPoint jun3dPoint) {
        double d = this.pointSize();
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Box_(new Jun3dPoint(d, d, d));
        junOpenGL3dObject = junOpenGL3dObject.translatedBy_(jun3dPoint.minus_(d / 2.0));
        return junOpenGL3dObject;
    }
}

