/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.chart.JunChartData;
import jp.co.sra.jun.opengl.chart.JunChartDataSheet;
import jp.co.sra.jun.opengl.chart.JunChartWithSymbolicKeys;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

public class JunChartPlot
extends JunChartWithSymbolicKeys {
    public static final double DefaultPointSize = 0.01;
    protected double pointSize;

    public JunChartPlot() {
    }

    public JunChartPlot(Vector vector) {
        super(vector);
    }

    public JunChartPlot(Vector vector, int n) {
        super(vector, n);
    }

    public JunChartPlot(JunChartData junChartData) {
        super(junChartData);
    }

    protected void initialize() {
        super.initialize();
        this.pointSize = 0.01;
    }

    public double pointSize() {
        return this.pointSize;
    }

    public void pointSize_(double d) {
        this.pointSize = d;
    }

    protected void _copyAttributes(JunChartPlot junChartPlot) {
        super._copyAttributes(junChartPlot);
        junChartPlot.pointSize_(this.pointSize);
    }

    protected JunOpenGL3dCompoundObject createChart3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunChartData junChartData = this.data();
        JunChartDataSheet[] junChartDataSheetArray = junChartData.sheets();
        if (junChartDataSheetArray == null) {
            return junOpenGL3dCompoundObject;
        }
        for (int i = 0; i < junChartDataSheetArray.length; ++i) {
            JunChartDataSheet junChartDataSheet = junChartDataSheetArray[i];
            double d = this.intervalBetweenCharts() * (double)i;
            int n = junChartDataSheet.rowSize();
            for (int j = 0; j < n; ++j) {
                Object[] objectArray = junChartDataSheet.valuesAtRow_(j);
                Object[] objectArray2 = junChartDataSheet.valuesAtRow_(j);
                double d2 = (1.0 - this.leftMargin() - this.rightMargin() - this.interval() * (double)(n - 1)) / (double)n;
                double d3 = this.leftMargin() + (d2 + this.interval) * (double)j + d2 / 2.0;
                for (int k = 0; k < objectArray2.length; ++k) {
                    JunOpenGL3dObject junOpenGL3dObject = this.createSmallCubeAt_(new Jun3dPoint(d3, junChartData.normalizeValue_(((Number)objectArray2[k]).doubleValue()), d));
                    junOpenGL3dObject.paint_(this.nextColor());
                    junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
                    this.registerVisualObject_withValue_(junOpenGL3dObject, new Object[]{objectArray, objectArray2[k]});
                }
            }
        }
        return junOpenGL3dCompoundObject;
    }

    protected JunOpenGL3dObject createSmallCubeAt_(Jun3dPoint jun3dPoint) {
        double d = this.pointSize();
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Box_(new Jun3dPoint(d, d, d));
        junOpenGL3dObject = junOpenGL3dObject.translatedBy_(jun3dPoint.minus_(d / 2.0));
        return junOpenGL3dObject;
    }
}

