/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.awt.Color;
import java.awt.Font;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.goodies.font.JunFontModel;
import jp.co.sra.jun.opengl.chart.JunChartData;
import jp.co.sra.jun.opengl.chart.JunChartDataSheet;
import jp.co.sra.jun.opengl.chart.JunChartWithRoundShape;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.smalltalk.StComposedText;

public class JunChartPie
extends JunChartWithRoundShape {
    protected boolean hasLabels;

    public JunChartPie() {
    }

    public JunChartPie(Vector vector) {
        super(vector);
    }

    public JunChartPie(Vector vector, int n) {
        super(vector, n);
    }

    public JunChartPie(JunChartData junChartData) {
        super(junChartData);
    }

    protected void initialize() {
        super.initialize();
        this.hasLabels = true;
    }

    public void showLabels() {
        if (!this.hasLabels()) {
            this.hasLabels = true;
            this.flushDisplayObject();
            this.changed_(JunChartPie.$((String)"object"));
        }
    }

    public void hideLabels() {
        if (this.hasLabels()) {
            this.hasLabels = false;
            this.flushDisplayObject();
            this.changed_(JunChartPie.$((String)"object"));
        }
    }

    public void labelHeight_(double d) {
        super.labelHeight_(d);
        if (this.hasLabels()) {
            this.flushDisplayObject();
            this.changed_(JunChartPie.$((String)"object"));
        }
    }

    public void useScalableLabels() {
        super.useScalableLabels();
        if (this.hasLabels()) {
            this.flushDisplayObject();
            this.changed_(JunChartPie.$((String)"object"));
        }
    }

    public void useTextureLabels() {
        super.useTextureLabels();
        if (this.hasLabels()) {
            this.flushDisplayObject();
            this.changed_(JunChartPie.$((String)"object"));
        }
    }

    protected void _copyAttributes(JunChartPie junChartPie) {
        super._copyAttributes(junChartPie);
        if (this.hasLabels()) {
            junChartPie.showLabels();
        } else {
            junChartPie.hideLabels();
        }
    }

    public boolean hasLabels() {
        return this.hasLabels;
    }

    protected JunOpenGL3dCompoundObject createChart3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunChartDataSheet[] junChartDataSheetArray = this.data().sheets();
        if (junChartDataSheetArray == null) {
            return junOpenGL3dCompoundObject;
        }
        for (int i = 0; i < junChartDataSheetArray.length; ++i) {
            JunChartDataSheet junChartDataSheet = junChartDataSheetArray[i];
            double d = this.intervalBetweenCharts() * (double)i;
            Object[] objectArray = junChartDataSheet.valuesAtColumn_(0);
            double d2 = 0.0;
            for (int j = 0; j < objectArray.length; ++j) {
                d2 += ((Number)objectArray[j]).doubleValue();
            }
            double d3 = 90.0;
            for (int j = 0; j < objectArray.length; ++j) {
                double d4 = ((Number)objectArray[j]).doubleValue();
                double d5 = 360.0 * d4 / d2;
                JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.PieFrom_to_by_radius_thickness_(d3 - d5, d3, 10.0, this.radius(), this.thickness());
                junOpenGL3dObject = junOpenGL3dObject.translatedBy_(new Jun3dPoint(0.0, 0.0, d));
                junOpenGL3dObject.paint_(this.nextColor());
                junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
                this.registerVisualObject_withValue_(junOpenGL3dObject, new Object[]{junChartDataSheet.keysAtRow_(0), new Double(d4)});
                if (this.hasLabels()) {
                    String string = this.labelStringFor_within_(d4, d2);
                    Jun3dPoint jun3dPoint = new Jun3dPoint(Jun2dPoint.Rho_theta_(this.radius(), JunAngle._DegreesToRadians(d3 - d5 / 2.0)), d);
                    junOpenGL3dCompoundObject.add_(this.label_at_(string, jun3dPoint));
                }
                d3 -= d5;
            }
        }
        return junOpenGL3dCompoundObject;
    }

    protected JunOpenGL3dObject label_at_(String string, Jun3dPoint jun3dPoint) {
        if (this.useScalableLabels) {
            return this.scalableLabel_at_(string, jun3dPoint);
        }
        return this.texturedLabel_at_(string, jun3dPoint);
    }

    protected JunOpenGL3dObject scalableLabel_at_(String string, Jun3dPoint jun3dPoint) {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            ++n;
        }
        Font font = JunFontModel.TextStyle(100.0f);
        StComposedText stComposedText = new StComposedText(string, font);
        stComposedText.centered();
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Text_(stComposedText);
        Jun3dBoundingBox jun3dBoundingBox = junOpenGL3dObject.boundingBox();
        double d = 1.0 / Math.max(jun3dBoundingBox.height() / this.labelHeight(), 1.0);
        junOpenGL3dObject = junOpenGL3dObject.scaledBy_(new Jun3dPoint(d *= (double)(n + 1), d, 1.0));
        jun3dBoundingBox = jun3dBoundingBox.scaledBy_(new Jun3dPoint(d, d, 1.0));
        double d2 = this.labelHeight() / 10.0;
        Jun2dPoint jun2dPoint = jun3dPoint.as2dPoint();
        jun2dPoint = Jun2dPoint.Rho_theta_(jun2dPoint.r() + jun3dBoundingBox.origin().distance_(jun3dBoundingBox.corner()) / 2.0 + d2, jun2dPoint.theta());
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(jun2dPoint.x(), jun2dPoint.y(), jun3dPoint.z()).minus_(jun3dBoundingBox.center());
        junOpenGL3dObject = junOpenGL3dObject.translatedBy_(jun3dPoint2);
        jun3dBoundingBox = jun3dBoundingBox.translatedBy_(jun3dPoint2);
        junOpenGL3dObject.paint_(this.labelForegroundColor());
        return junOpenGL3dObject;
    }

    protected JunOpenGL3dObject texturedLabel_at_(String string, Jun3dPoint jun3dPoint) {
        JunOpenGLTexture junOpenGLTexture = JunOpenGLTexture.TextureForString_foreColor_backColor_(string, this.labelForegroundColor(), this.labelBackgroundColor());
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            ++n;
        }
        double d = this.defaultLabelHeight() * (double)(n + 1);
        double d2 = d * (double)junOpenGLTexture.width() / (double)junOpenGLTexture.height();
        Jun2dPoint jun2dPoint = new Jun2dPoint(jun3dPoint.x(), jun3dPoint.y());
        jun2dPoint = Jun2dPoint.Rho_theta_(jun2dPoint.rho() + Math.sqrt(d2 * d2 + d * d) / 2.0, jun2dPoint.theta());
        Jun2dPoint jun2dPoint2 = new Jun2dPoint(jun2dPoint.x() - d2 / 2.0, jun2dPoint.y() - d / 2.0);
        Jun2dPoint jun2dPoint3 = new Jun2dPoint(jun2dPoint.x() + d2 / 2.0, jun2dPoint.y() + d / 2.0);
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(jun2dPoint2.x(), jun2dPoint2.y(), jun3dPoint.z()), new Jun3dPoint(jun2dPoint3.x(), jun2dPoint2.y(), jun3dPoint.z()), new Jun3dPoint(jun2dPoint3.x(), jun2dPoint3.y(), jun3dPoint.z()), new Jun3dPoint(jun2dPoint2.x(), jun2dPoint3.y(), jun3dPoint.z())};
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray);
        junOpenGL3dPolygon.paint_(Color.white);
        junOpenGL3dPolygon.texture_(junOpenGLTexture);
        return junOpenGL3dPolygon;
    }

    protected String labelStringFor_within_(double d, double d2) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(d);
        printWriter.print('(');
        printWriter.print(Math.floor(d * 100.0 / d2));
        printWriter.print("%)");
        printWriter.flush();
        return stringWriter.toString();
    }
}

