/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import jp.co.sra.jun.opengl.chart.JunChartData;
import jp.co.sra.jun.opengl.chart.JunChartDataSheet;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

public class JunChartDataWithNumericalKeys
extends JunChartData {
    protected double[] keyRange = null;
    protected double minimumKey = Double.NaN;
    protected double maximumKey = Double.NaN;

    public JunChartDataWithNumericalKeys() {
    }

    public JunChartDataWithNumericalKeys(Vector vector) {
        super(vector);
    }

    public JunChartDataWithNumericalKeys(Vector vector, int n) {
        super(vector, n);
    }

    public void samples_(Vector vector) {
        Object[][][] objectArray = this.samples();
        super.samples_(vector);
        if (!this.hasValidKeys()) {
            JunDialog.Warn_(JunSystem.$String((String)"Invalid keys:  Could not change samples."));
            super.samples_(objectArray);
        }
    }

    public JunChartDataSheet[] sheets() {
        if (this.sheets == null) {
            if (this.samples == null) {
                return null;
            }
            if (!this.hasValidSamples()) {
                return null;
            }
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    double d;
                    double d2 = ((Number)((Object[])object)[0]).doubleValue();
                    return d2 < (d = ((Number)((Object[])object2)[0]).doubleValue()) ? -1 : 1;
                }
            };
            int n = this.samples.length;
            this.sheets = new JunChartDataSheet[n];
            for (int i = 0; i < n; ++i) {
                TreeSet<Object[]> treeSet = new TreeSet<Object[]>(comparator);
                for (int j = 0; j < this.samples[i].length; ++j) {
                    treeSet.add(this.samples[i][j]);
                }
                Object[][] objectArray = (Object[][])treeSet.toArray((T[])new Object[treeSet.size()][]);
                this.sheets[i] = new JunChartDataSheet(objectArray, this.numberOfKeys());
            }
        }
        return this.sheets;
    }

    public double intervalOfKeyRange() {
        return this.keyRange()[2];
    }

    public double[] keyRange() {
        if (this.keyRange == null) {
            this.keyRange = this.defaultKeyRange();
        }
        return this.keyRange;
    }

    public void keyRange_(double[] dArray) {
        this.keyRange = dArray;
    }

    public void keyRangeFrom_to_(double d, double d2) {
        this.keyRangeFrom_to_by_(d, d2, this.defaultIntervalFrom_to_(d, d2));
    }

    public void keyRangeFrom_to_by_(double d, double d2, double d3) {
        if (d >= d2) {
            return;
        }
        double[] dArray = new double[]{d, d2, d3};
        this.keyRange_(dArray);
    }

    public double maximumKey() {
        if (Double.isNaN(this.maximumKey)) {
            final StValueHolder stValueHolder = new StValueHolder(Double.NEGATIVE_INFINITY);
            JunChartDataSheet[] junChartDataSheetArray = this.sheets();
            for (int i = 0; i < junChartDataSheetArray.length; ++i) {
                junChartDataSheetArray[i].keysDo_(new StBlockClosure(){

                    public Object value_(Object object) {
                        double d = ((Number)object).doubleValue();
                        if (d > stValueHolder._doubleValue()) {
                            stValueHolder.value_(d);
                        }
                        return null;
                    }
                });
            }
            this.maximumKey = stValueHolder._doubleValue();
        }
        return this.maximumKey;
    }

    public double maximumOfKeyRange() {
        return this.keyRange()[1];
    }

    public double minimumKey() {
        if (Double.isNaN(this.minimumKey)) {
            final StValueHolder stValueHolder = new StValueHolder(Double.MAX_VALUE);
            JunChartDataSheet[] junChartDataSheetArray = this.sheets();
            for (int i = 0; i < junChartDataSheetArray.length; ++i) {
                junChartDataSheetArray[i].keysDo_(new StBlockClosure(){

                    public Object value_(Object object) {
                        double d = ((Number)object).doubleValue();
                        if (d < stValueHolder._doubleValue()) {
                            stValueHolder.value_(object);
                        }
                        return null;
                    }
                });
            }
            this.minimumKey = stValueHolder._doubleValue();
        }
        return this.minimumKey;
    }

    public double minimumOfKeyRange() {
        return this.keyRange()[0];
    }

    protected double[] defaultKeyRange() {
        double d = this.maximumKey();
        double d2 = this.minimumKey();
        double[] dArray = new double[]{d2, d, this.defaultIntervalFrom_to_(d2, d)};
        return dArray;
    }

    protected int defaultNumberOfKeys() {
        return 1;
    }

    protected void flushCaches() {
        super.flushCaches();
        this.minimumKey = Double.NaN;
        this.maximumKey = Double.NaN;
    }

    public double normalizeKey_(double d) {
        double[] dArray = new double[]{0.0, 1.0};
        return this.mapNumber_fromRange_toRange_(d, this.keyRange(), dArray);
    }

    public double denormalizeKey_(double d) {
        double[] dArray = new double[]{0.0, 1.0};
        return this.mapNumber_fromRange_toRange_(d, dArray, this.keyRange());
    }

    public void printOn_(Writer writer) throws IOException {
        super.printOn_(writer);
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        bufferedWriter.write(40);
        bufferedWriter.newLine();
        bufferedWriter.write("     keyRange :  ");
        if (this.keyRange == null) {
            bufferedWriter.write("null");
        } else {
            bufferedWriter.write(" from ");
            bufferedWriter.write(String.valueOf(this.keyRange[0]));
            bufferedWriter.write(" to ");
            bufferedWriter.write(String.valueOf(this.keyRange[1]));
            bufferedWriter.write(" by ");
            bufferedWriter.write(String.valueOf(this.keyRange[2]));
        }
        bufferedWriter.newLine();
        bufferedWriter.write("     minimumKey :  ");
        bufferedWriter.write(String.valueOf(this.minimumKey));
        bufferedWriter.newLine();
        bufferedWriter.write("     maximumKey :  ");
        bufferedWriter.write(String.valueOf(this.maximumKey));
        bufferedWriter.newLine();
        bufferedWriter.write(41);
        bufferedWriter.flush();
    }

    public boolean hasValidKeys() {
        if (this.numberOfKeys() != 1) {
            return false;
        }
        JunChartDataSheet[] junChartDataSheetArray = this.sheets();
        for (int i = 0; i < junChartDataSheetArray.length; ++i) {
            Object object = junChartDataSheetArray[i].keysDo_(new StBlockClosure(){

                public Object value_(Object object) {
                    if (!(object instanceof Number)) {
                        return Boolean.FALSE;
                    }
                    return null;
                }
            });
            if (object != Boolean.FALSE) continue;
            return false;
        }
        return true;
    }
}

