/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.awt.Point;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.collections.sequences.JunMatrix;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunChartDataSheet
extends JunAbstractObject {
    protected JunMatrix keyMatrix = null;
    protected JunDoubleMatrix valueMatrix = null;

    public JunChartDataSheet(Object[][] objectArray, int n) {
        this();
        this.sample_numberOfKeys_(objectArray, n);
    }

    public JunChartDataSheet(Vector vector, int n) {
        this();
        int n2 = vector.size();
        Object[][] objectArray = new Object[n2][];
        vector.copyInto((Object[])objectArray);
        this.sample_numberOfKeys_(objectArray, n);
    }

    private JunChartDataSheet() {
    }

    protected void sample_numberOfKeys_(Object[][] objectArray, int n) {
        int n2;
        if (objectArray == null) {
            return;
        }
        int n3 = objectArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 = Math.max(n4, objectArray[n2].length);
        }
        this.keyMatrix = new JunMatrix(n3, n);
        this.valueMatrix = new JunDoubleMatrix(n3, n4 - n);
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            Object[] objectArray2 = objectArray[n2];
            for (n5 = 0; n5 < n; ++n5) {
                this.keyMatrix._put(n2, n5, objectArray2[n5]);
            }
            for (n5 = n; n5 < objectArray2.length; ++n5) {
                this.valueMatrix._put(n2, n5 - n, objectArray2[n5]);
            }
        }
    }

    public Object keyAtPoint_(Point point) {
        return this.keyMatrix._at(point.x, point.y);
    }

    public Object[] keysAtColumn_(int n) {
        return this.keyMatrix.atColumn_(n);
    }

    public Object[] keysAtRow_(int n) {
        return this.keyMatrix.atRow_(n);
    }

    public Object keysDo_(StBlockClosure stBlockClosure) {
        return this.keyMatrix.do_(stBlockClosure);
    }

    public int keySize() {
        return this.keyMatrix.columnSize();
    }

    public int rowSize() {
        return this.valueMatrix.rowSize();
    }

    public Object valueAtPoint_(Point point) {
        return this.valueMatrix._at(point.x, point.y);
    }

    public Object[] valuesAtColumn_(int n) {
        return this.valueMatrix.atColumn_(n);
    }

    public Object[] valuesAtRow_(int n) {
        return this.valueMatrix.atRow_(n);
    }

    public int valueSize() {
        return this.valueMatrix.columnSize();
    }

    public void valuesDo_(StBlockClosure stBlockClosure) {
        this.valueMatrix.do_(stBlockClosure);
    }

    public void valuesDoIJ_(StBlockClosure stBlockClosure) {
        this.valueMatrix.doIJ_(stBlockClosure);
    }

    public void printOn_(Writer writer) throws IOException {
        super.printOn_(writer);
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        bufferedWriter.write(40);
        bufferedWriter.newLine();
        bufferedWriter.write("     keys :  ");
        this.keyMatrix.printOn_(bufferedWriter);
        bufferedWriter.newLine();
        bufferedWriter.write("     values :  ");
        this.valueMatrix.printOn_(bufferedWriter);
        bufferedWriter.newLine();
        bufferedWriter.write(41);
        bufferedWriter.flush();
    }
}

