/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.metaball.abstracts;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.metaball.abstracts.JunMetaball;

public abstract class JunDistanceMetaball
extends JunMetaball {
    protected double weight;
    protected int order;

    public JunDistanceMetaball() {
    }

    public JunDistanceMetaball(int n, double d) {
        this();
        this.order_(n);
        this.weight_(d);
    }

    protected void initialize() {
        super.initialize();
        this.weight = this.defaultWeight();
        this.order = this.defaultOrder();
    }

    public int order() {
        return this.order;
    }

    public void order_(int n) {
        this.order = n;
    }

    public double weight() {
        return this.weight;
    }

    public void weight_(double d) {
        this.weight = d;
    }

    public double valueAt_(Jun3dPoint jun3dPoint) {
        double d = this.distance_(jun3dPoint);
        if (d < this.accuracy()) {
            d = this.accuracy();
        }
        int n = this.weight == 0.0 ? 0 : (this.weight > 0.0 ? 1 : -1);
        return Math.pow(Math.abs(this.weight) / d, this.order) * (double)n;
    }

    public abstract double distance_(Jun3dPoint var1);

    public int defaultOrder() {
        return 2;
    }

    public double defaultWeight() {
        return 1.0;
    }

    protected double accuracy() {
        return 1.0E-12;
    }
}

