/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.navigator;

import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import jp.co.sra.jun.goodies.display.JunDisplayView;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.movie.framework.JunMovieHandle;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaBodyModel;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageModel;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieModel;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextModel;
import jp.co.sra.jun.goodies.utilities.JunFileUtility;
import jp.co.sra.jun.graphics.navigator.JunFileNavigator;
import jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigatorViewAwt;
import jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigatorViewSwing;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StView;

public class JunMultiMediaNavigator
extends JunApplicationModel {
    protected JunFileNavigator fileModel;
    protected JunMultiMediaTextModel textModel;
    protected JunMultiMediaImageModel imageModel;
    protected JunMultiMediaMovieModel movieModel;
    protected JunMultiMediaBodyModel bodyModel;
    protected boolean isMoviePlaying;

    public JunMultiMediaNavigator() {
        this(JunFileModel.DefaultDirectory());
    }

    public JunMultiMediaNavigator(File file) {
        this.currentFile_(file);
    }

    protected void initialize() {
        super.initialize();
        this.fileModel = null;
        this.textModel = null;
        this.imageModel = null;
        this.movieModel = null;
        this.bodyModel = null;
        this.isMoviePlaying = false;
    }

    public void release() {
        this.fileModel().release();
        this.movieModel().release();
        this.imageModel().release();
        this.textModel().release();
        this.bodyModel().release();
        super.release();
    }

    public File currentFile() {
        return this.fileModel().currentFile();
    }

    public void currentFile_(File file) {
        this.fileModel().currentFile_(file);
    }

    protected String currentFileAsString() {
        return this.fileModel().currentFileAsString();
    }

    public JunFileNavigator fileModel() {
        if (this.fileModel == null) {
            this.fileModel = new JunFileNavigator();
            this.fileModel.currentFileHolder().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    File file = (File)object;
                    JunMultiMediaNavigator.this.checkFile_(file);
                    return null;
                }
            });
        }
        return this.fileModel;
    }

    public JunMultiMediaTextModel textModel() {
        if (this.textModel == null) {
            this.textModel = new JunMultiMediaTextModel();
        }
        return this.textModel;
    }

    public JunMultiMediaImageModel imageModel() {
        if (this.imageModel == null) {
            this.imageModel = new JunMultiMediaImageModel();
        }
        return this.imageModel;
    }

    public JunMultiMediaMovieModel movieModel() {
        if (this.movieModel == null) {
            this.movieModel = new JunMultiMediaMovieModel();
            this.movieModel.trackerModel().loopCondition_(JunMultiMediaNavigator.$((String)"loop"));
            this.movieModel.trackerModel().enableMarkers();
        }
        return this.movieModel;
    }

    public JunMultiMediaBodyModel bodyModel() {
        if (this.bodyModel == null) {
            this.bodyModel = new JunMultiMediaBodyModel();
        }
        return this.bodyModel;
    }

    protected void checkFile_(File file) {
        if (this.fileModel().centerList().getView() == null) {
            return;
        }
        this.fileModel().checkFile_(file);
        if (this.movieModel().getView() == null) {
            return;
        }
        if (this.movieModel().getView().toComponent().isVisible()) {
            this.isMoviePlaying = this.movieModel().isPlay();
            if (this.isMoviePlaying) {
                this.movieModel().stop();
            }
        }
        this.movieModel().beInvisible();
        this.imageModel().beInvisible();
        this.textModel().beInvisible();
        this.bodyModel().beInvisible();
        this.fileModel().updateCurrentFile();
        if (file == null || !file.exists() || file.isDirectory()) {
            return;
        }
        String string = JunFileUtility.ExtensionStringOf_(file);
        if (string == null) {
            string = new String();
        }
        if (Arrays.asList(JunSystem.DefaultMovieExtensions()).contains(string)) {
            this.checkMovieFile(file);
        } else if (Arrays.asList(JunSystem.DefaultSoundExtensions()).contains(string)) {
            this.checkMovieFile(file);
        } else if (Arrays.asList(JunSystem.DefaultImageExtensions()).contains(string)) {
            this.checkImageFile(file);
        } else if (Arrays.asList(JunSystem.DefaultBodyExtensions()).contains(string)) {
            this.checkBodyFile(file);
        } else if (Arrays.asList(JunSystem.DefaultTextExtensions()).contains(string)) {
            this.checkTextFile(file);
        } else {
            String string2 = null;
            int n = 0x400000;
            long l = file.length();
            if (l > (long)n) {
                String string3 = JunMultiMediaNavigator.$String((String)"The file is large: <1p> bytes.", (String)("The file is large: " + l + " bytes."), (Object)Long.toString(l));
                string3 = string3 + "\n";
                if (JunDialog.Confirm_(string3 = string3 + JunMultiMediaNavigator.$String((String)"Would you like to use dump on the head?"), true)) {
                    string2 = (String)new JunMultiMediaTextModel(file, n).textHolder().value();
                }
            }
            if (string2 == null) {
                string2 = (String)new JunMultiMediaTextModel(file).textHolder().value();
            }
            this.textModel().textHolder().value_(string2);
            this.textModel().beVisible();
        }
    }

    protected void checkBodyFile(File file) {
        JunOpenGL3dObject junOpenGL3dObject = null;
        try {
            junOpenGL3dObject = new JunMultiMediaBodyModel(file).displayObject();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (junOpenGL3dObject == null) {
            this.bodyModel().beInvisible();
            return;
        }
        this.bodyModel().displayObject_(junOpenGL3dObject);
        this.bodyModel().beVisible();
        this.bodyModel().flushMovementVector();
        this.bodyModel().resetView();
    }

    protected void checkMovieFile(File file) {
        this.movieModel().movieHandle();
        JunMovieHandle junMovieHandle = JunMovieHandle.Filename_(file);
        if (junMovieHandle == null) {
            return;
        }
        this.movieModel().movieHandle_(junMovieHandle);
        this.movieModel().normalSize();
        this.movieModel().beVisible();
        this.movieModel().goto_(this.movieModel().now());
        if (this.movieModel().isIntervalNotEmpty()) {
            this.movieModel().trackerModel().lastMarker_(this.movieModel().trackerModel().lastMarker());
            this.movieModel().trackerModel().firstMarker_(this.movieModel().trackerModel().firstMarker());
        }
        if (this.isMoviePlaying) {
            this.movieModel().start();
        }
    }

    protected void checkImageFile(File file) {
        StDisplayable stDisplayable = new JunMultiMediaImageModel(file).visual();
        JunDisplayView junDisplayView = (JunDisplayView)this.imageModel().getView();
        if (StInputState.Default().shiftDown()) {
            stDisplayable = JunImageAdjuster.AdjustImage_extent_keepAspect_alignmentSymbol_(stDisplayable.asImage(), junDisplayView._getViewportSize(), true, JunMultiMediaNavigator.$((String)"center"));
        }
        if (StInputState.Default().altDown()) {
            stDisplayable = JunImageAdjuster.AdjustImage_extent_keepAspect_(stDisplayable.asImage(), junDisplayView._getViewportSize(), true);
        }
        this.imageModel().visual_(stDisplayable);
        this.imageModel().beVisible();
    }

    protected void checkTextFile(File file) {
        String string = (String)new JunMultiMediaTextModel(file).textHolder().value();
        this.textModel().textHolder().value_((Object)string);
        this.textModel().beVisible();
    }

    public void compute_(StBlockClosure stBlockClosure) {
        this.fileModel().currentFileHolder().compute_(stBlockClosure);
    }

    public StView defaultView() {
        if (JunMultiMediaNavigator.GetDefaultViewMode() == 0) {
            return new JunMultiMediaNavigatorViewAwt(this);
        }
        return new JunMultiMediaNavigatorViewSwing(this);
    }

    protected String windowTitle() {
        return JunMultiMediaNavigator.$String((String)"Multi-Media Navigator");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        this.fileModel().closeRequest();
        this.movieModel().closeRequest();
        this.imageModel().closeRequest();
        this.textModel().closeRequest();
        this.bodyModel().closeRequest();
        this.release();
        super.noticeOfWindowClose(windowEvent);
    }
}

