/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.list;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import jp.co.sra.jun.graphics.framework.JunGraphicController;
import jp.co.sra.jun.graphics.framework.JunGraphicModel;
import jp.co.sra.jun.graphics.framework.JunGraphicViewAwt;
import jp.co.sra.jun.graphics.list.JunSequenceList;
import jp.co.sra.jun.graphics.list.JunSequenceListView;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StApplicationWindowAwt;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StViewCanvas;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunSequenceListViewAwt
extends JunGraphicViewAwt
implements JunSequenceListView {
    protected VerticalScrollPane _scrollPane;

    public JunSequenceListViewAwt(JunSequenceList junSequenceList) {
        super(junSequenceList);
    }

    protected void initialize() {
        super.initialize();
        this._scrollPane = null;
    }

    protected void buildComponent() {
        this.setLayout(new BorderLayout());
        this.add(this._scrollPane(), "Center");
        this._scrollPane().setSize(200, 150);
    }

    public JunSequenceList getSequenceList() {
        return (JunSequenceList)this.model();
    }

    public void makeVisible(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(this._scrollPane().getScrollPosition(), this._scrollPane().getViewportSize());
        if (rectangle2.contains(rectangle)) {
            return;
        }
        Point point = this._scrollPane().getScrollPosition();
        if (rectangle.y + rectangle.height >= rectangle2.y + rectangle2.height) {
            point.y = rectangle.y - (rectangle2.height - rectangle.height);
        }
        if (rectangle.y <= rectangle2.y || rectangle.height >= rectangle2.height) {
            point.y = rectangle.y;
        }
        this._scrollPane().setScrollPosition(point);
    }

    public Point scrollOffset() {
        return this._scrollPane().getScrollPosition();
    }

    public void scrollTo_(Point point) {
        if (this.scrollOffset().equals(point)) {
            return;
        }
        this._scrollPane().setScrollPosition(point);
    }

    protected void updateCanvasSize() {
        this.getGraphicModel().recomposeIn_(new Rectangle(new Point(0, 0), this._scrollPane().getViewportSize()));
        this._scrollPane().doLayout();
    }

    public StViewCanvas canvas() {
        if (this.canvas == null) {
            this.canvas = new StViewCanvas((StModel)this.getGraphicModel()){

                protected StController defaultController() {
                    return new JunGraphicController(){

                        public void mousePressed(MouseEvent mouseEvent) {
                            if (mouseEvent.getButton() == 1) {
                                Point point = mouseEvent.getPoint();
                                Point point2 = JunSequenceListViewAwt.this.scrollOffset();
                                point.translate(point2.x, point2.y);
                                ((JunGraphicModel)this.model()).redButtonPressedAt_(point);
                            } else {
                                super.mousePressed(mouseEvent);
                            }
                        }
                    };
                }

                public void displayOn_(Graphics graphics) {
                    if (this.isShowing()) {
                        graphics.translate(0, -JunSequenceListViewAwt.this.scrollOffset().y);
                        JunSequenceListViewAwt.this.displayCanvasOn_(graphics);
                    }
                }

                public void update_(DependentEvent dependentEvent) {
                    if (dependentEvent.getAspect() == 1.$((String)"redisplay")) {
                        this.popupMenu_(null);
                    }
                    super.update_(dependentEvent);
                }
            };
            this.canvas.setBackground(Color.white);
        }
        return this.canvas;
    }

    protected ScrollPane scrollPane() {
        return null;
    }

    protected VerticalScrollPane _scrollPane() {
        if (this._scrollPane == null) {
            this._scrollPane = new VerticalScrollPane(this.canvas());
            this._scrollPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    JunSequenceListViewAwt.this.updateCanvasSize();
                }
            });
            this.updateCanvasSize();
        }
        return this._scrollPane;
    }

    protected class VerticalScrollPane
    extends Panel
    implements AdjustmentListener {
        protected Panel borderPanel;
        protected Scrollbar verticalScrollBar;
        protected StViewCanvas viewport;

        public VerticalScrollPane(StViewCanvas stViewCanvas) {
            this.initialize();
            this.setViewport(stViewCanvas);
            int n = this.getVerticalScrollBar().getWidth();
            if (n == 0) {
                n = this.defaultScrollBarWidth();
            }
            this.setLayout(new BorderLayout());
            this.add((Component)this.getBorderPanel(), "Center");
            this.getBorderPanel().setLayout((LayoutManager)new WindowSpecLayout());
            this.getBorderPanel().add((Component)this.getVerticalScrollBar(), WindowSpecLayout.Position((float)1.0f, (int)(-n), (float)0.0f, (int)0, (float)1.0f, (int)0, (float)1.0f, (int)0));
            this.getBorderPanel().add((Component)this.getViewport(), WindowSpecLayout.Position((float)0.0f, (int)0, (float)0.0f, (int)0, (float)1.0f, (int)(-n), (float)1.0f, (int)0));
        }

        protected void initialize() {
            this.borderPanel = null;
            this.verticalScrollBar = null;
            this.viewport = null;
        }

        public void addNotify() {
            super.addNotify();
            this.doLayout();
        }

        public void doLayout() {
            super.doLayout();
            Dimension dimension = this.getViewportSize();
            Dimension dimension2 = this.getScrollableSize();
            int n = JunSequenceListViewAwt.this.getSequenceList().sequenceMap().componentItems().size();
            int n2 = n > 0 && dimension2.height > dimension.height ? Math.max(1, dimension2.height / n) : 1;
            Scrollbar scrollbar = this.getVerticalScrollBar();
            scrollbar.setValues(scrollbar.getValue(), dimension.height, 0, dimension2.height);
            scrollbar.setBlockIncrement(Math.min(dimension.height, dimension2.height));
            scrollbar.setUnitIncrement(n2);
            scrollbar.setEnabled(dimension2.height > dimension.height);
        }

        public Dimension getScrollableSize() {
            return JunSequenceListViewAwt.this.getSequenceList().sequenceMap().bounds().getSize();
        }

        public Dimension getViewportSize() {
            Dimension dimension = this.getViewport().getSize();
            if (dimension.width > 0 || dimension.height > 0) {
                return dimension;
            }
            Rectangle rectangle = this.getBounds();
            int n = this.getVerticalScrollBar().getWidth();
            if (n == 0) {
                n = this.defaultScrollBarWidth();
            }
            return new Dimension(Math.max(rectangle.width - n, 0), rectangle.height);
        }

        public int defaultScrollBarWidth() {
            return 16;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            this.getViewport().repaint();
        }

        public Point getScrollPosition() {
            return new Point(0, this.getVerticalScrollBar().getValue());
        }

        public void setScrollPosition(Point point) {
            this.getVerticalScrollBar().setValue(point.y);
            this.getViewport().repaint();
        }

        protected Panel getBorderPanel() {
            if (this.borderPanel == null) {
                this.borderPanel = StApplicationWindowAwt._PanelWithBorder();
            }
            return this.borderPanel;
        }

        public Scrollbar getVerticalScrollBar() {
            if (this.verticalScrollBar == null) {
                this.verticalScrollBar = new Scrollbar(1);
                this.verticalScrollBar.addAdjustmentListener(this);
                this.verticalScrollBar.setFocusable(false);
                this.verticalScrollBar.setEnabled(true);
            }
            return this.verticalScrollBar;
        }

        public StViewCanvas getViewport() {
            return this.viewport;
        }

        protected void setViewport(StViewCanvas stViewCanvas) {
            this.viewport = stViewCanvas;
        }
    }
}

