/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.wheels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.wheels.JunThumbWheel;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StView;

public class JunThumbWheelController
extends JunAbstractController
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected Point previousPoint;

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getView().thumbWheelArea().contains(mouseEvent.getPoint())) {
            if (this.getModel().verticalFlag()) {
                this.view().toComponent().setCursor(JunCursors.UpDownCursor());
            } else {
                this.view().toComponent().setCursor(JunCursors.BetweenCursor());
            }
        } else {
            this.view().toComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.previousPoint = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.previousPoint != null) {
            this.view().toComponent().setCursor(Cursor.getDefaultCursor());
            this.previousPoint = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point;
        if (this.previousPoint != null && !(point = mouseEvent.getPoint()).equals(this.previousPoint)) {
            this.getView().rotateDelta_(new Point(point.x - this.previousPoint.x, point.y - this.previousPoint.y));
            this.previousPoint = point;
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n;
        Rectangle rectangle = this.getView().thumbWheelArea();
        if (!rectangle.contains(this.cursorPoint())) {
            return;
        }
        int n2 = n = mouseWheelEvent.isAltDown() ? 1 : 5;
        Point point = this.getModel().verticalFlag() ? (mouseWheelEvent.getWheelRotation() < 0 ? new Point(0, -n) : new Point(0, n)) : (mouseWheelEvent.getWheelRotation() < 0 ? new Point(-n, 0) : new Point(n, 0));
        this.getView().rotateDelta_(point);
    }

    protected void buildListener(StView stView) {
        Component component = (Component)stView;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
    }

    protected JunThumbWheel getModel() {
        return (JunThumbWheel)this.model();
    }

    protected JunThumbWheelView getView() {
        return (JunThumbWheelView)this.view();
    }
}

