/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StInterval;
import jp.co.sra.smalltalk.StSymbol;

public class JunStringUtility
extends JunAbstractObject {
    public static String CanonicalString_usingTable_(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            Character c = new Character(string.charAt(i));
            if (map.containsKey(c)) {
                stringBuffer.append(map.get(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String HtmlCanonicalString_(String string) {
        return JunStringUtility.HtmlCanonicalString_usingTable_(string, JunStringUtility.HtmlCanonicalCharacterTable());
    }

    public static String HtmlCanonicalString_usingTable_(String string, Map map) {
        return JunStringUtility.CanonicalString_usingTable_(string, map);
    }

    public static Map HtmlCanonicalCharacterTable() {
        return JunStringUtility.XmlCanonicalCharacterTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void On_tag_attributes_do_(Writer writer, String string, String string2, StBlockClosure stBlockClosure) throws IOException {
        try {
            writer.write("<");
            writer.write(string);
            if (string2 != null && string2.length() > 0) {
                writer.write(" ");
                writer.write(string2);
            }
            writer.write(">");
            stBlockClosure.value();
        }
        finally {
            writer.write("</");
            writer.write(string);
            writer.write(">");
        }
    }

    public static void On_tag_do_(Writer writer, String string, StBlockClosure stBlockClosure) throws IOException {
        JunStringUtility.On_tag_attributes_do_(writer, string, null, stBlockClosure);
    }

    public static String XmlCanonicalString_(String string) {
        return JunStringUtility.XmlCanonicalString_usingTable_(string, JunStringUtility.XmlCanonicalCharacterTable());
    }

    public static String XmlCanonicalString_usingTable_(String string, Map map) {
        return JunStringUtility.CanonicalString_usingTable_(string, map);
    }

    public static Map XmlCanonicalCharacterTable() {
        HashMap<Character, String> hashMap = new HashMap<Character, String>(5);
        hashMap.put(new Character('&'), "&amp;");
        hashMap.put(new Character('<'), "&lt;");
        hashMap.put(new Character('>'), "&gt;");
        hashMap.put(new Character('\''), "&apos;");
        hashMap.put(new Character('\"'), "&quot;");
        return hashMap;
    }

    public static boolean StringMatch_and_(String string, String string2) {
        char[] cArray = new char[string.length() + 1];
        string.getChars(0, string.length(), cArray, 0);
        cArray[string.length()] = '\u0000';
        char[] cArray2 = new char[string2.length() + 1];
        string2.getChars(0, string2.length(), cArray2, 0);
        cArray2[string2.length()] = '\u0000';
        return JunStringUtility.StringMatch_sIndex_and_pIndex_(cArray, 0, cArray2, 0);
    }

    public static boolean StringMatch_sIndex_and_pIndex_(char[] cArray, int n, char[] cArray2, int n2) {
        int n3 = n;
        int n4 = n2;
        char c = cArray[n3];
        ++n3;
        char c2 = cArray2[n4];
        ++n4;
        if (c2 == '[') {
            boolean bl = false;
            char c3 = '\u00ff';
            while ((c2 = cArray2[n4++]) != '\u0000') {
                if (c2 == ']') {
                    if (bl) {
                        return JunStringUtility.StringMatch_sIndex_and_pIndex_(cArray, n3, cArray2, n4);
                    }
                    return false;
                }
                if (c2 == '-') {
                    if (c3 <= c && c <= cArray2[n4]) {
                        bl = true;
                    }
                    ++n4;
                    continue;
                }
                c3 = c2;
                if (c != c2) continue;
                bl = true;
            }
        }
        if (c2 == '?') {
            if (c != '\u0000') {
                return JunStringUtility.StringMatch_sIndex_and_pIndex_(cArray, n3, cArray2, n4);
            }
            return false;
        }
        if (c2 == '*') {
            if (cArray2[n4] == '\u0000') {
                return true;
            }
            --n3;
            while (cArray[n3] != '\u0000') {
                if (JunStringUtility.StringMatch_sIndex_and_pIndex_(cArray, n3, cArray2, n4)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (c2 == '\u0000') {
            return c == '\u0000';
        }
        if (c2 != c) {
            return false;
        }
        if (c != '\u0000') {
            return JunStringUtility.StringMatch_sIndex_and_pIndex_(cArray, n3, cArray2, n4);
        }
        return false;
    }

    public static String _ContractString_to_(String string, int n) {
        String string2;
        String string3 = string2 = string == null ? new String("") : new String(string);
        if (string.length() > n) {
            int n2 = n / 2;
            string2 = string.substring(0, n2 - 1) + "..." + string.substring(string.length() - (n - n2) + 2);
        }
        return string2;
    }

    public static String A_value_(String string, String string2) {
        String string3 = string2.toString();
        int n = string == null || string.length() == 0 ? string3.length() : Integer.parseInt(JunStringUtility.Separate_(string)[0]);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3.substring(0, Math.min(n, string3.length())));
        for (int i = 0; i < n - string3.length(); ++i) {
            stringBuffer.append(" ");
        }
        string3 = stringBuffer.toString();
        return string3;
    }

    public static String E_value_(String string, String string2) {
        return string2.toString();
    }

    public static String F_value_(String string, float f) {
        int n;
        int n2;
        char[] cArray = JunStringUtility.Separators();
        char[] cArray2 = new char[cArray.length + 1];
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[i] = cArray[i];
        }
        cArray2[cArray2.length - 1] = 46;
        String[] stringArray = JunStringUtility.Separate_dividers_(string, cArray2);
        if (stringArray == null || stringArray.length == 0) {
            n2 = 10;
            n = 4;
        } else {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[stringArray.length - 1]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((double)f < 0.0) {
            stringBuffer.append("-");
        }
        stringBuffer.append("################.");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("0");
        }
        String string2 = new DecimalFormat(stringBuffer.toString()).format(f);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n2 - string2.length(); ++i) {
            stringBuffer2.append(" ");
        }
        stringBuffer2.append(string2.substring(0, Math.min(n2, string2.length())));
        string2 = stringBuffer2.toString();
        return string2;
    }

    public static String I_value_(String string, int n) {
        String string2 = Integer.toString(n);
        String[] stringArray = JunStringUtility.Separate_(string);
        int n2 = stringArray == null || stringArray.length == 0 ? string2.length() : Integer.parseInt(stringArray[0]);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2 - string2.length(); ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string2.substring(0, Math.min(n2, string2.length())));
        string2 = stringBuffer.toString();
        return string2;
    }

    public static String SpacingMessageSelector_(StSymbol stSymbol) {
        return JunStringUtility.SpacingMessageSelector_with_(stSymbol, " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String SpacingMessageSelector_with_(StSymbol stSymbol, String string) {
        String string2 = stSymbol.toString();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (Character.isUpperCase(c)) {
                    stringBuffer.append(string);
                    stringBuffer.append(Character.toLowerCase(c));
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        finally {
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String X_(String string) {
        int n = string == null || string.length() == 0 ? 1 : Integer.parseInt(JunStringUtility.Separate_(string)[0]);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public static String Format_value_(String string, Object object) {
        try {
            String string2 = JunStringUtility.SkipSeparators_(string);
            char c = string2.toLowerCase().charAt(0);
            String string3 = string2.substring(1);
            switch (c) {
                case 'a': {
                    return JunStringUtility.A_value_(string3, (String)object);
                }
                case 'e': {
                    return JunStringUtility.E_value_(string3, (String)object);
                }
                case 'f': {
                    return JunStringUtility.F_value_(string3, ((Number)object).floatValue());
                }
                case 'i': {
                    return JunStringUtility.I_value_(string3, ((Number)object).intValue());
                }
                case 'x': {
                    return JunStringUtility.X_(string3);
                }
            }
        }
        catch (Exception exception) {
            JunDialog.Warn_("unexpected error.");
            throw new IllegalArgumentException(object.toString());
        }
        return object.toString();
    }

    public static String StringWithCommas_(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        for (int i = cArray.length - 1; i >= 0; --i) {
            stringBuffer.append(cArray[i]);
            if (i != 0 && n % 3 == 0) {
                stringBuffer.append(',');
            }
            ++n;
        }
        char[] cArray2 = stringBuffer.toString().toCharArray();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = cArray2.length - 1; i >= 0; --i) {
            stringBuffer2.append(cArray2[i]);
        }
        return stringBuffer2.toString();
    }

    public static String[] GetLines_(BufferedReader bufferedReader) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] GetLinesFromString_(String string) throws IOException {
        String[] stringArray = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            stringArray = JunStringUtility.GetLines_(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return stringArray;
    }

    public static String[][] GetTokens_(BufferedReader bufferedReader) throws IOException {
        String[] stringArray = JunStringUtility.GetLines_(bufferedReader);
        String[][] stringArray2 = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = JunStringUtility.Separate_(stringArray[i]);
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] GetTokensFromString_(String string) throws IOException {
        String[][] stringArray = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            stringArray = JunStringUtility.GetTokens_(bufferedReader);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return stringArray;
    }

    public static String StringWithCommasFor_(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("###,###.#####################################################################################################################################################################################################################################################################################################################################");
        return decimalFormat.format(d);
    }

    public static String[] Separate_(String string) {
        return JunStringUtility.Separate_dividers_(string, JunStringUtility.Separators());
    }

    public static String[] Separate_dividers_(String string, char[] cArray) {
        int n;
        int n2;
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(-1));
        for (int i = 0; i < string.length(); ++i) {
            n3 = string.charAt(i);
            for (n2 = 0; n2 < cArray.length; ++n2) {
                if (cArray[n2] != n3) continue;
                arrayList.add(new Integer(i));
            }
        }
        arrayList.add(new Integer(string.length()));
        ArrayList<StInterval> arrayList2 = new ArrayList<StInterval>();
        for (n3 = 0; n3 < arrayList.size() - 1; ++n3) {
            n2 = (Integer)arrayList.get(n3);
            n = (Integer)arrayList.get(n3 + '\u0001');
            arrayList2.add(new StInterval((double)(n2 + 1), (double)(n - 1)));
        }
        StInterval[] stIntervalArray = arrayList2.toArray(new StInterval[arrayList2.size()]);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < stIntervalArray.length; ++n) {
            if (stIntervalArray[n].size() <= 0) continue;
            String string2 = string.substring((int)stIntervalArray[n].first(), (int)stIntervalArray[n].last() + 1);
            arrayList3.add(string2);
        }
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    public static char[] Separators() {
        char[] cArray = new char[]{' ', '\t', '\r', '\f', '\n'};
        return cArray;
    }

    public static String StripBackCharcters_from_(char[] cArray, String string) {
        String string2 = string.toString();
        int n = 0;
        int n2 = string2.length() - 1;
        for (int i = string2.length() - 1; i >= 0; --i) {
            char c = string2.charAt(i);
            boolean bl = false;
            for (int j = 0; j < cArray.length; ++j) {
                if (c != cArray[j]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            n2 = i;
            break;
        }
        if (n2 < n) {
            return "";
        }
        return string2.substring(n, n2 + 1);
    }

    public static String StripBackSeparators_(String string) {
        String string2 = string.toString();
        int n = 0;
        int n2 = string2.length() - 1;
        while (Character.isWhitespace(string2.charAt(n2))) {
            --n2;
        }
        if (n2 < n) {
            return "";
        }
        return string2.substring(n, n2 + 1);
    }

    public static String StripFrontBackCharcters_from_(char[] cArray, String string) {
        return JunStringUtility.StripFrontCharcters_from_(cArray, JunStringUtility.StripBackCharcters_from_(cArray, string));
    }

    public static String StripFrontBackSeparators_(String string) {
        return string.trim();
    }

    public static String StripFrontCharcters_from_(char[] cArray, String string) {
        int n;
        String string2 = string.toString();
        int n2 = 0;
        for (n = 0; n < string2.length(); ++n) {
            char c = string2.charAt(n);
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            n2 = n;
            break;
        }
        if ((n = string2.length()) < n2) {
            return "";
        }
        return string2.substring(n2, n);
    }

    public static String StripFrontSeparators_(String string) {
        String string2 = string.toString();
        int n = 0;
        while (Character.isWhitespace(string2.charAt(n))) {
            ++n;
        }
        int n2 = string2.length();
        if (n2 < n) {
            return "";
        }
        return string2.substring(n, n2);
    }

    protected static String SkipSeparators_(String string) {
        String string2 = string.substring(0);
        while (string2.length() != 0 && Character.isWhitespace(string2.charAt(0))) {
            string2 = string2.substring(1);
        }
        return string2;
    }
}

