/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.track;

import java.awt.Color;
import java.awt.Image;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.button.JunButtonWithMenuModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.track.JunTrackSliderModel;
import jp.co.sra.jun.goodies.track.JunTrackerViewAwt;
import jp.co.sra.jun.goodies.track.JunTrackerViewSwing;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

public class JunTrackerModel
extends JunTrackSliderModel {
    protected Thread trackingProcess;
    protected StValueHolder stepHolder;
    protected StSymbol loopCondition;
    protected StSymbol loopDirection;
    protected JunButtonModel playButton;
    protected JunButtonModel loopButton;
    protected JunButtonModel previousButton;
    protected JunButtonModel nextButton;
    protected JunButtonModel firstButton;
    protected JunButtonModel lastButton;
    protected JunButtonModel firstMarkerButton;
    protected JunButtonModel lastMarkerButton;
    protected JunButtonWithMenuModel speakerButton;
    protected JunTrackSliderModel childTracker;

    protected void initialize() {
        super.initialize();
        this.trackingProcess = null;
        this.stepHolder = null;
        this.loopCondition = null;
        this.loopDirection = JunTrackerModel.$((String)"forth");
        this.playButton = null;
        this.loopButton = null;
        this.previousButton = null;
        this.nextButton = null;
        this.firstButton = null;
        this.lastButton = null;
        this.firstMarkerButton = null;
        this.lastMarkerButton = null;
        this.speakerButton = null;
        this.childTracker = null;
        this.stepHolder();
        this.loopCondition();
    }

    public double step() {
        return ((Number)this.stepHolder.value()).doubleValue();
    }

    public void step_(double d) {
        if (d <= 0.0) {
            return;
        }
        this.stepHolder.value_(Math.max(0.0, Math.min(d, 1.0)));
        this.value_(this.doubleValue());
    }

    protected StValueHolder stepHolder() {
        if (this.stepHolder == null) {
            this.stepHolder = new StValueHolder(0.01);
        }
        return this.stepHolder;
    }

    public StSymbol loopCondition() {
        if (this.loopCondition == null) {
            this.loopCondition = JunTrackerModel.$((String)"oneWay");
        }
        return this.loopCondition;
    }

    public void loopCondition_(StSymbol stSymbol) {
        if (stSymbol == JunTrackerModel.$((String)"oneWay") || stSymbol == JunTrackerModel.$((String)"loop") || stSymbol == JunTrackerModel.$((String)"backAndForth")) {
            this.loopCondition = stSymbol;
            this.loopButton().visual_(this.loopImage());
        }
    }

    public void oneWay() {
        this.loopCondition_(JunTrackerModel.$((String)"oneWay"));
    }

    public void loop() {
        this.loopCondition_(JunTrackerModel.$((String)"loop"));
    }

    public void backAndForth() {
        this.loopCondition_(JunTrackerModel.$((String)"backAndForth"));
    }

    public void value_(double d) {
        if (d <= 0.0) {
            super.value_(0.0);
        } else if (1.0 <= d) {
            super.value_(1.0);
        } else {
            super.value_((double)Math.round(d / this.step()) * this.step());
        }
    }

    public void first() {
        if (this.areMarkersActive()) {
            this.value_(this.firstMarker());
        } else {
            this.value_(0.0);
        }
    }

    public void last() {
        if (this.areMarkersActive()) {
            this.value_(this.lastMarker());
        } else {
            this.value_(1.0);
        }
    }

    public void firstMarker_(double d) {
        if (!this.fixFirstMarker()) {
            double d2 = Math.max(d, this.intervalBounds()[0]);
            double[] dArray = new double[]{d2, Math.max(d2, this.lastMarker())};
            this.interval_(dArray);
        }
    }

    public void lastMarker_(double d) {
        if (!this.fixLastMarker()) {
            double d2 = Math.min(d, this.intervalBounds()[1]);
            double[] dArray = new double[]{Math.min(this.firstMarker(), d2), d2};
            this.interval_(dArray);
        }
    }

    protected double[] adjustInterval_(double[] dArray) {
        double d = Math.min(dArray[0], dArray[1]);
        double d2 = Math.max(dArray[0], dArray[1]);
        d = (double)Math.round(Math.max(0.0, Math.min(d, 1.0)) / this.step()) * this.step();
        d2 = (double)Math.round(Math.max(d, Math.min(d2, 1.0)) / this.step()) * this.step();
        return new double[]{d, d2};
    }

    public void enableMarkers() {
        super.enableMarkers();
        this.firstButton().enable();
        this.lastButton().enable();
        this.firstMarkerButton().enable();
        this.lastMarkerButton().enable();
    }

    public void disableMarkers() {
        super.disableMarkers();
        this.firstButton().disable();
        this.lastButton().disable();
        this.firstMarkerButton().disable();
        this.lastMarkerButton().disable();
    }

    public JunTrackSliderModel childTracker() {
        return this.childTracker;
    }

    public void childTracker_(JunTrackSliderModel junTrackSliderModel) {
        this.childTracker = junTrackSliderModel;
    }

    public JunButtonModel playButton() {
        if (this.playButton == null) {
            JunButtonModel junButtonModel;
            this.playButton = junButtonModel = new JunButtonModel(false, this.playImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunTrackerModel.this.playAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
        }
        return this.playButton;
    }

    public Image playImage() {
        if (this.playButton != null) {
            if (this.playButton().value()) {
                return JunCursors.PauseCursorImage();
            }
            return JunCursors.PlayCursorImage();
        }
        return JunCursors.PlayCursorImage();
    }

    protected void playAction_(JunButtonModel junButtonModel) {
        if (junButtonModel.value()) {
            this.end();
        } else {
            if (junButtonModel._isPressedWithShiftDown()) {
                this.first();
            }
            this.start();
        }
    }

    public void playButtonVisual_(boolean bl) {
        this.playButton().value_(bl);
        this.playButton().visual_(this.playImage());
    }

    public JunButtonModel loopButton() {
        if (this.loopButton == null) {
            JunButtonModel junButtonModel;
            this.loopButton = junButtonModel = new JunButtonModel(false, this.loopImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunTrackerModel.this.loopAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
        }
        return this.loopButton;
    }

    public Image loopImage() {
        if (this.loopCondition() == JunTrackerModel.$((String)"oneWay")) {
            return JunCursors.ArrowCursorImage();
        }
        if (this.loopCondition() == JunTrackerModel.$((String)"loop")) {
            return JunCursors.RepeatCursorImage();
        }
        if (this.loopCondition() == JunTrackerModel.$((String)"backAndForth")) {
            return JunCursors.RoundtripCursorImage();
        }
        return JunCursors.ArrowCursorImage();
    }

    protected void loopAction_(JunButtonModel junButtonModel) {
        if (this.loopCondition() == JunTrackerModel.$((String)"oneWay")) {
            this.loop();
        } else if (this.loopCondition() == JunTrackerModel.$((String)"loop")) {
            this.backAndForth();
        } else if (this.loopCondition() == JunTrackerModel.$((String)"backAndForth")) {
            this.oneWay();
        } else {
            this.oneWay();
        }
    }

    public JunButtonModel previousButton() {
        if (this.previousButton == null) {
            JunButtonModel junButtonModel = new JunButtonModel(false, this.previousButtonImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunTrackerModel.this.previousAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
            junButtonModel.repeatAction_(true);
            this.previousButton = junButtonModel;
        }
        return this.previousButton;
    }

    public Image previousButtonImage() {
        return JunCursors.PreviousCursorImage();
    }

    protected void previousAction_(JunButtonModel junButtonModel) {
        if (junButtonModel._isPressedWithShiftDown()) {
            this.first();
        } else if (this.doubleValue() > 0.0) {
            this.previous();
        }
    }

    public JunButtonModel nextButton() {
        if (this.nextButton == null) {
            JunButtonModel junButtonModel = new JunButtonModel(false, this.nextButtonImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunTrackerModel.this.nextAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
            junButtonModel.repeatAction_(true);
            this.nextButton = junButtonModel;
        }
        return this.nextButton;
    }

    public Image nextButtonImage() {
        return JunCursors.NextCursorImage();
    }

    protected void nextAction_(JunButtonModel junButtonModel) {
        if (junButtonModel._isPressedWithShiftDown()) {
            this.last();
        } else if (this.doubleValue() < 1.0) {
            this.next();
        }
    }

    public JunButtonModel firstButton() {
        if (this.firstButton == null) {
            JunButtonModel junButtonModel = new JunButtonModel(false, this.firstButtonImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunTrackerModel.this.firstAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
            junButtonModel.repeatAction_(true);
            this.firstButton = junButtonModel;
        }
        return this.firstButton;
    }

    protected Image firstButtonImage() {
        BufferedImage bufferedImage = ((StImage)new StImage((Image)JunCursors.PrologueCursorImage()).clone()).image();
        int n = Color.blue.getRGB();
        for (int i = 2; i <= 13; ++i) {
            bufferedImage.setRGB(3, i, n);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firstAction_(JunButtonModel junButtonModel) {
        if (!this.areMarkersActive()) {
            return;
        }
        JunCursors junCursors = new JunCursors(JunCursors.PrologueCursor());
        try {
            junCursors._show();
            double d = this.firstMarker();
            double d2 = 0.02;
            if (junButtonModel._isPressedWithShiftDown()) {
                double d3 = this.doubleValue();
                if (d - d3 > 0.0) {
                    while (true) {
                        double d4;
                        d3 += d2;
                        if (d4 < d) {
                            this.value_(d3);
                            continue;
                        }
                        break;
                    }
                } else {
                    while (true) {
                        double d5;
                        d3 -= d2;
                        if (!(d5 > d)) break;
                        this.value_(d3);
                    }
                }
            }
            this.value_(d);
        }
        finally {
            junCursors._restore();
        }
    }

    public JunButtonModel lastButton() {
        if (this.lastButton == null) {
            JunButtonModel junButtonModel = new JunButtonModel(false, this.lastButtonImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunTrackerModel.this.lastAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
            junButtonModel.repeatAction_(true);
            this.lastButton = junButtonModel;
        }
        return this.lastButton;
    }

    protected Image lastButtonImage() {
        BufferedImage bufferedImage = ((StImage)new StImage((Image)JunCursors.EpilogueCursorImage()).clone()).image();
        int n = Color.red.getRGB();
        for (int i = 2; i <= 13; ++i) {
            bufferedImage.setRGB(12, i, n);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lastAction_(JunButtonModel junButtonModel) {
        if (!this.areMarkersActive()) {
            return;
        }
        JunCursors junCursors = new JunCursors(JunCursors.EpilogueCursor());
        try {
            junCursors._show();
            double d = this.lastMarker();
            double d2 = 0.02;
            if (junButtonModel._isPressedWithShiftDown()) {
                double d3 = this.doubleValue();
                if (d - d3 > 0.0) {
                    while (true) {
                        double d4;
                        d3 += d2;
                        if (d4 < d) {
                            this.value_(d3);
                            continue;
                        }
                        break;
                    }
                } else {
                    while (true) {
                        double d5;
                        d3 -= d2;
                        if (!(d5 > d)) break;
                        this.value_(d3);
                    }
                }
            }
            this.value_(d);
        }
        finally {
            junCursors._restore();
        }
    }

    public JunButtonModel firstMarkerButton() {
        if (this.firstMarkerButton == null) {
            JunButtonModel junButtonModel;
            this.firstMarkerButton = junButtonModel = new JunButtonModel(false, this.firstMarkerImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunTrackerModel.this.firstMarkerAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
        }
        return this.firstMarkerButton;
    }

    protected Image firstMarkerImage() {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        int n = Color.white.getRGB();
        bufferedImage.setRGB(9, 3, n);
        bufferedImage.setRGB(8, 4, n);
        bufferedImage.setRGB(9, 4, n);
        bufferedImage.setRGB(10, 4, n);
        bufferedImage.setRGB(7, 5, n);
        bufferedImage.setRGB(8, 5, n);
        bufferedImage.setRGB(9, 5, n);
        bufferedImage.setRGB(10, 5, n);
        bufferedImage.setRGB(7, 6, n);
        bufferedImage.setRGB(8, 6, n);
        bufferedImage.setRGB(9, 6, n);
        bufferedImage.setRGB(10, 6, n);
        bufferedImage.setRGB(6, 7, n);
        bufferedImage.setRGB(7, 7, n);
        bufferedImage.setRGB(8, 7, n);
        bufferedImage.setRGB(9, 7, n);
        bufferedImage.setRGB(10, 7, n);
        bufferedImage.setRGB(6, 8, n);
        bufferedImage.setRGB(7, 8, n);
        bufferedImage.setRGB(8, 8, n);
        bufferedImage.setRGB(9, 8, n);
        bufferedImage.setRGB(10, 8, n);
        bufferedImage.setRGB(5, 9, n);
        bufferedImage.setRGB(6, 9, n);
        bufferedImage.setRGB(7, 9, n);
        bufferedImage.setRGB(8, 9, n);
        bufferedImage.setRGB(9, 9, n);
        bufferedImage.setRGB(10, 9, n);
        bufferedImage.setRGB(5, 10, n);
        bufferedImage.setRGB(6, 10, n);
        bufferedImage.setRGB(7, 10, n);
        bufferedImage.setRGB(8, 10, n);
        bufferedImage.setRGB(9, 10, n);
        bufferedImage.setRGB(10, 10, n);
        bufferedImage.setRGB(4, 11, n);
        bufferedImage.setRGB(5, 11, n);
        bufferedImage.setRGB(6, 11, n);
        bufferedImage.setRGB(7, 11, n);
        bufferedImage.setRGB(8, 11, n);
        bufferedImage.setRGB(9, 11, n);
        bufferedImage.setRGB(10, 11, n);
        bufferedImage.setRGB(4, 12, n);
        bufferedImage.setRGB(5, 12, n);
        bufferedImage.setRGB(6, 12, n);
        bufferedImage.setRGB(7, 12, n);
        bufferedImage.setRGB(8, 12, n);
        bufferedImage.setRGB(9, 12, n);
        bufferedImage.setRGB(10, 12, n);
        bufferedImage.setRGB(5, 13, n);
        bufferedImage.setRGB(6, 13, n);
        bufferedImage.setRGB(7, 13, n);
        bufferedImage.setRGB(8, 13, n);
        bufferedImage.setRGB(9, 13, n);
        int n2 = Color.blue.getRGB();
        bufferedImage.setRGB(9, 4, n2);
        bufferedImage.setRGB(8, 5, n2);
        bufferedImage.setRGB(9, 5, n2);
        bufferedImage.setRGB(8, 6, n2);
        bufferedImage.setRGB(9, 6, n2);
        bufferedImage.setRGB(7, 7, n2);
        bufferedImage.setRGB(9, 7, n2);
        bufferedImage.setRGB(7, 8, n2);
        bufferedImage.setRGB(9, 8, n2);
        bufferedImage.setRGB(6, 9, n2);
        bufferedImage.setRGB(9, 9, n2);
        bufferedImage.setRGB(6, 10, n2);
        bufferedImage.setRGB(9, 10, n2);
        bufferedImage.setRGB(5, 11, n2);
        bufferedImage.setRGB(9, 11, n2);
        bufferedImage.setRGB(5, 12, n2);
        bufferedImage.setRGB(6, 12, n2);
        bufferedImage.setRGB(7, 12, n2);
        bufferedImage.setRGB(8, 12, n2);
        bufferedImage.setRGB(9, 12, n2);
        return bufferedImage;
    }

    protected void firstMarkerAction_(JunButtonModel junButtonModel) {
        if (!this.areMarkersActive()) {
            return;
        }
        if (this.fixFirstMarker()) {
            this.value_(this.firstMarker());
        } else {
            this.firstMarker_(this.doubleValue());
        }
    }

    public JunButtonModel lastMarkerButton() {
        if (this.lastMarkerButton == null) {
            JunButtonModel junButtonModel;
            this.lastMarkerButton = junButtonModel = new JunButtonModel(false, this.lastMarkerImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunTrackerModel.this.lastMarkerAction_((JunButtonModel)((Object)object));
                    return null;
                }
            });
        }
        return this.lastMarkerButton;
    }

    protected Image lastMarkerImage() {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        int n = Color.white.getRGB();
        bufferedImage.setRGB(6, 3, n);
        bufferedImage.setRGB(5, 4, n);
        bufferedImage.setRGB(6, 4, n);
        bufferedImage.setRGB(7, 4, n);
        bufferedImage.setRGB(5, 5, n);
        bufferedImage.setRGB(6, 5, n);
        bufferedImage.setRGB(7, 5, n);
        bufferedImage.setRGB(8, 5, n);
        bufferedImage.setRGB(5, 6, n);
        bufferedImage.setRGB(6, 6, n);
        bufferedImage.setRGB(7, 6, n);
        bufferedImage.setRGB(8, 6, n);
        bufferedImage.setRGB(5, 7, n);
        bufferedImage.setRGB(6, 7, n);
        bufferedImage.setRGB(7, 7, n);
        bufferedImage.setRGB(8, 7, n);
        bufferedImage.setRGB(9, 7, n);
        bufferedImage.setRGB(5, 8, n);
        bufferedImage.setRGB(6, 8, n);
        bufferedImage.setRGB(7, 8, n);
        bufferedImage.setRGB(8, 8, n);
        bufferedImage.setRGB(9, 8, n);
        bufferedImage.setRGB(5, 9, n);
        bufferedImage.setRGB(6, 9, n);
        bufferedImage.setRGB(7, 9, n);
        bufferedImage.setRGB(8, 9, n);
        bufferedImage.setRGB(9, 9, n);
        bufferedImage.setRGB(10, 9, n);
        bufferedImage.setRGB(5, 10, n);
        bufferedImage.setRGB(6, 10, n);
        bufferedImage.setRGB(7, 10, n);
        bufferedImage.setRGB(8, 10, n);
        bufferedImage.setRGB(9, 10, n);
        bufferedImage.setRGB(10, 10, n);
        bufferedImage.setRGB(5, 11, n);
        bufferedImage.setRGB(6, 11, n);
        bufferedImage.setRGB(7, 11, n);
        bufferedImage.setRGB(8, 11, n);
        bufferedImage.setRGB(9, 11, n);
        bufferedImage.setRGB(10, 11, n);
        bufferedImage.setRGB(11, 11, n);
        bufferedImage.setRGB(5, 12, n);
        bufferedImage.setRGB(6, 12, n);
        bufferedImage.setRGB(7, 12, n);
        bufferedImage.setRGB(8, 12, n);
        bufferedImage.setRGB(9, 12, n);
        bufferedImage.setRGB(10, 12, n);
        bufferedImage.setRGB(11, 12, n);
        bufferedImage.setRGB(6, 13, n);
        bufferedImage.setRGB(7, 13, n);
        bufferedImage.setRGB(8, 13, n);
        bufferedImage.setRGB(9, 13, n);
        bufferedImage.setRGB(10, 13, n);
        int n2 = Color.red.getRGB();
        bufferedImage.setRGB(6, 4, n2);
        bufferedImage.setRGB(6, 5, n2);
        bufferedImage.setRGB(7, 5, n2);
        bufferedImage.setRGB(6, 6, n2);
        bufferedImage.setRGB(7, 6, n2);
        bufferedImage.setRGB(6, 7, n2);
        bufferedImage.setRGB(8, 7, n2);
        bufferedImage.setRGB(6, 8, n2);
        bufferedImage.setRGB(8, 8, n2);
        bufferedImage.setRGB(6, 9, n2);
        bufferedImage.setRGB(9, 9, n2);
        bufferedImage.setRGB(6, 10, n2);
        bufferedImage.setRGB(9, 10, n2);
        bufferedImage.setRGB(6, 11, n2);
        bufferedImage.setRGB(10, 11, n2);
        bufferedImage.setRGB(6, 12, n2);
        bufferedImage.setRGB(7, 12, n2);
        bufferedImage.setRGB(8, 12, n2);
        bufferedImage.setRGB(9, 12, n2);
        bufferedImage.setRGB(10, 12, n2);
        return bufferedImage;
    }

    protected void lastMarkerAction_(JunButtonModel junButtonModel) {
        if (!this.areMarkersActive()) {
            return;
        }
        if (this.fixLastMarker()) {
            this.value_(this.lastMarker());
        } else {
            this.lastMarker_(this.doubleValue());
        }
    }

    public JunButtonWithMenuModel speakerButton() {
        if (this.speakerButton == null) {
            int n = 11;
            Object[] objectArray = new String[n];
            Object[] objectArray2 = new Float[n];
            for (int i = 0; i < n; ++i) {
                int n2 = 100 - i * 10;
                objectArray[i] = String.valueOf(n2);
                objectArray2[i] = new Float((float)n2 / 100.0f);
            }
            Image[] imageArray = new Image[]{JunCursors.Speaker10CursorImage(), JunCursors.Speaker09CursorImage(), JunCursors.Speaker08CursorImage(), JunCursors.Speaker07CursorImage(), JunCursors.Speaker06CursorImage(), JunCursors.Speaker05CursorImage(), JunCursors.Speaker04CursorImage(), JunCursors.Speaker03CursorImage(), JunCursors.Speaker02CursorImage(), JunCursors.Speaker01CursorImage(), JunCursors.Speaker00CursorImage()};
            JunButtonWithMenuModel junButtonWithMenuModel = new JunButtonWithMenuModel(objectArray, imageArray, objectArray2);
            junButtonWithMenuModel.action_(new StBlockClosure());
            junButtonWithMenuModel.repeatTick_(10);
            junButtonWithMenuModel.markerDisplaying_(false);
            this.speakerButton = junButtonWithMenuModel;
        }
        return this.speakerButton;
    }

    public boolean atStart() {
        double d = this.doubleValue() - this.step();
        if (d < 0.0) {
            return true;
        }
        return this.isIntervalNotEmpty() && this.doubleValue() >= this.firstMarker() && d < this.firstMarker();
    }

    public boolean atEnd() {
        double d = this.doubleValue() + this.step();
        if (d > 1.0) {
            return true;
        }
        return this.isIntervalNotEmpty() && this.doubleValue() <= this.lastMarker() && d > this.lastMarker();
    }

    public StView defaultView() {
        if (JunTrackerModel.GetDefaultViewMode() == 0) {
            return new JunTrackerViewAwt(this);
        }
        return new JunTrackerViewSwing(this);
    }

    protected String windowTitle() {
        return JunTrackerModel.$String((String)"Tracker");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        super.noticeOfWindowClose(windowEvent);
        this.end();
    }

    public void start() {
        this.trackingProcess = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JunTrackerModel.this.loopDirection = StObject.$((String)"forth");
                    JunTrackerModel.this.playButtonVisual_(true);
                    if (JunTrackerModel.this.atEnd()) {
                        JunTrackerModel.this.first();
                    }
                    while (JunTrackerModel.this.playButton().value()) {
                        JunTrackerModel.this.next();
                        JunTrackerModel junTrackerModel = JunTrackerModel.this;
                        junTrackerModel.trackingProcess.yield();
                    }
                }
                finally {
                    JunTrackerModel.this.playButtonVisual_(false);
                    JunTrackerModel.this.trackingProcess = null;
                }
            }
        };
        this.trackingProcess.setPriority(5);
        this.trackingProcess.start();
    }

    public void end() {
        this.playButton().value_(false);
        this.playButton().visual_(this.playImage());
    }

    public void next() {
        if (this.loopCondition() == JunTrackerModel.$((String)"oneWay")) {
            this.nextOneWay();
        } else if (this.loopCondition() == JunTrackerModel.$((String)"loop")) {
            this.nextLoop();
        } else if (this.loopCondition() == JunTrackerModel.$((String)"backAndForth")) {
            this.nextBackAndForth();
        }
    }

    protected void nextOneWay() {
        if (this.atEnd()) {
            this.end();
        } else {
            this.nextStep();
        }
    }

    protected void nextLoop() {
        if (this.atEnd()) {
            this.first();
        } else {
            this.nextStep();
        }
    }

    protected void nextBackAndForth() {
        if (this.loopDirection == JunTrackerModel.$((String)"forth")) {
            this.nextForth();
        } else {
            this.nextBack();
        }
    }

    protected void nextBack() {
        if (this.atStart()) {
            this.loopDirection = JunTrackerModel.$((String)"forth");
        } else {
            this.previousStep();
        }
    }

    protected void nextForth() {
        if (this.atEnd()) {
            this.loopDirection = JunTrackerModel.$((String)"back");
        } else {
            this.nextStep();
        }
    }

    protected void nextStep() {
        this.value_(this.doubleValue() + this.step());
    }

    public void previous() {
        if (this.loopCondition() == JunTrackerModel.$((String)"oneWay")) {
            this.previousOneWay();
        } else if (this.loopCondition() == JunTrackerModel.$((String)"loop")) {
            this.previousLoop();
        } else if (this.loopCondition() == JunTrackerModel.$((String)"backAndForth")) {
            this.previousBackAndForth();
        }
    }

    protected void previousOneWay() {
        if (this.atStart()) {
            this.first();
        } else {
            this.previousStep();
        }
    }

    protected void previousLoop() {
        if (this.atStart()) {
            this.last();
        } else {
            this.previousStep();
        }
    }

    protected void previousBackAndForth() {
        double d;
        double d2 = d = this.loopDirection == JunTrackerModel.$((String)"forth") ? this.doubleValue() - this.step() : this.doubleValue() + this.step();
        if (this.isIntervalNotEmpty() && (d < this.firstMarker() || d > this.lastMarker()) && this.firstMarker() <= this.doubleValue() && this.doubleValue() <= this.lastMarker()) {
            this.loopDirection = this.loopDirection == JunTrackerModel.$((String)"forth") ? JunTrackerModel.$((String)"back") : JunTrackerModel.$((String)"forth");
            d = this.loopDirection == JunTrackerModel.$((String)"forth") ? Math.max(this.firstMarker(), Math.min(this.doubleValue() - this.step(), this.lastMarker())) : Math.max(this.firstMarker(), Math.min(this.doubleValue() + this.step(), this.lastMarker()));
        } else if (d < 0.0 || d > 1.0) {
            this.loopDirection = this.loopDirection == JunTrackerModel.$((String)"forth") ? JunTrackerModel.$((String)"back") : JunTrackerModel.$((String)"forth");
            d = this.loopDirection == JunTrackerModel.$((String)"forth") ? Math.max(0.0, Math.min(this.doubleValue() - this.step(), 1.0)) : Math.max(0.0, Math.min(this.doubleValue() + this.step(), 1.0));
        }
        this.value_(d);
    }

    protected void previousStep() {
        this.value_(this.doubleValue() - this.step());
    }
}

