/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.track;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.track.JunSimpleSliderModel;
import jp.co.sra.jun.goodies.track.JunSimpleSliderView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunSimpleSliderController
extends JunAbstractController
implements MouseListener,
MouseMotionListener {
    protected StSymbol _tracking;
    protected Point _previousPoint;
    protected Point _offsetPoint;
    protected boolean _redisplayBoolean;
    protected Graphics _graphicsContext;

    public JunSimpleSliderModel getSimpleSliderModel() {
        return (JunSimpleSliderModel)this.model();
    }

    public JunSimpleSliderView getSimpleSliderView() {
        return (JunSimpleSliderView)this.view();
    }

    public JunSimpleSliderView getView() {
        return (JunSimpleSliderView)this.view();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._tracking == JunSimpleSliderController.$((String)"slider")) {
            this._trackSlider(mouseEvent.getPoint());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        StSymbol stSymbol = this._trackingState(mouseEvent.getPoint());
        if (stSymbol == JunSimpleSliderController.$((String)"slider")) {
            this.getComponent().setCursor(JunCursors.CrossCursor());
        } else {
            this.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown() || mouseEvent.isAltDown()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        this._tracking = this._trackingState(point);
        if (this._tracking == JunSimpleSliderController.$((String)"slider")) {
            if (this.getSimpleSliderView().sliderRectangle().containsPoint_(point)) {
                this._offsetPoint = this.getSimpleSliderView().sliderRectangle().center();
                this._offsetPoint = new Point(this._offsetPoint.x - point.x, this._offsetPoint.y - point.y);
            } else {
                this._offsetPoint = new Point(0, 0);
            }
            this._previousPoint = null;
            this._redisplayBoolean = false;
            this._trackSlider(point);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._tracking == JunSimpleSliderController.$((String)"slider") && this._redisplayBoolean) {
            this.getSimpleSliderView().displayOn_(this._graphicsContext());
        }
        this._tracking = null;
        this._offsetPoint = null;
        this._previousPoint = null;
        this._redisplayBoolean = false;
        if (this._graphicsContext != null) {
            this._graphicsContext.dispose();
            this._graphicsContext = null;
        }
    }

    protected Graphics _graphicsContext() {
        if (this._graphicsContext == null) {
            this._graphicsContext = this.getComponent().getGraphics();
        }
        return this._graphicsContext;
    }

    protected StSymbol _trackingState(Point point) {
        StSymbol stSymbol = null;
        if (this.getSimpleSliderView().sliderArea().containsPoint_(point)) {
            stSymbol = JunSimpleSliderController.$((String)"slider");
        }
        if (this.getSimpleSliderView().sliderRectangle().containsPoint_(point)) {
            stSymbol = JunSimpleSliderController.$((String)"slider");
        }
        return stSymbol;
    }

    protected void _trackSlider(Point point) {
        if (new StRectangle(this.getComponent().getSize()).expandedBy_(16, 16).containsPoint_(point)) {
            if (!point.equals(this._previousPoint)) {
                this.getSimpleSliderView().setModelValue_(point.x + this._offsetPoint.x, point.y + this._offsetPoint.y);
                this.getSimpleSliderView().displaySliderOn_(this._graphicsContext());
                this._previousPoint = point;
            }
            this._redisplayBoolean = true;
        }
    }

    protected void buildListener(StView stView) {
        Component component = (Component)stView;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    protected Component getComponent() {
        return (Component)this.view();
    }
}

