/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.stopwatch;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel;
import jp.co.sra.jun.goodies.stopwatch.JunStopwatchViewAwt;
import jp.co.sra.jun.goodies.stopwatch.JunStopwatchViewSwing;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StOpaqueImage;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunStopwatch
extends JunLevelGaugeModel
implements ClipboardOwner {
    protected JunButtonModel resetButton;
    protected JunButtonModel toggleButton;
    protected Timer clockProcess;
    protected KeyListener _keyListener;
    protected transient StPopupMenu _popupMenu;

    protected void initialize() {
        super.initialize();
        this.resetButton = null;
        this.toggleButton = null;
        this.clockProcess = null;
        this._keyListener = null;
        this._popupMenu = null;
    }

    public void release() {
        super.release();
        this.terminateClockProcess();
    }

    public void start() {
        if (!this.toggleButton().value()) {
            this.toggleButtonAction();
        }
    }

    public void stop() {
        if (this.toggleButton().value()) {
            this.toggleButtonAction();
        }
    }

    public void zero() {
        this.resetButtonAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunButtonModel resetButton() {
        if (this.resetButton == null) {
            JunButtonModel junButtonModel;
            StImage stImage;
            StComposedText stComposedText = new StComposedText("0");
            StImage stImage2 = new StImage(stComposedText.width() + 2, stComposedText.height() + 2);
            Graphics graphics = stImage2.asImage().image().getGraphics();
            try {
                graphics.setColor(Color.black);
                stComposedText.displayOn_at_(graphics, new Point(1, 1));
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
            StImage stImage3 = stImage2.asImage().convertToPalette_(new IndexColorModel(1, 2, new byte[]{-1, 0}, new byte[]{-1, 0}, new byte[]{-1, 0}));
            stImage2 = new StImage(stComposedText.width() + 2, stComposedText.height() + 2);
            graphics = stImage2.asImage().image().getGraphics();
            try {
                graphics.setColor(Color.black);
                stImage = new StImage[]{new Point(0, 1), new Point(0, -1), new Point(1, 0), new Point(-1, 0)};
                for (int i = 0; i < ((Point[])stImage).length; ++i) {
                    stComposedText.displayOn_at_(graphics, new Point(1 + stImage[i].x, 1 + stImage[i].y));
                }
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
            stImage = new StImage(stImage2.asImage().width(), stImage2.asImage().height(), (ColorModel)StImage.MonoMaskColorModel());
            stImage.copy_from_in_rule_(new Rectangle(0, 0, stImage2.asImage().width(), stImage2.asImage().height()), new Point(0, 0), stImage2.asImage(), 3);
            stImage2 = new StOpaqueImage(stImage3, stImage);
            this.resetButton = junButtonModel = new JunButtonModel(false, stImage2, new StBlockClosure(){

                public Object value_(Object object) {
                    JunStopwatch.this.resetButtonAction();
                    return null;
                }
            });
        }
        return this.resetButton;
    }

    public void resetButtonAction() {
        this.resetButton().value_(false);
        if (this.toggleButton().value()) {
            this.toggleButton().value_(false);
            this.terminateClockProcess();
        }
        this.initial_(this.nextMillisecondClockValue());
    }

    public JunButtonModel toggleButton() {
        if (this.toggleButton == null) {
            JunButtonModel junButtonModel;
            BufferedImage bufferedImage = JunCursors.StopwatchCursorImage();
            this.toggleButton = junButtonModel = new JunButtonModel(false, bufferedImage, new StBlockClosure(){

                public Object value_(Object object) {
                    JunStopwatch.this.toggleButtonAction();
                    return null;
                }
            });
        }
        return this.toggleButton;
    }

    public void toggleButtonAction() {
        this.toggleButton().value_(!this.toggleButton().value());
        if (this.toggleButton().value()) {
            this.resumeClockProcess();
        } else {
            this.terminateClockProcess();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void reset() {
        super.reset();
        this.value = 0.0;
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        this.release();
        super.noticeOfWindowClose(windowEvent);
    }

    public StView defaultView() {
        if (JunStopwatch.GetDefaultViewMode() == 0) {
            return new JunStopwatchViewAwt(this);
        }
        return new JunStopwatchViewSwing(this);
    }

    protected String windowTitle() {
        return JunStopwatch.$String((String)"Stopwatch");
    }

    public KeyListener _keyListener() {
        if (this._keyListener == null) {
            this._keyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (JunStopwatch.this._keyboardEvent_(keyEvent)) {
                        keyEvent.consume();
                    }
                }
            };
        }
        return this._keyListener;
    }

    protected boolean _keyboardEvent_(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 32: {
                this.toggleButtonAction();
                return true;
            }
            case 10: {
                this.resetButtonAction();
                return true;
            }
            case 83: {
                this.toggleButtonAction();
                return true;
            }
            case 82: {
                this.resetButtonAction();
                return true;
            }
            case 49: {
                this.toggleButtonAction();
                return true;
            }
            case 48: {
                this.resetButtonAction();
                return true;
            }
            case 97: {
                this.toggleButtonAction();
                return true;
            }
            case 96: {
                this.resetButtonAction();
                return true;
            }
        }
        return false;
    }

    public void copyValue() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.displayString());
        clipboard.setContents(stringSelection, this);
    }

    public Color backgroundColor() {
        Color color = (Color)this.attributes().at_(JunStopwatch.$((String)"backgroundColor"));
        if (color == null) {
            color = StColorValue.Brightness_((double)1.0);
            this.attributes().at_put_(JunStopwatch.$((String)"backgroundColor"), color);
        }
        return color;
    }

    public int tickTime() {
        Integer n = (Integer)this.attributes().at_(JunStopwatch.$((String)"tickTime"));
        if (n == null) {
            n = new Integer(10);
            this.attributes().at_put_(JunStopwatch.$((String)"tickTime"), n);
        }
        return n;
    }

    public void tickTime_(int n) {
        this.attributes().at_put_(JunStopwatch.$((String)"tickTime"), new Integer(Math.max(n, 10)));
    }

    public Color valueColor() {
        Color color = (Color)this.attributes().at_(JunStopwatch.$((String)"valueColor"));
        if (color == null) {
            color = Color.black;
            this.attributes().at_put_(JunStopwatch.$((String)"valueColor"), color);
        }
        return color;
    }

    public int valueSize() {
        Number number = (Number)this.attributes().at_(JunStopwatch.$((String)"valueSize"));
        if (number == null) {
            number = new Integer(16);
            this.attributes().at_put_(JunStopwatch.$((String)"valueSize"), number);
        }
        return number.intValue();
    }

    public void valueSize_(int n) {
        this.attributes().at_put_(JunStopwatch.$((String)"valueSize"), new Integer(Math.max(4, Math.min(n, 72))));
    }

    public int valueStyle() {
        Number number = (Number)this.attributes().at_(JunStopwatch.$((String)"valueStyle"));
        if (number == null) {
            number = new Integer(1);
            this.attributes().at_put_(JunStopwatch.$((String)"valueStyle"), number);
        }
        return number.intValue();
    }

    public void valueStyle_(int n) {
        this.attributes().at_put_(JunStopwatch.$((String)"valueStyle"), new Integer(n));
    }

    public String displayString() {
        long l = this._longValue();
        int n = (int)(l % 1000L / 10L);
        int n2 = (int)(l / 1000L % 60L);
        int n3 = (int)(l / 60000L % 60L);
        int n4 = (int)(l / 3600000L);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n4);
        stringBuffer.append(":");
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        stringBuffer.append(":");
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append(".");
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(this.displayString());
    }

    public long nextMillisecondClockValue() {
        return JunControlUtility.NextMillisecondClockValue_(this.tickTime());
    }

    protected synchronized void resumeClockProcess() {
        if (this.clockProcess != null) {
            this.clockProcess.cancel();
        }
        final JunStopwatch junStopwatch = this;
        this.clockProcess = new Timer();
        junStopwatch.resume_(this.nextMillisecondClockValue());
        this.clockProcess.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                junStopwatch.value_(junStopwatch._doubleValue() + junStopwatch.offset() + (double)junStopwatch.tickTime());
            }
        }, 0L, (long)this.tickTime());
    }

    protected synchronized void terminateClockProcess() {
        if (this.clockProcess != null) {
            this.clockProcess.cancel();
        }
        this.clockProcess = null;
    }

    public StPopupMenu _popupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new StPopupMenu();
            this._popupMenu.add(new StMenuItem((Object)JunStopwatch.$String((String)"Copy"), JunStopwatch.$((String)"copyValue"), (MenuListener)new MenuPerformer((StObject)this, "copyValue")));
        }
        return this._popupMenu;
    }
}

