/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.sound;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.co.sra.jun.goodies.sound.JunSoundMeterModel;
import jp.co.sra.jun.goodies.sound.JunSoundWaveMeterView;
import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;

public class JunSoundWaveMeterViewAwt
extends JunAbstractViewCanvas
implements JunSoundWaveMeterView {
    protected int[][] cacheTable;
    protected int previousPosition = 0;

    public JunSoundWaveMeterViewAwt(JunSoundMeterModel junSoundMeterModel) {
        super(junSoundMeterModel);
    }

    public JunSoundMeterModel getSoundMeterModel() {
        return (JunSoundMeterModel)this.model();
    }

    public int[][] cacheTable() {
        if (this.cacheTable == null) {
            this.cacheTable = this.makeCacheTable();
        }
        return this.cacheTable;
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.flushCacheTable();
        Dimension dimension = this.getSize();
        this.displayOn_from_to_(graphics, 0, dimension.width);
    }

    public void displayOn_currentPosition_(Graphics graphics, Double d) {
        Dimension dimension = this.getSize();
        int n = (int)(d * (double)dimension.width);
        this.displayOn_from_to_(graphics, Math.max(this.previousPosition - 1, 0), Math.min(this.previousPosition + 1, dimension.width));
        graphics.setColor(Color.gray);
        graphics.fillRect(n, 0, 1, dimension.height);
        int[][] nArray = this.cacheTable();
        double[] dArray = this.getSoundMeterModel().soundLevelDataAt_(d);
        if (dArray != null) {
            int n2 = (int)(dArray[0] * (double)dimension.height);
            int n3 = (int)(dArray[1] * (double)dimension.height);
            this.cacheTable_at_low_high_(nArray, n, n2, n3);
        }
        this.previousPosition = n;
    }

    public void displayOn_from_to_(Graphics graphics, int n, int n2) {
        int[][] nArray = this.cacheTable();
        Dimension dimension = this.getSize();
        for (int i = n; i < n2; ++i) {
            if (nArray[i] == null) {
                graphics.setColor(Color.white);
                graphics.fillRect(i, 0, 1, dimension.height);
                continue;
            }
            int n3 = nArray[i][0];
            int n4 = nArray[i][1];
            graphics.setColor(Color.white);
            graphics.fillRect(i, 0, 1, n3);
            graphics.fillRect(i, n4, 1, dimension.height - n4);
            float f = 0.75f - (float)(n4 - n3) / (float)dimension.height / 2.0f;
            graphics.setColor(new Color(f, f, f));
            graphics.fillRect(i, n3, 1, Math.max(n4 - n3, 1));
        }
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunSoundWaveMeterViewAwt.$((String)"wave")) {
            Graphics graphics;
            Object object = dependentEvent.getParameter();
            if (object instanceof Double && (graphics = this.getGraphics()) != null) {
                this.displayOn_currentPosition_(graphics, (Double)object);
            }
        } else {
            if (stSymbol == JunSoundWaveMeterViewAwt.$((String)"level")) {
                return;
            }
            super.update_(dependentEvent);
        }
    }

    public void flushCacheTable() {
        this.cacheTable = null;
    }

    public void cacheTable_at_low_high_(int[][] nArray, int n, int n2, int n3) {
        nArray[n] = new int[]{n2, n3};
    }

    public int[][] makeCacheTable() {
        Dimension dimension = this.getSize();
        int[][] nArrayArray = new int[dimension.width + 1][];
        Hashtable hashtable = this.getSoundMeterModel().soundLevelData();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            double[] dArray = this.getSoundMeterModel().soundLevelDataAt_(k);
            if (!(k instanceof Double) || dArray == null) continue;
            int n = (int)((Double)k * (double)dimension.width);
            int n2 = (int)(dArray[0] * (double)dimension.height);
            int n3 = (int)(dArray[1] * (double)dimension.height);
            this.cacheTable_at_low_high_(nArrayArray, n, n2, n3);
        }
        return nArrayArray;
    }
}

