/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.prolog;

import jp.co.sra.jun.goodies.prolog.JunPrologObject;
import jp.co.sra.jun.goodies.prolog.JunPrologScannerTable;
import jp.co.sra.jun.goodies.prolog.JunPrologString;
import jp.co.sra.jun.goodies.prolog.JunPrologSymbol;
import jp.co.sra.jun.goodies.prolog.JunPrologVariable;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StNumber;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StSymbol;

public class JunPrologScanner
extends JunAbstractObject {
    protected static final char CR = '\r';
    protected static final char LF = '\n';
    protected static final char EndChar = '^';
    protected StReadStream source;
    protected int mark;
    protected Object token;
    protected StSymbol tokenType;
    protected StSymbol[] typeTable;
    protected char endChar;
    protected StBlockClosure failBlock;

    public JunPrologScanner() {
        this.initScanner();
    }

    public static String ContractTo(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = n / 2 - 1;
        return string.substring(0, n3) + "..." + string.substring(n2 - n + n3 + 3);
    }

    public void xBinary() {
        this.failBlock.value_((Object)("Syntax error" + this.source.peek()));
    }

    public void xColon() {
        this.source.next();
        char c = this.source.peek();
        if (c == '-') {
            this.tokenType = JunPrologScanner.$((String)"neck");
            this.singleChar_(this.tokenType);
        } else {
            this.unNextToken();
            this.tokenType = JunPrologScanner.$((String)"symbol");
            this.token = JunPrologSymbol.ReadFrom_(this.source);
        }
    }

    public void xComment() {
        char c;
        while ((c = this.nextChar()) != '\r') {
            if (c != this.endChar) continue;
            this.tokenType = JunPrologScanner.$((String)"eof");
            return;
        }
        this.nextToken();
    }

    public void xDigit() {
        this.tokenType = JunPrologScanner.$((String)"number");
        this.token = StNumber.ReadFrom_((StReadStream)this.source);
    }

    public void xDollar() {
        throw new SmalltalkException("Should not be called.  It is a symbol.");
    }

    public void xDoubleQuote() {
        this.tokenType = JunPrologScanner.$((String)"string");
        this.token = JunPrologString.ReadFrom_(this.source);
    }

    public void xSign() {
        char c = this.nextChar();
        char c2 = this.peekChar();
        if (Character.isDigit(c2)) {
            this.tokenType = JunPrologScanner.$((String)"number");
            this.token = StNumber.ReadFrom_((StReadStream)this.source);
            if (c == '-') {
                this.token = StNumber._Negate((Number)((Number)this.token));
            }
        } else {
            this.unNextChar();
            this.tokenType = JunPrologScanner.$((String)"symbol");
            this.token = JunPrologSymbol.ReadFrom_(this.source);
        }
    }

    public void xSingleQuote() {
        this.tokenType = JunPrologScanner.$((String)"symbol");
        this.token = JunPrologSymbol.ReadFrom_(this.source);
    }

    public void xSymbol() {
        this.tokenType = JunPrologScanner.$((String)"symbol");
        this.token = JunPrologSymbol.ReadFrom_(this.source);
    }

    public void xVariable() {
        this.tokenType = JunPrologScanner.$((String)"variable");
        this.token = JunPrologVariable.ReadFrom_(this.source);
    }

    protected void initScanner() {
        this.typeTable = JunPrologScannerTable.ScannerTable();
        this.endChar = (char)94;
        this.failBlock = new StBlockClosure(){

            public Object value_(Object object) {
                String string = (String)object;
                String string2 = string + " near " + JunPrologScanner.ContractTo(JunPrologScanner.this.token.toString(), 10);
                String string3 = JunPrologScanner.this.source.upToEnd();
                string3 = string3.length() == 0 ? "--> end of file" : "--> " + JunPrologScanner.ContractTo(string3, 30);
                throw SmalltalkException.Error((String)(string2 + "\n" + string3));
            }
        };
    }

    protected void multiChar_(StSymbol stSymbol) {
        try {
            this.perform_(stSymbol.toString());
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
    }

    protected char nextChar() {
        char c = this.source.next();
        if (c == '\n') {
            return '\r';
        }
        if (c == '\r') {
            if (this.source.peek() == '\n') {
                this.source.next();
            }
            return '\r';
        }
        if (c == '\u0000') {
            return this.endChar;
        }
        return c;
    }

    protected Object nextToken() {
        this.mark = this.source.position();
        char c = this.peekChar();
        this.tokenType = this.typeTable[c];
        while (this.tokenType == JunPrologScanner.$((String)"xDelimiter")) {
            this.nextChar();
            c = this.peekChar();
            this.tokenType = this.typeTable[c];
        }
        if (this.tokenType.toString().charAt(0) == 'x') {
            this.multiChar_(this.tokenType);
        } else {
            this.singleChar_(this.tokenType);
        }
        return this.token;
    }

    protected void on_(StReadStream stReadStream) {
        this.source = stReadStream;
        this.mark = this.source.position();
    }

    protected char peekChar() {
        char c = this.source.peek();
        if (c == '\n') {
            return '\r';
        }
        if (c == '\r') {
            return '\r';
        }
        if (c == '\u0000') {
            return this.endChar;
        }
        return c;
    }

    protected void singleChar_(StSymbol stSymbol) {
        this.nextChar();
        this.token = stSymbol;
        if (this.tokenType != JunPrologScanner.$((String)"leftBrace")) {
            return;
        }
        this.tokenType = JunPrologScanner.$((String)"object");
        this.token = JunPrologObject.ReadFrom_(this.source);
    }

    protected void unNextChar() {
        this.source.skip_(-1);
    }

    protected void unNextToken() {
        this.source.position_(this.mark);
    }
}

