/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.plotter;

import java.awt.Color;
import java.awt.Frame;
import java.awt.List;
import java.lang.reflect.Method;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.pen.JunPen;
import jp.co.sra.jun.goodies.pen.JunPenDirection;
import jp.co.sra.jun.goodies.pen.JunPenLocation;
import jp.co.sra.jun.goodies.plotter.JunPlotterController;
import jp.co.sra.jun.goodies.plotter.JunPlotterViewAwt;
import jp.co.sra.jun.goodies.plotter.JunPlotterViewSwing;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunPlotter
extends JunApplicationModel {
    protected Vector drawings;
    protected StPopupMenu _popupMenu;

    public void drawingsDo_(StBlockClosure stBlockClosure) {
        Object[] objectArray = this.drawings.toArray(new Object[this.drawings.size()]);
        for (int i = 0; i < objectArray.length; ++i) {
            stBlockClosure.value_(objectArray[i]);
        }
    }

    public String[] programSelectors() {
        String[] stringArray = new String[]{"curveOfSinAndCos1", "curveOfSinAndCos2", "penExample", "sample1_triangles", "sample2_star", "sample3_dragon", "sample4_mandala", "sample5_spirals", "sample6_spirals", "sample7_polylines", "sample8_fill", "sample9_spirals", "sampleA_combination"};
        return stringArray;
    }

    public JunPlotterController plotterController() {
        return (JunPlotterController)this.getController();
    }

    public void flushMenus() {
        this._popupMenu = null;
    }

    protected void initialize() {
        super.initialize();
        this.drawings = new Vector();
        this._popupMenu = null;
    }

    public StView defaultView() {
        if (JunPlotter.GetDefaultViewMode() == 0) {
            return new JunPlotterViewAwt(this);
        }
        return new JunPlotterViewSwing(this);
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Pen Plotter");
    }

    public StPopupMenu _popupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new StPopupMenu();
            this._popupMenu.add(new StMenuItem((Object)JunPlotter.$String((String)"Clear"), (MenuListener)new MenuPerformer((StObject)this, "clearPaper")));
            this._popupMenu.add((StMenuItem)this._createExecuteMenu());
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunPlotter.$String((String)"Zoom in"), (MenuListener)new MenuPerformer((StObject)this, "zoomIn")));
            this._popupMenu.add(new StMenuItem((Object)JunPlotter.$String((String)"Zoom out"), (MenuListener)new MenuPerformer((StObject)this, "zoomOut")));
            this._popupMenu.add(new StMenuItem((Object)JunPlotter.$String((String)"Reset"), (MenuListener)new MenuPerformer((StObject)this, "resetView")));
        }
        return this._popupMenu;
    }

    public StMenu _createExecuteMenu() {
        String[] stringArray = this.programSelectors();
        if (stringArray == null) {
            return null;
        }
        StMenu stMenu = new StMenu((Object)(JunPlotter.$String((String)"Execute") + "..."));
        for (int i = 0; i < stringArray.length; ++i) {
            stMenu.add(new StMenuItem((Object)stringArray[i], (MenuListener)new MenuPerformer((StObject)this, stringArray[i])));
        }
        return stMenu;
    }

    public void browsePrograms() {
        int n;
        Method[] methodArray = ((Object)((Object)this)).getClass().getDeclaredMethods();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < methodArray.length; ++i) {
            for (n = 0; n < this.programSelectors().length; ++n) {
                if (!methodArray[i].getName().equals(this.programSelectors()[n])) continue;
                vector.add(methodArray[i].getName());
            }
        }
        List list = new List(vector.size(), true);
        n = 0;
        int n2 = 0;
        StComposedText stComposedText = null;
        for (int i = 0; i < vector.size(); ++i) {
            list.add((String)vector.get(i));
            stComposedText = new StComposedText((String)vector.get(i));
            if (n < stComposedText.width()) {
                n = stComposedText.width();
            }
            n2 += stComposedText.height();
        }
        Frame frame = new Frame();
        frame.add(list);
        frame.setSize(n, n2);
        frame.setVisible(true);
    }

    public void clearPaper() {
        this.drawings = new Vector();
        this.changed_(JunPlotter.$((String)"clear"));
    }

    public void resetView() {
        this.plotterController().resetView();
    }

    public void zoomIn() {
        this.plotterController().zoomIn();
    }

    public void zoomOut() {
        this.plotterController().zoomOut();
    }

    public void curveOfSinAndCos1() {
        this.clearPaper();
        final JunPen junPen = this.newPen(Color.red);
        final JunPen junPen2 = this.newPen(Color.blue);
        final Jun2dPoint jun2dPoint = new Jun2dPoint(30.0, 30.0);
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                final JunPen junPen = (JunPen)((Object)object);
                final StSymbol stSymbol = (StSymbol)object2;
                junPen.up();
                for (int i = -300; i <= 300; i += 6) {
                    final Double d = new Double((double)i / 100.0);
                    JunPlotter.this.do_forMilliseconds_(new StBlockClosure(){

                        public Object value() {
                            double d3;
                            double d2 = d3 = d * Math.PI;
                            if (stSymbol == 1.$((String)"sin")) {
                                d2 = Math.sin(d2);
                            } else if (stSymbol == 1.$((String)"cos")) {
                                d2 = Math.cos(d2);
                            }
                            Jun2dPoint jun2dPoint = new Jun2dPoint(d3, d2);
                            jun2dPoint = jun2dPoint.scaledBy_(jun2dPoint);
                            junPen.goto_((Object)jun2dPoint);
                            if (junPen.isUp()) {
                                junPen.down();
                            }
                            return null;
                        }
                    }, 100);
                }
                return null;
            }
        };
        Thread thread = new Thread(){

            public void run() {
                stBlockClosure.value_value_((Object)junPen, (Object)StObject.$((String)"sin"));
            }
        };
        thread.setPriority(4);
        thread.start();
        Thread thread2 = new Thread(){

            public void run() {
                stBlockClosure.value_value_((Object)junPen2, (Object)StObject.$((String)"cos"));
            }
        };
        thread2.setPriority(4);
        thread2.start();
    }

    public void curveOfSinAndCos2() {
        this.curveOfSinAndCos1();
        final JunPen junPen = this.newPen(Color.gray);
        final Jun2dPoint jun2dPoint = new Jun2dPoint(30.0, 30.0);
        Thread thread = new Thread(){

            public void run() {
                junPen.location_((Object)new Jun2dPoint(Math.PI * -3, 0.0).scaledBy_(jun2dPoint));
                junPen.goto_((Object)new Jun2dPoint(Math.PI * 3, 0.0).scaledBy_(jun2dPoint));
            }
        };
        thread.setPriority(4);
        thread.start();
        Thread thread2 = new Thread(){

            public void run() {
                junPen.location_((Object)new Jun2dPoint(0.0, -1.0).scaledBy_(jun2dPoint));
                junPen.goto_((Object)new Jun2dPoint(0.0, 1.0).scaledBy_(jun2dPoint));
            }
        };
        thread2.setPriority(4);
        thread2.start();
    }

    public void penExample() {
        this.clearPaper();
        final JunPen junPen = this.newPen();
        junPen.nib_(4);
        junPen.color_(Color.gray);
        for (int i = 1; i <= 50; ++i) {
            final Integer n = new Integer(i);
            this.do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    junPen.go_(n * 4);
                    junPen.turn_(89.0);
                    return null;
                }
            }, 100);
        }
    }

    public void sample1_triangles() {
        this.clearPaper();
        final JunPen junPen = this.newPen();
        junPen.color_(Color.red);
        int n = 45;
        for (int i = 0; i < 360; i += n) {
            for (int j = 0; j < 3; ++j) {
                this.do_forMilliseconds_(new StBlockClosure(){

                    public Object value() {
                        junPen.go_(100.0);
                        junPen.turn_(120.0);
                        return null;
                    }
                }, 100);
            }
            junPen.turn_(n);
        }
    }

    public void sample2_star() {
        this.clearPaper();
        JunPen junPen = this.newPen();
        junPen.nib_(3);
        junPen.color_(Color.red);
        junPen.spiral_angle_tick_(200, 144, 10L);
    }

    public void sample3_dragon() {
        this.clearPaper();
        JunPen junPen = this.newPen();
        junPen.color_(Color.red);
        junPen.dragon_distance_tick_(9, 5, 3L);
    }

    public void sample4_mandala() {
        this.clearPaper();
        JunPen junPen = this.newPen();
        junPen.color_(Color.red);
        junPen.mandala_diameter_tick_(24, 250, 25L);
    }

    public void sample5_spirals() {
        this.clearPaper();
        JunPen[] junPenArray = new JunPen[]{this.newPen(Color.red), this.newPen(Color.red), this.newPen(Color.red), this.newPen(Color.red), this.newPen(Color.red)};
        junPenArray[0].location_((Object)new Jun2dPoint(-75.0, -75.0));
        junPenArray[1].location_((Object)new Jun2dPoint(75.0, -75.0));
        junPenArray[2].location_((Object)new Jun2dPoint(75.0, 75.0));
        junPenArray[3].location_((Object)new Jun2dPoint(-75.0, 75.0));
        junPenArray[4].location_((Object)new Jun2dPoint(0.0, 0.0));
        for (int i = 0; i < junPenArray.length; ++i) {
            junPenArray[i].spiral_angle_tick_(100, 88, 10L);
        }
    }

    public void sample6_spirals() {
        this.clearPaper();
        JunPen[] junPenArray = new JunPen[]{this.newPen(Color.red), this.newPen(Color.red), this.newPen(Color.red), this.newPen(Color.red), this.newPen(Color.red)};
        junPenArray[0].location_((Object)new Jun2dPoint(-75.0, -75.0));
        junPenArray[1].location_((Object)new Jun2dPoint(75.0, -75.0));
        junPenArray[2].location_((Object)new Jun2dPoint(75.0, 75.0));
        junPenArray[3].location_((Object)new Jun2dPoint(-75.0, 75.0));
        junPenArray[4].location_((Object)new Jun2dPoint(0.0, 0.0));
        for (int i = 0; i < junPenArray.length; ++i) {
            final JunPen junPen = junPenArray[i];
            Thread thread = new Thread(){

                public void run() {
                    junPen.spiral_angle_tick_(100, 88, 10L);
                }
            };
            thread.setPriority(4);
            thread.start();
        }
    }

    public void sample7_polylines() {
        int n;
        this.clearPaper();
        JunPen junPen = this.newPen();
        junPen.nib_(3);
        junPen.location_((Object)JunPenLocation.FromArray_(new double[]{-50.0, -50.0, -50.0}));
        junPen.direction_((Object)JunPenDirection.Zero());
        junPen.color_(Color.blue);
        for (n = 0; n < 4; ++n) {
            junPen.go_(100.0);
            junPen.turn_(90.0);
        }
        junPen.location_((Object)JunPenLocation.FromArray_(new double[]{50.0, -50.0, -50.0}));
        junPen.direction_((Object)JunPenDirection.Longitude_(90.0));
        junPen.color_(Color.blue);
        for (n = 0; n < 4; ++n) {
            junPen.go_(100.0);
            junPen.tilt_(90.0);
        }
        junPen.location_((Object)JunPenLocation.FromArray_(new double[]{-50.0, 50.0, -50.0}));
        junPen.direction_((Object)JunPenDirection.Zero());
        junPen.color_(Color.blue);
        for (n = 0; n < 4; ++n) {
            junPen.go_(100.0);
            junPen.tilt_(90.0);
        }
    }

    public void sample8_fill() {
        this.clearPaper();
        final JunPen junPen = this.newPen();
        junPen.nib_(3);
        junPen.location_((Object)JunPenLocation.FromArray_(new double[]{-50.0, -50.0, -50.0}));
        junPen.direction_((Object)JunPenDirection.Zero());
        junPen.color_(Color.red);
        junPen.fill_(new StBlockClosure(){

            public Object value() {
                for (int i = 0; i < 4; ++i) {
                    junPen.go_(100.0);
                    junPen.turn_(90.0);
                }
                return null;
            }
        });
        junPen.location_((Object)JunPenLocation.FromArray_(new double[]{50.0, -50.0, -50.0}));
        junPen.direction_((Object)JunPenDirection.Longitude_(90.0));
        junPen.color_(Color.blue);
        junPen.fill_(new StBlockClosure(){

            public Object value() {
                for (int i = 0; i < 4; ++i) {
                    junPen.go_(100.0);
                    junPen.tilt_(90.0);
                }
                return null;
            }
        });
        junPen.location_((Object)JunPenLocation.FromArray_(new double[]{-50.0, 50.0, -50.0}));
        junPen.direction_((Object)JunPenDirection.Zero());
        junPen.color_(Color.green);
        junPen.fill_(new StBlockClosure(){

            public Object value() {
                for (int i = 0; i < 4; ++i) {
                    junPen.go_(100.0);
                    junPen.tilt_(90.0);
                }
                return null;
            }
        });
    }

    public void sample9_spirals() {
        this.clearPaper();
        final JunPen junPen = this.newPen();
        junPen.nib_(1);
        junPen.color_(Color.blue);
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                final double d = ((Number)object).doubleValue();
                junPen.home();
                for (int i = 1; i <= 50; ++i) {
                    final Integer n = new Integer(i);
                    JunPlotter.this.do_forMilliseconds_(new StBlockClosure(){

                        public Object value() {
                            JunPenLocation junPenLocation = junPen.location();
                            junPen.up();
                            junPen.go_(n.doubleValue() * 4.0 * d);
                            junPen.goto_((Object)junPen.location().plus_((Object)JunPenLocation.X_y_z_(0.0, 2.0 * d, 0.0)));
                            JunPenLocation junPenLocation2 = junPen.location();
                            junPen.location_((Object)junPenLocation);
                            junPen.down();
                            junPen.goto_((Object)junPenLocation2);
                            junPen.tilt_(89.0);
                            return null;
                        }
                    }, 100);
                }
                return null;
            }
        };
        stBlockClosure.value_((Object)new Double(1.0));
        stBlockClosure.value_((Object)new Double(-1.0));
    }

    public void sampleA_combination() {
        Thread thread = new Thread(){

            public void run() {
                JunPlotter.this.sample4_mandala();
            }
        };
        thread.setPriority(4);
        thread.start();
        Thread thread2 = new Thread(){

            public void run() {
                JunPlotter.this.sample9_spirals();
            }
        };
        thread2.setPriority(4);
        thread2.start();
    }

    protected JunPen newPen() {
        JunPen junPen = new JunPen();
        junPen.compute_(new StBlockClosure(){

            public Object value_(Object object) {
                JunPlotter.this.drawings.add(object);
                JunPlotter.this.changed_with_(15.$((String)"draw"), object);
                return null;
            }
        });
        return junPen;
    }

    protected JunPen newPen(Color color) {
        JunPen junPen = this.newPen();
        junPen.color_(color);
        return junPen;
    }
}

