/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.pen;

import jp.co.sra.jun.goodies.pen.JunPenGeometry;

public class JunPenAngle
extends JunPenGeometry {
    private double deg = 0.0;
    private double rad = Double.NaN;
    private double sin = Double.NaN;
    private double cos = Double.NaN;
    private double tan = Double.NaN;

    public JunPenAngle() {
        this.rad = Double.NaN;
        this.sin = Double.NaN;
        this.cos = Double.NaN;
        this.tan = Double.NaN;
    }

    public static JunPenAngle Coerce_(Object object) {
        if (object.getClass() == JunPenAngle.class) {
            return (JunPenAngle)((Object)object);
        }
        return JunPenAngle.FromDeg_((Double)object);
    }

    public static JunPenAngle FromDeg_(double d) {
        JunPenAngle junPenAngle = new JunPenAngle();
        junPenAngle.deg_(d);
        return junPenAngle;
    }

    public static JunPenAngle FromRad_(double d) {
        JunPenAngle junPenAngle = new JunPenAngle();
        junPenAngle.rad_(d);
        return junPenAngle;
    }

    public static JunPenAngle Pi() {
        return JunPenAngle.FromRad_(Math.PI);
    }

    public static JunPenAngle Unity() {
        return JunPenAngle.FromDeg_(1.0);
    }

    public static JunPenAngle Zero() {
        return JunPenAngle.FromDeg_(0.0);
    }

    public JunPenAngle abs() {
        return JunPenAngle.FromDeg_(Math.abs(this.deg()));
    }

    public double cos() {
        double d = this.cos;
        if (Double.isNaN(d)) {
            this.cos = d = Math.cos(this.rad());
        }
        return d;
    }

    public double deg() {
        return this.deg;
    }

    public void deg_(double d) {
        this.setDeg_(d);
    }

    public boolean isGreaterThan_(Object object) {
        JunPenAngle junPenAngle = JunPenAngle.Coerce_(object);
        return this.deg() > junPenAngle.deg();
    }

    public double rad() {
        double d = this.rad;
        if (Double.isNaN(d)) {
            this.rad = d = Math.PI * this.deg / 180.0;
        }
        return d;
    }

    public void rad_(double d) {
        this.setDeg_(d * 180.0 / Math.PI);
    }

    public double sin() {
        double d = this.sin;
        if (Double.isNaN(d)) {
            this.sin = d = Math.sin(this.rad());
        }
        return d;
    }

    public double tan() {
        double d = this.tan;
        if (Double.isNaN(d)) {
            this.tan = d = Math.tan(this.rad());
        }
        return d;
    }

    private void setDeg_(double d) {
        this.deg = d;
        this.rad = Double.NaN;
        this.sin = Double.NaN;
        this.cos = Double.NaN;
        this.tan = Double.NaN;
    }
}

