/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.pen;

import java.awt.Color;
import java.util.Vector;
import jp.co.sra.jun.goodies.pen.JunPenAngle;
import jp.co.sra.jun.goodies.pen.JunPenDirection;
import jp.co.sra.jun.goodies.pen.JunPenGeometry;
import jp.co.sra.jun.goodies.pen.JunPenLocation;
import jp.co.sra.jun.goodies.pen.JunPenTransformation;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StAssociation;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;

public class JunPen
extends JunAbstractObject {
    protected JunPenLocation location;
    protected JunPenDirection direction;
    protected boolean down;
    protected int nib;
    protected Color color;
    protected Vector sequence;
    protected StValueHolder drawing;

    protected void initialize() {
        super.initialize();
        this.location = JunPenLocation.Zero();
        this.direction = JunPenDirection.Longitude_latitude_(0.0, 0.0);
        this.down = true;
        this.nib = 1;
        this.color = Color.black;
        this.drawing = new StValueHolder(new Vector());
    }

    public Color color() {
        return this.color;
    }

    public void color_(Color color) {
        this.color = color;
    }

    public JunPenDirection direction() {
        return this.direction;
    }

    public void direction_(double[] dArray) {
        this.direction = JunPenDirection.Coerce_(dArray);
    }

    public void direction_(double d) {
        this.direction = JunPenDirection.Coerce_(d);
    }

    public void direction_(Object object) {
        this.direction = JunPenDirection.Coerce_(object);
    }

    public JunPenLocation location() {
        return this.location;
    }

    public void location_(double[] dArray) {
        this.location = JunPenLocation.Coerce_(dArray);
    }

    public void location_(double d) {
        this.location = JunPenLocation.Coerce_(d);
    }

    public void location_(Object object) {
        this.location = JunPenLocation.Coerce_(object);
    }

    public int nib() {
        return this.nib;
    }

    public void nib_(int n) {
        this.nib = Math.max(n, 1);
    }

    public void compute_(StBlockClosure stBlockClosure) {
        this.drawing.compute_(stBlockClosure);
    }

    public void dragon_distance_(int n, int n2) {
        this.dragon_distance_interim_(n, n2, null);
    }

    public void dragon_distance_interim_(int n, int n2, StBlockClosure stBlockClosure) {
        if (n == 0) {
            this.go_(n2);
        } else if (n > 0) {
            this.dragon_distance_interim_(n - 1, n2, stBlockClosure);
            this.turn_(90.0);
            this.dragon_distance_interim_(1 - n, n2, stBlockClosure);
        } else {
            this.dragon_distance_interim_(-1 - n, n2, stBlockClosure);
            this.turn_(-90.0);
            this.dragon_distance_interim_(1 + n, n2, stBlockClosure);
        }
        if (stBlockClosure != null) {
            stBlockClosure.value();
        }
    }

    public void dragon_distance_tick_(int n, int n2, final long l) {
        this.dragon_distance_interim_(n, n2, new StBlockClosure(){

            public Object value() {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void mandala_diameter_(int n, int n2) {
        this.mandala_diameter_interim_(n, n2, null);
    }

    public void mandala_diameter_interim_(int n, int n2, StBlockClosure stBlockClosure) {
        int n3;
        int n4 = (int)Math.round(Math.PI * (double)n2 / (double)n);
        this.home();
        this.up();
        this.turn_(-90.0);
        this.go_(n2 / 2);
        this.turn_(90.0);
        this.go_((0 - n4) / 2);
        JunPenLocation[] junPenLocationArray = new JunPenLocation[n];
        for (n3 = 0; n3 < n; ++n3) {
            junPenLocationArray[n3] = this.location().rounded();
            this.go_(n4);
            this.turn_(360 / n);
        }
        this.down();
        for (n3 = n / 2; n3 > 0; --n3) {
            for (int i = 0; i < n; ++i) {
                this.location_((Object)junPenLocationArray[i]);
                this.goto_((Object)junPenLocationArray[(i + n3) % n]);
                if (stBlockClosure == null) continue;
                stBlockClosure.value();
            }
        }
    }

    public void mandala_diameter_tick_(int n, int n2, final long l) {
        this.mandala_diameter_interim_(n, n2, new StBlockClosure(){

            public Object value() {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void spiral_angle_(int n, int n2) {
        this.spiral_angle_interim_(n, n2, null);
    }

    public void spiral_angle_interim_(int n, int n2, StBlockClosure stBlockClosure) {
        for (int i = 1; i < n + 1; ++i) {
            this.go_(i);
            this.turn_(n2);
            if (stBlockClosure == null) continue;
            stBlockClosure.value();
        }
    }

    public void spiral_angle_tick_(int n, int n2, final long l) {
        this.spiral_angle_interim_(n, n2, new StBlockClosure(){

            public Object value() {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void begin() {
        Vector<JunPenLocation> vector = new Vector<JunPenLocation>();
        vector.addElement(this.location());
        this.sequence = vector;
    }

    public void down() {
        this.down = true;
    }

    public void fill() {
        this.fillPolygon_(this.sequence);
    }

    public void fill_(StBlockClosure stBlockClosure) {
        boolean bl = this.isDown();
        final StValueHolder stValueHolder = new StValueHolder((Object)this.state());
        final JunPen junPen = this;
        final StBlockClosure stBlockClosure2 = stBlockClosure;
        StBlockClosure stBlockClosure3 = new StBlockClosure(){

            public Object value() {
                stValueHolder.value_((Object)junPen.state());
                return null;
            }
        };
        StBlockClosure stBlockClosure4 = new StBlockClosure(){

            public Object value() {
                junPen.down();
                junPen.begin();
                stBlockClosure2.value();
                junPen.fill();
                return null;
            }
        };
        StBlockClosure stBlockClosure5 = new StBlockClosure(){

            public Object value() {
                junPen.state_((StAssociation[])stValueHolder.value());
                return null;
            }
        };
        this.assert_do_ensure_(stBlockClosure3, stBlockClosure4, stBlockClosure5);
        if (bl) {
            this.down();
        } else {
            this.up();
        }
    }

    public void go_(double d) {
        JunPenGeometry junPenGeometry;
        JunPenLocation junPenLocation = JunPenLocation.X_y_z_(1.0, 0.0, 0.0);
        JunPenTransformation junPenTransformation = JunPenTransformation.Unity();
        JunPenAngle junPenAngle = this.direction().latitude();
        JunPenAngle junPenAngle2 = this.direction().longitude();
        if (junPenAngle2.abs().isGreaterThan_(new Double(junPenAngle2.accuracy()))) {
            junPenGeometry = JunPenTransformation.RotateZ_((Object)junPenAngle2);
            junPenTransformation = junPenTransformation.product_((JunPenTransformation)junPenGeometry);
        }
        if (junPenAngle.abs().isGreaterThan_(new Double(junPenAngle.accuracy()))) {
            junPenGeometry = JunPenLocation.X_y_z_(0.0, -1.0, 0.0);
            junPenGeometry = ((JunPenLocation)junPenGeometry).transform_(junPenTransformation);
            JunPenLocation[] junPenLocationArray = new JunPenLocation[]{JunPenLocation.Zero(), junPenGeometry};
            JunPenTransformation junPenTransformation2 = JunPenTransformation.Rotate_around_((Object)junPenAngle, junPenLocationArray);
            junPenTransformation = junPenTransformation.product_(junPenTransformation2);
        }
        junPenTransformation = junPenTransformation.product_(JunPenTransformation.Scale_(new Double(d)));
        junPenTransformation = junPenTransformation.product_(JunPenTransformation.Translate_((Object)this.location));
        junPenGeometry = junPenLocation.transform_(junPenTransformation);
        this.goto_((Object)junPenGeometry);
    }

    public void goto_(double[] dArray) {
        JunPenLocation junPenLocation = this.location();
        this.location_(dArray);
        this.drawLineFrom_to_(junPenLocation, this.location());
    }

    public void goto_(double d) {
        JunPenLocation junPenLocation = this.location();
        this.location_(d);
        this.drawLineFrom_to_(junPenLocation, this.location());
    }

    public void goto_(Object object) {
        JunPenLocation junPenLocation = this.location();
        this.location_(object);
        this.drawLineFrom_to_(junPenLocation, this.location());
    }

    public void home() {
        this.location_((Object)JunPenLocation.Zero());
        this.direction_((Object)JunPenDirection.Zero());
    }

    public StAssociation[] state() {
        StAssociation[] stAssociationArray = new StAssociation[]{new StAssociation((Object)JunPen.$((String)"location"), (Object)this.location()), new StAssociation((Object)JunPen.$((String)"direction"), (Object)this.direction()), new StAssociation((Object)JunPen.$((String)"down"), (Object)new Boolean(this.down)), new StAssociation((Object)JunPen.$((String)"nib"), (Object)new Integer(this.nib())), new StAssociation((Object)JunPen.$((String)"color"), (Object)this.color()), new StAssociation((Object)JunPen.$((String)"sequence"), (Object)this.sequence)};
        return stAssociationArray;
    }

    public void state_(StAssociation[] stAssociationArray) {
        for (int i = 0; i < stAssociationArray.length; ++i) {
            StAssociation stAssociation = stAssociationArray[i];
            StSymbol stSymbol = (StSymbol)stAssociation.key();
            Object object = stAssociation.value();
            if (stSymbol == JunPen.$((String)"location")) {
                this.location_((Object)((JunPenLocation)((Object)object)));
            }
            if (stSymbol == JunPen.$((String)"direction")) {
                this.direction_((Object)((JunPenDirection)((Object)object)));
            }
            if (stSymbol == JunPen.$((String)"down")) {
                this.down = (Boolean)object;
            }
            if (stSymbol == JunPen.$((String)"nib")) {
                this.nib_((Integer)object);
            }
            if (stSymbol == JunPen.$((String)"color")) {
                this.color_((Color)object);
            }
            if (stSymbol != JunPen.$((String)"sequence")) continue;
            this.sequence = (Vector)object;
        }
    }

    public void tilt_(double d) {
        double d2 = this.direction().longitude().deg();
        double d3 = (this.direction().latitude().deg() + d) % 360.0;
        this.direction_((Object)JunPenDirection.Longitude_latitude_(d2, d3));
    }

    public void turn_(double d) {
        double d2 = (this.direction().longitude().deg() + d) % 360.0;
        double d3 = this.direction().latitude().deg();
        this.direction_((Object)JunPenDirection.Longitude_latitude_(d2, d3));
    }

    public void up() {
        this.down = false;
    }

    public boolean isDown() {
        return this.down;
    }

    public boolean isUp() {
        return !this.down;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assert_do_ensure_(StBlockClosure stBlockClosure, StBlockClosure stBlockClosure2, StBlockClosure stBlockClosure3) {
        stBlockClosure.value();
        try {
            stBlockClosure2.value();
        }
        catch (Exception exception) {
        }
        finally {
            stBlockClosure3.value();
        }
    }

    protected void drawLineFrom_to_(JunPenLocation junPenLocation, JunPenLocation junPenLocation2) {
        Vector<Object> vector = new Vector<Object>();
        if (this.isDown()) {
            vector.addElement(JunPen.$((String)"stroke"));
            vector.addElement(new Integer(this.nib()));
            vector.addElement(this.color());
            vector.addElement((Object)junPenLocation);
            vector.addElement((Object)junPenLocation2);
            this.drawing.value_(vector);
        }
        if (this.sequence != null) {
            this.sequence.addElement(junPenLocation2);
        }
    }

    protected void fillPolygon_(Vector vector) {
        if (vector == null) {
            return;
        }
        if (vector.size() < 3) {
            return;
        }
        Vector<Object> vector2 = new Vector<Object>();
        if (this.isDown()) {
            vector2.addElement(JunPen.$((String)"fill"));
            vector2.addElement(this.color());
            vector2.addElement(vector);
            this.drawing.value_(vector2);
        }
        this.sequence = null;
    }
}

