/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.parameter;

import jp.co.sra.smalltalk.StModel;

public class JunParameter
extends StModel {
    protected String name;
    protected double value = Double.NaN;
    protected double minValue = Double.NaN;
    protected double maxValue = Double.NaN;
    protected double stepValue = Double.NaN;
    protected String parameterName;

    public JunParameter(String string) {
        this(string, JunParameter.DefaultValue());
    }

    public JunParameter(String string, double d, double d2) {
        this(string, d, JunParameter.DefaultMinValue(), d2);
    }

    public JunParameter(String string, double d, double d2, double d3) {
        this.name_(string);
        this.value_(d);
        this.minValue_(d2);
        this.maxValue_(d3);
    }

    public JunParameter(String string, double d, double d2, double d3, double d4) {
        this(string, d, d2, d3);
        this.stepValue_(d4);
    }

    public JunParameter(String string, double d) {
        this(string, d, JunParameter.DefaultMaxValue());
    }

    public JunParameter(String string, double[] dArray) {
        this(string);
        if (dArray.length >= 1) {
            this.value_(dArray[0]);
        }
        if (dArray.length == 2) {
            this.minValue_(0.0);
            this.maxValue_(dArray[1]);
        }
        if (dArray.length >= 3) {
            this.minValue_(dArray[1]);
            this.maxValue_(dArray[2]);
        }
        if (dArray.length >= 4) {
            this.stepValue_(dArray[3]);
        }
    }

    public JunParameter(String string, double[] dArray, String string2) {
        this(string, dArray);
        this.parameterName_(string2);
    }

    public static final double DefaultMaxValue() {
        return 100.0;
    }

    public static final double DefaultMinValue() {
        return 0.0;
    }

    public static double DefaultValue() {
        return 0.0;
    }

    public final int _rangeStartValue() {
        return 0;
    }

    public int _rangeStopValue() {
        if (Double.isNaN(this.stepValue)) {
            return 100;
        }
        return (int)Math.floor((this.maxValue() - this.minValue()) / this.stepValue());
    }

    public int _rangeValue() {
        return this._rangeStartValue() + (int)((double)(this._rangeStopValue() - this._rangeStartValue()) * (this.value() - this.minValue()) / (this.maxValue() - this.minValue()));
    }

    public void _setRangeValue(int n) {
        double d = this.minValue + (this.maxValue() - this.minValue()) * (double)(n - this._rangeStartValue()) / (double)(this._rangeStopValue() - this._rangeStartValue());
        this.value_(d);
    }

    public double maxValue() {
        return this.maxValue;
    }

    public void maxValue_(double d) {
        this.maxValue = d;
        this.changed_(JunParameter.$((String)"maxValue"));
    }

    public double minValue() {
        return this.minValue;
    }

    public void minValue_(double d) {
        this.minValue = d;
        this.changed_(JunParameter.$((String)"minValue"));
    }

    public String name() {
        return this.name;
    }

    public void name_(String string) {
        this.name = string;
        this.changed_(JunParameter.$((String)"name"));
    }

    public double stepValue() {
        return this.stepValue;
    }

    public void stepValue_(double d) {
        this.stepValue = d;
        this.changed_(JunParameter.$((String)"stepValue"));
    }

    public double value() {
        return this.value;
    }

    public void value_(double d) {
        if (d < this.minValue) {
            d = this.minValue;
        }
        if (this.maxValue < d) {
            d = this.maxValue;
        }
        if (d != this.value) {
            this.value = d;
            this.changed_(JunParameter.$((String)"value"));
        }
    }

    public String parameterName() {
        if (this.parameterName == null) {
            return this.name();
        }
        return this.parameterName;
    }

    public void parameterName_(String string) {
        this.parameterName = string;
    }
}

