/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.nib;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jp.co.sra.jun.goodies.nib.JunNibChoice;
import jp.co.sra.jun.goodies.nib.JunNibChoiceView;
import jp.co.sra.jun.goodies.track.JunSimpleSliderViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewJPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunNibChoiceViewSwing
extends JunAbstractViewJPanel
implements JunNibChoiceView {
    protected JunSimpleSliderViewSwing sliderView;

    public static StView WithSlider(JunNibChoice junNibChoice) {
        return new StViewJPanel((StModel)junNibChoice){
            protected JunNibChoiceViewSwing nibChoiceView;

            public JunNibChoiceViewSwing nibChoiceView() {
                if (this.nibChoiceView == null) {
                    this.nibChoiceView = new JunNibChoiceViewSwing((JunNibChoice)this.model());
                }
                return this.nibChoiceView;
            }

            protected void buildComponent() {
                this.setLayout((LayoutManager)new WindowSpecLayout());
                this.add((Component)((Object)this.nibChoiceView()), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)1, (float)1.0f, (int)-1, (float)1.0f, (int)-20));
                this.add((Component)((Object)this.nibChoiceView().sliderView()), WindowSpecLayout.Position((float)0.0f, (int)1, (float)1.0f, (int)-19, (float)1.0f, (int)-1, (float)1.0f, (int)-1));
                this.setSize(new Dimension(234, 55));
            }

            public void _setupKeyboard(Window window) {
                this.nibChoiceView()._setupKeyboard(window);
            }
        };
    }

    public JunNibChoiceViewSwing(JunNibChoice junNibChoice) {
        super(junNibChoice);
    }

    public JunNibChoice getNibChoice() {
        return (JunNibChoice)this.model();
    }

    protected JunSimpleSliderViewSwing sliderView() {
        if (this.sliderView == null) {
            this.sliderView = new JunSimpleSliderViewSwing(this.getNibChoice().simpleSlider());
        }
        return this.sliderView;
    }

    public StRectangle nibShapeArea() {
        StRectangle stRectangle = new StRectangle(this.getBounds());
        stRectangle = stRectangle.insetBy_(new StRectangle(-1, -1, 2, 2));
        return stRectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StRectangle nibWidthArea() {
        StRectangle stRectangle = null;
        Graphics graphics = null;
        try {
            graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Dimension dimension = new Dimension(fontMetrics.stringWidth(this.nibWidthString()), fontMetrics.getHeight());
            stRectangle = new StRectangle(dimension);
            stRectangle = stRectangle.expandedBy_(new StRectangle(4, 2, 4, 2));
            stRectangle = stRectangle.align_with_(stRectangle.bottomRight(), this.nibShapeArea().bottomRight());
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        return stRectangle;
    }

    public String nibWidthString() {
        if (this.getNibChoice().nibWidth() - (double)((int)this.getNibChoice().nibWidth()) == 0.0) {
            return String.valueOf((int)this.getNibChoice().nibWidth());
        }
        return String.valueOf(this.getNibChoice().nibWidth());
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.displayNibShapeOn_(graphics);
        this.displayNibWidthOn_(graphics);
    }

    public void displayNibShapeOn_(Graphics graphics) {
        StRectangle stRectangle;
        StRectangle stRectangle2 = this.nibShapeArea();
        graphics.setColor(Color.white);
        stRectangle2 = stRectangle2.insetBy_(new StRectangle(1, 1, 0, 0));
        graphics.fillRect(stRectangle2.x(), stRectangle2.y(), stRectangle2.width(), stRectangle2.height());
        StRectangle stRectangle3 = StRectangle.Origin_extent_((Point)new Point(0, 0), (Point)new Point((int)this.getNibChoice().nibWidth(), (int)this.getNibChoice().nibWidth()));
        stRectangle3 = stRectangle3.align_with_(stRectangle3.center(), stRectangle2.center());
        if (StColorValue._DistanceFrom((Color)this.getNibChoice().nibColor(), (Color)Color.white) / Math.sqrt(StColorValue._MaxDistanceSquared()) < 0.05) {
            graphics.setColor(Color.black);
            if (this.getNibChoice().nibShape() == JunNibChoiceViewSwing.$((String)"rectangle")) {
                stRectangle = stRectangle3.expandedBy_(new StRectangle(1, 1, 1, 1));
                graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
            }
            if (this.getNibChoice().nibShape() == JunNibChoiceViewSwing.$((String)"circle")) {
                if (stRectangle3.width() < 3) {
                    stRectangle = stRectangle3.expandedBy_(new StRectangle(1, 1, 1, 1));
                    graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
                } else {
                    stRectangle = stRectangle3.expandedBy_(new StRectangle(1, 1, 2, 2));
                    graphics.fillArc(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height(), 0, 360);
                }
            }
        }
        graphics.setColor(this.getNibChoice().nibColor());
        if (this.getNibChoice().nibShape() == JunNibChoiceViewSwing.$((String)"rectangle")) {
            graphics.fillRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
        }
        if (this.getNibChoice().nibShape() == JunNibChoiceViewSwing.$((String)"circle")) {
            if (stRectangle3.width() < 3) {
                graphics.fillRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
            } else {
                stRectangle = stRectangle3.expandedBy_(new StRectangle(0, 0, 1, 1));
                graphics.fillArc(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height(), 0, 360);
            }
        }
        graphics.setColor(Color.black);
        stRectangle2 = stRectangle2.expandedBy_(new StRectangle(1, 1, 0, 0));
        graphics.drawRect(stRectangle2.x(), stRectangle2.y(), stRectangle2.width(), stRectangle2.height());
    }

    public void displayNibWidthOn_(Graphics graphics) {
        StRectangle stRectangle = this.nibWidthArea();
        StComposedText stComposedText = new StComposedText(this.nibWidthString());
        graphics.setColor(Color.white);
        stRectangle = stRectangle.insetBy_(new StRectangle(1, 1, 0, 0));
        graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
        graphics.setColor(Color.black);
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        stRectangle2 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.clipRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
        stComposedText.displayOn_at_((Graphics)graphics2D, stRectangle2.origin());
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunNibChoiceViewSwing.$((String)"nibWidth")) {
            this.displayOn_(this.getGraphics());
        } else if (stSymbol == JunNibChoiceViewSwing.$((String)"nibColor")) {
            this.displayOn_(this.getGraphics());
        } else if (stSymbol == JunNibChoiceViewSwing.$((String)"nibShape")) {
            this.displayOn_(this.getGraphics());
        } else {
            super.update_(dependentEvent);
        }
    }

    public void _setupKeyboard(final Window window) {
        this.addKeyListener(this.getNibChoice()._keyListener());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                Component component = window.getFocusOwner();
                if (component != null && component != JunNibChoiceViewSwing.this) {
                    JunNibChoiceViewSwing.this.requestFocus();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.sliderView().addMouseListener(mouseAdapter);
    }
}

