/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.nib;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import jp.co.sra.jun.goodies.nib.JunNibChoiceView;
import jp.co.sra.jun.goodies.nib.JunNibChoiceViewAwt;
import jp.co.sra.jun.goodies.nib.JunNibChoiceViewSwing;
import jp.co.sra.jun.goodies.track.JunSimpleSliderModel;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunNibChoice
extends JunApplicationModel
implements StBlockValued {
    protected JunSimpleSliderModel simpleSlider;
    protected double[] nibCollection;
    protected double nibWidth;
    protected Color nibColor;
    protected StSymbol nibShape;

    public JunNibChoice() {
    }

    public JunNibChoice(double[] dArray) {
        this.nibCollection_(dArray);
    }

    public JunNibChoice(double[] dArray, double d, Color color, StSymbol stSymbol) {
        this.value_(new Object[]{dArray, new Double(d), color, stSymbol});
    }

    public JunNibChoice(Object[] objectArray) {
        this.value_(objectArray);
    }

    protected void initialize() {
        super.initialize();
        this.simpleSlider = null;
        this.nibCollection = null;
        this.nibWidth = 0.0;
        this.nibColor = null;
        this.nibShape = null;
    }

    protected boolean _keyboardEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 37: 
            case 40: {
                this.prevNibWidth();
                return true;
            }
            case 38: 
            case 39: {
                this.nextNibWidth();
                return true;
            }
        }
        return false;
    }

    protected void nextNibWidth() {
        int n = 0;
        for (int i = 0; i < this.nibCollection().length; ++i) {
            if (this.nibCollection()[i] != this.nibWidth()) continue;
            n = i;
        }
        if (n < this.nibCollection().length - 1) {
            this.nibWidth_(this.nibCollection()[n + 1]);
        }
    }

    protected void prevNibWidth() {
        int n = 0;
        for (int i = 0; i < this.nibCollection().length; ++i) {
            if (this.nibCollection()[i] != this.nibWidth()) continue;
            n = i;
        }
        if (n > 0) {
            this.nibWidth_(this.nibCollection()[n - 1]);
        }
    }

    public KeyListener _keyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (JunNibChoice.this._keyboardEvent(keyEvent)) {
                    keyEvent.consume();
                }
            }
        };
    }

    public double[] nibCollection() {
        if (this.nibCollection == null) {
            this.nibCollection = this.defaultNibCollection();
        }
        return this.nibCollection;
    }

    public void nibCollection_(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        Arrays.sort(dArray2);
        this.nibCollection = dArray2;
    }

    public Color nibColor() {
        if (this.nibColor == null) {
            this.nibColor = this.defaultNibColor();
        }
        return this.nibColor;
    }

    public void nibColor_(Color color) {
        if (this.nibColor().equals(color)) {
            return;
        }
        this.nibColor = color;
        this.changed_(JunNibChoice.$((String)"nibColor"));
    }

    public StSymbol nibShape() {
        if (this.nibShape == null) {
            this.nibShape = this.defaultNibShape();
        }
        return this.nibShape;
    }

    public void nibShape_(StSymbol stSymbol) {
        if (this.nibShape().equals((Object)stSymbol)) {
            return;
        }
        if (!JunNibChoice.$((String)"rectangle").equals((Object)stSymbol) && !JunNibChoice.$((String)"circle").equals((Object)stSymbol)) {
            return;
        }
        this.nibShape = stSymbol;
        this.changed_(JunNibChoice.$((String)"nibShape"));
    }

    public double nibWidth() {
        if (this.nibWidth == 0.0) {
            if (this.nibCollection().length == 0) {
                this.nibCollection_(new double[]{this.defaultNibWidth()});
            }
            this.nibWidth = this.nibCollection()[0];
        }
        return this.nibWidth;
    }

    public void nibWidth_(double d) {
        int n;
        if (this.nibWidth == d) {
            return;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (n = 0; n < this.nibCollection().length; ++n) {
            arrayList.add(new Double(this.nibCollection()[n]));
        }
        if (arrayList.contains(new Double(d))) {
            this.nibWidth = d;
        } else {
            for (n = 0; n < this.nibCollection().length; ++n) {
                if (!(this.nibCollection()[n] > d)) continue;
                this.nibWidth = this.nibCollection()[n];
                break;
            }
        }
        if (this.nibWidth != this.computeNibValueFromSliderValue_((Double)this.simpleSlider().value())) {
            this.simpleSlider().value_(this.computeSliderValueFromNibValue_(this.nibWidth));
        }
        this.changed_(JunNibChoice.$((String)"nibWidth"));
    }

    public void nibWidth_nibColor_(double d, Color color) {
        if (Arrays.binarySearch(this.nibCollection(), d) >= 0) {
            this.nibWidth = d;
        } else {
            double[] dArray = this.nibCollection();
            this.nibWidth = Double.NaN;
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] > d)) continue;
                this.nibWidth = dArray[i];
                break;
            }
            if (Double.isNaN(this.nibWidth)) {
                this.nibWidth = dArray[dArray.length - 1];
            }
        }
        this.nibColor = color;
        if (this.nibWidth != this.computeNibValueFromSliderValue_(this.simpleSlider().doubleValue())) {
            this.simpleSlider().value_(this.computeSliderValueFromNibValue_(this.nibWidth));
        }
        this.changed();
    }

    public JunSimpleSliderModel simpleSlider() {
        if (this.simpleSlider == null) {
            this.simpleSlider = new JunSimpleSliderModel();
            this.simpleSlider.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunNibChoice.this.nibWidth_(JunNibChoice.this.computeNibValueFromSliderValue_(((Number)object).doubleValue()));
                    return null;
                }
            });
        }
        return this.simpleSlider;
    }

    public Object value() {
        return new Object[]{this.nibCollection(), new Double(this.nibWidth()), this.nibColor(), this.nibShape()};
    }

    public void value_(Object object) {
        Object[] objectArray = (Object[])object;
        this.nibCollection_((double[])objectArray[0]);
        this.nibWidth_((Double)objectArray[1]);
        this.nibColor_((Color)objectArray[2]);
        this.nibShape_((StSymbol)objectArray[3]);
    }

    public StView defaultView() {
        if (JunNibChoice.GetDefaultViewMode() == 0) {
            return JunNibChoiceViewAwt.WithSlider(this);
        }
        return JunNibChoiceViewSwing.WithSlider(this);
    }

    public double[] defaultNibCollection() {
        return new double[]{1.0, 3.0, 5.0, 7.0, 9.0, 11.0, 13.0, 15.0, 17.0, 19.0, 21.0, 23.0, 25.0};
    }

    public Color defaultNibColor() {
        return Color.black;
    }

    public StSymbol defaultNibShape() {
        return JunNibChoice.$((String)"rectangle");
    }

    public int defaultNibWidth() {
        return 1;
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this);
    }

    protected double computeNibValueFromSliderValue_(double d) {
        int n = this.nibCollection().length - 1;
        int n2 = 0;
        n2 = n <= 0 ? 0 : (int)(d * (double)n + 0.5);
        return this.nibCollection()[n2];
    }

    protected double computeSliderValueFromNibValue_(double d) {
        int n = this.nibCollection().length - 1;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        if (n <= 0) {
            d2 = this.simpleSlider().doubleValue();
        } else {
            d3 = 1.0 / (double)n;
            for (int i = 0; i < this.nibCollection().length; ++i) {
                if (d != this.nibCollection()[i]) continue;
                n2 = i;
                break;
            }
            d2 = d3 * (double)Math.max(n2, 0);
        }
        return d2;
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Nib Choice");
    }

    public StView getView() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            DependentListener dependentListener = dependentListenerArray[i];
            if (!(dependentListener instanceof JunNibChoiceView) || ((JunNibChoiceView)dependentListener).model() != this) continue;
            return (JunNibChoiceView)dependentListener;
        }
        return null;
    }
}

