/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.movie.support;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.movie.framework.JunMovieHandle;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.tips.JunURL;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StSymbol;

public class JunMovieThumbnails
extends JunAbstractObject {
    protected static SimpleDateFormat TimeStampFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    protected File movieFile;
    protected double tickMilliseconds;
    protected int thumbnailSize;
    protected StImage[] capturedImages;
    protected StImage[] thumbnailImages;
    protected long[] capturedStamps;
    protected boolean timeStamp;
    protected int numberOfColumns;

    public JunMovieThumbnails() {
    }

    public JunMovieThumbnails(File file) {
        this();
        this.movieFile_(file);
    }

    public JunMovieThumbnails(File file, int n) {
        this.movieFile_(file);
        this.tickMilliseconds_(n);
    }

    public JunMovieThumbnails(File file, int n, int n2) {
        this.movieFile_(file);
        this.tickMilliseconds_(n);
        this.thumbnailSize_(n2);
    }

    public static JunMovieThumbnails Request() {
        return JunMovieThumbnails.Request(JunMovieThumbnails.$String((String)"Select a movie file."));
    }

    public static JunMovieThumbnails Request(String string) {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunMovieThumbnails.$String((String)"Movie files"), JunSystem.DefaultMovieExtensionPatterns()), JunFileModel.FileType.All(JunMovieThumbnails.$String((String)"All files"))};
        File file = JunFileRequesterDialog.RequestFile(string, fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return null;
        }
        return new JunMovieThumbnails(file);
    }

    protected void initialize() {
        super.initialize();
        this.movieFile = null;
        this.tickMilliseconds = this.defaultTickMilliseconds();
        this.thumbnailSize = this.defaultThumbnailSize();
        this.flushImages();
        this.timeStamp = false;
        this.numberOfColumns = 10;
    }

    public File movieFile() {
        return this.movieFile;
    }

    public void movieFile_(File file) {
        this.movieFile = file;
        this.flushImages();
    }

    public URI movieURI() {
        if (this.movieFile() == null) {
            return null;
        }
        return this.movieFile().toURI();
    }

    public double tickMilliseconds() {
        return this.tickMilliseconds;
    }

    public void tickMilliseconds_(double d) {
        this.tickMilliseconds = Math.max(d, 10.0);
    }

    public int thumbnailSize() {
        return this.thumbnailSize;
    }

    public void thumbnailSize_(int n) {
        this.thumbnailSize = Math.max(n, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage[] capturedImages() {
        if (this.capturedImages == null) {
            if (this.movieFile() == null) {
                return null;
            }
            JunMoviePlayer junMoviePlayer = new JunMoviePlayer(this.movieFile());
            try {
                long[] lArray = this.capturedStamps();
                StImage[] stImageArray = new StImage[lArray.length];
                for (int i = 0; i < stImageArray.length; ++i) {
                    junMoviePlayer.gotoInMilliseconds_(lArray[i]);
                    stImageArray[i] = junMoviePlayer.asImage();
                }
                this.capturedImages = stImageArray;
            }
            finally {
                junMoviePlayer.release();
            }
        }
        return this.capturedImages;
    }

    public StImage[] thumbnailImages() {
        if (this.thumbnailImages == null) {
            StImage[] stImageArray = this.capturedImages();
            if (stImageArray == null) {
                return null;
            }
            StImage[] stImageArray2 = new StImage[stImageArray.length];
            for (int i = 0; i < stImageArray2.length; ++i) {
                StImage stImage = stImageArray[i];
                int n = Math.max(stImage.width(), stImage.height());
                double d = (double)this.thumbnailSize() / (double)n;
                int n2 = (int)((double)stImage.width() * d);
                int n3 = (int)((double)stImage.height() * d);
                stImageArray2[i] = new StImage(stImageArray[i].image().getScaledInstance(n2, n3, 4));
            }
            this.thumbnailImages = stImageArray2;
        }
        return this.thumbnailImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] capturedStamps() {
        if (this.capturedStamps == null) {
            if (this.movieFile() == null) {
                return null;
            }
            JunMovieHandle junMovieHandle = JunMovieHandle.Filename_(this.movieFile());
            try {
                double d = junMovieHandle.durationInSeconds() * 1000.0;
                int n = (int)Math.floor(d / this.tickMilliseconds());
                this.capturedStamps = new long[n];
                for (int i = 0; i < n; ++i) {
                    this.capturedStamps[i] = (long)(this.tickMilliseconds() * (double)i);
                }
            }
            finally {
                junMovieHandle.release();
            }
        }
        return this.capturedStamps;
    }

    public int numberOfThumbnails() {
        return this.thumbnailImages().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void numberOfThumbnails_(int n) {
        if (this.movieFile() == null) {
            return;
        }
        JunMovieHandle junMovieHandle = JunMovieHandle.Filename_(this.movieFile());
        try {
            n = Math.max(n, 1);
            double d = junMovieHandle.durationInSeconds() * 1000.0;
            this.tickMilliseconds_(d / (double)n);
        }
        finally {
            junMovieHandle.release();
        }
    }

    public int numberOfColumns() {
        return this.numberOfColumns;
    }

    public void numberOfColumns_(int n) {
        this.numberOfColumns = Math.max(n, 1);
    }

    public boolean timeStamp() {
        return this.timeStamp;
    }

    public void timeStamp_(boolean bl) {
        this.timeStamp = bl;
    }

    protected double defaultTickMilliseconds() {
        return 1000.0;
    }

    protected int defaultThumbnailSize() {
        return 64;
    }

    protected void flushImages() {
        this.capturedImages = null;
        this.thumbnailImages = null;
        this.capturedStamps = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        File file = this.htmlDirectory();
        File file2 = new File(file, "index.html");
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "Shift_JIS")));
            Map[] mapArray = this.makeThumbnailsIn_(file);
            Map[] mapArray2 = this.makeImagesIn_(file);
            this.htmlOn_thumbnailInfo_imageInfo_(printWriter, mapArray, mapArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        try {
            JunURL.Browse_(file2.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    protected File htmlDirectory() {
        File file = null;
        while ((file = new File(JunSystem.DefaultBaseName())).exists()) {
        }
        file.mkdir();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void htmlOn_thumbnailInfo_imageInfo_(PrintWriter printWriter, Map[] mapArray, Map[] mapArray2) throws IOException {
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        String string = "HTML";
        try {
            printWriter.println("<" + string + ">");
            this.htmlHeadOn_(printWriter);
            this.htmlBodyOn_thumbnailInfo_imageInfo_(printWriter, mapArray, mapArray2);
        }
        finally {
            printWriter.println("</" + string + ">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void htmlHeadOn_(PrintWriter printWriter) throws IOException {
        String string = "HEAD";
        try {
            printWriter.println("<" + string + ">");
            printWriter.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=Shit_JIS\">");
            String string2 = "TITLE";
            try {
                printWriter.print("<" + string2 + ">");
                printWriter.print(this.htmlTitleString());
            }
            finally {
                printWriter.println("</" + string2 + ">");
            }
        }
        finally {
            printWriter.println("</" + string + ">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void htmlBodyOn_thumbnailInfo_imageInfo_(PrintWriter printWriter, Map[] mapArray, Map[] mapArray2) throws IOException {
        String string = "BODY";
        try {
            printWriter.println("<" + string + " bgcolor=\"#ffffff\">");
            this.htmlMovieOn_(printWriter);
            this.htmlTableOn_thumbnailInfo_imageInfo_(printWriter, mapArray, mapArray2);
        }
        finally {
            printWriter.println("</" + string + ">");
        }
    }

    protected String htmlTitleString() {
        if (this.movieFile() == null) {
            return "";
        }
        return this.movieFile().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void htmlMovieOn_(PrintWriter printWriter) throws IOException {
        String string = "H2";
        try {
            printWriter.print("<" + string + ">");
            printWriter.print("<A HREF=\"" + this.movieURI() + "\">" + this.htmlTitleString() + "</A>");
        }
        finally {
            printWriter.println("</" + string + ">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void htmlTableOn_thumbnailInfo_imageInfo_(PrintWriter printWriter, Map[] mapArray, Map[] mapArray2) {
        String string = "TABLE";
        try {
            printWriter.print("<" + string);
            if (this.timeStamp()) {
                printWriter.print(" border=\"0\" cellpadding=\"0\" cellspacing=\"2\" ");
            } else {
                printWriter.print(" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" ");
            }
            printWriter.println(">");
            String string2 = "TBODY";
            try {
                printWriter.println("  <" + string2 + ">");
                printWriter.println("    <TR>");
                for (int i = 0; i < this.numberOfThumbnails(); ++i) {
                    printWriter.print("      <TD align=\"center\">");
                    this.htmlThumbnailOn_thumbnailMap_imageMap_(printWriter, mapArray[i], mapArray2[i]);
                    printWriter.println("</TD>");
                    if ((i + 1) % this.numberOfColumns() != 0) continue;
                    printWriter.println("    </TR>");
                    printWriter.println("    <TR>");
                }
                printWriter.println("    </TR>");
            }
            finally {
                printWriter.println("  </" + string2 + ">");
            }
        }
        finally {
            printWriter.println("</" + string + ">");
        }
    }

    protected void htmlThumbnailOn_thumbnailMap_imageMap_(PrintWriter printWriter, Map map, Map map2) {
        printWriter.print("<A HREF=\"" + map2.get(JunMovieThumbnails.$((String)"src")) + "\">");
        printWriter.print("<IMG");
        printWriter.print(" align=\"middle\"");
        printWriter.print(" hspace=\"0\"");
        printWriter.print(" vspace=\"1\"");
        printWriter.print(" border=\"0\"");
        printWriter.print(" width=\"" + map.get(JunMovieThumbnails.$((String)"width")) + "\"");
        printWriter.print(" height=\"" + map.get(JunMovieThumbnails.$((String)"height")) + "\"");
        printWriter.print(" src=\"" + map.get(JunMovieThumbnails.$((String)"src")) + "\"");
        printWriter.print(" alt=\"" + map.get(JunMovieThumbnails.$((String)"alt")) + "\"");
        printWriter.print(">");
        printWriter.print("</A>");
        if (this.timeStamp()) {
            int n = Integer.parseInt((String)map.get(JunMovieThumbnails.$((String)"alt")));
            printWriter.print("<BR>");
            printWriter.print("<TT>");
            printWriter.print("&nbsp;");
            printWriter.print(TimeStampFormat.format(new Date(n)));
            printWriter.print("&nbsp;");
            printWriter.print("</TT>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map[] makeThumbnailsIn_(File file) {
        ArrayList arrayList = new ArrayList();
        File file2 = new File(file, "thumbnails");
        file2.mkdir();
        long[] lArray = this.capturedStamps();
        if (lArray != null && lArray.length > 0) {
            int n = String.valueOf(lArray[lArray.length - 1]).length();
            String string = "";
            for (int i = 0; i < n; ++i) {
                string = string + '0';
            }
            DecimalFormat decimalFormat = new DecimalFormat(string);
            for (int i = 0; i < lArray.length; ++i) {
                String string2 = decimalFormat.format(lArray[i]);
                File file3 = new File(file2, string2 + ".jpg");
                StImage stImage = this.thumbnailImages()[i];
                JunImageStream junImageStream = null;
                try {
                    junImageStream = JunJpegImageStream.On_(new BufferedOutputStream(new FileOutputStream(file3)));
                    junImageStream.nextPutImage_(stImage);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    if (junImageStream != null) {
                        try {
                            junImageStream.flush();
                            junImageStream.close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            junImageStream = null;
                        }
                    }
                }
                HashMap<StSymbol, Object> hashMap = new HashMap<StSymbol, Object>();
                hashMap.put(JunMovieThumbnails.$((String)"alt"), string2);
                hashMap.put(JunMovieThumbnails.$((String)"src"), "./thumbnails/" + string2 + ".jpg");
                hashMap.put(JunMovieThumbnails.$((String)"width"), new Integer(stImage.width()));
                hashMap.put(JunMovieThumbnails.$((String)"height"), new Integer(stImage.height()));
                arrayList.add(hashMap);
            }
        }
        return arrayList.toArray(new HashMap[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map[] makeImagesIn_(File file) {
        ArrayList arrayList = new ArrayList();
        File file2 = new File(file, "images");
        file2.mkdir();
        long[] lArray = this.capturedStamps();
        if (lArray != null && lArray.length > 0) {
            int n = String.valueOf(lArray[lArray.length - 1]).length();
            String string = "";
            for (int i = 0; i < n; ++i) {
                string = string + '0';
            }
            DecimalFormat decimalFormat = new DecimalFormat(string);
            for (int i = 0; i < lArray.length; ++i) {
                String string2 = decimalFormat.format(lArray[i]);
                File file3 = new File(file2, string2 + ".jpg");
                StImage stImage = this.capturedImages()[i];
                JunImageStream junImageStream = null;
                try {
                    junImageStream = JunJpegImageStream.On_(new BufferedOutputStream(new FileOutputStream(file3)));
                    junImageStream.nextPutImage_(stImage);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    if (junImageStream != null) {
                        try {
                            junImageStream.flush();
                            junImageStream.close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            junImageStream = null;
                        }
                    }
                }
                HashMap<StSymbol, Object> hashMap = new HashMap<StSymbol, Object>();
                hashMap.put(JunMovieThumbnails.$((String)"alt"), string2);
                hashMap.put(JunMovieThumbnails.$((String)"src"), "./images/" + string2 + ".jpg");
                hashMap.put(JunMovieThumbnails.$((String)"width"), new Integer(stImage.width()));
                hashMap.put(JunMovieThumbnails.$((String)"height"), new Integer(stImage.height()));
                arrayList.add(hashMap);
            }
        }
        return arrayList.toArray(new HashMap[arrayList.size()]);
    }

    static {
        TimeStampFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

