/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.movie.framework;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.qt4jun.JunQTMovie;
import jp.co.sra.qt4jun.JunQTMovieFactory;
import jp.co.sra.qt4jun.JunQTPort;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StModel;

public class JunMovieHandle
extends StModel {
    protected File filename;
    protected JunQTMovie movie;
    protected Dimension originalExtent;
    protected boolean dontRecover;

    public static String ConvertToRelative_(String string) {
        return string;
    }

    public static JunMovieHandle Filename_(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        JunMovieHandle junMovieHandle = new JunMovieHandle();
        junMovieHandle.setFilename_(file);
        junMovieHandle.setMovie_(JunQTMovieFactory.openMovie(file));
        return junMovieHandle;
    }

    public static JunMovieHandle Filename_(String string) {
        return JunMovieHandle.Filename_(new File(string));
    }

    public static JunMovieHandle OpenMovie() {
        JunMovieHandle junMovieHandle = new JunMovieHandle();
        junMovieHandle.openMovie();
        return junMovieHandle;
    }

    public Object _interface() {
        return null;
    }

    public void active_(boolean bl) {
        if (this.hasMovie()) {
            this.movie.setActive(bl);
        }
    }

    public StImage asImage() {
        Image image = this.toImage();
        return image == null ? null : new StImage(image);
    }

    public StImage asImageAt_(int n) {
        Image image = this.toImageAt_(n);
        return image == null ? null : new StImage(image);
    }

    public Image toImage() {
        if (this.hasMovie()) {
            return this.movie.getImageAt(this.timeValue(), this.originalExtent());
        }
        return null;
    }

    public Image toImageAt_(int n) {
        if (this.hasMovie()) {
            return this.movie.getImageAt(n, this.originalExtent());
        }
        return null;
    }

    public byte[] asSoundDataFrom_duration_(int n, int n2) {
        if (this.hasMovie()) {
            return this.movie.getSoundData(n, n2);
        }
        return null;
    }

    public JunQTMovie copyMovie() {
        if (this.hasMovie()) {
            return this.movie.copySelection();
        }
        return null;
    }

    public void doMovieTask() {
        if (this.hasMovie()) {
            this.movie.task();
        }
    }

    public boolean done() {
        if (this.hasMovie()) {
            return this.movie.isDone();
        }
        return true;
    }

    public int duration() {
        int n;
        if (this.hasMovie() && (n = this.movie.getDuration()) > 0) {
            return n;
        }
        return 1;
    }

    public double durationInSeconds() {
        return (double)this.duration() / (double)this.timeScale();
    }

    public File filename() {
        return this.filename;
    }

    public void goToBeginning() {
        if (this.hasMovie()) {
            this.movie.goToBeginning();
        }
    }

    public void goToEnd() {
        if (this.hasMovie()) {
            this.movie.goToEnd();
        }
    }

    public boolean hasMovie() {
        if (this.movie == null) {
            this.recoverMovie();
        }
        return this.movie != null;
    }

    public boolean isSound() {
        if (this.hasMovie()) {
            Rectangle rectangle = this.movie.getBox();
            if (rectangle.width == 0 && rectangle.height == 0) {
                return true;
            }
        }
        return false;
    }

    public Rectangle movieBox() {
        if (this.hasMovie()) {
            Rectangle rectangle = this.movie.getBox();
            if (rectangle.width == 0 && rectangle.height == 0) {
                rectangle.setSize(this.minimumSize());
            }
            return rectangle;
        }
        return new Rectangle(0, 0, 1, 1);
    }

    public void movieBox_(Rectangle rectangle) {
        if (this.hasMovie()) {
            this.movie.setBox(rectangle);
        }
    }

    public void movieBox_(JunQTPort junQTPort, Rectangle rectangle, Point point) {
        if (this.hasMovie()) {
            junQTPort.setMovieBox(this.movie, rectangle, point);
        }
    }

    public int nextInterestingTime() {
        if (this.hasMovie()) {
            int n = this.timeValue();
            int n2 = this.movie.getNextInterestingTime(n, 1);
            if (n2 < n) {
                return this.duration();
            }
            return n2;
        }
        return 0;
    }

    public Dimension originalExtent() {
        return this.originalExtent;
    }

    public int previousInterestingTime() {
        if (this.hasMovie()) {
            int n = this.timeValue();
            int n2 = this.movie.getNextInterestingTime(n, -1);
            if (n2 >= n) {
                return 0;
            }
            return n2;
        }
        return 0;
    }

    public void release() {
        this.releaseMovie();
        super.release();
    }

    public void releaseMovie() {
        if (this.movie != null) {
            this.changed_(JunMovieHandle.$((String)"releasing"));
            this.movie.release();
            this.movie = null;
        }
        this.dontRecover = true;
    }

    public void selection_duration_(int n, int n2) {
        if (this.hasMovie()) {
            this.movie.setSelection(n, n2);
        }
    }

    public void start() {
        if (this.hasMovie()) {
            this.movie.start();
        }
    }

    public void stop() {
        if (this.hasMovie()) {
            this.movie.stop();
        }
    }

    public int timeScale() {
        if (this.hasMovie()) {
            return this.movie.getTimeScale();
        }
        return 600;
    }

    public int timeValue() {
        if (this.hasMovie()) {
            return this.movie.getTimeValue();
        }
        return 0;
    }

    public void timeValue_(int n) {
        if (this.hasMovie()) {
            this.movie.setTimeValue(n);
        }
    }

    public double timeValueInSeconds() {
        return (double)this.timeValue() / (double)this.timeScale();
    }

    public void timeValueInSeconds_(double d) {
        this.timeValue_((int)(d * (double)this.timeScale()));
    }

    public String toString() {
        String string = new String();
        string = string + ((Object)((Object)this)).getClass().getName();
        string = string + "\n";
        string = string + "\t";
        string = string + "(";
        string = string + "\n";
        string = string + "\t";
        string = string + "filename: " + this.filename;
        string = string + "\n\t";
        string = string + "movie: " + this.movie;
        string = string + "\n\t";
        string = string + "originalExtent: " + this.originalExtent;
        string = string + "\n\t";
        string = string + "dontRecover: " + this.dontRecover;
        string = string + "\n";
        string = string + ")";
        return string;
    }

    public void updateMovie() {
        if (this.hasMovie()) {
            this.movie.update();
        }
    }

    public double volume() {
        if (this.hasMovie()) {
            return this.movie.getVolume();
        }
        return 0.0;
    }

    public void volume_(double d) {
        if (this.hasMovie()) {
            this.movie.setVolume(d);
        }
    }

    protected void setFilename_(File file) {
        this.filename = file;
    }

    protected void setMovie_(JunQTMovie junQTMovie) {
        this.movie = junQTMovie;
        if (this.movie != null) {
            this.originalExtent = this.movieBox().getSize();
        }
    }

    protected void enableRecover() {
        this.dontRecover = false;
    }

    protected void finalize() {
        this.release();
    }

    protected Dimension minimumSize() {
        return new Dimension(160, 12);
    }

    public void moviePort_(JunQTPort junQTPort) {
        if (this.hasMovie()) {
            this.movie.setPort(junQTPort);
        }
    }

    protected void openMovie() {
        File file = null;
        if (JunQTMovieFactory.canGetMovieFile()) {
            String string = JunQTMovieFactory.getMovieFile();
            if (string != null && string.length() > 0) {
                file = new File(string);
            }
        } else {
            JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunMovieHandle.$String((String)"Movie files"), JunSystem.DefaultMovieExtensionPatterns()), JunFileModel.FileType.All(JunMovieHandle.$String((String)"All files"))};
            file = JunFileRequesterDialog.RequestFile(JunMovieHandle.$String((String)"Select a <1p> file.", null, (Object)JunMovieHandle.$String((String)"Movie")), fileTypeArray, fileTypeArray[0]);
        }
        if (file != null) {
            this.setFilename_(file);
            this.setMovie_(JunQTMovieFactory.openMovie(this.filename));
        }
    }

    protected void recoverMovie() {
        if (this.filename == null || this.dontRecover) {
            return;
        }
        if (this.filename.exists()) {
            this.setMovie_(JunQTMovieFactory.openMovie(this.filename));
        }
        if (this.movie != null) {
            this.changed_(JunMovieHandle.$((String)"recovered"));
        } else {
            this.dontRecover = true;
        }
    }
}

