/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.smalltalk.StImage;

public class JunPngImageStream
extends JunImageStream {
    public static final String DefaultImageExtension = "png";

    public static JunImageStream On_(InputStream inputStream) throws IOException {
        return JunPngImageStream.On_(JunPngImageStream._CreateImageStream(), inputStream);
    }

    public static JunImageStream On_(OutputStream outputStream) throws IOException {
        return JunPngImageStream.On_(JunPngImageStream._CreateImageStream(), outputStream);
    }

    protected static JunImageStream _CreateImageStream() {
        return new JunPngImageStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage nextImage() throws IOException {
        if (this.inStream == null) {
            throw new IIOException("the inStream is null.");
        }
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            imageReader = ImageIO.getImageReadersBySuffix(this.defaultImageExtension()).next();
            imageInputStream = ImageIO.createImageInputStream(this.inStream);
            imageReader.setInput(imageInputStream);
            this.imageObject = new StImage((Image)imageReader.read(0));
        }
        finally {
            if (imageInputStream != null) {
                imageInputStream.flush();
                imageInputStream.close();
            }
            if (imageReader != null) {
                imageReader.reset();
                imageReader.dispose();
            }
        }
        return this.imageObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextPutImage_(StImage stImage) throws IOException {
        if (this.outStream == null) {
            throw new IIOException("the outStream is null.");
        }
        ImageWriter imageWriter = null;
        ImageInputStream imageInputStream = null;
        try {
            imageWriter = ImageIO.getImageWritersBySuffix(this.defaultImageExtension()).next();
            imageInputStream = ImageIO.createImageOutputStream(this.outStream);
            imageWriter.setOutput(imageInputStream);
            imageWriter.write(stImage.image());
        }
        finally {
            if (imageInputStream != null) {
                imageInputStream.flush();
                imageInputStream.close();
            }
            if (imageWriter != null) {
                imageWriter.reset();
                imageWriter.dispose();
            }
        }
    }

    public String defaultImageExtension() {
        return DefaultImageExtension;
    }
}

