/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.smalltalk.StImage;

public class JunJpegImageStream
extends JunImageStream {
    protected float quality = Float.NaN;
    public static final String DefaultImageExtension = "jpg";

    public static JunImageStream On_(InputStream inputStream) throws IOException {
        return JunJpegImageStream.On_(JunJpegImageStream._CreateImageStream(), inputStream);
    }

    public static JunImageStream On_(OutputStream outputStream) throws IOException {
        return JunJpegImageStream.On_(JunJpegImageStream._CreateImageStream(), outputStream);
    }

    protected static JunImageStream _CreateImageStream() {
        return new JunJpegImageStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage nextImage() throws IOException {
        if (this.inStream == null) {
            throw new IIOException("the inStream is null.");
        }
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            imageReader = ImageIO.getImageReadersBySuffix(this.defaultImageExtension()).next();
            imageInputStream = ImageIO.createImageInputStream(this.inStream);
            imageReader.setInput(imageInputStream);
            this.imageObject = new StImage((Image)imageReader.read(0));
        }
        finally {
            if (imageInputStream != null) {
                imageInputStream.flush();
                imageInputStream.close();
            }
            if (imageReader != null) {
                imageReader.reset();
                imageReader.dispose();
            }
        }
        return this.imageObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextPutImage_(StImage stImage) throws IOException {
        if (this.outStream == null) {
            throw new IIOException("the outStream is null.");
        }
        BufferedImage bufferedImage = new BufferedImage(stImage.width(), stImage.height(), 5);
        bufferedImage.setRGB(0, 0, stImage.width(), stImage.height(), stImage.getPixels(), 0, stImage.width());
        ImageWriter imageWriter = null;
        ImageInputStream imageInputStream = null;
        try {
            imageWriter = ImageIO.getImageWritersBySuffix(this.defaultImageExtension()).next();
            imageInputStream = ImageIO.createImageOutputStream(this.outStream);
            imageWriter.setOutput(imageInputStream);
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            imageWriteParam.setCompressionMode(2);
            if (imageWriteParam.canWriteCompressed() && imageWriteParam.getCompressionQuality() != this.quality()) {
                imageWriteParam.setCompressionQuality(this.quality());
                imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
            } else {
                imageWriter.write(bufferedImage);
            }
        }
        finally {
            if (imageInputStream != null) {
                imageInputStream.flush();
                imageInputStream.close();
            }
            if (imageWriter != null) {
                imageWriter.reset();
                imageWriter.dispose();
            }
        }
    }

    public float quality() {
        if (Float.isNaN(this.quality)) {
            this.quality = this.defaultQuality();
        }
        return this.quality;
    }

    public void quality_(float f) {
        this.quality = Math.min(Math.max(0.0f, f), 1.0f);
    }

    public String defaultImageExtension() {
        return DefaultImageExtension;
    }

    public float defaultQuality() {
        return 0.75f;
    }
}

