/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.framework;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayController;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StViewJPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunImageDisplayViewSwing
extends JunAbstractViewJPanel
implements JunImageDisplayView {
    protected boolean _scrollable;
    protected StViewJPanel canvas;
    protected JScrollPane scrollPane;

    public JunImageDisplayViewSwing() {
    }

    public JunImageDisplayViewSwing(JunImageDisplayModel junImageDisplayModel) {
        super(junImageDisplayModel);
    }

    protected void initialize() {
        super.initialize();
        this.canvas = null;
        this.scrollPane = null;
        this._scrollable(false);
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add(this.scrollPane(), WindowSpecLayout.Position((float)0.0f, (int)0, (float)0.0f, (int)0, (float)1.0f, (int)0, (float)1.0f, (int)0));
        Dimension dimension = this.getModel().bounds().getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        dimension2.setSize(dimension2.width - 100, dimension2.height - 120);
        Insets insets = this.scrollPane().getInsets();
        if (dimension.width > dimension2.width || dimension.height > dimension2.height) {
            this._scrollable(true);
            this.setPreferredSize(new Dimension(Math.min(dimension.width, dimension2.width) + insets.left + insets.right, Math.min(dimension.height, dimension2.height) + insets.top + insets.bottom));
        } else {
            this._scrollable(false);
            this.setPreferredSize(new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom));
        }
    }

    public boolean _isScrollable() {
        return this._scrollable;
    }

    public void _scrollable(boolean bl) {
        this._scrollable = bl;
        if (this._scrollable) {
            this.scrollPane().setVerticalScrollBarPolicy(22);
            this.scrollPane().setHorizontalScrollBarPolicy(32);
        } else {
            this.scrollPane().setVerticalScrollBarPolicy(21);
            this.scrollPane().setHorizontalScrollBarPolicy(31);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.doLayout();
        this.scrollPane().doLayout();
    }

    public Dimension getPreferredSize() {
        Point point = this.scrollPane().getLocation();
        Dimension dimension = this.scrollPane().getPreferredSize();
        return new Dimension(dimension.width + point.x * 2, dimension.height + point.y * 2);
    }

    public Rectangle _getViewportBounds() {
        return this.scrollPane().getViewport().getViewRect();
    }

    protected StController defaultController() {
        return new JunImageDisplayController();
    }

    public JunImageDisplayModel getModel() {
        return (JunImageDisplayModel)this.model();
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.topComponent().isShowing()) {
            return;
        }
        if (dependentEvent.getAspect() == JunImageDisplayViewSwing.$((String)"redisplay")) {
            this.canvas().repaint();
        } else {
            super.update_(dependentEvent);
        }
    }

    public StViewJPanel canvas() {
        if (this.canvas == null) {
            this.canvas = new StViewJPanel(){

                public StModel model() {
                    return JunImageDisplayViewSwing.this.model();
                }

                public Dimension getPreferredSize() {
                    if (JunImageDisplayViewSwing.this._isScrollable()) {
                        return JunImageDisplayViewSwing.this.getModel() == null ? Toolkit.getDefaultToolkit().getScreenSize() : JunImageDisplayViewSwing.this.getModel().bounds().getSize();
                    }
                    return super.getPreferredSize();
                }

                public void displayOn_(Graphics graphics) {
                    if (JunImageDisplayViewSwing.this.getModel().displayImage() == null) {
                        return;
                    }
                    JunImageDisplayViewSwing.this.getModel().displayImage().displayOn_(graphics);
                }

                public void _showPopupMenu(int n, int n2) {
                    JPopupMenu jPopupMenu = JunImageDisplayViewSwing.this.popupMenuView();
                    if (jPopupMenu != null) {
                        jPopupMenu.show((Component)((Object)this), n, n2);
                    }
                }
            };
        }
        return this.canvas;
    }

    public Component _canvasComponent() {
        return this.canvas().toComponent();
    }

    public JScrollPane scrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane((Component)this.canvas()){

                public Dimension getPreferredSize() {
                    Dimension dimension = JunImageDisplayViewSwing.this.getModel().bounds().getSize();
                    Insets insets = this.getInsets();
                    return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
                }
            };
            this.scrollPane.getHorizontalScrollBar().setFocusable(false);
            this.scrollPane.getVerticalScrollBar().setFocusable(false);
        }
        return this.scrollPane;
    }
}

