/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.gauge;

import java.awt.Color;
import jp.co.sra.jun.goodies.gauge.JunLevelGaugeViewAwt;
import jp.co.sra.jun.goodies.gauge.JunLevelGaugeViewSwing;
import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StView;

public class JunLevelGaugeModel
extends JunApplicationModel
implements StBlockValued {
    protected double value;
    protected double hill;
    protected double dale;
    protected int count;
    protected double average;
    protected double offset;
    protected double maximum;
    protected double minimum;
    protected JunAttributeTable attributes;

    public static JunLevelGaugeModel Initial_(double d) {
        return JunLevelGaugeModel.Initial_maximum_minimum_(d, Double.NaN, Double.NaN);
    }

    public static JunLevelGaugeModel Initial_maximum_minimum_(double d, double d2, double d3) {
        JunLevelGaugeModel junLevelGaugeModel = new JunLevelGaugeModel();
        junLevelGaugeModel.maximum_(d2);
        junLevelGaugeModel.minimum_(d3);
        junLevelGaugeModel.initial_(d);
        return junLevelGaugeModel;
    }

    public static JunLevelGaugeModel Value_(double d) {
        return JunLevelGaugeModel.Value_maximum_minimum_(d, Double.NaN, Double.NaN);
    }

    public static JunLevelGaugeModel Value_maximum_minimum_(double d, double d2, double d3) {
        JunLevelGaugeModel junLevelGaugeModel = new JunLevelGaugeModel();
        junLevelGaugeModel.maximum_(d2);
        junLevelGaugeModel.minimum_(d3);
        junLevelGaugeModel.value_(d);
        return junLevelGaugeModel;
    }

    protected void initialize() {
        super.initialize();
        this.reset();
        this.maximum = Double.NaN;
        this.minimum = Double.NaN;
        this.attributes = new JunAttributeTable();
    }

    public JunAttributeTable attributes() {
        return this.attributes;
    }

    public double average() {
        return this.average;
    }

    public int count() {
        return this.count;
    }

    public double dale() {
        return this.dale;
    }

    public double hill() {
        return this.hill;
    }

    public double maximum() {
        return this.maximum;
    }

    public void maximum_(double d) {
        this.maximum = d;
    }

    public double middle() {
        return this.minimum() + (this.maximum() - this.minimum()) / 2.0;
    }

    public double minimum() {
        return this.minimum;
    }

    public void minimum_(double d) {
        this.minimum = d;
    }

    public double range() {
        return this.maximum() - this.minimum();
    }

    public double total() {
        return Math.round(this.average() * (double)this.count());
    }

    public Object value() {
        return new Double(this.value);
    }

    public void value_(double d) {
        this.value = d - this.offset;
        if (!Double.isNaN(this.maximum())) {
            this.value = Math.min(this.value, this.maximum());
        }
        if (!Double.isNaN(this.minimum())) {
            this.value = Math.max(this.value, this.minimum());
        }
        this.hill = Double.isNaN(this.hill()) ? this.value : Math.max(this.value, this.hill());
        this.dale = Double.isNaN(this.dale()) ? this.value : Math.min(this.value, this.dale());
        this.average = (this.total() + this.value) / (double)(++this.count);
        this.changed_(JunLevelGaugeModel.$((String)"value"));
    }

    public double _doubleValue() {
        return this.value;
    }

    public long _longValue() {
        return Math.round(this.value);
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this);
    }

    protected void initial_(double d) {
        this.offset_(d);
        this.value_(d);
    }

    public double offset() {
        return this.offset;
    }

    public void offset_(double d) {
        this.offset = d;
    }

    public void reset() {
        this.value = Double.NaN;
        this.hill = Double.NaN;
        this.dale = Double.NaN;
        this.count = 0;
        this.average = Double.NaN;
        this.offset = 0.0;
    }

    public void resetDale() {
        this.dale = this._doubleValue();
    }

    public void resetHill() {
        this.hill = this._doubleValue();
    }

    public void resume_(double d) {
        this.offset_(d - this._doubleValue());
    }

    public StView defaultView() {
        if (JunLevelGaugeModel.GetDefaultViewMode() == 0) {
            return new JunLevelGaugeViewAwt(this);
        }
        return new JunLevelGaugeViewSwing(this);
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Level Gauge");
    }

    public Color averageColor() {
        Color color = (Color)this.attributes().at_(JunLevelGaugeModel.$((String)"averageColor"));
        if (color == null) {
            color = Color.green;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"averageColor"), color);
        }
        return color;
    }

    public void averageColor_(Color color) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"averageColor"), color);
    }

    public Color backgroundColor() {
        Color color = (Color)this.attributes().at_(JunLevelGaugeModel.$((String)"backgroundColor"));
        if (color == null) {
            color = StColorValue.VeryLightGray;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"backgroundColor"), color);
        }
        return color;
    }

    public void backgroundColor_(Color color) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"backgroundColor"), color);
    }

    public int cellSize() {
        Integer n = (Integer)this.attributes().at_(JunLevelGaugeModel.$((String)"cellSize"));
        if (n == null) {
            n = new Integer(5);
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"cellSize"), n);
        }
        return n;
    }

    public void cellSize_(int n) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"cellSize"), new Integer(Math.max(n, 3)));
    }

    public int cellSpace() {
        Integer n = (Integer)this.attributes().at_(JunLevelGaugeModel.$((String)"cellSpace"));
        if (n == null) {
            n = new Integer(1);
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"cellSpace"), n);
        }
        return n;
    }

    public void cellSpace_(int n) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"cellSpace"), new Integer(Math.max(n, 0)));
    }

    public Color daleColor() {
        Color color = (Color)this.attributes().at_(JunLevelGaugeModel.$((String)"daleColor"));
        if (color == null) {
            color = Color.blue;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"daleColor"), color);
        }
        return color;
    }

    public void daleColor_(Color color) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"daleColor"), color);
    }

    public Color edgeColor() {
        Color color = (Color)this.attributes().at_(JunLevelGaugeModel.$((String)"edgeColor"));
        if (color == null) {
            color = Color.white;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"edgeColor"), color);
        }
        return color;
    }

    public void edgeColor_(Color color) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"edgeColor"), color);
    }

    public Color frameColor() {
        Color color = (Color)this.attributes().at_(JunLevelGaugeModel.$((String)"frameColor"));
        if (color == null) {
            color = StColorValue.LightGray;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"frameColor"), color);
        }
        return color;
    }

    public void frameColor_(Color color) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"frameColor"), color);
    }

    public int gaugeWidth() {
        Integer n = (Integer)this.attributes().at_(JunLevelGaugeModel.$((String)"gaugeWidth"));
        if (n == null) {
            n = new Integer(16);
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"gaugeWidth"), n);
        }
        return n;
    }

    public void gaugeWidth_(int n) {
        int n2 = Math.round((float)n / 2.0f) * 2;
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"gaugeWidth"), new Integer(Math.max(n2, 2)));
    }

    public Color hillColor() {
        Color color = (Color)this.attributes().at_(JunLevelGaugeModel.$((String)"hillColor"));
        if (color == null) {
            color = Color.red;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"hillColor"), color);
        }
        return color;
    }

    public void hillColor_(Color color) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"hillColor"), color);
    }

    public boolean horizontalGauge() {
        return !this.verticalGauge();
    }

    public void horizontalGauge_(boolean bl) {
        this.verticalGauge_(!bl);
    }

    public boolean rainbowColor() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"rainbowColor"));
        if (bl == null) {
            bl = Boolean.FALSE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"rainbowColor"), bl);
        }
        return bl;
    }

    public void rainbowColor_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"rainbowColor"), new Boolean(bl));
    }

    public boolean reverseDirection() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"reverseDirection"));
        if (bl == null) {
            bl = Boolean.FALSE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"reverseDirection"), bl);
        }
        return bl;
    }

    public void reverseDirection_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"reverseDirection"), new Boolean(bl));
    }

    public boolean showAverage() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"showAverage"));
        if (bl == null) {
            bl = Boolean.TRUE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"showAverage"), bl);
        }
        return bl;
    }

    public void showAverage_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"showAverage"), new Boolean(bl));
    }

    public boolean showBackground() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"showBackground"));
        if (bl == null) {
            bl = Boolean.TRUE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"showBackground"), bl);
        }
        return bl;
    }

    public void showBackground_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"showBackground"), new Boolean(bl));
    }

    public boolean showDale() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"showDale"));
        if (bl == null) {
            bl = Boolean.TRUE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"showDale"), bl);
        }
        return bl;
    }

    public void showDale_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"showDale"), new Boolean(bl));
    }

    public boolean showEdge() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"showEdge"));
        if (bl == null) {
            bl = Boolean.FALSE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"showEdge"), bl);
        }
        return bl;
    }

    public void showEdge_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"showEdge"), new Boolean(bl));
    }

    public boolean showFrame() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"showFrame"));
        if (bl == null) {
            bl = Boolean.TRUE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"showFrame"), bl);
        }
        return bl;
    }

    public void showFrame_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"showFrame"), new Boolean(bl));
    }

    public boolean showHill() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"showHill"));
        if (bl == null) {
            bl = Boolean.TRUE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"showHill"), bl);
        }
        return bl;
    }

    public void showHill_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"showHill"), new Boolean(bl));
    }

    public boolean showValue() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"showValue"));
        if (bl == null) {
            bl = Boolean.TRUE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"showValue"), bl);
        }
        return bl;
    }

    public void showValue_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"showValue"), new Boolean(bl));
    }

    public Color valueColor() {
        Color color = (Color)this.attributes().at_(JunLevelGaugeModel.$((String)"valueColor"));
        if (color == null) {
            color = StColorValue.DarkGray;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"valueColor"), color);
        }
        return color;
    }

    public void valueColor_(Color color) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"valueColor"), color);
    }

    public boolean verticalGauge() {
        Boolean bl = (Boolean)this.attributes().at_(JunLevelGaugeModel.$((String)"verticalGauge"));
        if (bl == null) {
            bl = Boolean.TRUE;
            this.attributes().at_put_(JunLevelGaugeModel.$((String)"verticalGauge"), bl);
        }
        return bl;
    }

    public void verticalGauge_(boolean bl) {
        this.attributes().at_put_(JunLevelGaugeModel.$((String)"verticalGauge"), new Boolean(bl));
    }
}

