/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.gauge;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import jp.co.sra.jun.goodies.gauge.JunGaugeViewAwt;
import jp.co.sra.jun.goodies.gauge.JunGaugeViewSwing;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StView;

public class JunGaugeModel
extends JunApplicationModel
implements StBlockValued {
    protected double gaugeValue;
    protected double[] gaugeRange;
    protected StBlockClosure valueStringBlock;

    public JunGaugeModel() {
    }

    public JunGaugeModel(double d) {
        this(d, null);
    }

    public JunGaugeModel(double d, double[] dArray) {
        this.range_(dArray);
        this.value_(d);
    }

    public JunGaugeModel(double d, double d2, double d3, double d4) {
        this(d, new double[]{d2, d3, 10.0, d4});
    }

    protected void initialize() {
        super.initialize();
        this.gaugeValue = Double.NaN;
        this.gaugeRange = null;
        this.valueStringBlock = null;
    }

    public Object value() {
        return new Double(this._doubleValue());
    }

    public double _doubleValue() {
        double d;
        if (Double.isNaN(this.gaugeValue)) {
            this.gaugeValue = this.defaultGaugeValue();
        }
        if ((d = this.roundValue()) >= 1.0) {
            return (double)Math.round((this.fromValue() + this.gaugeValue * (this.toValue() - this.fromValue())) / d) * d;
        }
        d = 1.0 / d;
        return (double)Math.round((this.fromValue() + this.gaugeValue * (this.toValue() - this.fromValue())) * d) / d;
    }

    public void value_(double d) {
        d = (d - this.fromValue()) / (this.toValue() - this.fromValue());
        d = Math.max(0.0, Math.min(d, 1.0));
        if (this.normalizedValue() != d) {
            this.gaugeValue = d;
            this.changed_(JunGaugeModel.$((String)"value"));
        }
    }

    public double[] range() {
        if (this.gaugeRange == null) {
            this.gaugeRange = this.defaultGaugeRange();
        }
        return this.gaugeRange;
    }

    public void range_(double[] dArray) {
        this.gaugeRange = dArray;
        this.changed_(JunGaugeModel.$((String)"range"));
    }

    public double fromValue() {
        return this.range()[0];
    }

    public void fromValue_(double d) {
        if (this.fromValue() != d) {
            double[] dArray = this.range();
            dArray[0] = d;
            this.range_(dArray);
        }
    }

    public double toValue() {
        return this.range()[1];
    }

    public void toValue_(double d) {
        if (this.toValue() != d) {
            double[] dArray = this.range();
            dArray[1] = d;
            this.range_(dArray);
        }
    }

    public double divideValue() {
        return this.range()[2];
    }

    public void divideValue_(double d) {
        if (this.divideValue() != d) {
            double[] dArray = this.range();
            dArray[2] = d;
            this.range_(dArray);
        }
    }

    public double roundValue() {
        return this.range()[3];
    }

    public void roundValue_(double d) {
        if (this.roundValue() != d) {
            double[] dArray = this.range();
            dArray[3] = d;
            this.range_(dArray);
        }
    }

    public double normalizedValue() {
        return (this._doubleValue() - this.fromValue()) / (this.toValue() - this.fromValue());
    }

    public void normalizedValue_(double d) {
        d = Math.max(0.0, Math.min(d, 1.0));
        double d2 = (double)Math.round((this.fromValue() + d * (this.toValue() - this.fromValue())) / this.roundValue()) * this.roundValue();
        this.value_(d2);
    }

    public double stepValue() {
        double d = this.roundValue();
        if (this.fromValue() > this.toValue()) {
            d *= -1.0;
        }
        return d;
    }

    public StBlockClosure valueStringBlock() {
        if (this.valueStringBlock == null) {
            this.valueStringBlock = this.defaultValueStringBlock();
        }
        return this.valueStringBlock;
    }

    public void valueStringBlock_(StBlockClosure stBlockClosure) {
        this.valueStringBlock = stBlockClosure;
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this);
    }

    public KeyListener _keyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (JunGaugeModel.this._keyboardEvent(keyEvent)) {
                    keyEvent.consume();
                }
            }
        };
    }

    protected boolean _keyboardEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 37: 
            case 40: {
                this.value_(this._doubleValue() - this.stepValue());
                return true;
            }
            case 38: 
            case 39: {
                this.value_(this._doubleValue() + this.stepValue());
                return true;
            }
        }
        return false;
    }

    public void printOn_(Writer writer) throws IOException {
        super.printOn_(writer);
        writer.write(" on: " + this.value());
    }

    public StView defaultView() {
        if (JunGaugeModel.GetDefaultViewMode() == 0) {
            return JunGaugeViewAwt._OnBorderedPanel(this);
        }
        return JunGaugeViewSwing._OnBorderedPanel(this);
    }

    protected double defaultGaugeValue() {
        return 0.0;
    }

    protected double[] defaultGaugeRange() {
        return new double[]{this.defaultFromValue(), this.defaultToValue(), this.defaultDivideValue(), this.defaultRoundValue()};
    }

    protected double defaultFromValue() {
        return 0.0;
    }

    protected double defaultToValue() {
        return 100.0;
    }

    protected double defaultDivideValue() {
        return 10.0;
    }

    protected double defaultRoundValue() {
        return 1.0;
    }

    protected StBlockClosure defaultValueStringBlock() {
        return new StBlockClosure(){

            public Object value_(Object object) {
                return JunGaugeModel.this.formatValueString_(((Number)object).doubleValue());
            }
        };
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Gauge");
    }

    protected String formatValueString_(double d) {
        String string = "0";
        if (this.roundValue() < 1.0) {
            string = string + '.';
            int n = (int)Math.round(Math.log(this.roundValue()) / Math.log(10.0) * -1.0);
            for (int i = 0; i < n; ++i) {
                string = string + '0';
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }
}

