/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.font;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.co.sra.jun.goodies.display.JunDisplayViewSwing;
import jp.co.sra.jun.goodies.font.JunFontModel;
import jp.co.sra.jun.goodies.font.JunFontView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunFontViewSwing
extends JunAbstractViewJPanel
implements JunFontView {
    protected JunDisplayViewSwing displayView;
    protected JList fontNameList;
    protected JScrollPane fontNameScrollPane;
    protected JList fontSizeList;
    protected JScrollPane fontSizeScrollPane;

    public JunFontViewSwing(JunFontModel junFontModel) {
        super(junFontModel);
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add((Component)((Object)this.displayView()), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)1, (float)1.0f, (int)-1, (float)0.0f, (int)79));
        this.add(this.fontNameScrollPane(), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)80, (float)0.7f, (int)-1, (float)1.0f, (int)-1));
        this.add(this.fontSizeScrollPane(), WindowSpecLayout.Position((float)0.7f, (int)0, (float)0.0f, (int)80, (float)1.0f, (int)-1, (float)1.0f, (int)-1));
        this.setPreferredSize(new Dimension(350, 250));
    }

    public void addNotify() {
        super.addNotify();
        this.topComponent().addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                super.windowOpened(windowEvent);
                JunFontViewSwing.this.updateFontNameList();
                JunFontViewSwing.this.updateFontSizeList();
            }
        });
    }

    public JunFontModel getFontModel() {
        return (JunFontModel)this.model();
    }

    protected JunDisplayViewSwing displayView() {
        if (this.displayView == null) {
            this.displayView = new JunDisplayViewSwing(this.getFontModel().displayModel());
        }
        return this.displayView;
    }

    protected JList fontNameList() {
        if (this.fontNameList == null) {
            this.fontNameList = new JList(new DefaultListModel());
            this.fontNameList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    JunFontViewSwing.this.getFontModel().setFontNameIndex(JunFontViewSwing.this.fontNameList.getSelectedIndex());
                }
            });
        }
        return this.fontNameList;
    }

    protected JScrollPane fontNameScrollPane() {
        if (this.fontNameScrollPane == null) {
            this.fontNameScrollPane = new JScrollPane(this.fontNameList(), 20, 30);
        }
        return this.fontNameScrollPane;
    }

    protected JList fontSizeList() {
        if (this.fontSizeList == null) {
            this.fontSizeList = new JList(new DefaultListModel());
            this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    JunFontViewSwing.this.getFontModel().setFontSizeIndex(JunFontViewSwing.this.fontSizeList.getSelectedIndex());
                }
            });
        }
        return this.fontSizeList;
    }

    protected JScrollPane fontSizeScrollPane() {
        if (this.fontSizeScrollPane == null) {
            this.fontSizeScrollPane = new JScrollPane(this.fontSizeList(), 20, 30);
        }
        return this.fontSizeScrollPane;
    }

    protected void updateFontNameList() {
        int n;
        DefaultListModel defaultListModel = (DefaultListModel)this.fontNameList().getModel();
        defaultListModel.clear();
        String[] stringArray = this.getFontModel().fontNames();
        for (n = 0; n < stringArray.length; ++n) {
            defaultListModel.add(n, stringArray[n]);
        }
        n = this.getFontModel().getFontNameIndex();
        if (n >= 0) {
            this.fontNameList().setSelectedIndex(n);
            this.fontNameList().ensureIndexIsVisible(n);
        }
    }

    protected void updateFontSizeList() {
        int n;
        DefaultListModel defaultListModel = (DefaultListModel)this.fontSizeList().getModel();
        defaultListModel.clear();
        int[] nArray = this.getFontModel().fontSizes();
        for (n = 0; n < nArray.length; ++n) {
            defaultListModel.add(n, String.valueOf(nArray[n]));
        }
        n = this.getFontModel().getFontSizeIndex();
        if (n >= 0) {
            this.fontSizeList().setSelectedIndex(n);
            this.fontSizeList().ensureIndexIsVisible(n);
        }
    }
}

