/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.font;

import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.PrintWriter;
import java.io.StringWriter;
import jp.co.sra.jun.goodies.display.JunEmbeddedDisplayModel;
import jp.co.sra.jun.goodies.font.JunFontViewAwt;
import jp.co.sra.jun.goodies.font.JunFontViewSwing;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StView;

public class JunFontModel
extends JunApplicationModel {
    public static final int DefaultTextStyleHeight = 72;
    protected static final String TextStyleString = "abcdefghijklmnopqrstuvwxyz";
    protected JunEmbeddedDisplayModel displayModel;
    protected String[] fontNames;
    protected String fontName;
    protected int[] fontSizes;
    protected int fontSize;

    public static Font TextStyle() {
        return JunFontModel.TextStyle(72.0f);
    }

    public static Font TextStyle(float f) {
        StComposedText stComposedText;
        Font font = null;
        Font font2 = StComposedText.DefaultFont();
        int n = 256;
        for (int i = 1; i <= n && !((float)(stComposedText = new StComposedText(TextStyleString, font = font2.deriveFont((float)i))).height() > f); ++i) {
        }
        return font;
    }

    protected void initialize() {
        super.initialize();
        this.fontName = null;
        this.fontSize = 0;
    }

    public JunEmbeddedDisplayModel displayModel() {
        if (this.displayModel == null) {
            this.displayModel = new JunEmbeddedDisplayModel();
        }
        return this.displayModel;
    }

    public String[] fontNames() {
        if (this.fontNames == null) {
            Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            this.fontNames = new String[fontArray.length];
            for (int i = 0; i < fontArray.length; ++i) {
                this.fontNames[i] = fontArray[i].getFontName();
            }
        }
        return this.fontNames;
    }

    public String fontName() {
        if (this.fontName == null) {
            this.fontName = this.defaultFontName();
        }
        return this.fontName;
    }

    public void fontName_(String string) {
        this.fontName = string;
    }

    public int[] fontSizes() {
        if (this.fontSizes == null) {
            this.fontSizes = this.defaultFontSizes();
        }
        return this.fontSizes;
    }

    public int fontSize() {
        if (this.fontSize <= 0) {
            this.fontSize = this.defaultFontSize();
        }
        return this.fontSize;
    }

    public void fontSize_(int n) {
        this.fontSize = n;
    }

    public Font getFont() {
        return new Font(this.fontName(), 0, this.fontSize());
    }

    protected String defaultFontName() {
        return "Dialog";
    }

    protected int defaultFontSize() {
        return 12;
    }

    protected int[] defaultFontSizes() {
        return new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String defaultText() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            printWriter.print("abcdefghijklmnopqrstuvwxyz 0123456789_~!\"'|\\,");
            printWriter.println();
            printWriter.print("ABCDEFGHIJKLMNOPQRSTUVWXYZ +-*/=<>{}()#$%&@^.");
            printWriter.println();
            printWriter.print(JunFontModel.$String((String)"AIUEO", (String)""));
        }
        finally {
            printWriter.flush();
            printWriter.close();
        }
        return stringWriter.toString();
    }

    public StView defaultView() {
        if (JunFontModel.GetDefaultViewMode() == 0) {
            return new JunFontViewAwt(this);
        }
        return new JunFontViewSwing(this);
    }

    protected String windowTitle() {
        return JunFontModel.$String((String)"Font Model");
    }

    protected Frame allButOpenView_(StView stView) {
        Frame frame = super.allButOpenView_(stView);
        this.updateVisualObject();
        return frame;
    }

    protected void updateVisualObject() {
        this.displayModel().visual_(new StComposedText(this.defaultText(), this.getFont()));
    }

    protected int getFontNameIndex() {
        int n = -1;
        String string = this.fontName();
        String[] stringArray = this.fontNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    protected void setFontNameIndex(int n) {
        this.fontName = this.fontNames()[n];
        this.updateVisualObject();
    }

    protected int getFontSizeIndex() {
        int n = -1;
        int n2 = this.fontSize();
        int[] nArray = this.fontSizes();
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 != nArray[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    protected void setFontSizeIndex(int n) {
        this.fontSize = this.fontSizes()[n];
        this.updateVisualObject();
    }
}

