/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.files;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.files.JunFileView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunFileViewSwing
extends JunAbstractViewJPanel
implements JunFileView {
    protected JLabel fileLabel;
    protected JTextField fileName;
    protected JList fileList;
    protected JScrollPane fileListPane;
    protected JLabel fileTypeLabel;
    protected JComboBox fileType;
    protected JLabel directoryLabel;
    protected JLabel currentDirectoryLabel;
    protected JList directoryList;
    protected JScrollPane directoryListPane;
    protected JLabel driveLabel;
    protected JComboBox currentDrive;
    protected boolean doNotPropagateFileTypeChange = false;
    protected boolean doNotPropagateCurrentDriveChange = false;

    public JunFileViewSwing(JunFileModel junFileModel) {
        super(junFileModel);
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add(this.fileLabel(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)0.0f, (int)4));
        this.add(this.fileName(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)0.0f, (int)32, (float)0.5f, (int)-4, (float)0.0f, (int)60));
        this.add(this.fileListPane(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)0.0f, (int)68, (float)0.5f, (int)-4, (float)1.0f, (int)-72));
        this.add(this.fileTypeLabel(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)1.0f, (int)-62));
        this.add(this.fileType(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)1.0f, (int)-36, (float)0.5f, (int)-4, (float)1.0f, (int)-8));
        this.add(this.directoryLabel(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)0.0f, (int)4));
        this.add(this.currentDirectoryLabel(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)0.0f, (int)32, (float)1.0f, (int)-8, (float)0.0f, (int)60));
        this.add(this.directoryListPane(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)0.0f, (int)68, (float)1.0f, (int)-8, (float)1.0f, (int)-72));
        this.add(this.driveLabel(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)1.0f, (int)-62));
        this.add(this.currentDrive(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)1.0f, (int)-36, (float)1.0f, (int)-8, (float)1.0f, (int)-8));
        this.setPreferredSize(new Dimension(500, 300));
        this.getFileModel().currentDirectory();
        this.getFileModel().updateCurrentDirectoryLabel();
        this.getFileModel().updateDirectoryAndFileList();
        this.getFileModel().updateCurrentDrive();
    }

    public JunFileModel getFileModel() {
        return (JunFileModel)this.model();
    }

    protected JLabel currentDirectoryLabel() {
        if (this.currentDirectoryLabel == null) {
            this.currentDirectoryLabel = new JLabel();
            this.getFileModel().currentDirectoryLabel().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileViewSwing.this.currentDirectoryLabel.setText((String)object);
                    return null;
                }
            });
        }
        return this.currentDirectoryLabel;
    }

    protected JComboBox currentDrive() {
        if (this.currentDrive == null) {
            this.currentDrive = new JComboBox();
            this.currentDrive.setLightWeightPopupEnabled(false);
            File[] fileArray = this.getFileModel().drives();
            for (int i = 0; i < fileArray.length; ++i) {
                this.currentDrive.addItem(fileArray[i].getPath().toUpperCase());
            }
            this.getFileModel();
            this.currentDrive.addItem(JunFileModel.DefaultDirectoryItem);
            this.currentDrive.setSelectedItem(((File)this.getFileModel().currentDrive().value()).getPath().toUpperCase());
            this.currentDrive.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (JunFileViewSwing.this.doNotPropagateCurrentDriveChange) {
                        return;
                    }
                    if (itemEvent.getStateChange() == 1) {
                        JunFileViewSwing.this.getFileModel().currentDriveChanged((String)JunFileViewSwing.this.currentDrive.getSelectedItem());
                    }
                }
            });
            this.getFileModel().currentDrive().compute_(new StBlockClosure(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object value_(Object object) {
                    String string = ((File)object).getPath().toUpperCase();
                    if (!string.equals(JunFileViewSwing.this.currentDrive.getSelectedItem())) {
                        JunFileViewSwing.this.doNotPropagateCurrentDriveChange = true;
                        try {
                            JunFileViewSwing.this.currentDrive.setSelectedItem(string);
                        }
                        finally {
                            JunFileViewSwing.this.doNotPropagateCurrentDriveChange = false;
                        }
                    }
                    return null;
                }
            });
        }
        return this.currentDrive;
    }

    protected JLabel directoryLabel() {
        if (this.directoryLabel == null) {
            this.directoryLabel = new BoldLabel(JunSystem.$String((String)"Directory") + ":");
        }
        return this.directoryLabel;
    }

    protected JList directoryList() {
        if (this.directoryList == null) {
            this.directoryList = new JList(new DefaultListModel());
            this.directoryList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = JunFileViewSwing.this.directoryList.locationToIndex(mouseEvent.getPoint());
                        JunFileViewSwing.this.getFileModel().directoryListDoubleClicked(n, (String)JunFileViewSwing.this.directoryList.getModel().getElementAt(n));
                    }
                }
            });
            this.getFileModel().directoryList().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    Object[] objectArray = (Object[])object;
                    int n = JunFileViewSwing.this.getFileModel().currentDirectoryLevel();
                    String string = "";
                    DefaultListModel defaultListModel = (DefaultListModel)JunFileViewSwing.this.directoryList.getModel();
                    defaultListModel.removeAllElements();
                    for (int i = 0; i < objectArray.length; ++i) {
                        defaultListModel.addElement(string + objectArray[i]);
                        if (i >= n) continue;
                        string = string + "  ";
                    }
                    return null;
                }
            });
        }
        return this.directoryList;
    }

    protected JScrollPane directoryListPane() {
        if (this.directoryListPane == null) {
            this.directoryListPane = new JScrollPane(this.directoryList());
        }
        return this.directoryListPane;
    }

    protected JLabel driveLabel() {
        if (this.driveLabel == null) {
            this.driveLabel = new BoldLabel(JunSystem.$String((String)"Drive") + ":");
        }
        return this.driveLabel;
    }

    protected JLabel fileLabel() {
        if (this.fileLabel == null) {
            this.fileLabel = new BoldLabel(JunSystem.$String((String)"File") + ":");
        }
        return this.fileLabel;
    }

    protected JList fileList() {
        if (this.fileList == null) {
            this.fileList = new JList(new DefaultListModel());
            this.fileList.setSelectionMode(0);
            this.fileList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    if (JunFileViewSwing.this.fileList.isSelectionEmpty()) {
                        return;
                    }
                    JunFileViewSwing.this.getFileModel().fileListChanged((String)JunFileViewSwing.this.fileList.getSelectedValue());
                }
            });
            this.getFileModel().fileList().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    Object[] objectArray = (Object[])object;
                    DefaultListModel defaultListModel = (DefaultListModel)JunFileViewSwing.this.fileList.getModel();
                    defaultListModel.clear();
                    for (int i = 0; i < objectArray.length; ++i) {
                        defaultListModel.addElement(objectArray[i]);
                    }
                    return null;
                }
            });
            this.getFileModel().fileName().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileViewSwing.this.fileList.setSelectedValue(object, true);
                    return null;
                }
            });
        }
        return this.fileList;
    }

    protected JScrollPane fileListPane() {
        if (this.fileListPane == null) {
            this.fileListPane = new JScrollPane(this.fileList());
        }
        return this.fileListPane;
    }

    protected JTextField fileName() {
        if (this.fileName == null) {
            this.fileName = new JTextField();
            this.fileName.setText((String)this.getFileModel().fileName().value());
            this.fileName.selectAll();
            this.fileName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!JunFileViewSwing.this.fileName.getText().equals(JunFileViewSwing.this.getFileModel().fileName())) {
                        JunFileViewSwing.this.getFileModel().fileNameChanged(JunFileViewSwing.this.fileName.getText());
                    }
                }
            });
            this.fileName.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    if (!JunFileViewSwing.this.fileName.getText().equals(JunFileViewSwing.this.getFileModel().fileName())) {
                        JunFileViewSwing.this.getFileModel().fileNameChanged(JunFileViewSwing.this.fileName.getText());
                    }
                }
            });
            this.getFileModel().fileName().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileViewSwing.this.fileName.setText((String)object);
                    return null;
                }
            });
        }
        return this.fileName;
    }

    protected JComboBox fileType() {
        if (this.fileType == null) {
            this.fileType = new JComboBox();
            this.fileType.setLightWeightPopupEnabled(false);
            JunFileModel.FileType[] fileTypeArray = this.getFileModel().fileTypes();
            for (int i = 0; i < fileTypeArray.length; ++i) {
                this.fileType.addItem(fileTypeArray[i].name());
            }
            this.fileType.setSelectedItem(((JunFileModel.FileType)this.getFileModel().fileType().value()).name());
            this.fileType.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (JunFileViewSwing.this.doNotPropagateFileTypeChange) {
                        return;
                    }
                    if (itemEvent.getStateChange() == 1) {
                        JunFileViewSwing.this.getFileModel().fileTypeChanged(JunFileViewSwing.this.fileType.getSelectedIndex());
                    }
                }
            });
            this.getFileModel().fileType().compute_(new StBlockClosure(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object value_(Object object) {
                    String string = ((JunFileModel.FileType)object).name();
                    if (!string.equals(JunFileViewSwing.this.fileType.getSelectedItem())) {
                        JunFileViewSwing.this.doNotPropagateFileTypeChange = true;
                        try {
                            JunFileViewSwing.this.fileType.setSelectedItem(((JunFileModel.FileType)object).name());
                        }
                        finally {
                            JunFileViewSwing.this.doNotPropagateFileTypeChange = false;
                        }
                    }
                    return null;
                }
            });
        }
        return this.fileType;
    }

    protected JLabel fileTypeLabel() {
        if (this.fileTypeLabel == null) {
            this.fileTypeLabel = new BoldLabel(JunSystem.$String((String)"File Type") + ":");
        }
        return this.fileTypeLabel;
    }

    class BoldLabel
    extends JLabel {
        public BoldLabel(String string) {
            super(string);
        }

        public void addNotify() {
            super.addNotify();
            this.setFont(this.getFont().deriveFont(1));
        }
    }
}

