/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.files;

import java.awt.Cursor;
import java.awt.Image;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileViewAwt;
import jp.co.sra.jun.goodies.files.JunFileViewSwing;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.SystemResourceSupport;

public class JunFileModel
extends JunApplicationModel
implements StBlockValued {
    protected static final String DefaultDirectoryItem = JunSystem.$String((String)"Default directory");
    private static Image ClosedFolderIcon = null;
    private static Image DeviceIcon = null;
    private static Image OpenedFolderIcon = null;
    protected StValueHolder fileName;
    protected StValueHolder fileList;
    protected StValueHolder fileType;
    protected FileType[] fileTypes;
    protected File currentDirectory;
    protected StValueHolder currentDirectoryLabel;
    protected int currentDirectoryLevel;
    protected StValueHolder directoryList;
    protected StValueHolder currentDrive;
    protected File[] drives;

    public static File DefaultDirectory() {
        return new File(System.getProperty("user.dir"));
    }

    public static Image ClosedFolderIcon() {
        if (ClosedFolderIcon == null) {
            ClosedFolderIcon = SystemResourceSupport.createImage((String)"/jp/co/sra/jun/goodies/files/closedFolderIcon.png");
        }
        return ClosedFolderIcon;
    }

    public static Image DeviceIcon() {
        if (DeviceIcon == null) {
            DeviceIcon = SystemResourceSupport.createImage((String)"/jp/co/sra/jun/goodies/files/deviceIcon.png");
        }
        return DeviceIcon;
    }

    public static Image OpenedFolderIcon() {
        if (OpenedFolderIcon == null) {
            OpenedFolderIcon = SystemResourceSupport.createImage((String)"/jp/co/sra/jun/goodies/files/openedFolderIcon.png");
        }
        return OpenedFolderIcon;
    }

    protected void initialize() {
        super.initialize();
        this.fileName = null;
        this.fileList = null;
        this.fileType = null;
        this.fileTypes = null;
        this.currentDirectory = null;
        this.currentDirectoryLabel = null;
        this.currentDirectoryLevel = -1;
        this.directoryList = null;
        this.fileList = null;
        this.currentDrive = null;
        this.drives = null;
    }

    public File currentDirectory() {
        if (this.currentDirectory == null) {
            this.currentDirectory_(JunFileModel.DefaultDirectory());
        }
        return this.currentDirectory;
    }

    public void currentDirectory_(File file) {
        File file2 = null;
        if (file == null) {
            file2 = JunFileModel.DefaultDirectory();
        } else {
            file2 = file;
            if (file2.exists() && file2.isDirectory()) {
                if (!file2.isAbsolute()) {
                    file2 = file2.getAbsoluteFile();
                }
            } else {
                file2 = JunFileModel.DefaultDirectory();
            }
        }
        this.currentDirectory = file2;
        this.currentDirectoryLevel = -1;
        this.updateCurrentDrive();
        this.updateCurrentDirectoryLabel();
        this.updateDirectoryAndFileList();
    }

    public int currentDirectoryLevel() {
        if (this.currentDirectoryLevel < 0) {
            this.currentDirectoryLevel = 0;
            for (File file = this.currentDirectory(); file != null; file = file.getParentFile()) {
                ++this.currentDirectoryLevel;
            }
        }
        return this.currentDirectoryLevel;
    }

    public Object value() {
        return new File(this.currentDirectory(), (String)this.fileName().value());
    }

    public void value_(File file) {
        if (file == null) {
            return;
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                this.currentDirectory_(file);
            } else {
                this.currentDirectory_(file.getParentFile());
                this.fileName().value_((Object)file.getName());
            }
        } else {
            File file2;
            this.fileName().value_((Object)file.getName());
            for (file2 = file.getParentFile(); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
            }
            this.currentDirectory_(file2);
        }
    }

    public StValueHolder currentDirectoryLabel() {
        if (this.currentDirectoryLabel == null) {
            this.currentDirectoryLabel = new StValueHolder((Object)new String());
        }
        return this.currentDirectoryLabel;
    }

    public StValueHolder currentDrive() {
        if (this.currentDrive == null) {
            this.currentDrive = new StValueHolder(null);
            this.updateCurrentDrive();
        }
        return this.currentDrive;
    }

    public StValueHolder directoryList() {
        if (this.directoryList == null) {
            this.directoryList = new StValueHolder((Object)new String[0]);
        }
        return this.directoryList;
    }

    public File[] drives() {
        return File.listRoots();
    }

    public StValueHolder fileList() {
        if (this.fileList == null) {
            this.fileList = new StValueHolder((Object)new String[0]);
        }
        return this.fileList;
    }

    public StValueHolder fileName() {
        if (this.fileName == null) {
            this.fileName = new StValueHolder((Object)new String());
        }
        return this.fileName;
    }

    public StValueHolder fileType() {
        if (this.fileType == null) {
            this.fileType = new StValueHolder((Object)this.fileTypes()[0]);
        }
        return this.fileType;
    }

    public FileType[] fileTypes() {
        if (this.fileTypes == null) {
            this.fileTypes = this.defaultFileTypes();
        }
        return this.fileTypes;
    }

    public void fileTypes_(FileType[] fileTypeArray) {
        this.fileTypes = fileTypeArray;
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this);
    }

    protected void currentDriveChanged(String string) {
        if (DefaultDirectoryItem.equals(string)) {
            this.currentDirectory_(JunFileModel.DefaultDirectory());
        } else {
            this.currentDirectory_(new File(string));
        }
        this.changed_(JunFileModel.$((String)"value"));
    }

    protected void directoryListDoubleClicked(int n, String string) {
        String string2 = string.trim();
        File file = this.currentDirectory();
        if (n >= this.currentDirectoryLevel()) {
            this.currentDirectory_(new File(file, string2));
        } else {
            for (int i = this.currentDirectoryLevel() - 1; i > n; --i) {
                file = file.getParentFile();
            }
            this.currentDirectory_(file);
        }
        this.changed_(JunFileModel.$((String)"value"));
    }

    protected void fileListChanged(String string) {
        this.fileName().value_((Object)string);
        this.changed_(JunFileModel.$((String)"value"));
    }

    protected void fileNameChanged(String string) {
        this.fileName().value_((Object)string);
        this.changed_(JunFileModel.$((String)"value"));
    }

    protected void fileTypeChanged(int n) {
        this.fileType().value_((Object)this.fileTypes()[n]);
        this.updateDirectoryAndFileList();
        this.changed_(JunFileModel.$((String)"value"));
    }

    protected FileType[] defaultFileTypes() {
        return new FileType[]{FileType.All(JunSystem.$String((String)"All files") + " (*)")};
    }

    protected void updateCurrentDirectoryLabel() {
        int n = 32;
        String string = this.currentDirectory().getPath();
        if (string.length() > n) {
            string = string.substring(0, 3) + "..." + string.substring(string.length() - n + 5, string.length());
        }
        this.currentDirectoryLabel().value_((Object)string);
    }

    protected void updateCurrentDrive() {
        File file = this.currentDirectory();
        while (file.getParent() != null) {
            file = file.getParentFile();
        }
        this.currentDrive().value_((Object)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDirectoryAndFileList() {
        JunCursors junCursors = new JunCursors(new Cursor(3));
        try {
            String string;
            junCursors._show();
            LinkedList<String> linkedList = new LinkedList<String>();
            for (File file = this.currentDirectory(); file != null; file = file.getParentFile()) {
                string = file.getName();
                if (string.length() == 0) {
                    string = file.getPath();
                }
                linkedList.addFirst(string);
            }
            LinkedList<String> linkedList2 = new LinkedList<String>();
            LinkedList<String> linkedList3 = new LinkedList<String>();
            File[] fileArray = this.currentDirectory().listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                string = file.getName();
                if (!file.canRead()) continue;
                if (file.isDirectory()) {
                    linkedList2.add(string);
                    continue;
                }
                if (!this.checkFileTypeMatch_(string)) continue;
                linkedList3.add(string);
            }
            Collections.sort(linkedList2);
            linkedList.addAll(linkedList2);
            this.directoryList().value_((Object)linkedList.toArray());
            Collections.sort(linkedList3);
            this.fileList().value_((Object)linkedList3.toArray());
        }
        finally {
            junCursors._restore();
        }
    }

    public StView defaultView() {
        if (JunFileModel.GetDefaultViewMode() == 0) {
            return new JunFileViewAwt(this);
        }
        return new JunFileViewSwing(this);
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"File Model");
    }

    protected boolean checkFileTypeMatch_(String string) {
        FileType fileType = (FileType)this.fileType().value();
        if (fileType == null) {
            return true;
        }
        String[] stringArray = fileType.extensions();
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!JunStringUtility.StringMatch_and_(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static class FileType {
        protected String name;
        protected String[] extensions;

        public FileType(String string, String[] stringArray) {
            this.name = string;
            this.extensions = stringArray;
        }

        public static FileType All(String string) {
            return new FileType(string, new String[]{"*"});
        }

        public String name() {
            return this.name;
        }

        public String[] extensions() {
            return this.extensions;
        }
    }
}

