/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.properties;

import jp.co.sra.jun.goodies.colors.JunColorChoiceHSB;
import jp.co.sra.jun.goodies.colors.JunColorChoiceModel;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunTextElement;
import jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel;
import jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesViewAwt;
import jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesViewSwing;
import jp.co.sra.jun.goodies.texteditor.JunTextEditor;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

public class JunTextPropertiesModel
extends JunDrawingElementPropertiesModel {
    protected JunTextEditor textEditor;
    protected JunColorChoiceModel foregroundColorChoiceModel;

    public JunTextPropertiesModel(JunTextElement junTextElement) {
        super(junTextElement);
    }

    protected void initialize() {
        super.initialize();
        this.textEditor = null;
        this.foregroundColorChoiceModel = null;
    }

    protected void drawingElement_(JunDrawingElement junDrawingElement) {
        if (junDrawingElement == null) {
            return;
        }
        super.drawingElement_(junDrawingElement);
        JunTextElement junTextElement = (JunTextElement)junDrawingElement;
        this.foregroundColorChoiceModel().color_(junTextElement.foregroundColor());
    }

    public JunTextElement textElement() {
        return (JunTextElement)this.drawingElement();
    }

    public String text() {
        return this.textElement().text();
    }

    public void text_(String string) {
        this.textElement().text_(string);
        this.textElement().map().changed_with_(JunTextPropertiesModel.$((String)"redisplay"), this.textElement().bounds());
        this.changed_(JunTextPropertiesModel.$((String)"text"));
    }

    public JunTextEditor textEditor() {
        if (this.textEditor == null) {
            this.textEditor = new JunTextEditor(this.text());
            this.textEditor.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunTextPropertiesModel.this.text_((String)object);
                    return null;
                }
            });
        }
        return this.textEditor;
    }

    public JunColorChoiceModel foregroundColorChoiceModel() {
        if (this.foregroundColorChoiceModel == null) {
            this.foregroundColorChoiceModel = new JunColorChoiceHSB();
            this.foregroundColorChoiceModel.compute_(new StBlockClosure(){

                public Object value() {
                    JunTextPropertiesModel.this.updateForegroundColor();
                    return null;
                }
            });
        }
        return this.foregroundColorChoiceModel;
    }

    public StView defaultView() {
        if (JunTextPropertiesModel.GetDefaultViewMode() == 0) {
            return new JunTextPropertiesViewAwt(this);
        }
        return new JunTextPropertiesViewSwing(this);
    }

    protected void updateForegroundColor() {
        if (!this.foregroundColorChoiceModel().color().equals(this.textElement().foregroundColor())) {
            this.textElement().foregroundColor_(this.foregroundColorChoiceModel().color());
            this.textElement().map().changed_with_(JunTextPropertiesModel.$((String)"redisplay"), this.textElement().bounds());
            this.changed_(JunTextPropertiesModel.$((String)"foregroundColor"));
        }
    }
}

