/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.properties;

import java.awt.Color;
import jp.co.sra.jun.goodies.colors.JunColorChoiceHSB;
import jp.co.sra.jun.goodies.colors.JunColorChoiceModel;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunRectangularShapeElement;
import jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel;
import jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesViewAwt;
import jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesViewSwing;
import jp.co.sra.jun.goodies.parameter.JunParameter;
import jp.co.sra.jun.goodies.parameter.JunParameterModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

public class JunRectangularShapePropertiesModel
extends JunDrawingElementPropertiesModel {
    protected JunColorChoiceModel foregroundColorChoiceModel;
    protected JunColorChoiceModel backgroundColorChoiceModel;
    protected JunParameterModel lineWidthParameterModel;
    protected boolean isFill;

    public JunRectangularShapePropertiesModel(JunRectangularShapeElement junRectangularShapeElement) {
        super(junRectangularShapeElement);
    }

    protected void initialize() {
        super.initialize();
        this.foregroundColorChoiceModel = null;
        this.backgroundColorChoiceModel = null;
        this.lineWidthParameterModel = null;
        this.isFill = false;
    }

    public JunRectangularShapeElement rectangularShapeElement() {
        return (JunRectangularShapeElement)this.drawingElement();
    }

    protected void drawingElement_(JunDrawingElement junDrawingElement) {
        boolean bl;
        if (junDrawingElement == null) {
            return;
        }
        super.drawingElement_(junDrawingElement);
        JunRectangularShapeElement junRectangularShapeElement = (JunRectangularShapeElement)junDrawingElement;
        this.foregroundColorChoiceModel().color_(junRectangularShapeElement.foregroundColor());
        this.lineWidthParameterModel().parameter().value_(junRectangularShapeElement.lineWidth());
        boolean bl2 = bl = junRectangularShapeElement.backgroundColor() != null;
        if (bl) {
            this.fill_(true);
            this.backgroundColorChoiceModel().color_(junRectangularShapeElement.backgroundColor());
        } else {
            this.fill_(false);
            this.backgroundColorChoiceModel().color_(Color.white);
        }
    }

    public boolean isFill() {
        return this.isFill;
    }

    public void fill_(boolean bl) {
        this.isFill = bl;
    }

    public JunColorChoiceModel foregroundColorChoiceModel() {
        if (this.foregroundColorChoiceModel == null) {
            this.foregroundColorChoiceModel = new JunColorChoiceHSB();
            this.foregroundColorChoiceModel.compute_(new StBlockClosure(){

                public Object value() {
                    JunRectangularShapePropertiesModel.this.updateForegroundColor();
                    return null;
                }
            });
        }
        return this.foregroundColorChoiceModel;
    }

    public JunColorChoiceModel backgroundColorChoiceModel() {
        if (this.backgroundColorChoiceModel == null) {
            this.backgroundColorChoiceModel = new JunColorChoiceHSB();
            this.backgroundColorChoiceModel.compute_(new StBlockClosure(){

                public Object value() {
                    JunRectangularShapePropertiesModel.this.updateBackgroundColor();
                    return null;
                }
            });
        }
        return this.backgroundColorChoiceModel;
    }

    public JunParameterModel lineWidthParameterModel() {
        if (this.lineWidthParameterModel == null) {
            this.lineWidthParameterModel = new JunParameterModel(new JunParameter(JunSystem.$String((String)"Border width"), ((JunRectangularShapeElement)this.drawingElement()).lineWidth(), 0.0, 20.0, 1.0));
            this.lineWidthParameterModel.addDependent_((DependentListener)this);
        }
        return this.lineWidthParameterModel;
    }

    public StView defaultView() {
        if (JunRectangularShapePropertiesModel.GetDefaultViewMode() == 0) {
            return new JunRectangularShapePropertiesViewAwt(this);
        }
        return new JunRectangularShapePropertiesViewSwing(this);
    }

    public void update_(DependentEvent dependentEvent) {
        if (dependentEvent.getAspect() == JunRectangularShapePropertiesModel.$((String)"value")) {
            this.updateLineWidth();
        }
    }

    protected void updateForegroundColor() {
        if (!this.foregroundColorChoiceModel().color().equals(this.rectangularShapeElement().foregroundColor())) {
            this.rectangularShapeElement().foregroundColor_(this.foregroundColorChoiceModel().color());
            this.rectangularShapeElement().map().changed_with_(JunRectangularShapePropertiesModel.$((String)"redisplay"), this.rectangularShapeElement().bounds());
            this.changed_(JunRectangularShapePropertiesModel.$((String)"foregroundColor"));
        }
    }

    protected void updateBackgroundColor() {
        if (this.isFill() && !this.backgroundColorChoiceModel().color().equals(this.rectangularShapeElement().backgroundColor())) {
            this.rectangularShapeElement().backgroundColor_(this.backgroundColorChoiceModel().color());
            this.rectangularShapeElement().map().changed_with_(JunRectangularShapePropertiesModel.$((String)"redisplay"), this.rectangularShapeElement().bounds());
            this.changed_(JunRectangularShapePropertiesModel.$((String)"backgroundColor"));
        }
    }

    protected void updateLineWidth() {
        int n = (int)this.lineWidthParameterModel().parameter().value();
        if (this.rectangularShapeElement().lineWidth() != n) {
            this.rectangularShapeElement().lineWidth_(n);
            this.rectangularShapeElement().map().changed_with_(JunRectangularShapePropertiesModel.$((String)"redisplay"), this.rectangularShapeElement().bounds());
            this.changed_(JunRectangularShapePropertiesModel.$((String)"lineWidth"));
        }
    }

    protected void updateFill() {
        if (this.isFill() && this.rectangularShapeElement().backgroundColor() == null) {
            this.rectangularShapeElement().backgroundColor_(this.backgroundColorChoiceModel().color());
            this.rectangularShapeElement().map().changed_with_(JunRectangularShapePropertiesModel.$((String)"redisplay"), this.rectangularShapeElement().bounds());
            this.changed_(JunRectangularShapePropertiesModel.$((String)"fill"));
        } else if (!this.isFill() && this.rectangularShapeElement().backgroundColor() != null) {
            this.rectangularShapeElement().backgroundColor_(null);
            this.rectangularShapeElement().map().changed_with_(JunRectangularShapePropertiesModel.$((String)"redisplay"), this.rectangularShapeElement().bounds());
            this.changed_(JunRectangularShapePropertiesModel.$((String)"fill"));
        }
    }
}

