/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.util.HashMap;
import java.util.Map;
import jp.co.sra.jun.goodies.drawing.element.JunCompositeElement;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunRectangleElement;
import jp.co.sra.jun.goodies.drawing.element.JunRectangularShapeElement;
import jp.co.sra.jun.goodies.drawing.element.JunTextElement;
import jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel;
import jp.co.sra.jun.goodies.drawing.properties.JunTextboxPropertiesModel;
import jp.co.sra.jun.goodies.lisp.JunLispList;

public class JunTextboxElement
extends JunCompositeElement {
    protected transient JunTextboxPropertiesModel propertiesModel;
    public static int DefaultMargin = 5;
    public static DataFlavor DataFlavor = new DataFlavor(JunTextboxElement.class, "JunTextboxElement");

    public JunTextboxElement() {
    }

    public JunTextboxElement(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.propertiesModel = null;
    }

    protected void initializeComponentElements() {
        super.initializeComponentElements();
        this.addElement_(new JunRectangleElement());
        this.addElement_(new JunTextElement());
    }

    public void release() {
        super.release();
        if (this.propertiesModel != null) {
            this.propertiesModel.closeRequest();
            this.propertiesModel = null;
        }
    }

    public JunRectangularShapeElement borderElement() {
        if (this.componentElementSize() == 0) {
            this.initializeComponentElements();
        }
        return (JunRectangularShapeElement)this.componentElementAt_(0);
    }

    public JunTextElement textElement() {
        if (this.componentElementSize() == 0) {
            this.initializeComponentElements();
        }
        return (JunTextElement)this.componentElementAt_(1);
    }

    public String text() {
        return this.textElement().text();
    }

    public void text_(String string) {
        this.textElement().text_(string);
    }

    public void location_(Point point) {
        Point point2 = new Point(Math.max(point.x, 0), Math.max(point.y, 0));
        this.borderElement().location_(point2);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.textElement().defaultMinimumExtent().width + DefaultMargin * 2 + this.lineWidth() * 2 <= this.borderElement().width()) {
            n = point2.x + DefaultMargin + this.borderElement().lineWidth();
            n3 = this.textElement().width();
        } else {
            n = point2.x + (this.borderElement().width() - this.textElement().defaultMinimumExtent().width) / 2;
            n3 = this.textElement().defaultMinimumExtent().width;
        }
        if (this.textElement().defaultMinimumExtent().height + DefaultMargin * 2 + this.lineWidth() * 2 <= this.borderElement().height()) {
            n2 = point2.y + DefaultMargin + this.borderElement().lineWidth();
            n4 = this.textElement().height();
        } else {
            n2 = point2.y + (this.borderElement().height() - this.textElement().defaultMinimumExtent().height) / 2;
            n4 = this.textElement().defaultMinimumExtent().height;
        }
        this.textElement().location_(n, n2);
        this.textElement().extent_(n3, n4);
    }

    public void extent_(Dimension dimension) {
        Dimension dimension2 = this.defaultMinimumExtent();
        Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        this.borderElement().extent_(dimension3);
        int n = 0;
        int n2 = 0;
        n = this.textElement().defaultMinimumExtent().width + DefaultMargin * 2 + this.lineWidth() * 2 <= dimension3.width ? dimension3.width - this.borderElement().lineWidth() * 2 - DefaultMargin * 2 : dimension3.width - (dimension3.width - this.textElement().defaultMinimumExtent().width) / 2;
        n2 = this.textElement().defaultMinimumExtent().height + DefaultMargin * 2 + this.lineWidth() * 2 <= dimension3.height ? dimension3.height - this.borderElement().lineWidth() * 2 - DefaultMargin * 2 : dimension3.height - (dimension3.height - this.textElement().defaultMinimumExtent().height) / 2;
        this.textElement().extent_(n, n2);
    }

    public Rectangle preferredBounds() {
        return this.borderElement().preferredBounds();
    }

    public HashMap controllPoints() {
        return this.borderElement().controllPoints();
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        this.propertiesModel = null;
        return this;
    }

    public Dimension defaultExtent() {
        return new Dimension(96, this.defaultMinimumExtent().height + 4);
    }

    public Dimension defaultMinimumExtent() {
        Dimension dimension = this.textElement().defaultMinimumExtent();
        Dimension dimension2 = this.borderElement().defaultMinimumExtent();
        return new Dimension(Math.max(dimension.width + DefaultMargin * 2, dimension2.width), Math.max(dimension.height + DefaultMargin * 2, dimension2.height));
    }

    public Font font() {
        return this.textElement().font();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor};
    }

    public String fontName() {
        return this.textElement().fontName();
    }

    public void fontName_(String string) {
        this.textElement().fontName_(string);
    }

    public int fontSize() {
        return this.textElement().fontSize();
    }

    public void fontSize_(int n) {
        this.textElement().fontSize_(n);
    }

    public int fontStyle() {
        return this.textElement().fontStyle();
    }

    public void fontStyle_(int n) {
        this.textElement().fontStyle_(n);
    }

    public Color foregroundColor() {
        return this.textElement().foregroundColor();
    }

    public void foregroundColor_(Color color) {
        this.textElement().foregroundColor_(color);
    }

    public Color backgroundColor() {
        return this.borderElement().backgroundColor();
    }

    public void backgroundColor_(Color color) {
        this.borderElement().backgroundColor_(color);
    }

    public Color borderColor() {
        return this.borderElement().foregroundColor();
    }

    public void borderColor_(Color color) {
        this.borderElement().foregroundColor_(color);
    }

    public int lineWidth() {
        return this.borderElement().lineWidth();
    }

    public void lineWidth_(int n) {
        this.borderElement().lineWidth_(n);
        this.location_(this.location());
        this.extent_(this.extent());
    }

    public JunDrawingElementPropertiesModel propertiesModel() {
        if (this.propertiesModel == null) {
            this.propertiesModel = new JunTextboxPropertiesModel(this);
        }
        return this.propertiesModel;
    }
}

