/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunLabelElement;
import jp.co.sra.jun.goodies.drawing.element.JunNodeElement;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class JunLinkElement
extends JunDrawingElement {
    protected JunNodeElement fromElement;
    protected JunNodeElement toElement;
    protected JunPathElement pathElement;
    protected JunLabelElement labelElement;
    protected transient long fromElementId;
    protected transient long toElementId;
    protected transient long labelElementId;
    protected transient int[] nearestPointIndexesFromLabel;
    protected transient Point labelElementDeltaPoint;
    public static DataFlavor DataFlavor = new DataFlavor(JunLinkElement.class, "JunLinkElement");

    public JunLinkElement() {
    }

    public JunLinkElement(JunLispList junLispList) {
        super(junLispList);
    }

    public JunLinkElement(JunNodeElement junNodeElement, JunNodeElement junNodeElement2) {
        this(junNodeElement, junNodeElement2, null);
    }

    public JunLinkElement(JunNodeElement junNodeElement, JunNodeElement junNodeElement2, JunPathElement junPathElement) {
        this(junNodeElement, junNodeElement2, junPathElement, null);
    }

    public JunLinkElement(JunNodeElement junNodeElement, JunNodeElement junNodeElement2, JunPathElement junPathElement, JunLabelElement junLabelElement) {
        this();
        if (junNodeElement == null || junNodeElement2 == null) {
            throw new IllegalArgumentException("The two nodes must be exist.");
        }
        this.fromElement_(junNodeElement);
        this.toElement_(junNodeElement2);
        this.pathElement_(junPathElement);
        this.labelElement_(junLabelElement);
        this.updateFromToPoint();
    }

    protected void initialize() {
        super.initialize();
        this.fromElement = null;
        this.toElement = null;
        this.pathElement = null;
        this.labelElement = null;
        this.fromElementId = Long.MIN_VALUE;
        this.toElementId = Long.MIN_VALUE;
        this.labelElementId = Long.MIN_VALUE;
        this.labelElementDeltaPoint = null;
        this.nearestPointIndexesFromLabel = null;
    }

    public JunNodeElement fromElement() {
        if (this.fromElement == null && this.fromElementId() > Long.MIN_VALUE) {
            JunDrawingElement junDrawingElement = this.map().findElement_(this.fromElementId());
            if (junDrawingElement != null && junDrawingElement.isNode()) {
                this.fromElement_((JunNodeElement)junDrawingElement);
            } else {
                throw new IllegalStateException("the from element id '" + this.fromElementId() + "' don't find this map object.");
            }
        }
        return this.fromElement;
    }

    public void fromElement_(JunNodeElement junNodeElement) {
        this.fromElement = junNodeElement;
        if (this.fromElement != null) {
            this.fromElementId_(Long.MIN_VALUE);
        }
    }

    public JunNodeElement toElement() {
        if (this.toElement == null && this.toElementId() > Long.MIN_VALUE) {
            JunDrawingElement junDrawingElement = this.map().findElement_(this.toElementId());
            if (junDrawingElement != null && junDrawingElement.isNode()) {
                this.toElement_((JunNodeElement)junDrawingElement);
            } else {
                throw new IllegalStateException("the to element id '" + this.toElementId() + "' don't find this map object.");
            }
        }
        return this.toElement;
    }

    public void toElement_(JunNodeElement junNodeElement) {
        this.toElement = junNodeElement;
        if (this.toElement != null) {
            this.toElementId_(Long.MIN_VALUE);
        }
    }

    public JunPathElement pathElement() {
        if (this.pathElement == null) {
            JunPathElement junPathElement = new JunPathElement();
            junPathElement.add_(this.fromElement().center());
            junPathElement.add_(this.toElement().center());
            junPathElement.beginStyle_(0);
            junPathElement.endStyle_(1);
            this.pathElement_(junPathElement);
        }
        return this.pathElement;
    }

    public void pathElement_(JunPathElement junPathElement) {
        if (junPathElement != null) {
            this.pathElement = junPathElement;
            this.pathElement.parent_(this);
        }
    }

    public List points() {
        return this.pathElement().points();
    }

    public void points_(List list) {
        int n = this.pathElement().points().size();
        this.pathElement().points_(list);
        if (list.size() != n) {
            this.flushLabelElementPoints();
        }
        this.flushBounds();
    }

    public Point[] _points() {
        return this.pathElement()._points();
    }

    public void at_put_(int n, Point point) {
        this.pathElement().at_put_(n, point);
        this.flushBounds();
    }

    public Point controllPointAt_(StSymbol stSymbol) {
        return this.pathElement().controllPointAt_(stSymbol);
    }

    public void controllPointAt_put_(StSymbol stSymbol, Point point) {
        this.pathElement().controllPointAt_put_(stSymbol, point);
        this.flushBounds();
    }

    public Point pointAt_(int n) {
        return this.pathElement().pointAt_(n);
    }

    public Point begin() {
        return this.pathElement.begin();
    }

    public void begin_(Point point) {
        this.pathElement().begin_(point);
        this.flushBounds();
    }

    public Point end() {
        return this.pathElement().end();
    }

    public void end_(Point point) {
        this.pathElement().end_(point);
        this.flushBounds();
    }

    public JunLabelElement labelElement() {
        if (this.labelElement == null && this.labelElementId() > Long.MIN_VALUE) {
            JunDrawingElement junDrawingElement = this.map().findElement_(this.labelElementId());
            if (junDrawingElement != null && junDrawingElement.isLabel()) {
                this.labelElement_((JunLabelElement)junDrawingElement);
            } else {
                throw new IllegalStateException("the label element id '" + this.labelElementId() + "' don't find this map object.");
            }
        }
        return this.labelElement;
    }

    public void labelElement_(JunLabelElement junLabelElement) {
        if (this.labelElement != null) {
            this.labelElement.baseElement_(null);
        }
        this.labelElement = junLabelElement;
        this.labelElementId_(Long.MIN_VALUE);
        this.labelElementDeltaPoint_(null);
        if (this.labelElement != null) {
            this.labelElement.baseElement_(this);
        }
    }

    public Point addOnLine_(Point point) {
        Point point2 = this.pathElement().addOnLine_(point);
        this.flushLabelElementPoints();
        this.updateFromToPoint();
        return point2;
    }

    public void location_(Point point) {
    }

    public void extent_(Dimension dimension) {
    }

    public Rectangle preferredBounds() {
        return this.pathElement().preferredBounds();
    }

    public HashMap controllPoints() {
        return this.pathElement().controllPoints();
    }

    public boolean checkElement() {
        try {
            this.fromElement();
            this.toElement();
            this.labelElement();
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    public JunDrawingVisual postCopy(Map map) {
        JunNodeElement junNodeElement = this.fromElement();
        JunNodeElement junNodeElement2 = this.toElement();
        JunLabelElement junLabelElement = this.labelElement();
        super.postCopy(map);
        if (junNodeElement != null) {
            this.fromElement = junNodeElement = (JunNodeElement)(map.containsKey(junNodeElement) ? map.get(junNodeElement) : junNodeElement.copy(map));
            this.fromElementId = junNodeElement.id();
        }
        if (junNodeElement2 != null) {
            this.toElement = junNodeElement2 = (JunNodeElement)(map.containsKey(junNodeElement2) ? map.get(junNodeElement2) : junNodeElement2.copy(map));
            this.toElementId = junNodeElement2.id();
        }
        this.pathElement_((JunPathElement)this.pathElement().copy(map));
        if (junLabelElement != null) {
            this.labelElement = junLabelElement = (JunLabelElement)(map.containsKey(junLabelElement) ? map.get(junLabelElement) : junLabelElement.copy(map));
            this.labelElementId = junLabelElement.id();
            junLabelElement.baseElement_(this);
            this.flushLabelElementPoints();
        }
        return this;
    }

    public void displayOn_(Graphics graphics) {
        this.pathElement().displayOn_(graphics);
    }

    protected void flushBounds() {
        if (this.labelElement() != null) {
            int[] nArray = this.nearestPointIndexesFromLabel();
            Point point = new Jun2dLine(new Jun2dPoint(this.pointAt_(nArray[0])), new Jun2dPoint(this.pointAt_(nArray[1]))).center()._toPoint();
            Point point2 = this.labelElementDeltaPoint();
            this.labelElement().moveLabel_(new Point(point.x + point2.x, point.y + point2.y));
        }
    }

    public void flushLabelElementPoints() {
        this.nearestPointIndexesFromLabel = null;
        this.labelElementDeltaPoint = null;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("a ");
        writer.write(this._className().toString());
        writer.write("(id=");
        writer.write(String.valueOf(this.id));
        writer.write(", (");
        this.fromElement().printOn_(writer);
        writer.write(" -> ");
        this.toElement().printOn_(writer);
        writer.write("))");
    }

    public Point remove_(Point point) {
        Point point2 = this.pathElement().remove_(point);
        this.flushLabelElementPoints();
        this.updateFromToPoint();
        return point2;
    }

    public boolean isLink() {
        return true;
    }

    public boolean hasLabel() {
        return this.labelElement() != null;
    }

    public boolean containsPoint_(Point point) {
        return this.pathElement().containsPoint_(point);
    }

    public boolean intersects_(Rectangle rectangle) {
        return this.pathElement().intersects_(rectangle);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor};
    }

    public void updateFromToPoint() {
        Point point;
        Point point2;
        if (this.fromElement() == null || this.toElement() == null) {
            return;
        }
        if (this.pathElement().points().size() <= 2) {
            point2 = this.fromElement().nearestPointFromPoint_(this.toElement().center());
            point = this.toElement().nearestPointFromPoint_(this.fromElement().center());
        } else {
            point2 = this.fromElement().nearestPointFromPoint_(this.pathElement().pointAt_(1));
            point = this.toElement().nearestPointFromPoint_(this.pathElement().pointAt_(this.pathElement().points().size() - 2));
        }
        this.begin_(point2);
        this.end_(point);
    }

    public JunDrawingElementPropertiesModel propertiesModel() {
        return this.pathElement().propertiesModel();
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        junLispCons.add_((Object)this.fromElementToLispList());
        junLispCons.add_((Object)this.toElementToLispList());
        junLispCons.add_((Object)this.pathElementToLispList());
        if (this.hasLabel()) {
            junLispCons.add_((Object)this.labelElementToLispList());
        }
        return junLispCons;
    }

    protected JunLispCons fromElementToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunLinkElement.$((String)"from"));
        junLispCons.tail_(new Long(this.fromElement().id()));
        return junLispCons;
    }

    protected JunLispCons toElementToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunLinkElement.$((String)"to"));
        junLispCons.tail_(new Long(this.toElement().id()));
        return junLispCons;
    }

    protected JunLispCons pathElementToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunLinkElement.$((String)"path"));
        junLispCons.tail_((Object)this.pathElement().toLispList());
        return junLispCons;
    }

    protected JunLispCons labelElementToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunLinkElement.$((String)"label"));
        junLispCons.tail_(new Long(this.labelElement().id()));
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.fromElementFromLispList_(junLispList);
        this.toElementFromLispList_(junLispList);
        this.pathElementFromLispList_(junLispList);
        this.labelElementFromLispList_(junLispList);
    }

    protected void fromElementFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"from"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.fromElement_(null);
        this.fromElementId_(((Number)junLispList2.tail()).longValue());
    }

    protected void toElementFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"to"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.toElement_(null);
        this.toElementId_(((Number)junLispList2.tail()).longValue());
    }

    protected void pathElementFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"path"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.pathElement_((JunPathElement)JunDrawingElement.FromLispList_((JunLispCons)((Object)junLispList2.tail())));
    }

    protected void labelElementFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"label"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.labelElement_(null);
        this.labelElementId_(((Number)junLispList2.tail()).longValue());
    }

    protected int[] nearestPointIndexesFromLabel() {
        if (this.nearestPointIndexesFromLabel == null) {
            double d = 9.223372036854776E18;
            Point[] pointArray = this._points();
            for (int i = 1; i < pointArray.length; ++i) {
                double d2 = new Jun2dLine(new Jun2dPoint(pointArray[i - 1]), new Jun2dPoint(pointArray[i])).center().distance_(new Jun2dPoint(this.labelElement().center()));
                if (!(d2 < d)) continue;
                d = d2;
                this.nearestPointIndexesFromLabel = new int[]{i - 1, i};
            }
        }
        return this.nearestPointIndexesFromLabel;
    }

    protected Point labelElementDeltaPoint() {
        if (this.labelElementDeltaPoint == null && this.labelElement() != null) {
            int[] nArray = this.nearestPointIndexesFromLabel();
            Point point = new Jun2dLine(new Jun2dPoint(this.pointAt_(nArray[0])), new Jun2dPoint(this.pointAt_(nArray[1]))).center()._toPoint();
            Point point2 = this.labelElement().location();
            this.labelElementDeltaPoint = new Point(point2.x - point.x, point2.y - point.y);
        }
        return this.labelElementDeltaPoint;
    }

    protected void labelElementDeltaPoint_(Point point) {
        this.labelElementDeltaPoint = point;
    }

    public long fromElementId() {
        return this.fromElementId;
    }

    public void fromElementId_(long l) {
        this.fromElementId = l;
    }

    public long toElementId() {
        return this.toElementId;
    }

    public void toElementId_(long l) {
        this.toElementId = l;
    }

    public long labelElementId() {
        return this.labelElementId;
    }

    public void labelElementId_(long l) {
        this.labelElementId = l;
    }
}

