/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import jp.co.sra.jun.goodies.display.JunDisplayController;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.goodies.display.JunDisplayView;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StViewCanvas;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunDisplayViewAwt
extends JunAbstractViewPanel
implements JunDisplayView {
    protected StViewCanvas canvas;
    protected ScrollPane scrollPane;

    public JunDisplayViewAwt(JunDisplayModel junDisplayModel) {
        super(junDisplayModel);
    }

    public JunDisplayViewAwt(JunDisplayModel junDisplayModel, Dimension dimension) {
        super(junDisplayModel);
        this.setSize(dimension);
    }

    protected void initialize() {
        super.initialize();
        this.canvas = null;
        this.scrollPane = null;
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add(this.scrollPane(), WindowSpecLayout.Position((float)0.0f, (int)0, (float)0.0f, (int)0, (float)1.0f, (int)0, (float)1.0f, (int)0));
    }

    public StDisplayable visual() {
        return this.getDisplayModel().visual();
    }

    public Dimension getPreferredSize() {
        Point point = this.scrollPane().getLocation();
        Dimension dimension = this.scrollPane().getPreferredSize();
        return new Dimension(dimension.width + point.x * 2, dimension.height + point.y * 2);
    }

    public Dimension _getViewportSize() {
        return this.scrollPane().getViewportSize();
    }

    public JunDisplayModel getDisplayModel() {
        return (JunDisplayModel)this.model();
    }

    protected StController defaultController() {
        return new JunDisplayController();
    }

    public StViewCanvas canvas() {
        if (this.canvas == null) {
            this.canvas = new StViewCanvas(){

                public Dimension getPreferredSize() {
                    if (JunDisplayViewAwt.this.getDisplayModel()._isScrollable()) {
                        return JunDisplayViewAwt.this.visual().bounds().getSize();
                    }
                    return super.getPreferredSize();
                }

                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    graphics.setColor(Color.white);
                    Dimension dimension = JunDisplayViewAwt.this.visual().bounds().getSize();
                    int n = (this.getWidth() - dimension.width) / 2;
                    int n2 = (this.getHeight() - dimension.height) / 2;
                    JunDisplayViewAwt.this.visual().displayOn_at_(graphics, new Point(n, n2));
                }
            };
        }
        return this.canvas;
    }

    public Component canvasComponent() {
        return this.canvas();
    }

    protected ScrollPane scrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new ScrollPane(){

                public Dimension getPreferredSize() {
                    Dimension dimension = JunDisplayViewAwt.this.visual().bounds().getSize();
                    Insets insets = this.getInsets();
                    return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
                }

                public void setBounds(int n, int n2, int n3, int n4) {
                    super.setBounds(n, n2, n3, n4);
                    if (!JunDisplayViewAwt.this.getDisplayModel()._isScrollable()) {
                        Insets insets = this.getInsets();
                        JunDisplayViewAwt.this.canvas().setSize(n3 - insets.left - insets.right, n4 - insets.top - insets.bottom);
                    }
                }
            };
            this.scrollPane.add((Component)this.canvas());
        }
        return this.scrollPane;
    }

    public void addNotify() {
        super.addNotify();
        this.scrollPane().doLayout();
    }

    public void _showPopupMenu(int n, int n2) {
        PopupMenu popupMenu = this.popupMenuView();
        if (popupMenu != null) {
            popupMenu.show((Component)this.canvas(), n, n2);
        }
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.topComponent().isShowing()) {
            return;
        }
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunDisplayViewAwt.$((String)"redisplay")) {
            this.canvas().repaint();
        } else if (stSymbol == JunDisplayViewAwt.$((String)"visual")) {
            this.scrollPane().doLayout();
            this.canvas().repaint();
        } else {
            super.update_(dependentEvent);
        }
    }
}

