/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import java.awt.Frame;
import jp.co.sra.jun.goodies.colors.JunColorBarVerticalViewAwt;
import jp.co.sra.jun.goodies.colors.JunColorBarVerticalViewSwing;
import jp.co.sra.jun.goodies.colors.JunColorBarViewAwt;
import jp.co.sra.jun.goodies.colors.JunColorBarViewSwing;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

public class JunColorBarModel
extends JunApplicationModel
implements StBlockValued {
    protected StValueHolder valueHolder;
    protected StValueHolder intervalHolder;
    protected StValueHolder colorHolder;
    protected Color ultraFirstColor;
    protected Color ultraLastColor;
    protected double[] intervalBounds;

    protected void initialize() {
        super.initialize();
        this.valueHolder = null;
        this.intervalHolder = null;
        this.colorHolder = null;
        this.ultraFirstColor = null;
        this.ultraLastColor = null;
        this.intervalBounds = null;
    }

    public Object value() {
        return this.valueHolder().value();
    }

    public double _doubleValue() {
        return this.valueHolder()._doubleValue();
    }

    public void value_(double d) {
        this.valueHolder().value_(Math.max(0.0, Math.min(d, 1.0)));
        this.changed_(JunColorBarModel.$((String)"value"));
        this.colorHolder().value_((Object)this.color());
    }

    protected StValueHolder valueHolder() {
        if (this.valueHolder == null) {
            this.valueHolder = new StValueHolder(0);
        }
        return this.valueHolder;
    }

    public double[] interval() {
        return (double[])this.intervalHolder().value();
    }

    public void interval_(double[] dArray) {
        this.intervalHolder().value_((Object)this.adjustInterval_(dArray));
        this.changed_(JunColorBarModel.$((String)"interval"));
        this.colorHolder().value_((Object)this.color());
    }

    protected StValueHolder intervalHolder() {
        if (this.intervalHolder == null) {
            this.intervalHolder = new StValueHolder((Object)new double[]{0.0, 0.0});
        }
        return this.intervalHolder;
    }

    public double firstMarker() {
        return this.interval()[0];
    }

    public void firstMarker_(double d) {
        double d2 = Math.max(d, this.intervalBounds()[0]);
        double[] dArray = new double[]{d2, Math.max(d2, this.lastMarker())};
        this.interval_(dArray);
    }

    public double lastMarker() {
        return this.interval()[1];
    }

    public void lastMarker_(double d) {
        double d2 = Math.min(d, this.intervalBounds()[1]);
        double[] dArray = new double[]{Math.min(this.firstMarker(), d2), d2};
        this.interval_(dArray);
    }

    public Color color() {
        if (this._doubleValue() < this.firstMarker()) {
            return this.ultraFirstColor();
        }
        if (this.lastMarker() < this._doubleValue()) {
            return this.ultraLastColor();
        }
        double d = 0.0;
        double d2 = this.lastMarker() - this.firstMarker();
        if (d2 > 0.0) {
            d = (this._doubleValue() - this.firstMarker()) / d2;
        }
        return this.getColor_(d);
    }

    protected StValueHolder colorHolder() {
        if (this.colorHolder == null) {
            this.colorHolder = new StValueHolder(null);
        }
        return this.colorHolder;
    }

    public Color ultraFirstColor() {
        if (this.ultraFirstColor == null) {
            this.ultraFirstColor = this.defaultUltraFirstColor();
        }
        return this.ultraFirstColor;
    }

    public void ultraFirstColor_(Color color) {
        if (this.ultraFirstColor != null && this.ultraFirstColor.equals(color)) {
            return;
        }
        this.ultraFirstColor = color;
        this.changed_(JunColorBarModel.$((String)"color"));
    }

    public Color ultraLastColor() {
        if (this.ultraLastColor == null) {
            this.ultraLastColor = this.defaultUltraLastColor();
        }
        return this.ultraLastColor;
    }

    public void ultraLastColor_(Color color) {
        if (this.ultraLastColor != null && this.ultraLastColor.equals(color)) {
            return;
        }
        this.ultraLastColor = color;
        this.changed_(JunColorBarModel.$((String)"color"));
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return this.colorCompute_(stBlockClosure);
    }

    public StBlockValue valueCompute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this.valueHolder());
    }

    public StBlockValue intervalCompute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this.intervalHolder());
    }

    public StBlockValue colorCompute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this.colorHolder());
    }

    protected Color defaultUltraFirstColor() {
        return StColorValue.Brightness_((double)0.8);
    }

    protected Color defaultUltraLastColor() {
        return StColorValue.Brightness_((double)0.8);
    }

    public StView defaultView() {
        if (JunColorBarModel.GetDefaultViewMode() == 0) {
            return JunColorBarViewAwt.OnBorderedPanel_(this);
        }
        return JunColorBarViewSwing.OnBorderedPanel_(this);
    }

    public StView defaultVerticalView() {
        if (JunColorBarModel.GetDefaultViewMode() == 0) {
            return JunColorBarVerticalViewAwt.OnBorderedPanel_(this);
        }
        return JunColorBarVerticalViewSwing.OnBorderedPanel_(this);
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Color Bar");
    }

    protected Color getColor_(double d) {
        return Color.getHSBColor((float)d, 1.0f, 1.0f);
    }

    protected double[] adjustInterval_(double[] dArray) {
        double d = Math.max(0.0, Math.min(Math.min(dArray[0], dArray[1]), 1.0));
        double d2 = Math.max(d, Math.min(Math.max(dArray[0], dArray[1]), 1.0));
        return new double[]{d, d2};
    }

    protected double[] intervalBounds() {
        if (this.intervalBounds == null) {
            this.intervalBounds = new double[]{0.0, 1.0};
        }
        return this.intervalBounds;
    }

    public Frame openVertical() {
        return this.openView_(this.defaultVerticalView());
    }
}

