/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.colors;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.goodies.colors.JunColorBarModel;
import jp.co.sra.jun.goodies.colors.JunColorBarView;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunColorBarController
extends JunAbstractController
implements MouseListener,
MouseMotionListener {
    protected StSymbol _tracking;
    protected Point _offsetPoint;
    protected Point _previousPoint;
    protected boolean _redisplayBoolean;

    public void release() {
        super.release();
        this.view().toComponent().removeMouseListener(this);
        this.view().toComponent().removeMouseMotionListener(this);
    }

    protected void buildListener(StView stView) {
        this.view().toComponent().addMouseListener(this);
        this.view().toComponent().addMouseMotionListener(this);
    }

    public JunColorBarModel getColorBarModel() {
        return (JunColorBarModel)this.model();
    }

    public JunColorBarView getColorBarView() {
        return (JunColorBarView)this.view();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            super.mousePressed(mouseEvent);
            return;
        }
        this._previousPoint = null;
        this._redisplayBoolean = false;
        Point point = mouseEvent.getPoint();
        this._tracking = this._state(point);
        if (this._tracking == JunColorBarController.$((String)"slider")) {
            if (this.getColorBarView().sliderRectangle().containsPoint_(point)) {
                this._offsetPoint = this.getColorBarView().sliderRectangle().center();
                this._offsetPoint.translate(-point.x, -point.y);
            } else {
                this._offsetPoint = new Point(0, 0);
            }
            this.trackSlider_(point);
        } else if (this._tracking == JunColorBarController.$((String)"firstMarker")) {
            this._offsetPoint = this.getColorBarView().firstMarkerRectangle().rightCenter();
            this._offsetPoint.translate(-point.x, -point.y);
            this.trackFirstMarker_(point);
        } else if (this._tracking == JunColorBarController.$((String)"lastMarker")) {
            this._offsetPoint = this.getColorBarView().lastMarkerRectangle().leftCenter();
            this._offsetPoint.translate(-point.x, -point.y);
            this.trackLastMarker_(point);
        } else if (this._tracking == JunColorBarController.$((String)"interval")) {
            this._offsetPoint = this.getColorBarView().anotherIntervalRectangle().center();
            this._offsetPoint.translate(-point.x, -point.y);
            this.trackInterval_(point);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            super.mouseReleased(mouseEvent);
            return;
        }
        if (this._tracking == JunColorBarController.$((String)"slider")) {
            if (this._redisplayBoolean) {
                this.view().toComponent().repaint();
            }
        } else if (this._tracking == JunColorBarController.$((String)"firstMarker") || this._tracking == JunColorBarController.$((String)"lastMarker") || this._tracking == JunColorBarController.$((String)"interval")) {
            // empty if block
        }
        this._tracking = null;
        this._offsetPoint = null;
        this._redisplayBoolean = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (new StRectangle(this.view().toComponent().getSize()).expandedBy_(16, 16).containsPoint_(point)) {
            if (!point.equals(this._previousPoint)) {
                if (this._tracking == JunColorBarController.$((String)"slider")) {
                    this.trackSlider_(mouseEvent.getPoint());
                } else if (this._tracking == JunColorBarController.$((String)"firstMarker")) {
                    this.trackFirstMarker_(mouseEvent.getPoint());
                } else if (this._tracking == JunColorBarController.$((String)"lastMarker")) {
                    this.trackLastMarker_(mouseEvent.getPoint());
                } else if (this._tracking == JunColorBarController.$((String)"interval")) {
                    this.trackInterval_(mouseEvent.getPoint());
                }
                this._previousPoint = point;
            }
            this._redisplayBoolean = true;
        }
        Thread.yield();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        StSymbol stSymbol = this._state(mouseEvent.getPoint());
        if (stSymbol == JunColorBarController.$((String)"slider")) {
            this.view().toComponent().setCursor(JunCursors.CrossCursor());
        } else if (stSymbol == JunColorBarController.$((String)"firstMarker")) {
            if (this.getColorBarView().isVertical()) {
                this.view().toComponent().setCursor(JunCursors.Corner1Cursor());
            } else {
                this.view().toComponent().setCursor(JunCursors.Corner2Cursor());
            }
        } else if (stSymbol == JunColorBarController.$((String)"lastMarker")) {
            this.view().toComponent().setCursor(JunCursors.Corner4Cursor());
        } else if (stSymbol == JunColorBarController.$((String)"interval")) {
            if (this.getColorBarView().isVertical()) {
                this.view().toComponent().setCursor(JunCursors.UpDownCursor());
            } else {
                this.view().toComponent().setCursor(JunCursors.BetweenCursor());
            }
        } else {
            this.view().toComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void trackSlider_(Point point) {
        if (!point.equals(this._previousPoint)) {
            this.getColorBarView().setSliderAt(new Point(point.x + this._offsetPoint.x, point.y + this._offsetPoint.y));
            this._previousPoint = point;
        }
        this._redisplayBoolean = true;
    }

    protected void trackFirstMarker_(Point point) {
        if (!point.equals(this._previousPoint)) {
            this.getColorBarView().setFirstMarkerAt(new Point(point.x + this._offsetPoint.x, point.y + this._offsetPoint.y));
            this._previousPoint = point;
        }
        this._redisplayBoolean = true;
    }

    protected void trackLastMarker_(Point point) {
        if (!point.equals(this._previousPoint)) {
            this.getColorBarView().setLastMarkerAt(new Point(point.x + this._offsetPoint.x, point.y + this._offsetPoint.y));
            this._previousPoint = point;
        }
        this._redisplayBoolean = true;
    }

    protected void trackInterval_(Point point) {
        if (!point.equals(this._previousPoint)) {
            this.getColorBarView().setIntervalAt(new Point(point.x + this._offsetPoint.x, point.y + this._offsetPoint.y));
            this._previousPoint = point;
        }
        this._redisplayBoolean = true;
    }

    protected StSymbol _state(Point point) {
        StSymbol stSymbol = null;
        if (this.getColorBarView().sliderRectangle().containsPoint_(point)) {
            stSymbol = JunColorBarController.$((String)"slider");
        } else if (this.getColorBarView().firstMarkerRectangle().containsPoint_(point)) {
            stSymbol = JunColorBarController.$((String)"firstMarker");
        } else if (this.getColorBarView().lastMarkerRectangle().containsPoint_(point)) {
            stSymbol = JunColorBarController.$((String)"lastMarker");
        } else if (this.getColorBarView().anotherIntervalRectangle().containsPoint_(point)) {
            stSymbol = JunColorBarController.$((String)"interval");
        } else if (this.getColorBarView().rangeArea().containsPoint_(point)) {
            stSymbol = JunColorBarController.$((String)"slider");
        }
        return stSymbol;
    }
}

