/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.calendar;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Calendar;
import jp.co.sra.jun.goodies.calendar.JunCalendarDateView;
import jp.co.sra.jun.goodies.calendar.JunCalendarDateViewAwt;
import jp.co.sra.jun.goodies.calendar.JunCalendarDateViewSwing;
import jp.co.sra.jun.goodies.calendar.JunCalendarModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunCalendarDateModel
extends JunCalendarModel {
    protected Calendar calendarDate;
    protected Calendar originalDate;
    protected int[][] calendarMatrix;
    protected StBlockClosure validateBlock;
    protected String[] monthNames;
    protected String[] weekdayNames;
    protected StDisplayable displayObject;
    protected StPopupMenu _popupMenu;

    public JunCalendarDateModel() {
        this.initialize();
    }

    public static JunCalendarDateModel Date_(Calendar calendar) {
        JunCalendarDateModel junCalendarDateModel = new JunCalendarDateModel();
        junCalendarDateModel.date_(calendar);
        return junCalendarDateModel;
    }

    public static JunCalendarDateModel Year_month_day_(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, 1);
        calendar.set(calendar.get(1), calendar.get(2) - 1, Math.max(1, Math.min(n3, calendar.getActualMaximum(5))));
        return JunCalendarDateModel.Date_(calendar);
    }

    public void initialize() {
        this.initialize_(Calendar.getInstance());
    }

    public void initialize_(Calendar calendar) {
        this.date_(calendar);
        this.originalDate = calendar;
        this.monthNames = null;
        this.weekdayNames = null;
        this._popupMenu = null;
    }

    public int atPoint_(Point point) {
        int[][] nArray = this.calendarMatrix();
        return nArray[point.y][point.x];
    }

    public Calendar date() {
        return this.calendarDate;
    }

    public void date_(Calendar calendar) {
        Calendar calendar2;
        Calendar calendar3 = null;
        if (this.date() != null) {
            calendar3 = (Calendar)this.date().clone();
        }
        if ((calendar2 = (Calendar)this.validateBlock().value_value_((Object)calendar3, (Object)calendar)) == null) {
            return;
        }
        this.calendarDate = calendar2;
        this.makeCalendarMatrix();
        if (calendar3 == null) {
            this.changed_(JunCalendarDateModel.$((String)"date"));
            return;
        }
        if (calendar3.get(1) != this.calendarDate.get(1)) {
            this.changed_(JunCalendarDateModel.$((String)"year"));
            return;
        }
        if (calendar3.get(2) != this.calendarDate.get(2)) {
            this.changed_(JunCalendarDateModel.$((String)"month"));
            return;
        }
        if (calendar3.get(5) != this.calendarDate.get(5)) {
            this.changed_(JunCalendarDateModel.$((String)"day"));
            return;
        }
    }

    public int day() {
        return this.date().get(5);
    }

    public void day_(int n) {
        if (1 > n || n > this.date().getActualMaximum(5)) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year(), this.month() - 1, n);
        this.date_(calendar);
    }

    public int month() {
        return this.date().get(2) + 1;
    }

    public void month_(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year(), Math.max(0, Math.min(n - 1, 11)), 1);
        calendar.set(calendar.get(1), calendar.get(2), Math.min(this.day(), calendar.getActualMaximum(5)));
        this.date_(calendar);
    }

    public String[] monthNames() {
        if (this.monthNames == null) {
            String[] stringArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
            this.monthNames = stringArray;
        }
        return this.monthNames;
    }

    public Calendar original() {
        return this.originalDate;
    }

    public StBlockClosure validateBlock() {
        if (this.validateBlock == null) {
            this.validateBlock = new StBlockClosure(){

                public Object value_value_(Object object, Object object2) {
                    return object2;
                }
            };
        }
        return this.validateBlock;
    }

    public void validateBlock_(StBlockClosure stBlockClosure) {
        this.validateBlock = stBlockClosure;
    }

    public String[] weekdayNames() {
        if (this.weekdayNames == null) {
            String[] stringArray = new String[]{JunSystem.$String((String)"Su.", (String)"Su"), JunSystem.$String((String)"Mo.", (String)"Mo"), JunSystem.$String((String)"Tu.", (String)"Tu"), JunSystem.$String((String)"We.", (String)"We"), JunSystem.$String((String)"Th.", (String)"Th"), JunSystem.$String((String)"Fr.", (String)"Fr"), JunSystem.$String((String)"Sa.", (String)"Sa")};
            this.weekdayNames = stringArray;
        }
        return this.weekdayNames;
    }

    public int year() {
        return this.date().get(1);
    }

    public void year_(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Math.max(n, 100), this.date().get(2), 1);
        calendar.set(calendar.get(1), calendar.get(2), Math.min(this.date().get(5), calendar.getActualMaximum(5)));
        this.date_(calendar);
    }

    public void monthDown() {
        int n;
        int n2;
        Calendar calendar = Calendar.getInstance();
        if (this.month() == 1) {
            n2 = this.year() - 1;
            n = 12;
        } else {
            n2 = this.year();
            n = this.month() - 1;
        }
        calendar.set(n2, n - 1, 1);
        calendar.set(calendar.get(1), calendar.get(2), Math.min(this.day(), calendar.getActualMaximum(5)));
        this.date_(calendar);
        this.changed_(JunCalendarDateModel.$((String)"month"));
    }

    public void monthUp() {
        int n;
        int n2;
        Calendar calendar = Calendar.getInstance();
        if (this.month() == 12) {
            n2 = this.year() + 1;
            n = 1;
        } else {
            n2 = this.year();
            n = this.month() + 1;
        }
        calendar.set(n2, n - 1, 1);
        calendar.set(calendar.get(1), calendar.get(2), Math.min(this.day(), calendar.getActualMaximum(5)));
        this.date_(calendar);
        this.changed_(JunCalendarDateModel.$((String)"month"));
    }

    public void yearDown() {
        this.year_(this.year() - 1);
        this.changed_(JunCalendarDateModel.$((String)"year"));
    }

    public void yearUp() {
        this.year_(this.year() + 1);
        this.changed_(JunCalendarDateModel.$((String)"year"));
    }

    public StView calendarDateView() {
        StView stView = this.defaultView();
        return stView;
    }

    public StView defaultView() {
        JunCalendarDateView junCalendarDateView = JunCalendarDateModel.GetDefaultViewMode() == 0 ? new JunCalendarDateViewAwt(this) : new JunCalendarDateViewSwing(this);
        return junCalendarDateView;
    }

    public StPopupMenu _popupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new StPopupMenu();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Copy"), (MenuListener)new MenuPerformer((StObject)this, "copyDate")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Today's date", (String)"Today"), (MenuListener)new MenuPerformer((StObject)this, "todayDate")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Original date"), (MenuListener)new MenuPerformer((StObject)this, "originalDate")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Month down"), (MenuListener)new MenuPerformer((StObject)this, "monthDown")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Month up"), (MenuListener)new MenuPerformer((StObject)this, "monthUp")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Year down"), (MenuListener)new MenuPerformer((StObject)this, "yearDown")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Year up"), (MenuListener)new MenuPerformer((StObject)this, "yearUp")));
        }
        return this._popupMenu;
    }

    public void copyDate() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.monthNames()[this.month() - 1]);
        stringBuffer.append(' ');
        stringBuffer.append(this.day());
        stringBuffer.append(", ");
        stringBuffer.append(this.year());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuffer.toString()), null);
    }

    public void originalDate() {
        this.date_(this.original());
    }

    public void todayDate() {
        this.date_(Calendar.getInstance());
    }

    public int[][] calendarMatrix() {
        if (this.calendarMatrix == null) {
            this.makeCalendarMatrix();
        }
        return this.calendarMatrix;
    }

    private void makeCalendarMatrix() {
        int n;
        int n2;
        int n3;
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year(), this.month() - 1, 1);
        int n4 = calendar.get(7);
        Integer[][] integerArray = new Integer[6][7];
        int n5 = n4 - 1;
        int n6 = 0;
        for (n3 = 0; n3 < calendar.getActualMaximum(5); ++n3) {
            integerArray[n6][n5] = new Integer(n3 + 1);
            if (++n5 <= 6) continue;
            n5 = 0;
            ++n6;
        }
        n3 = 0;
        for (int i = 0; i < integerArray.length; ++i) {
            n2 = 0;
            for (n = 0; n < integerArray[i].length; ++n) {
                if (integerArray[i][n] != null) continue;
                ++n2;
            }
            if (n2 >= 7) continue;
            ++n3;
        }
        int[][] nArray = new int[n3][7];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 7; ++n) {
                if (integerArray[n2][n] == null) continue;
                nArray[n2][n] = integerArray[n2][n];
            }
        }
        this.calendarMatrix = nArray;
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"YYMMDD", (String)"Date");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.month());
        stringBuffer.append(" ");
        stringBuffer.append(this.day());
        stringBuffer.append(",");
        stringBuffer.append(this.year());
        return stringBuffer.toString();
    }

    public String printCalendarString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printCalendarOn_(stringBuffer);
        return stringBuffer.toString();
    }

    public void printCalendarOn_(StringBuffer stringBuffer) {
        int n;
        Calendar calendar = this.date();
        stringBuffer.append(calendar.get(1));
        stringBuffer.append("\t");
        stringBuffer.append(this.monthNames()[calendar.get(2)]);
        stringBuffer.append("\t");
        stringBuffer.append("\n");
        for (n = 0; n < this.weekdayNames().length; ++n) {
            stringBuffer.append(this.weekdayNames()[n]);
            if (n >= this.weekdayNames().length) continue;
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.calendarMatrix().length; ++n) {
            for (int i = 0; i < this.calendarMatrix()[n].length; ++i) {
                if (this.calendarMatrix()[n][i] != 0) {
                    stringBuffer.append(this.calendarMatrix()[n][i]);
                }
                if (n >= this.calendarMatrix().length) continue;
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
    }

    public void setDate_(Calendar calendar) {
        this.calendarDate = calendar;
    }
}

