/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.bulletinboard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoardViewAwt;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoardViewSwing;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinElement;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.SystemResourceSupport;

public class JunBulletinBoard
extends JunApplicationModel {
    protected static final int DefaultBulletinHeight = 48;
    protected static final Color DefaultBackgroundColor = Color.getHSBColor(0.0f, 0.0f, 0.833354f);
    protected Vector bulletinElements;
    protected Color bulletinColor;
    protected Rectangle bulletinBounds;
    protected Color _backgroundColor;

    public JunBulletinBoard() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ConvertToFlatString_(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            if (Character.isWhitespace(string.charAt(0))) {
                return String.valueOf(' ');
            }
            return string;
        }
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedWriter = new BufferedWriter(stringWriter);
            bufferedReader = new BufferedReader(new StringReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() > 0) {
                    bufferedWriter.write(string2);
                    continue;
                }
                bufferedWriter.write(32);
            }
        }
        catch (IOException iOException) {
            stringWriter.write("!!! failed to convert to a flat string !!!");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringWriter.toString();
    }

    public static Font Font() {
        return JunBulletinBoard.FontHeight_(48);
    }

    protected static Font FontHeight_(int n) {
        Font font = SystemResourceSupport.getFont();
        return font.deriveFont(0, Math.max(1, n));
    }

    public void add_(char c) {
        this.add_(new Character(c));
    }

    public void add_(Object object) {
        JunBulletinElement junBulletinElement = new JunBulletinElement();
        junBulletinElement.entity_(object);
        junBulletinElement.color_(this.color());
        this.bulletinElements.add(junBulletinElement);
        this.flushBounds();
    }

    public Color backgroundColor() {
        return this._backgroundColor;
    }

    public void backgroundColor_(Color color) {
        this._backgroundColor = color;
    }

    public Rectangle bounds() {
        if (this.bulletinBounds == null) {
            this.bulletinBounds = this.preferredBounds();
        }
        return this.bulletinBounds;
    }

    public Color color() {
        return this.bulletinColor;
    }

    public void color_(Color color) {
        this.bulletinColor = color;
    }

    public JunBulletinElement[] elements() {
        JunBulletinElement[] junBulletinElementArray = new JunBulletinElement[this.bulletinElements.size()];
        this.bulletinElements.copyInto((Object[])junBulletinElementArray);
        return junBulletinElementArray;
    }

    public void fontHeight_(int n) {
        Font font = JunBulletinBoard.FontHeight_(n);
        JunBulletinElement[] junBulletinElementArray = this.elements();
        for (int i = 0; i < junBulletinElementArray.length; ++i) {
            junBulletinElementArray[i].font_(font);
        }
        this.flushBounds();
    }

    public int height() {
        return this.bounds().height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage imageLocation_width_(int n, int n2) {
        Rectangle rectangle = new Rectangle(n, 0, n2, this.height());
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        try {
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            JunBulletinElement[] junBulletinElementArray = this.elements();
            for (int i = 0; i < junBulletinElementArray.length; ++i) {
                Rectangle rectangle2 = junBulletinElementArray[i].rectangle();
                if (!rectangle2.intersects(rectangle)) continue;
                int n3 = rectangle2.x - n;
                int n4 = rectangle2.y;
                graphics.setColor(junBulletinElementArray[i].color());
                junBulletinElementArray[i].entity().displayOn_at_(graphics, new Point(n3, n4));
            }
        }
        finally {
            graphics.dispose();
        }
        return bufferedImage;
    }

    public Frame open() {
        if (JunBulletinBoard.GetDefaultViewMode() == 0) {
            return JunBulletinBoardViewAwt.OpenOn_(this);
        }
        return JunBulletinBoardViewSwing.OpenOn_(this);
    }

    public int width() {
        return this.bounds().width;
    }

    protected void flushBounds() {
        this.bulletinBounds = null;
    }

    protected void initialize() {
        super.initialize();
        this.bulletinElements = new Vector();
        this.bulletinColor = Color.black;
        this.bulletinBounds = new Rectangle(0, 0, 0, 0);
        this._backgroundColor = DefaultBackgroundColor;
    }

    protected Rectangle preferredBounds() {
        int n;
        int n2 = 0;
        int n3 = 0;
        JunBulletinElement[] junBulletinElementArray = this.elements();
        for (n = 0; n < junBulletinElementArray.length; ++n) {
            n2 += junBulletinElementArray[n].width();
            n3 = Math.max(n3, junBulletinElementArray[n].height());
        }
        n = 0;
        for (int i = 0; i < junBulletinElementArray.length; ++i) {
            int n4 = (n3 - junBulletinElementArray[i].height()) / 2;
            Rectangle rectangle = junBulletinElementArray[i].rectangle();
            rectangle.translate(n - rectangle.x, n4 - rectangle.y);
            junBulletinElementArray[i].rectangle_(rectangle);
            n += junBulletinElementArray[i].width();
        }
        return new Rectangle(0, 0, n2, n3);
    }

    public StView defaultView() {
        if (JunBulletinBoard.GetDefaultViewMode() == 0) {
            return new JunBulletinBoardViewAwt(this);
        }
        return new JunBulletinBoardViewSwing(this);
    }
}

