/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.animation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.sra.jun.goodies.animation.JunCartoonMovieView;
import jp.co.sra.jun.goodies.animation.JunCartoonMovieViewAwt;
import jp.co.sra.jun.goodies.animation.JunCartoonMovieViewSwing;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunGifAnimationStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.goodies.track.JunTrackSliderModel;
import jp.co.sra.jun.goodies.track.JunTrackSliderView;
import jp.co.sra.jun.goodies.track.JunTrackerModel;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunCartoonMovie
extends JunApplicationModel {
    protected JunTrackerModel trackerModel;
    protected JunTrackSliderModel trackerModel2;
    protected ArrayList imageCollection;
    protected ArrayList timeCollection;
    protected StValueHolder progressText;
    protected Timer playProcess;
    protected String displayName;
    protected StMenuBar _menuBar;

    public JunCartoonMovie() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunCartoonMovie(File file, final String string, int n) throws IOException {
        if (!file.exists()) {
            throw new IOException(file.getPath() + " does not exist.");
        }
        if (!file.isDirectory()) {
            throw new IOException(file.getPath() + " is not a directory.");
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string2) {
                return JunStringUtility.StringMatch_and_(string2, string);
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            throw new IOException("No image in " + file.getPath());
        }
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            for (int i = 0; i < fileArray.length; ++i) {
                JunImageStream junImageStream = null;
                try {
                    junImageStream = JunJpegImageStream.On_(new FileInputStream(fileArray[i]));
                    this.addImage_framesPerSecond_(junImageStream.nextImage(), n);
                    continue;
                }
                finally {
                    if (junImageStream != null) {
                        junImageStream.close();
                    }
                }
            }
        }
        finally {
            junCursors._restore();
        }
    }

    public JunCartoonMovie(File file) throws IOException {
        this.openGifAnimationFrom_(file);
    }

    protected void initialize() {
        super.initialize();
        this.trackerModel = null;
        this.imageCollection = null;
        this.timeCollection = null;
        this.progressText = null;
        this.playProcess = null;
        this._menuBar = null;
    }

    public double cumulativeTimeUntilIndex_(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.timeCollection().size()) {
            return this.totalMilliseconds();
        }
        double d = 0.0;
        for (int i = 0; i < n + 1; ++i) {
            d += ((Double)this.timeCollection().get(i)).doubleValue();
        }
        return d;
    }

    public double currentMilliseconds() {
        return this.now() * this.totalMilliseconds();
    }

    public String displayName() {
        if (this.displayName == null) {
            this.displayName = "";
        }
        return this.displayName;
    }

    public void displayName_(String string) {
        this.displayName = string;
    }

    public StImage imageAtCumulativeTime_(double d) {
        int n = this.indexAtCumulativeTime_(d);
        if (n < 0) {
            return this.defaultBlueImage();
        }
        return (StImage)this.imageCollection().get(n);
    }

    public ArrayList imageCollection() {
        if (this.imageCollection == null) {
            this.imageCollection = new ArrayList();
        }
        return this.imageCollection;
    }

    public StImage imageToDisplay() {
        return this.imageAtCumulativeTime_(this.currentMilliseconds());
    }

    public int indexAtCumulativeTime_(double d) {
        int n = this.timeCollection().size();
        if (d <= 0.0 || d > this.totalMilliseconds()) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            if (!(this.cumulativeTimeUntilIndex_(i - 1) <= d) || !(d < this.cumulativeTimeUntilIndex_(i))) continue;
            return i;
        }
        return n - 1;
    }

    public StValueHolder progressText() {
        if (this.progressText == null) {
            this.progressText = new StValueHolder((Object)"");
            this.updateProgressText();
        }
        return this.progressText;
    }

    public ArrayList timeCollection() {
        if (this.timeCollection == null) {
            this.timeCollection = new ArrayList();
        }
        return this.timeCollection;
    }

    public double totalMilliseconds() {
        double d = 0.0;
        for (int i = 0; i < this.timeCollection().size(); ++i) {
            double d2 = (Double)this.timeCollection().get(i);
            d += d2;
        }
        return d;
    }

    public JunTrackerModel trackerModel() {
        if (this.trackerModel != null) {
            return this.trackerModel;
        }
        this.trackerModel = new JunTrackerModel();
        this.trackerModel.addDependent_((DependentListener)this);
        final JunCartoonMovie junCartoonMovie = this;
        this.trackerModel.playButton().action_(new StBlockClosure(){

            public Object value_(Object object) {
                junCartoonMovie.playAction_((JunButtonModel)((Object)object));
                return null;
            }
        });
        this.trackerModel.loopButton().action_(new StBlockClosure(){

            public Object value_(Object object) {
                junCartoonMovie.loopAction_((JunButtonModel)((Object)object));
                return null;
            }
        });
        this.trackerModel.nextButton().action_(new StBlockClosure(){

            public Object value_(Object object) {
                junCartoonMovie.nextAction_((JunButtonModel)((Object)object));
                return null;
            }
        });
        this.trackerModel.previousButton().action_(new StBlockClosure(){

            public Object value_(Object object) {
                junCartoonMovie.previousAction_((JunButtonModel)((Object)object));
                return null;
            }
        });
        this.trackerModel.compute_(new StBlockClosure(){

            public Object value_(Object object) {
                junCartoonMovie.setTime_((Double)object);
                return null;
            }
        });
        this.trackerModel.enableMarkers();
        return this.trackerModel;
    }

    public JunTrackSliderModel trackerModel2() {
        if (this.trackerModel2 == null) {
            this.trackerModel2 = new JunTrackSliderModel();
            this.trackerModel2.parentTracker_(this.trackerModel());
            final JunCartoonMovie junCartoonMovie = this;
            this.trackerModel2.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    junCartoonMovie.setTime2_((Double)object);
                    return null;
                }
            });
        }
        return this.trackerModel2;
    }

    public void addImage_framesPerSecond_(StImage stImage, int n) {
        this.addImage_keepTime_(stImage, 1000.0 / (double)Math.min(Math.max(1, n), 1000));
    }

    public void addImage_keepTime_(StImage stImage, double d) {
        this.imageCollection().add(stImage);
        this.timeCollection().add(new Double(d));
        double d2 = this.totalMilliseconds();
        if (d2 <= 0.0) {
            this.trackerModel().step_(1.0);
        } else {
            this.trackerModel().step_(1.0 / d2);
        }
        this.updateMenuIndication();
    }

    public void loopAction_(JunButtonModel junButtonModel) {
        if (this.trackerModel().loopCondition() == JunCartoonMovie.$((String)"oneWay")) {
            this.trackerModel().loop();
        } else {
            this.trackerModel().oneWay();
        }
        this.updatePlayMenuIndication();
    }

    public void nextAction_(JunButtonModel junButtonModel) {
        if (junButtonModel._isPressedWithShiftDown()) {
            this.last();
        } else {
            this.next();
        }
    }

    public void playAction_(JunButtonModel junButtonModel) {
        if (junButtonModel.value()) {
            this.stop();
        } else {
            if (junButtonModel._isPressedWithShiftDown()) {
                this.trackerModel().first();
            }
            this.start();
        }
        this.updatePlayMenuIndication();
    }

    public void previousAction_(JunButtonModel junButtonModel) {
        if (junButtonModel._isPressedWithShiftDown()) {
            this.first();
        } else {
            this.previous();
        }
    }

    public StImage asImage() {
        return this.imageToDisplay();
    }

    public StImage defaultBlueImage() {
        StImage stImage = new StImage(this.defaultBlueImageExtent());
        Graphics graphics = stImage.image().getGraphics();
        graphics.setColor(Color.blue);
        graphics.fillRect(0, 0, stImage.width(), stImage.height());
        return stImage;
    }

    public Point defaultBlueImageExtent() {
        return new Point(320, 240);
    }

    public Color defaultDisplayNameColor() {
        Color color = Color.black;
        Color color2 = Color.green;
        Color color3 = new Color(color.getRed() + color2.getRed(), color.getGreen() + color2.getGreen(), color.getBlue() + color2.getBlue());
        return color3;
    }

    public Object imagesAndTimesDo_(StBlockClosure stBlockClosure) {
        for (int i = 0; i < this.imageCollection().size(); ++i) {
            Double d;
            StImage stImage = (StImage)this.imageCollection().get(i);
            Object object = stBlockClosure.value_value_((Object)stImage, (Object)(d = (Double)this.timeCollection().get(i)));
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        if (this.playProcess != null) {
            this.playProcess.cancel();
            this.playProcess = null;
        }
        super.noticeOfWindowClose(windowEvent);
    }

    public void openAndPlay() {
        this.openLightWeightWindowSpecFitFlag_(true);
        this.start();
    }

    public Frame openLightWeightWindowSpec() {
        return this.openLightWeightWindowSpecAt_fitFlag_markerFlag_(null, true, false);
    }

    public Frame openLightWeightWindowSpecAt_fitFlag_markerFlag_(Point point, boolean bl, boolean bl2) {
        Frame frame = null;
        StView stView = this.defaultViewWithSimpleTracker();
        frame = point == null ? this.openView_(stView) : this.openViewAt_(stView, point);
        if (bl) {
            this.normalSize();
        }
        if (bl2) {
            this.trackerModel().enableMarkers();
        } else {
            this.trackerModel().disableMarkers();
        }
        return frame;
    }

    public Frame openLightWeightWindowSpecFitFlag_(boolean bl) {
        return this.openLightWeightWindowSpecAt_fitFlag_markerFlag_(null, bl, false);
    }

    public Frame openLightWeightWindowSpecFitFlag_markerFlag_(boolean bl, boolean bl2) {
        return this.openLightWeightWindowSpecAt_fitFlag_markerFlag_(null, bl, bl2);
    }

    public Frame openLightWeightWindowSpecMarkerFlag_(boolean bl) {
        return this.openLightWeightWindowSpecAt_fitFlag_markerFlag_(null, false, bl);
    }

    public StView defaultView() {
        return this.defaultViewWithTracker();
    }

    public StView defaultViewWithTracker() {
        if (JunCartoonMovie.GetDefaultViewMode() == 0) {
            return JunCartoonMovieViewAwt.WithTracker(this);
        }
        return JunCartoonMovieViewSwing.WithTracker(this);
    }

    public StView defaultViewWithSimpleTracker() {
        if (JunCartoonMovie.GetDefaultViewMode() == 0) {
            return JunCartoonMovieViewAwt.WithSimpleTracker(this);
        }
        return JunCartoonMovieViewSwing.WithSimpleTracker(this);
    }

    protected String windowTitle() {
        return JunCartoonMovie.$String((String)"Cartoon Movie Player");
    }

    public KeyListener _keyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (JunCartoonMovie.this._keyboardEvent(keyEvent)) {
                    keyEvent.consume();
                }
            }
        };
    }

    protected boolean _keyboardEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 10: 
            case 32: {
                if (this.isPlay()) {
                    this.stop();
                } else {
                    this.start();
                }
                return true;
            }
            case 37: {
                this.previousAction_(this.trackerModel().previousButton());
                return true;
            }
            case 39: {
                this.nextAction_(this.trackerModel().nextButton());
                return true;
            }
            case 9: {
                if (this.trackerModel().loopCondition() == JunCartoonMovie.$((String)"oneWay")) {
                    this.trackerModel().loopCondition_(JunCartoonMovie.$((String)"loop"));
                } else {
                    this.trackerModel().loopCondition_(JunCartoonMovie.$((String)"oneWay"));
                }
                return true;
            }
            case 91: {
                this.trackerModel().firstMarker_(this.now());
                return true;
            }
            case 93: {
                this.trackerModel().lastMarker_(this.now());
                return true;
            }
            case 80: {
                this.prologue();
                return true;
            }
            case 69: {
                this.epilogue();
                return true;
            }
            case 70: {
                this.trackerModel().first();
                return true;
            }
            case 76: {
                this.trackerModel().last();
                return true;
            }
        }
        return false;
    }

    public void updateMenuIndication() {
        super.updateMenuIndication();
        this.updateFileMenuIndication();
        this.updatePlayMenuIndication();
        this.updatePositionMenuIndication();
        this.updateMiscMenuIndication();
    }

    protected void updateFileMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunCartoonMovie.$((String)"fileMenu"));
        if (stMenu == null) {
            return;
        }
        StMenuItem stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"saveAsGifAnimation"));
        if (stMenuItem != null) {
            if (this.isEmpty()) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"saveAsMovie"))) != null) {
            if (this.isEmpty()) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
    }

    protected void updatePlayMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunCartoonMovie.$((String)"playMenu"));
        if (stMenu == null) {
            return;
        }
        StMenuItem stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"start"));
        if (stMenuItem != null) {
            if (this.isEmpty()) {
                stMenuItem.disable();
            } else if (this.isPlay()) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"stop"))) != null) {
            if (this.isEmpty()) {
                stMenuItem.disable();
            } else if (this.isPlay()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"loopPlay"))) != null) {
            if (this.trackerModel().loopCondition() == JunCartoonMovie.$((String)"loop")) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"oneWayPlay"))) != null) {
            if (this.trackerModel().loopCondition() == JunCartoonMovie.$((String)"oneWay")) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
    }

    protected void updatePositionMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunCartoonMovie.$((String)"positionMenu"));
        if (stMenu == null) {
            return;
        }
        StMenuItem stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"gotoPrevious"));
        if (stMenuItem != null) {
            if (this.isEmpty()) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"gotoNext"))) != null) {
            if (this.isEmpty()) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"gotoFirst"))) != null) {
            if (this.trackerModel().areMarkersActive()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"gotoLast"))) != null) {
            if (this.trackerModel().areMarkersActive()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"setFirstMarker"))) != null) {
            if (this.trackerModel().areMarkersActive()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunCartoonMovie.$((String)"setLastMarker"))) != null) {
            if (this.trackerModel().areMarkersActive()) {
                stMenuItem.enable();
            } else {
                stMenuItem.disable();
            }
        }
    }

    protected void updateMiscMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunCartoonMovie.$((String)"positionMenu"));
        if (stMenu == null) {
            return;
        }
    }

    public void doubleSize() {
        int n = -1;
        int n2 = -1;
        StImage[] stImageArray = this.imageCollection().toArray(new StImage[this.imageCollection().size()]);
        for (int i = 0; i < stImageArray.length; ++i) {
            n = Math.max(n, stImageArray[i].width());
            n2 = Math.max(n2, stImageArray[i].height());
        }
        if (n <= 0 || n2 <= 0) {
            return;
        }
        this.setSize_(new Dimension(n * 2, n2 * 2));
    }

    public void gotoEpilogue() {
        this.epilogue();
    }

    public void gotoFirst() {
        this.first();
    }

    public void gotoLast() {
        this.last();
    }

    public void gotoNext() {
        this.next();
    }

    public void gotoPrevious() {
        this.previous();
    }

    public void gotoPrologue() {
        this.prologue();
    }

    public void halfSize() {
        int n = -1;
        int n2 = -1;
        StImage[] stImageArray = this.imageCollection().toArray(new StImage[this.imageCollection().size()]);
        for (int i = 0; i < stImageArray.length; ++i) {
            n = Math.max(n, stImageArray[i].width());
            n2 = Math.max(n2, stImageArray[i].height());
        }
        if (n <= 0 || n2 <= 0) {
            return;
        }
        this.setSize_(new Dimension(n / 2, n2 / 2));
    }

    public void loopPlay() {
        this.trackerModel().loop();
        this.updatePlayMenuIndication();
    }

    public void normalSize() {
        int n = -1;
        int n2 = -1;
        StImage[] stImageArray = this.imageCollection().toArray(new StImage[this.imageCollection().size()]);
        for (int i = 0; i < stImageArray.length; ++i) {
            n = Math.max(n, stImageArray[i].width());
            n2 = Math.max(n2, stImageArray[i].height());
        }
        if (n <= 0 || n2 <= 0) {
            return;
        }
        this.setSize_(new Dimension(n, n2));
    }

    public void oneWayPlay() {
        this.trackerModel().oneWay();
        this.updatePlayMenuIndication();
    }

    public void openGifAnimation() throws IOException {
        File file = JunCartoonMovie.RequestFile();
        if (file == null) {
            return;
        }
        this.openGifAnimationFrom_(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openGifAnimationFrom_(File file) throws IOException {
        Object[] objectArray;
        if (file == null || !file.exists()) {
            return;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        JunGifAnimationStream junGifAnimationStream = null;
        try {
            junGifAnimationStream = (JunGifAnimationStream)JunGifAnimationStream.On_(new FileInputStream(file));
            JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
            try {
                junCursors._show();
                objectArray = null;
                while ((objectArray = junGifAnimationStream.nextImage()) != null) {
                    int n = junGifAnimationStream.tick();
                    arrayList.add(new Object[]{objectArray, new Integer(n)});
                }
            }
            finally {
                junCursors._restore();
            }
        }
        finally {
            if (junGifAnimationStream != null) {
                junGifAnimationStream.close();
            }
        }
        this.imageCollection = null;
        this.timeCollection = null;
        if (junGifAnimationStream.loop() == 0) {
            this.loopPlay();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray = (Object[])arrayList.get(i);
            StImage stImage = (StImage)objectArray[0];
            int n = ((Number)objectArray[1]).intValue();
            this.addImage_keepTime_(stImage, n);
        }
        this.normalSize();
        this.goto_(0.0);
    }

    public void quitDoing() {
        this.closeRequest();
    }

    public void saveAsGifAnimation() throws IOException {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunCartoonMovie.$String((String)"GifAnimation files"), new String[]{"*.gif", "*.GIF"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunCartoonMovie.$String((String)"Input a GifAnimation file."), new File(this.defaultBaseName() + ".gif"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        this.saveAsGifAnimationTo_(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsGifAnimationTo_(File file) throws IOException {
        JunGifAnimationStream junGifAnimationStream = null;
        try {
            junGifAnimationStream = (JunGifAnimationStream)JunGifAnimationStream.On_(new FileOutputStream(file));
            if (this.trackerModel().loopCondition() == JunCartoonMovie.$((String)"loop")) {
                junGifAnimationStream.loop_(0);
            } else {
                junGifAnimationStream.loop_(1);
            }
            JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
            try {
                junCursors._show();
                final JunGifAnimationStream junGifAnimationStream2 = junGifAnimationStream;
                Object object = this.imagesAndTimesDo_(new StBlockClosure(){

                    public Object value_value_(Object object, Object object2) {
                        junGifAnimationStream2.tick_(((Number)object2).intValue());
                        try {
                            junGifAnimationStream2.nextPutImage_((StImage)object);
                        }
                        catch (IOException iOException) {
                            return iOException;
                        }
                        return null;
                    }
                });
                if (object != null && object instanceof IOException) {
                    throw (IOException)object;
                }
            }
            finally {
                junCursors._restore();
            }
        }
        finally {
            if (junGifAnimationStream != null) {
                junGifAnimationStream.close();
            }
        }
    }

    public void saveAsMovie() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunCartoonMovie.$String((String)"Movie files"), new String[]{"*.mov", "*.MOV"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunCartoonMovie.$String((String)"Input a <1p> file.", null, (Object)JunCartoonMovie.$String((String)"Movie")), new File(this.defaultBaseName() + ".mov"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        this.saveAsMovieTo_(file);
    }

    public void saveAsMovieTo_(File file) {
        final StView stView = this.getView();
        StRectangle stRectangle = stView == null ? new StRectangle(0, 0, 320, 240) : new StRectangle(stView.toComponent().getBounds());
        JunImagesToMovie.File_extent_do_(file, new Dimension(stRectangle.width(), stRectangle.height()), new StBlockClosure(){

            public Object value_(Object object) {
                final JunImagesToMovie junImagesToMovie = (JunImagesToMovie)((Object)object);
                if (stView != null) {
                    junImagesToMovie.background_(stView.toComponent().getBackground());
                }
                new JunProgress().do_(new StBlockClosure(){

                    public Object value_(Object object) {
                        final JunProgress junProgress = (JunProgress)((Object)object);
                        final Integer[] integerArray = new Integer[]{new Integer(0), new Integer(0)};
                        final int n = JunCartoonMovie.this.imageCollection().size();
                        junProgress.value_(integerArray[1] / n);
                        junProgress.message_(1.$String((String)"writing..."));
                        JunCartoonMovie.this.imagesAndTimesDo_(new StBlockClosure(){

                            public Object value_value_(Object object, Object object2) {
                                StImage stImage = (StImage)object;
                                int n2 = ((Double)object2).intValue();
                                if (n2 > 0) {
                                    junImagesToMovie.add_milliseconds_(stImage, n2);
                                }
                                integerArray[1] = new Integer(integerArray[1] + 1);
                                integerArray[0] = new Integer(integerArray[0] + n2);
                                junProgress.value_(integerArray[1] / n);
                                junProgress.message_(1.$String((String)"writing..."));
                                return null;
                            }
                        });
                        return Boolean.TRUE;
                    }
                });
                return null;
            }
        });
    }

    public void setFirstMarker() {
        this.trackerModel().firstMarkerButton().action().value_((Object)this.trackerModel().firstMarkerButton());
    }

    public void setLastMarker() {
        this.trackerModel().lastMarkerButton().action().value_((Object)this.trackerModel().lastMarkerButton());
    }

    public void epilogue() {
        this.goto_(1.0);
    }

    public void first() {
        this.trackerModel().first();
    }

    public void goto_(double d) {
        this.trackerModel().value_(d);
    }

    public void last() {
        this.trackerModel().last();
    }

    public void next() {
        if (this.isEmpty()) {
            return;
        }
        int n = this.indexAtCumulativeTime_(this.currentMilliseconds());
        double d = this.cumulativeTimeUntilIndex_(n);
        double d2 = this.totalMilliseconds();
        double d3 = d2 <= 0.0 ? 1.0 : d / d2;
        this.goto_(d3);
    }

    public double now() {
        return this.trackerModel().doubleValue();
    }

    public void previous() {
        double d;
        if (this.isEmpty()) {
            return;
        }
        int n = this.indexAtCumulativeTime_(this.currentMilliseconds());
        double d2 = this.cumulativeTimeUntilIndex_(n);
        double d3 = (Double)this.timeCollection().get(n);
        if (this.currentMilliseconds() == (d2 -= d3)) {
            n = Math.max(n - 1, 0);
            d3 = (Double)this.timeCollection().get(n);
            while (n > 1 && d3 == 0.0) {
                n = Math.max(n - 1, 0);
                d3 = (Double)this.timeCollection().get(n);
            }
            d2 = this.cumulativeTimeUntilIndex_(n);
            d3 = (Double)this.timeCollection().get(n);
            d2 -= d3;
        }
        double d4 = (d = this.totalMilliseconds()) <= 0.0 ? 0.0 : d2 / d;
        this.goto_(d4);
    }

    public void prologue() {
        this.goto_(0.0);
    }

    public void start() {
        if (this.isEmpty()) {
            return;
        }
        if (this.playProcess != null) {
            this.playProcess.cancel();
        }
        this.trackerModel().playButtonVisual_(true);
        if (this.now() >= 1.0) {
            this.prologue();
        }
        if (this.trackerModel().isIntervalNotEmpty() && (this.now() <= this.trackerModel().firstMarker() || this.trackerModel().lastMarker() <= this.now())) {
            this.first();
        }
        double d = this.currentMilliseconds();
        double d2 = this.totalMilliseconds();
        final double[] dArray = new double[]{d, d2};
        this.playProcess = new Timer();
        this.playProcess.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                double d = dArray[0];
                double d2 = dArray[1];
                double d3 = JunCartoonMovie.this.currentMilliseconds() + (double)JunCartoonMovie.this.tickTime();
                if (d == d3) {
                    d3 += (double)JunCartoonMovie.this.tickTime();
                }
                if (d2 <= 0.0) {
                    JunCartoonMovie.this.epilogue();
                } else {
                    JunCartoonMovie.this.goto_(d3 / d2);
                }
                if (d3 >= d2) {
                    if (JunCartoonMovie.this.trackerModel().loopCondition() == StObject.$((String)"loop")) {
                        JunCartoonMovie.this.prologue();
                    } else {
                        JunCartoonMovie.this.stop();
                        JunCartoonMovie.this.last();
                    }
                }
                if (JunCartoonMovie.this.trackerModel().isIntervalNotEmpty() && d3 >= JunCartoonMovie.this.trackerModel().lastMarker() * d2) {
                    if (JunCartoonMovie.this.trackerModel().loopCondition() == StObject.$((String)"loop")) {
                        JunCartoonMovie.this.first();
                    } else {
                        JunCartoonMovie.this.stop();
                        JunCartoonMovie.this.last();
                    }
                }
                dArray[0] = d3;
            }
        }, 0L, (long)this.tickTime());
        this.updatePlayMenuIndication();
    }

    public void stop() {
        if (this.playProcess != null) {
            this.playProcess.cancel();
            this.playProcess = null;
        }
        if (this.isEmpty()) {
            return;
        }
        this.trackerModel().playButtonVisual_(false);
        this.updatePlayMenuIndication();
    }

    protected void run() {
        if (this.isEmpty()) {
            return;
        }
        if (this.now() >= 1.0) {
            this.prologue();
        }
        if (this.trackerModel().isIntervalNotEmpty() && (this.now() <= this.trackerModel().firstMarker() || this.now() >= this.trackerModel().lastMarker())) {
            this.first();
        }
        double d = this.currentMilliseconds();
        double d2 = this.totalMilliseconds();
        while (this.isPlay()) {
            JunControlUtility.NextMillisecondClockValue_(this.tickTime());
            double d3 = this.currentMilliseconds() + (double)this.tickTime();
            if (d == d3) {
                d3 += (double)this.tickTime();
            }
            if (d2 <= 0.0) {
                this.epilogue();
            } else {
                this.goto_(d3 / d2);
            }
            if (d3 >= d2) {
                if (this.trackerModel().loopCondition() == JunCartoonMovie.$((String)"loop")) {
                    this.prologue();
                } else {
                    this.stop();
                    this.last();
                }
            }
            if (this.trackerModel().isIntervalNotEmpty() && d3 >= this.trackerModel().lastMarker() * d2) {
                if (this.trackerModel().loopCondition() == JunCartoonMovie.$((String)"loop")) {
                    this.first();
                } else {
                    this.stop();
                    this.last();
                }
            }
            d = d3;
        }
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            StMenu stMenu = new StMenu((Object)JunCartoonMovie.$String((String)"File"), JunCartoonMovie.$((String)"fileMenu"));
            stMenu.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Open GifAnimation..."), (MenuListener)new MenuPerformer((StObject)this, "openGifAnimation")));
            stMenu.addSeparator();
            stMenu.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Save as GifAnimation..."), JunCartoonMovie.$((String)"saveAsGifAnimation"), (MenuListener)new MenuPerformer((StObject)this, "saveAsGifAnimation")));
            stMenu.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Save as movie..."), JunCartoonMovie.$((String)"saveAsMovie"), (MenuListener)new MenuPerformer((StObject)this, "saveAsMovie")));
            stMenu.addSeparator();
            stMenu.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Quit"), (MenuListener)new MenuPerformer((StObject)this, "quitDoing")));
            this._menuBar.add(stMenu);
            StMenu stMenu2 = new StMenu((Object)JunCartoonMovie.$String((String)"Play"), JunCartoonMovie.$((String)"playMenu"));
            stMenu2.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Start"), JunCartoonMovie.$((String)"start"), (MenuListener)new MenuPerformer((StObject)this, "start")));
            stMenu2.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Stop"), JunCartoonMovie.$((String)"stop"), (MenuListener)new MenuPerformer((StObject)this, "stop")));
            stMenu2.addSeparator();
            stMenu2.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Loop"), JunCartoonMovie.$((String)"loopPlay"), (MenuListener)new MenuPerformer((StObject)this, "loopPlay")));
            stMenu2.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"One way"), JunCartoonMovie.$((String)"oneWayPlay"), (MenuListener)new MenuPerformer((StObject)this, "oneWayPlay")));
            this._menuBar.add(stMenu2);
            StMenu stMenu3 = new StMenu((Object)JunCartoonMovie.$String((String)"Position"), JunCartoonMovie.$((String)"positionMenu"));
            stMenu3.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Previous"), JunCartoonMovie.$((String)"gotoPrevious"), (MenuListener)new MenuPerformer((StObject)this, "gotoPrevious")));
            stMenu3.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Next"), JunCartoonMovie.$((String)"gotoNext"), (MenuListener)new MenuPerformer((StObject)this, "gotoNext")));
            stMenu3.addSeparator();
            stMenu3.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"-> Prologue"), (MenuListener)new MenuPerformer((StObject)this, "gotoPrologue")));
            stMenu3.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"-> Epilogue"), (MenuListener)new MenuPerformer((StObject)this, "gotoEpilogue")));
            stMenu3.addSeparator();
            stMenu3.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"-> First"), JunCartoonMovie.$((String)"gotoFirst"), (MenuListener)new MenuPerformer((StObject)this, "gotoFirst")));
            stMenu3.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"-> Last"), JunCartoonMovie.$((String)"gotoLast"), (MenuListener)new MenuPerformer((StObject)this, "gotoLast")));
            stMenu3.addSeparator();
            stMenu3.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Set first marker"), JunCartoonMovie.$((String)"setFirstMarker"), (MenuListener)new MenuPerformer((StObject)this, "setFirstMarker")));
            stMenu3.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Set last marker"), JunCartoonMovie.$((String)"setLastMarker"), (MenuListener)new MenuPerformer((StObject)this, "setLastMarker")));
            this._menuBar.add(stMenu3);
            StMenu stMenu4 = new StMenu((Object)JunCartoonMovie.$String((String)"Misc"), JunCartoonMovie.$((String)"miscMenu"));
            stMenu4.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Half size"), (MenuListener)new MenuPerformer((StObject)this, "halfSize")));
            stMenu4.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Normal size"), (MenuListener)new MenuPerformer((StObject)this, "normalSize")));
            stMenu4.add(new StMenuItem((Object)JunCartoonMovie.$String((String)"Double size"), (MenuListener)new MenuPerformer((StObject)this, "doubleSize")));
            this._menuBar.add(stMenu4);
        }
        return this._menuBar;
    }

    public boolean isEmpty() {
        return this.imageCollection().size() == 0;
    }

    public boolean isPlay() {
        return this.trackerModel().playButton().value();
    }

    public void updateProgressText() {
        this.progressText().value_((Object)(this.stringFromMilliseconds_((long)this.currentMilliseconds()) + " / " + this.stringFromMilliseconds_((long)this.totalMilliseconds())));
    }

    public StView getView() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            DependentListener dependentListener = dependentListenerArray[i];
            if (!(dependentListener instanceof JunCartoonMovieView) || ((StView)dependentListener).model() != this) continue;
            return (StView)dependentListener;
        }
        return null;
    }

    public double[] markerMargins() {
        return new double[]{0.1, 0.1};
    }

    public void setTime_(double d) {
        this.updateProgressText();
        this.changed_(JunCartoonMovie.$((String)"image"));
        this.setTime1_(d);
    }

    public void setTime1_(double d) {
        double d2;
        boolean bl = this.trackerModel2().areMarkersActive();
        if (this.trackerModel().isIntervalNotEmpty()) {
            this.trackerModel2().enableMarkers();
        } else {
            this.trackerModel2().disableMarkers();
        }
        if (bl != this.trackerModel2().areMarkersActive()) {
            DependentListener[] dependentListenerArray = this.trackerModel2().dependents();
            for (int i = 0; i < dependentListenerArray.length; ++i) {
                if (!(dependentListenerArray[i] instanceof JunTrackSliderView)) continue;
                dependentListenerArray[i].update_(new DependentEvent((Object)dependentListenerArray[i], JunCartoonMovie.$((String)"interval"), null));
            }
        }
        if (this.trackerModel().isIntervalNotEmpty()) {
            d2 = (this.trackerModel().doubleValue() - this.trackerModel().firstMarker()) / (this.trackerModel().lastMarker() - this.trackerModel().firstMarker());
            d2 = d2 * (1.0 - this.markerMargins()[0] - this.markerMargins()[1]) + this.markerMargins()[0];
            d2 = Math.max(0.0, Math.min(d2, 1.0));
        } else {
            d2 = this.trackerModel().doubleValue();
        }
        double[] dArray = new double[]{this.markerMargins()[0], 1.0 - this.markerMargins()[1]};
        this.trackerModel2().intervalHolder().value_((Object)dArray);
        this.trackerModel2().valueHolder().value_(d2);
        DependentListener[] dependentListenerArray = this.trackerModel2().dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunTrackSliderView)) continue;
            dependentListenerArray[i].update_(new DependentEvent((Object)dependentListenerArray[i], JunCartoonMovie.$((String)"value"), null));
        }
    }

    public void setTime2_(double d) {
        if (this.trackerModel().isIntervalNotEmpty()) {
            double d2 = (d - this.markerMargins()[0]) / (1.0 - this.markerMargins()[0] - this.markerMargins()[1]);
            d2 = (this.trackerModel().lastMarker() - this.trackerModel().firstMarker()) * d2 + this.trackerModel().firstMarker();
            this.trackerModel().value_(d2);
        } else {
            this.trackerModel().value_(d);
        }
    }

    public int tickTime() {
        return 50;
    }

    protected String stringFromMilliseconds_(long l) {
        long l2 = l % 1000L;
        long l3 = l / 1000L;
        int n = (int)(l3 % 60L);
        int n2 = (int)(l3 / 60L % 60L);
        int n3 = (int)(l3 / 3600L);
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        stringBuffer.append(':');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append(':');
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append('.');
        if (l2 < 100L) {
            stringBuffer.append('0');
        }
        if (l2 < 10L) {
            stringBuffer.append('0');
        }
        stringBuffer.append(l2);
        return stringBuffer.toString();
    }

    public static void ImageSequenceDirectory_jpegImageFileNamePattern_framesPerSecond_movieFile_(File file, String string, int n, File file2) throws IOException {
        JunImagesToMovie.ImageSequenceDirectory_jpegImageFileNamePattern_framesPerSecond_movieFile_(file, string, n, file2);
    }

    public static File RequestFile() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunCartoonMovie.$String((String)"GifAnimation files"), new String[]{"*.gif", "*.GIF"})};
        File file = JunFileRequesterDialog.Request(JunCartoonMovie.$String((String)"Select a file"), fileTypeArray, fileTypeArray[0]);
        return file;
    }

    public static JunCartoonMovie ShowFile_(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            JunCartoonMovie junCartoonMovie = new JunCartoonMovie(file);
            junCartoonMovie.openLightWeightWindowSpecFitFlag_markerFlag_(true, false);
            junCartoonMovie.start();
            return junCartoonMovie;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

